/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.docproc.CallStack;
import com.yahoo.docproc.DocprocService;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.Processing;
import com.yahoo.document.DocumentOperation;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.feedapi.MessageProcessor;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.routing.Route;
import java.util.ArrayList;
import java.util.List;

public class DocprocMessageProcessor
implements MessageProcessor {
    private final DocprocService docproc;
    private final ComponentRegistry<DocprocService> docprocServiceRegistry;

    public DocprocMessageProcessor(DocprocService docproc, ComponentRegistry<DocprocService> docprocServiceRegistry) {
        this.docproc = docproc;
        this.docprocServiceRegistry = docprocServiceRegistry;
    }

    @Override
    public void process(Message m) {
        try {
            ArrayList<DocumentOperation> documentBases = new ArrayList<DocumentOperation>(1);
            if (m.getType() == 100004) {
                documentBases.add((DocumentOperation)((PutDocumentMessage)m).getDocumentPut());
            } else if (m.getType() == 100006) {
                documentBases.add((DocumentOperation)((UpdateDocumentMessage)m).getDocumentUpdate());
            } else if (m.getType() == 100005) {
                documentBases.add((DocumentOperation)((RemoveDocumentMessage)m).getDocumentRemove());
            }
            if (this.docproc != null) {
                this.processDocumentOperations(documentBases, m);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processDocumentOperations(List<DocumentOperation> documentOperations, Message m) throws Exception {
        Processing processing = Processing.createProcessingFromDocumentOperations((String)this.docproc.getName(), documentOperations, (CallStack)new CallStack(this.docproc.getCallStack()));
        processing.setServiceName(this.docproc.getName());
        processing.setDocprocServiceRegistry(this.docprocServiceRegistry);
        processing.setVariable("route", (Object)m.getRoute());
        processing.setVariable("timeout", (Object)m.getTimeRemaining());
        DocumentProcessor.Progress progress = this.docproc.getExecutor().process(processing);
        while (DocumentProcessor.Progress.LATER.equals((Object)progress)) {
            Thread.sleep(50L);
            progress = this.docproc.getExecutor().process(processing);
        }
        if (progress == DocumentProcessor.Progress.FAILED || progress == DocumentProcessor.Progress.PERMANENT_FAILURE) {
            throw new RuntimeException("Processing of " + documentOperations + " failed: " + progress + ".");
        }
        m.setRoute((Route)processing.getVariable("route"));
        m.setTimeRemaining(((Long)processing.getVariable("timeout")).longValue());
    }
}

