/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.clientmetrics;

import com.yahoo.clientmetrics.MessageTypeMetricSet;
import com.yahoo.messagebus.Reply;
import java.util.HashMap;
import java.util.Map;

public class RouteMetricSet {
    private final String route;
    private final ProgressCallback callback;
    private final Map<Integer, MessageTypeMetricSet> typeMap = new HashMap<Integer, MessageTypeMetricSet>();

    public RouteMetricSet(String route, ProgressCallback callback) {
        this.route = route;
        this.callback = callback;
    }

    public Map<Integer, MessageTypeMetricSet> getMetrics() {
        return this.typeMap;
    }

    public void addReply(Reply r) {
        MessageTypeMetricSet type = this.typeMap.get(r.getMessage().getType());
        if (type == null) {
            String msgName = r.getMessage().getClass().getSimpleName().replace("Message", "");
            type = new MessageTypeMetricSet(msgName);
            this.typeMap.put(r.getMessage().getType(), type);
        }
        type.addReply(r);
        if (this.callback != null) {
            this.callback.onProgress(this);
        }
    }

    public void done() {
        if (this.callback != null) {
            this.callback.done(this);
        }
    }

    public String getRoute() {
        return this.route;
    }

    public static interface ProgressCallback {
        public void onProgress(RouteMetricSet var1);

        public void done(RouteMetricSet var1);
    }
}

