/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.spooler;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SpoolerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "e0e0fb1316922a2fe837696dc296d044";
    public static final String CONFIG_DEF_NAME = "spooler";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.spooler";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.spooler", "directory string default=\"var/spool/vespa\"", "keepsuccess bool default=false", "maxfailuresize int default=0", "maxfatalfailuresize int default=0", "maxsuccesssize int default=0", "threads int default=10", "parsers[].classname string", "parsers[].parameters[].key string", "parsers[].parameters[].value string", "maxfailuretime int default=259200", "minfailureretries int default=5", "maxretries int default=5"};
    private final StringNode directory;
    private final BooleanNode keepsuccess;
    private final IntegerNode maxfailuresize;
    private final IntegerNode maxfatalfailuresize;
    private final IntegerNode maxsuccesssize;
    private final IntegerNode threads;
    private final InnerNodeVector<Parsers> parsers;
    private final IntegerNode maxfailuretime;
    private final IntegerNode minfailureretries;
    private final IntegerNode maxretries;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public SpoolerConfig(Builder builder) {
        this(builder, true);
    }

    private SpoolerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for spooler must be initialized: " + builder.__uninitialized);
        }
        this.directory = builder.directory == null ? new StringNode("var/spool/vespa") : new StringNode(builder.directory);
        this.keepsuccess = builder.keepsuccess == null ? new BooleanNode(false) : new BooleanNode(builder.keepsuccess.booleanValue());
        this.maxfailuresize = builder.maxfailuresize == null ? new IntegerNode(0) : new IntegerNode(builder.maxfailuresize.intValue());
        this.maxfatalfailuresize = builder.maxfatalfailuresize == null ? new IntegerNode(0) : new IntegerNode(builder.maxfatalfailuresize.intValue());
        this.maxsuccesssize = builder.maxsuccesssize == null ? new IntegerNode(0) : new IntegerNode(builder.maxsuccesssize.intValue());
        this.threads = builder.threads == null ? new IntegerNode(10) : new IntegerNode(builder.threads.intValue());
        this.parsers = Parsers.createVector(builder.parsers);
        this.maxfailuretime = builder.maxfailuretime == null ? new IntegerNode(259200) : new IntegerNode(builder.maxfailuretime.intValue());
        this.minfailureretries = builder.minfailureretries == null ? new IntegerNode(5) : new IntegerNode(builder.minfailureretries.intValue());
        this.maxretries = builder.maxretries == null ? new IntegerNode(5) : new IntegerNode(builder.maxretries.intValue());
    }

    public String directory() {
        return this.directory.value();
    }

    public boolean keepsuccess() {
        return this.keepsuccess.value();
    }

    public int maxfailuresize() {
        return this.maxfailuresize.value();
    }

    public int maxfatalfailuresize() {
        return this.maxfatalfailuresize.value();
    }

    public int maxsuccesssize() {
        return this.maxsuccesssize.value();
    }

    public int threads() {
        return this.threads.value();
    }

    public List<Parsers> parsers() {
        return this.parsers;
    }

    public Parsers parsers(int i) {
        return (Parsers)((Object)this.parsers.get(i));
    }

    public int maxfailuretime() {
        return this.maxfailuretime.value();
    }

    public int minfailureretries() {
        return this.minfailureretries.value();
    }

    public int maxretries() {
        return this.maxretries.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SpoolerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Parsers
    extends InnerNode {
        private final StringNode classname;
        private final InnerNodeVector<Parameters> parameters;

        @Deprecated
        private Parsers() {
            this(new Builder(), false);
        }

        public Parsers(Builder builder) {
            this(builder, true);
        }

        private Parsers(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for spooler.parsers[] must be initialized: " + builder.__uninitialized);
            }
            this.classname = builder.classname == null ? new StringNode() : new StringNode(builder.classname);
            this.parameters = Parameters.createVector(builder.parameters);
        }

        public String classname() {
            return this.classname.value();
        }

        public List<Parameters> parameters() {
            return this.parameters;
        }

        public Parameters parameters(int i) {
            return (Parameters)((Object)this.parameters.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Parsers newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("parsers");
            return changes;
        }

        private static InnerNodeVector<Parsers> createVector(List<Builder> builders) {
            ArrayList<Parsers> elems = new ArrayList<Parsers>();
            for (Builder b : builders) {
                elems.add(new Parsers(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Parsers());
        }

        public static final class Parameters
        extends InnerNode {
            private final StringNode key;
            private final StringNode value;

            @Deprecated
            private Parameters() {
                this(new Builder(), false);
            }

            public Parameters(Builder builder) {
                this(builder, true);
            }

            private Parameters(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for spooler.parsers[].parameters[] must be initialized: " + builder.__uninitialized);
                }
                this.key = builder.key == null ? new StringNode() : new StringNode(builder.key);
                this.value = builder.value == null ? new StringNode() : new StringNode(builder.value);
            }

            public String key() {
                return this.key.value();
            }

            public String value() {
                return this.value.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Parameters newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("parameters");
                return changes;
            }

            private static InnerNodeVector<Parameters> createVector(List<Builder> builders) {
                ArrayList<Parameters> elems = new ArrayList<Parameters>();
                for (Builder b : builders) {
                    elems.add(new Parameters(b));
                }
                return new InnerNodeVector(elems, (InnerNode)new Parameters());
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("key", "value"));
                private String key = null;
                private String value = null;

                public Builder() {
                }

                public Builder(Parameters config) {
                    this.key(config.key());
                    this.value(config.value());
                }

                private Builder override(Builder __superior) {
                    if (__superior.key != null) {
                        this.key(__superior.key);
                    }
                    if (__superior.value != null) {
                        this.value(__superior.value);
                    }
                    return this;
                }

                public Builder key(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.key = __value;
                    this.__uninitialized.remove("key");
                    return this;
                }

                public Builder value(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.value = __value;
                    this.__uninitialized.remove("value");
                    return this;
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("classname"));
            private String classname = null;
            public List<Parameters.Builder> parameters = new ArrayList<Parameters.Builder>();

            public Builder() {
            }

            public Builder(Parsers config) {
                this.classname(config.classname());
                for (Parameters p : config.parameters()) {
                    this.parameters(new Parameters.Builder(p));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.classname != null) {
                    this.classname(__superior.classname);
                }
                if (!__superior.parameters.isEmpty()) {
                    this.parameters.addAll(__superior.parameters);
                }
                return this;
            }

            public Builder classname(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.classname = __value;
                this.__uninitialized.remove("classname");
                return this;
            }

            public Builder parameters(Parameters.Builder __builder) {
                this.parameters.add(__builder);
                return this;
            }

            public Builder parameters(List<Parameters.Builder> __builders) {
                this.parameters = __builders;
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String directory = null;
        private Boolean keepsuccess = null;
        private Integer maxfailuresize = null;
        private Integer maxfatalfailuresize = null;
        private Integer maxsuccesssize = null;
        private Integer threads = null;
        public List<Parsers.Builder> parsers = new ArrayList<Parsers.Builder>();
        private Integer maxfailuretime = null;
        private Integer minfailureretries = null;
        private Integer maxretries = null;

        public Builder() {
        }

        public Builder(SpoolerConfig config) {
            this.directory(config.directory());
            this.keepsuccess(config.keepsuccess());
            this.maxfailuresize(config.maxfailuresize());
            this.maxfatalfailuresize(config.maxfatalfailuresize());
            this.maxsuccesssize(config.maxsuccesssize());
            this.threads(config.threads());
            for (Parsers p : config.parsers()) {
                this.parsers(new Parsers.Builder(p));
            }
            this.maxfailuretime(config.maxfailuretime());
            this.minfailureretries(config.minfailureretries());
            this.maxretries(config.maxretries());
        }

        private Builder override(Builder __superior) {
            if (__superior.directory != null) {
                this.directory(__superior.directory);
            }
            if (__superior.keepsuccess != null) {
                this.keepsuccess(__superior.keepsuccess);
            }
            if (__superior.maxfailuresize != null) {
                this.maxfailuresize(__superior.maxfailuresize);
            }
            if (__superior.maxfatalfailuresize != null) {
                this.maxfatalfailuresize(__superior.maxfatalfailuresize);
            }
            if (__superior.maxsuccesssize != null) {
                this.maxsuccesssize(__superior.maxsuccesssize);
            }
            if (__superior.threads != null) {
                this.threads(__superior.threads);
            }
            if (!__superior.parsers.isEmpty()) {
                this.parsers.addAll(__superior.parsers);
            }
            if (__superior.maxfailuretime != null) {
                this.maxfailuretime(__superior.maxfailuretime);
            }
            if (__superior.minfailureretries != null) {
                this.minfailureretries(__superior.minfailureretries);
            }
            if (__superior.maxretries != null) {
                this.maxretries(__superior.maxretries);
            }
            return this;
        }

        public Builder directory(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.directory = __value;
            return this;
        }

        public Builder keepsuccess(boolean __value) {
            this.keepsuccess = __value;
            return this;
        }

        private Builder keepsuccess(String __value) {
            return this.keepsuccess(Boolean.valueOf(__value));
        }

        public Builder maxfailuresize(int __value) {
            this.maxfailuresize = __value;
            return this;
        }

        private Builder maxfailuresize(String __value) {
            return this.maxfailuresize(Integer.valueOf(__value));
        }

        public Builder maxfatalfailuresize(int __value) {
            this.maxfatalfailuresize = __value;
            return this;
        }

        private Builder maxfatalfailuresize(String __value) {
            return this.maxfatalfailuresize(Integer.valueOf(__value));
        }

        public Builder maxsuccesssize(int __value) {
            this.maxsuccesssize = __value;
            return this;
        }

        private Builder maxsuccesssize(String __value) {
            return this.maxsuccesssize(Integer.valueOf(__value));
        }

        public Builder threads(int __value) {
            this.threads = __value;
            return this;
        }

        private Builder threads(String __value) {
            return this.threads(Integer.valueOf(__value));
        }

        public Builder parsers(Parsers.Builder __builder) {
            this.parsers.add(__builder);
            return this;
        }

        public Builder parsers(List<Parsers.Builder> __builders) {
            this.parsers = __builders;
            return this;
        }

        public Builder maxfailuretime(int __value) {
            this.maxfailuretime = __value;
            return this;
        }

        private Builder maxfailuretime(String __value) {
            return this.maxfailuretime(Integer.valueOf(__value));
        }

        public Builder minfailureretries(int __value) {
            this.minfailureretries = __value;
            return this;
        }

        private Builder minfailureretries(String __value) {
            return this.minfailureretries(Integer.valueOf(__value));
        }

        public Builder maxretries(int __value) {
            this.maxretries = __value;
            return this;
        }

        private Builder maxretries(String __value) {
            return this.maxretries(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SpoolerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SpoolerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SpoolerConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

