/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedhandler;

import com.google.inject.Inject;
import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.cloud.config.ClusterListConfig;
import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.container.jdisc.EmptyResponse;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.feedapi.DocprocMessageProcessor;
import com.yahoo.feedapi.FeedContext;
import com.yahoo.feedapi.Feeder;
import com.yahoo.feedapi.JsonFeeder;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SingleSender;
import com.yahoo.feedapi.XMLFeeder;
import com.yahoo.feedhandler.FeedResponse;
import com.yahoo.feedhandler.MetricResponse;
import com.yahoo.feedhandler.VespaFeedHandlerBase;
import com.yahoo.jdisc.Metric;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespaclient.config.FeederConfig;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public final class VespaFeedHandler
extends VespaFeedHandlerBase {
    private static final Logger log = Logger.getLogger(VespaFeedHandler.class.getName());
    public static final String JSON_INPUT = "jsonInput";
    private AtomicInteger busyThreads = new AtomicInteger(0);
    private final int maxBusyThreads;

    @Inject
    public VespaFeedHandler(FeederConfig feederConfig, LoadTypeConfig loadTypeConfig, DocumentmanagerConfig documentmanagerConfig, SlobroksConfig slobroksConfig, ClusterListConfig clusterListConfig, Executor executor, Metric metric) throws Exception {
        super(feederConfig, loadTypeConfig, documentmanagerConfig, slobroksConfig, clusterListConfig, executor, metric);
        this.maxBusyThreads = feederConfig.maxbusythreads();
    }

    VespaFeedHandler(FeedContext context, Executor executor) throws Exception {
        super(context, executor);
        this.maxBusyThreads = 32;
    }

    public static VespaFeedHandler createFromContext(FeedContext context, Executor executor) throws Exception {
        return new VespaFeedHandler(context, executor);
    }

    public HttpResponse handle(HttpRequest request) {
        return this.handle(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse handle(HttpRequest request, RouteMetricSet.ProgressCallback callback) {
        if (request.getProperty("status") != null) {
            return new MetricResponse(this.context.getMetrics().getMetricSet());
        }
        try {
            int busy = this.busyThreads.incrementAndGet();
            if (busy > this.maxBusyThreads) {
                log.warning("too many threads [" + busy + "] busy, returning SERVICE UNAVAILABLE");
                EmptyResponse emptyResponse = new EmptyResponse(503);
                return emptyResponse;
            }
            boolean asynchronous = request.getBooleanProperty("asynchronous");
            MessagePropertyProcessor.PropertySetter properties = this.getPropertyProcessor().buildPropertySetter(request);
            String route = properties.getRoute().toString();
            FeedResponse response = new FeedResponse(new RouteMetricSet(route, callback));
            SingleSender sender = new SingleSender(response, this.getSharedSender(route), !asynchronous);
            sender.addMessageProcessor(properties);
            sender.addMessageProcessor(new DocprocMessageProcessor(this.getDocprocChain(request), this.getDocprocServiceRegistry(request)));
            Feeder feeder = this.createFeeder(sender, request);
            feeder.setAbortOnDocumentError(properties.getAbortOnDocumentError());
            feeder.setCreateIfNonExistent(properties.getCreateIfNonExistent());
            response.setAbortOnFeedError(properties.getAbortOnFeedError());
            List<String> errors = feeder.parse();
            for (String s : errors) {
                response.addXMLParseError(s);
            }
            if (errors.size() > 0 && feeder instanceof XMLFeeder) {
                response.addXMLParseError("If you are trying to feed JSON, set the Content-Type header to application/json.");
            }
            sender.done();
            if (asynchronous) {
                FeedResponse feedResponse = response;
                return feedResponse;
            }
            long millis = this.getTimeoutMillis(request);
            boolean completed = sender.waitForPending(millis);
            if (!completed) {
                response.addError("Timed out after " + millis + " ms waiting for responses");
            }
            response.done();
            FeedResponse feedResponse = response;
            return feedResponse;
        }
        finally {
            this.busyThreads.decrementAndGet();
        }
    }

    private Feeder createFeeder(SingleSender sender, HttpRequest request) {
        String contentType = request.getHeader("Content-Type");
        if (Boolean.valueOf(request.getProperty(JSON_INPUT)).booleanValue() || contentType != null && contentType.startsWith("application/json")) {
            return new JsonFeeder(this.getDocumentTypeManager(), sender, this.getRequestInputStream(request));
        }
        return new XMLFeeder(this.getDocumentTypeManager(), sender, this.getRequestInputStream(request));
    }
}

