/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedhandler;

import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.VespaHeaders;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.feedapi.SharedSender;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.processing.request.ErrorMessage;
import com.yahoo.text.Utf8String;
import com.yahoo.text.XMLWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class FeedResponse
extends HttpResponse
implements SharedSender.ResultCallback {
    private static final Logger log = Logger.getLogger(FeedResponse.class.getName());
    private final List<com.yahoo.search.result.ErrorMessage> errorMessages = new ArrayList<com.yahoo.search.result.ErrorMessage>();
    private final List<String> errors = new ArrayList<String>();
    private final StringBuilder traces = new StringBuilder();
    private final RouteMetricSet metrics;
    private boolean abortOnError = false;
    private boolean isAborted = false;
    private final SharedSender.Pending pendingNumber = new SharedSender.Pending();

    public FeedResponse(RouteMetricSet metrics) {
        super(200);
        this.metrics = metrics;
    }

    @Override
    public boolean isAborted() {
        return this.isAborted;
    }

    public void setAbortOnFeedError(boolean abort) {
        this.abortOnError = abort;
    }

    public void render(OutputStream outputStream) throws IOException {
        if (!this.errorMessages.isEmpty()) {
            this.setStatus(VespaHeaders.getStatus((boolean)false, (ErrorMessage)((ErrorMessage)this.errorMessages.get(0)), this.errorMessages.iterator()));
        }
        XMLWriter writer = new XMLWriter((Writer)new OutputStreamWriter(outputStream));
        writer.openTag("result");
        if (this.metrics != null) {
            this.metrics.printXml(writer, 0, 0);
        }
        if (this.traces.length() > 0) {
            writer.openTag("trace");
            writer.append((CharSequence)this.traces);
            writer.closeTag();
        }
        if (!this.errors.isEmpty()) {
            writer.openTag("errors");
            writer.attribute(new Utf8String("count"), (long)this.errors.size());
            for (int i = 0; i < this.errors.size() && i < 10; ++i) {
                writer.openTag("error");
                writer.attribute(new Utf8String("message"), this.errors.get(i));
                writer.closeTag();
            }
            writer.closeTag();
        }
        writer.closeTag();
        writer.flush();
        outputStream.close();
    }

    public String getContentType() {
        return "application/xml";
    }

    public String prettyPrint(Message m) {
        if (m instanceof PutDocumentMessage) {
            return "PUT[" + ((PutDocumentMessage)m).getDocumentPut().getDocument().getId() + "] ";
        }
        if (m instanceof RemoveDocumentMessage) {
            return "REMOVE[" + ((RemoveDocumentMessage)m).getDocumentId() + "] ";
        }
        if (m instanceof UpdateDocumentMessage) {
            return "UPDATE[" + ((UpdateDocumentMessage)m).getDocumentUpdate().getId() + "] ";
        }
        return "";
    }

    @Override
    public boolean handleReply(Reply reply) {
        this.metrics.addReply(reply);
        if (reply.getTrace().getLevel() > 0) {
            String str = reply.getTrace().toString();
            this.traces.append(str);
            System.out.println(str);
        }
        if (FeedResponse.containsFatalErrors(reply.getErrors())) {
            for (int i = 0; i < reply.getNumErrors(); ++i) {
                Error err = reply.getError(i);
                StringBuilder out = new StringBuilder(this.prettyPrint(reply.getMessage()));
                out.append("[").append(DocumentProtocol.getErrorName((int)err.getCode())).append("] ");
                if (err.getService() != null) {
                    out.append("(").append(err.getService()).append(") ");
                }
                out.append(err.getMessage());
                String str = out.toString();
                log.finest(str);
                this.addError(str);
            }
            if (this.abortOnError) {
                this.isAborted = true;
                return false;
            }
        }
        return true;
    }

    @Override
    public SharedSender.Pending getPending() {
        return this.pendingNumber;
    }

    public void done() {
        this.metrics.done();
    }

    public FeedResponse addXMLParseError(String error) {
        this.errorMessages.add(com.yahoo.search.result.ErrorMessage.createBadRequest((String)error));
        this.errors.add(error);
        return this;
    }

    public FeedResponse addError(String error) {
        this.errorMessages.add(com.yahoo.search.result.ErrorMessage.createBadRequest((String)error));
        this.errors.add(error);
        return this;
    }

    public List<String> getErrorList() {
        return this.errors;
    }

    public List<com.yahoo.search.result.ErrorMessage> getErrorMessageList() {
        return this.errorMessages;
    }

    private static boolean containsFatalErrors(Stream<Error> errors) {
        return errors.anyMatch(e -> e.getCode() != 251013);
    }

    public boolean isSuccess() {
        return this.errors.isEmpty();
    }
}

