/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.container.Container;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.docproc.DocprocService;
import com.yahoo.docproc.jdisc.DocumentProcessingHandler;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.messagebus.loadtypes.LoadType;
import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.feedapi.FeederOptions;
import com.yahoo.feedapi.MessageProcessor;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespaclient.config.FeederConfig;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessagePropertyProcessor
implements ConfigSubscriber.SingleSubscriber<FeederConfig> {
    private static final Logger log = Logger.getLogger(MessagePropertyProcessor.class.getName());
    private FeederOptions feederOptions = null;
    private Route defaultRoute = null;
    private long defaultTimeoutMillis = 0L;
    private boolean retryEnabled = true;
    private String defaultDocprocChain = null;
    private boolean defaultAbortOnDocumentError = true;
    private boolean defaultAbortOnSendError = true;
    private boolean defaultCreateIfNonExistent = false;
    private LoadTypeSet loadTypes = null;
    private boolean configChanged = false;

    public MessagePropertyProcessor(String configId, String loadTypeConfig) {
        new ConfigSubscriber().subscribe((ConfigSubscriber.SingleSubscriber)this, FeederConfig.class, configId);
        this.loadTypes = new LoadTypeSet(loadTypeConfig);
    }

    public MessagePropertyProcessor(FeederConfig config, LoadTypeConfig loadTypeCfg) {
        this.loadTypes = new LoadTypeSet();
        this.configure(config, loadTypeCfg);
    }

    public void setRoute(String routeOverride) {
        this.defaultRoute = Route.parse((String)routeOverride);
    }

    private synchronized String getDocprocChainParameter(HttpRequest request) {
        String docprocChainParam = request.getProperty("docprocchain");
        return docprocChainParam == null ? this.defaultDocprocChain : docprocChainParam;
    }

    public synchronized DocprocService getDocprocChain(HttpRequest request) {
        ComponentRegistry<DocprocService> services = this.getDocprocServiceRegistry(request);
        String docprocChain = this.getDocprocChainParameter(request);
        if (docprocChain == null) {
            return null;
        }
        return (DocprocService)services.getComponent(docprocChain);
    }

    public synchronized ComponentRegistry<DocprocService> getDocprocServiceRegistry(HttpRequest request) {
        String docprocChain = this.getDocprocChainParameter(request);
        if (docprocChain == null) {
            return null;
        }
        Container container = Container.get();
        if (container == null) {
            throw new IllegalStateException("Could not get Container instance.");
        }
        ComponentRegistry requestHandlerRegistry = container.getRequestHandlerRegistry();
        if (requestHandlerRegistry == null) {
            throw new IllegalStateException("Could not get requesthandlerregistry.");
        }
        DocumentProcessingHandler handler = (DocumentProcessingHandler)requestHandlerRegistry.getComponent(DocumentProcessingHandler.class.getName());
        if (handler == null) {
            return null;
        }
        ComponentRegistry services = handler.getDocprocServiceRegistry();
        if (services == null) {
            throw new IllegalStateException("Could not get DocprocServiceRegistry.");
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertySetter buildPropertySetter(HttpRequest request) {
        boolean createIfNonExistent;
        boolean abortOnFeedError;
        boolean abortOnDocumentError;
        boolean retry;
        long timeout;
        String routeParam = null;
        double timeoutParam = -1.0;
        String priorityParam = null;
        String abortOnDocErrorParam = null;
        String abortOnFeedErrorParam = null;
        String loadTypeStr = null;
        String traceStr = null;
        String createIfNonExistentParam = null;
        if (request != null) {
            routeParam = request.getProperty("route");
            String timeoutStr = request.getProperty("timeout");
            if (timeoutStr != null) {
                timeoutParam = Double.parseDouble(timeoutStr);
            }
            priorityParam = request.getProperty("priority");
            traceStr = request.getProperty("tracelevel");
            abortOnDocErrorParam = request.getProperty("abortondocumenterror");
            abortOnFeedErrorParam = request.getProperty("abortonfeederror");
            loadTypeStr = request.getProperty("loadtype");
            createIfNonExistentParam = request.getProperty("createifnonexistent");
        }
        Route route = routeParam != null ? Route.parse((String)routeParam) : null;
        MessagePropertyProcessor messagePropertyProcessor = this;
        synchronized (messagePropertyProcessor) {
            if (route == null) {
                route = this.defaultRoute;
            }
            timeout = timeoutParam < 0.0 ? this.defaultTimeoutMillis : (long)(timeoutParam * 1000.0);
            retry = this.retryEnabled;
            boolean bl = abortOnDocErrorParam == null ? this.defaultAbortOnDocumentError : (abortOnDocumentError = !"false".equals(abortOnDocErrorParam));
            abortOnFeedError = abortOnFeedErrorParam == null ? this.defaultAbortOnSendError : !"false".equals(abortOnFeedErrorParam);
            createIfNonExistent = createIfNonExistentParam == null ? this.defaultCreateIfNonExistent : "true".equals(createIfNonExistentParam);
        }
        DocumentProtocol.Priority priority = null;
        if (priorityParam != null) {
            priority = DocumentProtocol.getPriorityByName((String)priorityParam);
        }
        LoadType loadType = null;
        if (this.loadTypes != null && loadTypeStr != null) {
            loadType = (LoadType)this.loadTypes.getNameMap().get(loadTypeStr);
        }
        if (loadType == null) {
            loadType = LoadType.DEFAULT;
        }
        return new PropertySetter(route, timeout, priority, loadType, retry, abortOnDocumentError, abortOnFeedError, createIfNonExistent, traceStr != null ? Integer.parseInt(traceStr) : 0);
    }

    public long getDefaultTimeoutMillis() {
        return this.defaultTimeoutMillis;
    }

    public synchronized boolean configChanged() {
        return this.configChanged;
    }

    public synchronized void setConfigChanged(boolean configChanged) {
        this.configChanged = configChanged;
    }

    public synchronized FeederOptions getFeederOptions() {
        return this.feederOptions;
    }

    public synchronized void configure(FeederConfig config, LoadTypeConfig loadTypeConfig) {
        this.loadTypes.configure(loadTypeConfig);
        this.configure(config);
    }

    public LoadTypeSet getLoadTypes() {
        return this.loadTypes;
    }

    public synchronized void configure(FeederConfig config) {
        if (this.feederOptions != null) {
            this.setConfigChanged(true);
        }
        this.feederOptions = new FeederOptions(config);
        this.defaultRoute = this.feederOptions.getRoute() != null ? Route.parse((String)this.feederOptions.getRoute()) : null;
        this.defaultTimeoutMillis = (long)(this.feederOptions.getTimeout() * 1000.0);
        this.retryEnabled = this.feederOptions.getRetryEnabled();
        this.defaultAbortOnDocumentError = this.feederOptions.abortOnDocumentError();
        this.defaultAbortOnSendError = this.feederOptions.abortOnSendError();
        this.defaultDocprocChain = !"".equals(this.feederOptions.getDocprocChain()) ? this.feederOptions.getDocprocChain() : null;
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Received new config (route: " + (this.defaultRoute != null ? this.defaultRoute : "<none>") + ", timeout: " + this.defaultTimeoutMillis + " ms, retry enabled: " + this.retryEnabled + ", docproc chain: " + (this.defaultDocprocChain != null ? this.defaultDocprocChain : "<none>") + ", abort on doc error: " + this.defaultAbortOnDocumentError + ", abort on feed error: " + this.defaultAbortOnSendError + ")");
        }
    }

    public class PropertySetter
    implements MessageProcessor {
        private Route route;
        private long timeout;
        private DocumentProtocol.Priority priority;
        private boolean retryEnabled;
        private boolean abortOnDocumentError;
        private boolean abortOnFeedError;
        private boolean createIfNonExistent;
        private LoadType loadType;
        private int traceLevel;

        public PropertySetter(Route route, long timeout, DocumentProtocol.Priority priority, LoadType loadType, boolean retryEnabled, boolean abortOnDocumentError, boolean abortOnFeedError, boolean createIfNonExistent, int traceLevel) {
            this.route = route;
            this.timeout = timeout;
            this.priority = priority;
            this.loadType = loadType;
            this.retryEnabled = retryEnabled;
            this.abortOnDocumentError = abortOnDocumentError;
            this.abortOnFeedError = abortOnFeedError;
            this.createIfNonExistent = createIfNonExistent;
            this.traceLevel = traceLevel;
        }

        public Route getRoute() {
            return this.route;
        }

        public void setRoute(Route route) {
            this.route = route;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public DocumentProtocol.Priority getPriority() {
            return this.priority;
        }

        public void setPriority(DocumentProtocol.Priority priority) {
            this.priority = priority;
        }

        public LoadType getLoadType() {
            return this.loadType;
        }

        public void setLoadType(LoadType loadType) {
            this.loadType = loadType;
        }

        public boolean getAbortOnDocumentError() {
            return this.abortOnDocumentError;
        }

        public boolean getAbortOnFeedError() {
            return this.abortOnFeedError;
        }

        public boolean getCreateIfNonExistent() {
            return this.createIfNonExistent;
        }

        @Override
        public void process(Message msg) {
            if (this.route != null) {
                msg.setRoute(this.route);
            }
            msg.setTimeRemaining(this.timeout);
            msg.setRetryEnabled(this.retryEnabled);
            msg.getTrace().setLevel(Math.max(MessagePropertyProcessor.this.getFeederOptions().getTraceLevel(), this.traceLevel));
            if (this.loadType != null) {
                ((DocumentMessage)msg).setLoadType(this.loadType);
                ((DocumentMessage)msg).setPriority(this.loadType.getPriority());
            }
            if (this.priority != null) {
                ((DocumentMessage)msg).setPriority(this.priority);
            }
        }

        public void process(VisitorParameters params) {
            if (this.route != null) {
                params.setRoute(this.route);
            }
            params.setTimeoutMs(this.timeout);
            params.setTraceLevel(Math.max(MessagePropertyProcessor.this.getFeederOptions().getTraceLevel(), this.traceLevel));
            if (this.loadType != null) {
                params.setLoadType(this.loadType);
                params.setPriority(this.loadType.getPriority());
            }
            if (this.priority != null) {
                params.setPriority(this.priority);
            }
        }
    }
}

