/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SendSession;
import com.yahoo.feedapi.SessionFactory;
import com.yahoo.jdisc.Metric;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Result;
import com.yahoo.messagebus.SourceSession;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import java.util.Collections;

public class MessageBusSessionFactory
implements SessionFactory {
    private final MessageBusDocumentAccess access;
    private final MessagePropertyProcessor processor;

    public MessageBusSessionFactory(MessagePropertyProcessor processor) {
        this(processor, null, null);
    }

    public MessageBusSessionFactory(MessagePropertyProcessor processor, DocumentmanagerConfig documentmanagerConfig, SlobroksConfig slobroksConfig) {
        this.processor = processor;
        MessageBusParams params = new MessageBusParams(processor.getLoadTypes());
        params.setTraceLevel(processor.getFeederOptions().getTraceLevel());
        RPCNetworkParams rpcNetworkParams = processor.getFeederOptions().getNetworkParams();
        if (slobroksConfig != null) {
            rpcNetworkParams.setSlobroksConfig(slobroksConfig);
        }
        params.setRPCNetworkParams(rpcNetworkParams);
        params.setDocumentManagerConfigId("client");
        if (documentmanagerConfig != null) {
            params.setDocumentmanagerConfig(documentmanagerConfig);
        }
        this.access = new MessageBusDocumentAccess(params);
    }

    public MessageBusDocumentAccess getAccess() {
        return this.access;
    }

    @Override
    public synchronized SendSession createSendSession(ReplyHandler handler, Metric metric) {
        return new SourceSessionWrapper(this.access.getMessageBus().createSourceSession(handler, this.processor.getFeederOptions().toSourceSessionParams()), metric);
    }

    public void shutDown() {
        this.access.shutdown();
    }

    @Override
    public synchronized VisitorSession createVisitorSession(VisitorParameters params) {
        try {
            return this.access.createVisitorSession(params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class SourceSessionWrapper
    extends SendSession {
        private final SourceSession session;
        private final Metric metric;
        private final Metric.Context context;

        private SourceSessionWrapper(SourceSession session, Metric metric) {
            this.session = session;
            this.metric = metric;
            this.context = metric.createContext(Collections.emptyMap());
        }

        @Override
        protected Result onSend(Message m, boolean blockIfQueueFull) throws InterruptedException {
            this.updateCounters(m);
            if (blockIfQueueFull) {
                return this.session.sendBlocking(m);
            }
            return this.session.send(m);
        }

        private void updateCounters(Message m) {
            this.metric.add("num_operations", (Number)1, this.context);
            if (m instanceof PutDocumentMessage) {
                this.metric.add("num_puts", (Number)1, this.context);
            } else if (m instanceof RemoveDocumentMessage) {
                this.metric.add("num_removes", (Number)1, this.context);
            } else if (m instanceof UpdateDocumentMessage) {
                this.metric.add("num_updates", (Number)1, this.context);
            }
        }

        @Override
        public void close() {
            this.session.close();
        }
    }

    private static interface Metrics {
        public static final String NUM_OPERATIONS = "num_operations";
        public static final String NUM_PUTS = "num_puts";
        public static final String NUM_REMOVES = "num_removes";
        public static final String NUM_UPDATES = "num_updates";
    }
}

