/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.messagebus.DynamicThrottlePolicy;
import com.yahoo.messagebus.RateThrottlingPolicy;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.StaticThrottlePolicy;
import com.yahoo.messagebus.ThrottlePolicy;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import com.yahoo.vespaclient.config.FeederConfig;

public class FeederOptions {
    private boolean abortOnDocumentError = true;
    private boolean abortOnSendError = true;
    private boolean retryEnabled = true;
    private double retryDelay = 1.0;
    private double timeout = 60.0;
    private int maxPendingBytes = 0;
    private int maxPendingDocs = 0;
    private double maxFeedRate = 0.0;
    private String documentManagerConfigId = "client";
    private String idPrefix = "";
    private String route = "default";
    private String routingConfigId;
    private String slobrokConfigId;
    private int traceLevel;
    private int mbusPort;
    private DocumentProtocol.Priority priority = DocumentProtocol.Priority.NORMAL_3;
    private boolean priorityExplicitlySet = false;
    private String docprocChain = "";

    public FeederOptions() {
    }

    public FeederOptions(FeederOptions src) {
        this.abortOnDocumentError = src.abortOnDocumentError;
        this.abortOnSendError = src.abortOnSendError;
        this.retryEnabled = src.retryEnabled;
        this.retryDelay = src.retryDelay;
        this.timeout = src.timeout;
        this.maxPendingBytes = src.maxPendingBytes;
        this.maxPendingDocs = src.maxPendingDocs;
        this.maxFeedRate = src.maxFeedRate;
        this.documentManagerConfigId = src.documentManagerConfigId;
        this.idPrefix = src.idPrefix;
        this.route = src.route;
        this.routingConfigId = src.routingConfigId;
        this.slobrokConfigId = src.slobrokConfigId;
        this.traceLevel = src.traceLevel;
        this.mbusPort = src.mbusPort;
        this.priority = src.priority;
        this.docprocChain = src.docprocChain;
    }

    public FeederOptions(FeederConfig config) {
        this.setAbortOnDocumentError(config.abortondocumenterror());
        this.setAbortOnSendError(config.abortonsenderror());
        this.setIdPrefix(config.idprefix());
        this.setMaxPendingBytes(config.maxpendingbytes());
        this.setMaxPendingDocs(config.maxpendingdocs());
        this.setRetryEnabled(config.retryenabled());
        this.setRetryDelay(config.retrydelay());
        this.setRoute(config.route());
        this.setTimeout(config.timeout());
        this.setTraceLevel(config.tracelevel());
        this.setMessageBusPort(config.mbusport());
        this.setDocprocChain(config.docprocchain());
        this.setMaxFeedRate(config.maxfeedrate());
    }

    public void setMaxFeedRate(double feedRate) {
        this.maxFeedRate = feedRate;
    }

    public double getMaxFeedRate() {
        return this.maxFeedRate;
    }

    public boolean getRetryEnabled() {
        return this.retryEnabled;
    }

    public void setRetryEnabled(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
    }

    public double getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(double retryDelay) {
        this.retryDelay = retryDelay;
    }

    public double getTimeout() {
        return this.timeout;
    }

    public void setTimeout(double timeout) {
        this.timeout = timeout;
    }

    public int getMaxPendingBytes() {
        return this.maxPendingBytes;
    }

    public void setMaxPendingBytes(int maxPendingBytes) {
        this.maxPendingBytes = maxPendingBytes;
    }

    public int getMaxPendingDocs() {
        return this.maxPendingDocs;
    }

    public void setMaxPendingDocs(int maxPendingDocs) {
        this.maxPendingDocs = maxPendingDocs;
    }

    public boolean abortOnDocumentError() {
        return this.abortOnDocumentError;
    }

    public void setAbortOnDocumentError(boolean abortOnDocumentError) {
        this.abortOnDocumentError = abortOnDocumentError;
    }

    public boolean abortOnSendError() {
        return this.abortOnSendError;
    }

    public void setAbortOnSendError(boolean abortOnSendError) {
        this.abortOnSendError = abortOnSendError;
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public String getRoute() {
        return this.route;
    }

    public DocumentProtocol.Priority getPriority() {
        return this.priority;
    }

    public boolean isPriorityExplicitlySet() {
        return this.priorityExplicitlySet;
    }

    public String getSlobrokConfigId() {
        return this.slobrokConfigId;
    }

    public void setSlobrokConfigId(String slobrokConfigId) {
        this.slobrokConfigId = slobrokConfigId;
    }

    public String getRoutingConfigId() {
        return this.routingConfigId;
    }

    public void setRoutingConfigId(String routingConfigId) {
        this.routingConfigId = routingConfigId;
    }

    public String getDocumentManagerConfigId() {
        return this.documentManagerConfigId;
    }

    public void setDocumentManagerConfigId(String documentManagerConfigId) {
        this.documentManagerConfigId = documentManagerConfigId;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    public int getMessageBusPort() {
        return this.mbusPort;
    }

    public void setMessageBusPort(int mbusPort) {
        this.mbusPort = mbusPort;
    }

    public void setPriority(DocumentProtocol.Priority priority) {
        this.priority = priority;
        this.priorityExplicitlySet = true;
    }

    public String getDocprocChain() {
        return this.docprocChain;
    }

    public void setDocprocChain(String chain) {
        this.docprocChain = chain;
    }

    public SourceSessionParams toSourceSessionParams() {
        SourceSessionParams params = new SourceSessionParams();
        Object policy = this.maxFeedRate > 0.0 ? new RateThrottlingPolicy(this.maxFeedRate) : (this.maxPendingDocs == 0 && this.maxPendingBytes == 0 ? new DynamicThrottlePolicy() : new StaticThrottlePolicy());
        if (this.maxPendingDocs > 0) {
            policy.setMaxPendingCount(this.maxPendingDocs);
        }
        if (this.maxPendingBytes > 0) {
            policy.setMaxPendingSize((long)this.maxPendingBytes);
        }
        params.setThrottlePolicy((ThrottlePolicy)policy);
        params.setTimeout(this.getTimeout());
        return params;
    }

    public RPCNetworkParams getNetworkParams() {
        try {
            RPCNetworkParams networkParams = new RPCNetworkParams();
            if (this.mbusPort != -1) {
                networkParams.setListenPort(this.mbusPort);
            }
            return networkParams;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return "FeederOptions{abortOnDocumentError=" + this.abortOnDocumentError + ", abortOnSendError=" + this.abortOnSendError + ", retryEnabled=" + this.retryEnabled + ", retryDelay=" + this.retryDelay + ", timeout=" + this.timeout + ", maxPendingBytes=" + this.maxPendingBytes + ", maxPendingDocs=" + this.maxPendingDocs + ", documentManagerConfigId='" + this.documentManagerConfigId + '\'' + ", idPrefix='" + this.idPrefix + '\'' + ", route='" + this.route + '\'' + ", routingConfigId='" + this.routingConfigId + '\'' + ", slobrokConfigId='" + this.slobrokConfigId + '\'' + ", traceLevel=" + this.traceLevel + ", mbusPort=" + this.mbusPort + ", priority=" + this.priority.name() + ", priorityExplicitlySet=" + this.priorityExplicitlySet + ", docprocChain='" + this.docprocChain + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FeederOptions)) {
            return false;
        }
        FeederOptions that = (FeederOptions)o;
        if (this.abortOnDocumentError != that.abortOnDocumentError) {
            return false;
        }
        if (this.abortOnSendError != that.abortOnSendError) {
            return false;
        }
        if (this.maxPendingBytes != that.maxPendingBytes) {
            return false;
        }
        if (this.maxPendingDocs != that.maxPendingDocs) {
            return false;
        }
        if (this.maxFeedRate != that.maxFeedRate) {
            return false;
        }
        if (this.mbusPort != that.mbusPort) {
            return false;
        }
        if (this.priorityExplicitlySet != that.priorityExplicitlySet) {
            return false;
        }
        if (Double.compare(that.retryDelay, this.retryDelay) != 0) {
            return false;
        }
        if (this.retryEnabled != that.retryEnabled) {
            return false;
        }
        if (Double.compare(that.timeout, this.timeout) != 0) {
            return false;
        }
        if (this.traceLevel != that.traceLevel) {
            return false;
        }
        if (this.docprocChain != null ? !this.docprocChain.equals(that.docprocChain) : that.docprocChain != null) {
            return false;
        }
        if (this.documentManagerConfigId != null ? !this.documentManagerConfigId.equals(that.documentManagerConfigId) : that.documentManagerConfigId != null) {
            return false;
        }
        if (this.idPrefix != null ? !this.idPrefix.equals(that.idPrefix) : that.idPrefix != null) {
            return false;
        }
        if (this.priority != that.priority) {
            return false;
        }
        if (this.route != null ? !this.route.equals(that.route) : that.route != null) {
            return false;
        }
        if (this.routingConfigId != null ? !this.routingConfigId.equals(that.routingConfigId) : that.routingConfigId != null) {
            return false;
        }
        return !(this.slobrokConfigId != null ? !this.slobrokConfigId.equals(that.slobrokConfigId) : that.slobrokConfigId != null);
    }

    public int hashCode() {
        int result = this.abortOnDocumentError ? 1 : 0;
        result = 31 * result + (this.abortOnSendError ? 1 : 0);
        result = 31 * result + (this.retryEnabled ? 1 : 0);
        long temp = this.retryDelay != 0.0 ? Double.doubleToLongBits(this.retryDelay) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.timeout != 0.0 ? Double.doubleToLongBits(this.timeout) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.maxPendingBytes;
        result = 31 * result + this.maxPendingDocs;
        result = 31 * result + (int)(this.maxFeedRate * 1000.0);
        result = 31 * result + (this.documentManagerConfigId != null ? this.documentManagerConfigId.hashCode() : 0);
        result = 31 * result + (this.idPrefix != null ? this.idPrefix.hashCode() : 0);
        result = 31 * result + (this.route != null ? this.route.hashCode() : 0);
        result = 31 * result + (this.routingConfigId != null ? this.routingConfigId.hashCode() : 0);
        result = 31 * result + (this.slobrokConfigId != null ? this.slobrokConfigId.hashCode() : 0);
        result = 31 * result + this.traceLevel;
        result = 31 * result + this.mbusPort;
        result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
        result = 31 * result + (this.priorityExplicitlySet ? 1 : 0);
        result = 31 * result + (this.docprocChain != null ? this.docprocChain.hashCode() : 0);
        return result;
    }
}

