/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.document.DocumentTypeManager;
import com.yahoo.feedapi.VespaFeedSender;
import com.yahoo.vespaxmlparser.FeedReader;
import com.yahoo.vespaxmlparser.VespaXMLFeedReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public abstract class Feeder {
    protected final InputStream stream;
    protected final DocumentTypeManager docMan;
    protected List<String> errors = new LinkedList<String>();
    protected boolean doAbort = true;
    protected boolean createIfNonExistent = false;
    protected final VespaFeedSender sender;
    private final int MAX_ERRORS = 10;

    protected Feeder(DocumentTypeManager docMan, VespaFeedSender sender, InputStream stream) {
        this.docMan = docMan;
        this.sender = sender;
        this.stream = stream;
    }

    public void setAbortOnDocumentError(boolean doAbort) {
        this.doAbort = doAbort;
    }

    public void setCreateIfNonExistent(boolean value) {
        this.createIfNonExistent = value;
    }

    public void addException(Exception e) {
        String message;
        if (e.getMessage() != null) {
            message = e.getMessage().replaceAll("\"", "'");
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            message = "(no message) " + sw.toString();
        }
        this.addError("ERROR: " + message);
    }

    private void addError(String error) {
        if (this.errors.size() < 10) {
            this.errors.add(error);
        } else if (this.errors.size() == 10) {
            this.errors.add("Reached maximum limit of errors (10). Not collecting any more.");
        }
    }

    protected abstract FeedReader createReader() throws Exception;

    public List<String> parse() {
        FeedReader reader = null;
        try {
            reader = this.createReader();
        }
        catch (Exception e) {
            this.addError("ERROR: " + e.getClass().toString() + ": " + e.getMessage().replaceAll("\"", "'"));
            return this.errors;
        }
        while (!this.sender.isAborted()) {
            try {
                VespaXMLFeedReader.Operation op = new VespaXMLFeedReader.Operation();
                reader.read(op);
                if (this.createIfNonExistent && op.getDocumentUpdate() != null) {
                    op.getDocumentUpdate().setCreateIfNonExistent(true);
                }
                if (op.getType() == VespaXMLFeedReader.OperationType.INVALID) break;
                this.sender.sendOperation(op);
            }
            catch (XMLStreamException e) {
                this.addException(e);
                break;
            }
            catch (Exception e) {
                this.addException(e);
                if (!this.doAbort) continue;
                break;
            }
        }
        return this.errors;
    }
}

