/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.clientmetrics.ClientMetrics;
import com.yahoo.cloud.config.ClusterListConfig;
import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.feedapi.MessageBusSessionFactory;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SessionFactory;
import com.yahoo.feedapi.SharedSender;
import com.yahoo.jdisc.Metric;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespaclient.ClusterList;
import com.yahoo.vespaclient.config.FeederConfig;
import java.util.Map;
import java.util.TreeMap;

public class FeedContext {
    private final SessionFactory factory;
    private final MessagePropertyProcessor propertyProcessor;
    private final DocumentTypeManager docTypeManager;
    private final ClusterList clusterList;
    private final ClientMetrics metrics;
    private final Metric metric;
    private Map<String, SharedSender> senders = new TreeMap<String, SharedSender>();
    public static final Object sync = new Object();
    public static FeedContext instance = null;

    public FeedContext(MessagePropertyProcessor propertyProcessor, SessionFactory factory, DocumentTypeManager manager, ClusterList clusterList, Metric metric) {
        this.propertyProcessor = propertyProcessor;
        this.factory = factory;
        this.docTypeManager = manager;
        this.clusterList = clusterList;
        this.metrics = new ClientMetrics();
        this.metric = metric;
    }

    public ClientMetrics getMetrics() {
        return this.metrics;
    }

    public ClusterList getClusterList() {
        return this.clusterList;
    }

    public SessionFactory getSessionFactory() {
        return this.factory;
    }

    public void shutdownSenders() {
        for (SharedSender s : this.senders.values()) {
            s.shutdown();
        }
    }

    public synchronized SharedSender getSharedSender(String route) {
        SharedSender sender;
        if (this.propertyProcessor.configChanged()) {
            TreeMap<String, SharedSender> newSenders = new TreeMap<String, SharedSender>();
            for (Map.Entry<String, SharedSender> sender2 : this.senders.entrySet()) {
                newSenders.put(sender2.getKey(), new SharedSender(sender2.getKey(), this.factory, sender2.getValue(), this.metric));
            }
            this.shutdownSenders();
            this.senders = newSenders;
            this.propertyProcessor.setConfigChanged(false);
        }
        if (route == null) {
            route = this.propertyProcessor.getFeederOptions().getRoute();
        }
        if ((sender = this.senders.get(route)) == null) {
            sender = new SharedSender(route, this.factory, sender, this.metric);
            this.senders.put(route, sender);
            this.metrics.addRouteMetricSet(sender.getMetrics());
        }
        return sender;
    }

    public MessagePropertyProcessor getPropertyProcessor() {
        return this.propertyProcessor;
    }

    public DocumentTypeManager getDocumentTypeManager() {
        return this.docTypeManager;
    }

    public static FeedContext getInstance(FeederConfig feederConfig, LoadTypeConfig loadTypeConfig, DocumentmanagerConfig documentmanagerConfig, SlobroksConfig slobroksConfig, ClusterListConfig clusterListConfig, Metric metric) {
        Object object = sync;
        synchronized (object) {
            try {
                if (instance == null) {
                    MessagePropertyProcessor proc = new MessagePropertyProcessor(feederConfig, loadTypeConfig);
                    if (System.getProperty("vespa.local", "false").equals("true")) {
                        MessageBusSessionFactory mbusFactory = new MessageBusSessionFactory(proc, documentmanagerConfig, slobroksConfig);
                        instance = new FeedContext(proc, mbusFactory, mbusFactory.getAccess().getDocumentTypeManager(), new ClusterList(clusterListConfig), metric);
                    } else {
                        MessageBusSessionFactory mbusFactory = new MessageBusSessionFactory(proc, null, null);
                        instance = new FeedContext(proc, mbusFactory, mbusFactory.getAccess().getDocumentTypeManager(), new ClusterList("client"), metric);
                    }
                } else {
                    instance.getPropertyProcessor().configure(feederConfig, loadTypeConfig);
                }
                return instance;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

