/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.document.Document;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.feedapi.SendSession;
import com.yahoo.feedapi.SessionFactory;
import com.yahoo.jdisc.Metric;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Result;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class DummySessionFactory
implements SessionFactory {
    public final List<Message> messages;
    private boolean autoReply = false;
    private ReplyFactory autoReplyFactory = null;
    private Error autoError;
    private int sessionsCreated = 0;
    OutputStream output = null;

    protected DummySessionFactory() {
        this.messages = new ArrayList<Message>();
    }

    public static DummySessionFactory createDefault() {
        return new DummySessionFactory();
    }

    protected DummySessionFactory(boolean autoReply) {
        this.autoReply = autoReply;
        this.messages = new ArrayList<Message>();
    }

    protected DummySessionFactory(ReplyFactory autoReplyFactory) {
        this.autoReply = true;
        this.autoReplyFactory = autoReplyFactory;
        this.messages = new ArrayList<Message>();
    }

    public static DummySessionFactory createWithAutoReplyFactory(ReplyFactory autoReplyFactory) {
        return new DummySessionFactory(autoReplyFactory);
    }

    protected DummySessionFactory(Error e) {
        this.autoReply = true;
        this.autoError = e;
        this.messages = new ArrayList<Message>();
    }

    public static DummySessionFactory createWithErrorAutoReply(Error e) {
        return new DummySessionFactory(e);
    }

    public static DummySessionFactory createWithAutoReply() {
        return new DummySessionFactory(true);
    }

    public DummySessionFactory(Error e, OutputStream out) {
        this.messages = null;
        this.autoReply = true;
        this.output = out;
    }

    public int sessionsCreated() {
        return this.sessionsCreated;
    }

    void add(Message m) {
        if (this.messages != null) {
            this.messages.add(m);
        }
    }

    @Override
    public SendSession createSendSession(ReplyHandler r, Metric metric) {
        ++this.sessionsCreated;
        if (this.output != null) {
            return new DumpDocuments(this.output, r, this);
        }
        if (this.autoReply) {
            return new AutoReplySession(r, this.autoReplyFactory, this.autoError, this);
        }
        return new DummySession(r, this);
    }

    @Override
    public VisitorSession createVisitorSession(VisitorParameters p) {
        return null;
    }

    public void sendReply(Message m, Error error) {
        MyContext ctxt = (MyContext)m.getContext();
        EmptyReply r = new EmptyReply();
        r.setMessage(m);
        r.setContext(ctxt.oldContext);
        if (error != null) {
            r.addError(error);
        }
        ctxt.handler.handleReply((Reply)r);
    }

    private class DummySession
    extends SendSession {
        ReplyHandler handler;
        DummySessionFactory owner;

        public DummySession(ReplyHandler handler, DummySessionFactory owner) {
            this.handler = handler;
            this.owner = owner;
        }

        @Override
        protected Result onSend(Message m, boolean blockIfQueueFull) throws InterruptedException {
            m.setContext((Object)new MyContext(this.handler, m.getContext()));
            this.owner.add(m);
            return Result.ACCEPTED;
        }

        @Override
        public void close() {
        }
    }

    private class DumpDocuments
    extends AutoReplySession {
        final OutputStream out;

        public DumpDocuments(OutputStream out, ReplyHandler r, DummySessionFactory factory) {
            super(r, null, null, factory);
            this.out = out;
        }

        @Override
        protected void handleMessage(Message m) {
            if (m instanceof PutDocumentMessage) {
                PutDocumentMessage p = (PutDocumentMessage)m;
                Document d = p.getDocumentPut().getDocument();
                d.serialize(this.out);
            }
        }
    }

    private class AutoReplySession
    extends SendSession {
        ReplyHandler handler;
        ReplyFactory replyFactory;
        Error e;
        DummySessionFactory owner;

        public AutoReplySession(ReplyHandler handler, ReplyFactory replyFactory, Error e, DummySessionFactory owner) {
            this.handler = handler;
            this.replyFactory = replyFactory;
            this.e = e;
            this.owner = owner;
        }

        protected void handleMessage(Message m) {
        }

        @Override
        protected Result onSend(Message m, boolean blockIfQueueFull) throws InterruptedException {
            this.owner.add(m);
            this.handleMessage(m);
            Object r = this.replyFactory == null ? new EmptyReply() : this.replyFactory.createReply(m);
            m.setTimeReceivedNow();
            r.setMessage(m);
            r.setContext(m.getContext());
            if (this.e != null) {
                r.addError(this.e);
            }
            this.handler.handleReply((Reply)r);
            return Result.ACCEPTED;
        }

        @Override
        public void close() {
        }
    }

    private class MyContext {
        ReplyHandler handler;
        Object oldContext;

        MyContext(ReplyHandler handler, Object ctxt) {
            this.handler = handler;
            this.oldContext = ctxt;
        }
    }

    public static interface ReplyFactory {
        public Reply createReply(Message var1);
    }
}

