/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.clientmetrics;

import com.yahoo.clientmetrics.MessageTypeMetricSet;
import com.yahoo.messagebus.Reply;
import com.yahoo.metrics.Metric;
import com.yahoo.metrics.MetricSet;
import com.yahoo.metrics.SumMetric;
import java.util.HashMap;
import java.util.Map;

public class RouteMetricSet
extends MetricSet {
    SumMetric sum;
    ProgressCallback callback;
    Map<Integer, MessageTypeMetricSet> typeMap = new HashMap<Integer, MessageTypeMetricSet>();

    public RouteMetricSet(String route, ProgressCallback callback) {
        super(route, "", "Messages sent to the named route", null);
        this.sum = new SumMetric("total", "", "All kinds of messages sent to the given route", (MetricSet)this);
        this.callback = callback;
    }

    public String getXMLTag() {
        return "route";
    }

    public RouteMetricSet(RouteMetricSet source, Metric.CopyType copyType, MetricSet owner, boolean includeUnused) {
        super((MetricSet)source, copyType, owner, includeUnused);
    }

    public void addReply(Reply r) {
        MessageTypeMetricSet type = this.typeMap.get(r.getMessage().getType());
        if (type == null) {
            String msgName = r.getMessage().getClass().getSimpleName().replace("Message", "");
            type = new MessageTypeMetricSet(msgName, this);
            this.sum.addMetricToSum((Metric)type);
            this.typeMap.put(r.getMessage().getType(), type);
        }
        type.addReply(r);
        if (this.callback != null) {
            this.callback.onProgress(this);
        }
    }

    public void done() {
        if (this.callback != null) {
            this.callback.done(this);
        }
    }

    public Metric clone(Metric.CopyType type, MetricSet owner, boolean includeUnused) {
        return new RouteMetricSet(this, type, owner, includeUnused);
    }

    String getRoute() {
        return this.getName();
    }

    public static interface ProgressCallback {
        public void onProgress(RouteMetricSet var1);

        public void done(RouteMetricSet var1);
    }
}

