/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.clientmetrics;

import com.yahoo.concurrent.SystemTimer;
import com.yahoo.documentapi.messagebus.protocol.DocumentIgnoredReply;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Reply;
import com.yahoo.metrics.CountMetric;
import com.yahoo.metrics.Metric;
import com.yahoo.metrics.MetricSet;
import com.yahoo.metrics.SimpleMetricSet;
import com.yahoo.metrics.SumMetric;
import com.yahoo.metrics.ValueMetric;
import java.util.stream.Stream;

public class MessageTypeMetricSet
extends MetricSet {
    ValueMetric<Long> latency;
    CountMetric count;
    CountMetric ignored;
    SumMetric errorSum;
    MetricSet errors;
    String msgName;

    public MessageTypeMetricSet(String msgName, MetricSet owner) {
        super(msgName.toLowerCase(), "", "", owner);
        this.msgName = msgName;
        this.latency = new ValueMetric("latency", "", "Latency (in ms)", (MetricSet)this).averageMetric();
        this.count = new CountMetric("count", "", "Number received", (MetricSet)this);
        this.ignored = new CountMetric("ignored", "", "Number ignored due to no matching document routing selectors", (MetricSet)this);
        this.errors = new SimpleMetricSet("errors", "", "The errors returned", (MetricSet)this);
        this.errorSum = new SumMetric("total", "", "Total number of errors", this.errors);
    }

    public MessageTypeMetricSet(MessageTypeMetricSet source, Metric.CopyType copyType, MetricSet owner, boolean includeUnused) {
        super((MetricSet)source, copyType, owner, includeUnused);
        this.msgName = source.msgName;
    }

    public String getMessageName() {
        return this.msgName;
    }

    public void addReply(Reply r) {
        if (!r.hasErrors() || MessageTypeMetricSet.onlyTestAndSetConditionFailed(r.getErrors())) {
            this.updateSuccessMetrics(r);
        } else {
            this.updateFailureMetrics(r);
        }
    }

    private void updateFailureMetrics(Reply r) {
        String error = DocumentProtocol.getErrorName((int)r.getError(0).getCode());
        CountMetric s = (CountMetric)this.errors.getMetric(error);
        if (s == null) {
            s = new ErrorMetric(error, this.errors);
            this.errorSum.addMetricToSum((Metric)s);
        }
        s.inc();
    }

    private void updateSuccessMetrics(Reply r) {
        if (!(r instanceof DocumentIgnoredReply)) {
            if (r.getMessage().getTimeReceived() != 0L) {
                this.latency.addValue((Number)(SystemTimer.INSTANCE.milliTime() - r.getMessage().getTimeReceived()));
            }
            this.count.inc();
        } else {
            this.ignored.inc();
        }
    }

    public Metric clone(Metric.CopyType type, MetricSet owner, boolean includeUnused) {
        return new MessageTypeMetricSet(this, type, owner, includeUnused);
    }

    private static boolean onlyTestAndSetConditionFailed(Stream<Error> errors) {
        return errors.allMatch(e -> e.getCode() == 251013);
    }

    class ErrorMetric
    extends CountMetric {
        ErrorMetric(String name, MetricSet owner) {
            super(name, "", "Number of errors of type " + name, owner);
        }

        ErrorMetric(ErrorMetric other, Metric.CopyType copyType, MetricSet owner) {
            super((CountMetric)other, copyType, owner);
        }

        public String getXMLTag() {
            return "error";
        }

        public Metric clone(Metric.CopyType type, MetricSet owner, boolean includeUnused) {
            return new ErrorMetric(this, type, owner);
        }
    }
}

