/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.vespa.http.server.ErrorCode;
import com.yahoo.vespa.http.server.OperationStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;

public class FeedResponse
extends HttpResponse {
    BlockingQueue<OperationStatus> operations;

    public FeedResponse(int status, BlockingQueue<OperationStatus> operations, int protocolVersion, String sessionId) {
        super(status);
        this.operations = operations;
        this.headers().add("X-Yahoo-Feed-Session-Id", sessionId);
        this.headers().add("X-Yahoo-Feed-Protocol-Version", Integer.toString(protocolVersion));
    }

    public FeedResponse(int status, BlockingQueue<OperationStatus> operations, int protocolVersion, String sessionId, int outstandingClientOperations, String hostName) {
        super(status);
        this.operations = operations;
        this.headers().add("X-Yahoo-Feed-Session-Id", sessionId);
        this.headers().add("X-Yahoo-Feed-Protocol-Version", Integer.toString(protocolVersion));
        this.headers().add("X-Yahoo-Outstanding-Requests", Integer.toString(outstandingClientOperations));
        this.headers().add("X-Yahoo-Hostname", hostName);
    }

    public void render(OutputStream output) throws IOException {
        int i = 0;
        try {
            OperationStatus status = this.operations.take();
            while (status.errorCode != ErrorCode.END_OF_FEED) {
                output.write(this.toBytes(status.render()));
                if (++i % 5 == 0) {
                    output.flush();
                }
                status = this.operations.take();
            }
        }
        catch (InterruptedException e) {
            output.flush();
        }
    }

    private byte[] toBytes(String s) {
        byte[] b = new byte[s.length()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)s.charAt(i);
        }
        return b;
    }

    public String getContentType() {
        return "text/plain";
    }

    public String getCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }
}

