/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.yahoo.cloud.config.ClusterListConfig;
import com.yahoo.component.annotation.Inject;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.concurrent.SystemTimer;
import com.yahoo.container.core.HandlerMetricContextUtil;
import com.yahoo.container.core.documentapi.VespaDocumentAccess;
import com.yahoo.container.jdisc.ContentChannelOutputStream;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.idstring.IdIdString;
import com.yahoo.document.json.JsonReader;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.document.json.ParsedDocumentOperation;
import com.yahoo.document.restapi.DocumentOperationExecutorConfig;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AckToken;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.AsyncSession;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.DocumentOperationParameters;
import com.yahoo.documentapi.DocumentResponse;
import com.yahoo.documentapi.ProgressToken;
import com.yahoo.documentapi.Response;
import com.yahoo.documentapi.Result;
import com.yahoo.documentapi.VisitorControlHandler;
import com.yahoo.documentapi.VisitorControlSession;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.metrics.DocumentApiMetrics;
import com.yahoo.documentapi.metrics.DocumentOperationStatus;
import com.yahoo.documentapi.metrics.DocumentOperationType;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.BufferedContentChannel;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ReadableContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.handler.UnsafeContentInputStream;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.messagebus.DynamicThrottlePolicy;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.StaticThrottlePolicy;
import com.yahoo.messagebus.ThrottlePolicy;
import com.yahoo.messagebus.Trace;
import com.yahoo.messagebus.TraceNode;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.restapi.Path;
import com.yahoo.search.query.ParameterParser;
import com.yahoo.tensor.serialization.JsonFormat;
import com.yahoo.text.Text;
import com.yahoo.vespa.config.content.AllClustersBucketSpacesConfig;
import com.yahoo.vespa.http.server.MetricNames;
import com.yahoo.yolean.Exceptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DocumentV1ApiHandler
extends AbstractRequestHandler {
    private static final Duration defaultTimeout = Duration.ofSeconds(180L);
    private static final Duration handlerTimeout = Duration.ofMillis(100L);
    private static final Logger log = Logger.getLogger(DocumentV1ApiHandler.class.getName());
    private static final Parser<Integer> integerParser = Integer::parseInt;
    private static final Parser<Long> unsignedLongParser = Long::parseUnsignedLong;
    private static final Parser<Long> timeoutMillisParser = value -> ParameterParser.asMilliSeconds((Object)value, (Long)defaultTimeout.toMillis());
    private static final Parser<Boolean> booleanParser = Boolean::parseBoolean;
    private static final CompletionHandler logException = new CompletionHandler(){

        public void completed() {
        }

        public void failed(Throwable t) {
            log.log(Level.FINE, "Exception writing or closing response data", t);
        }
    };
    private static final ContentChannel ignoredContent = new ContentChannel(){

        public void write(ByteBuffer buf, CompletionHandler handler) {
            handler.completed();
        }

        public void close(CompletionHandler handler) {
            handler.completed();
        }
    };
    private static final JsonFactory jsonFactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build())).build();
    private static final String CREATE = "create";
    private static final String CONDITION = "condition";
    private static final String ROUTE = "route";
    private static final String FIELD_SET = "fieldSet";
    private static final String SELECTION = "selection";
    private static final String CLUSTER = "cluster";
    private static final String DESTINATION_CLUSTER = "destinationCluster";
    private static final String CONTINUATION = "continuation";
    private static final String WANTED_DOCUMENT_COUNT = "wantedDocumentCount";
    private static final String CONCURRENCY = "concurrency";
    private static final String BUCKET_SPACE = "bucketSpace";
    private static final String TIME_CHUNK = "timeChunk";
    private static final String TIMEOUT = "timeout";
    private static final String TRACELEVEL = "tracelevel";
    private static final String STREAM = "stream";
    private static final String SLICES = "slices";
    private static final String SLICE_ID = "sliceId";
    private static final String DRY_RUN = "dryRun";
    private static final String FROM_TIMESTAMP = "fromTimestamp";
    private static final String TO_TIMESTAMP = "toTimestamp";
    private static final String INCLUDE_REMOVES = "includeRemoves";
    private final Clock clock;
    private final Duration visitTimeout;
    private final Metric metric;
    private final DocumentApiMetrics metrics;
    private final DocumentOperationParser parser;
    private final long maxThrottled;
    private final long maxThrottledAgeNS;
    private final DocumentAccess access;
    private final AsyncSession asyncSession;
    private final Map<String, StorageCluster> clusters;
    private final Deque<Operation> operations;
    private final Deque<BooleanSupplier> visitOperations = new ConcurrentLinkedDeque<BooleanSupplier>();
    private final AtomicLong enqueued = new AtomicLong();
    private final AtomicLong outstanding = new AtomicLong();
    private final Map<VisitorControlHandler, VisitorSession> visits = new ConcurrentHashMap<VisitorControlHandler, VisitorSession>();
    private final ScheduledExecutorService dispatcher = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("document-api-handler-"));
    private final ScheduledExecutorService visitDispatcher = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("document-api-handler-visit-"));
    private final Map<String, Map<HttpRequest.Method, Handler>> handlers = this.defineApi();
    private final HandlerMetricContextUtil metricUtil;

    @Inject
    public DocumentV1ApiHandler(Metric metric, MetricReceiver metricReceiver, VespaDocumentAccess documentAccess, DocumentmanagerConfig documentManagerConfig, ClusterListConfig clusterListConfig, AllClustersBucketSpacesConfig bucketSpacesConfig, DocumentOperationExecutorConfig executorConfig) {
        this(Clock.systemUTC(), Duration.ofSeconds(5L), metric, metricReceiver, (DocumentAccess)documentAccess, documentManagerConfig, executorConfig, clusterListConfig, bucketSpacesConfig);
    }

    DocumentV1ApiHandler(Clock clock, Duration visitTimeout, Metric metric, MetricReceiver metricReceiver, DocumentAccess access, DocumentmanagerConfig documentmanagerConfig, DocumentOperationExecutorConfig executorConfig, ClusterListConfig clusterListConfig, AllClustersBucketSpacesConfig bucketSpacesConfig) {
        this.clock = clock;
        this.visitTimeout = visitTimeout;
        this.parser = new DocumentOperationParser(documentmanagerConfig);
        this.metric = metric;
        this.metrics = new DocumentApiMetrics(metricReceiver, "documentV1");
        this.maxThrottled = executorConfig.maxThrottled();
        log.info("maxThrottled=" + this.maxThrottled);
        this.maxThrottledAgeNS = (long)(executorConfig.maxThrottledAge() * 1.0E9);
        this.access = access;
        this.asyncSession = access.createAsyncSession(new AsyncParameters());
        this.clusters = DocumentV1ApiHandler.parseClusters(clusterListConfig, bucketSpacesConfig);
        this.operations = new ConcurrentLinkedDeque<Operation>();
        long resendDelayMS = SystemTimer.adjustTimeoutByDetectedHz((Duration)Duration.ofMillis(executorConfig.resendDelayMillis())).toMillis();
        this.dispatcher.scheduleWithFixedDelay(this::dispatchEnqueued, resendDelayMS, resendDelayMS, TimeUnit.MILLISECONDS);
        this.visitDispatcher.scheduleWithFixedDelay(this::dispatchVisitEnqueued, resendDelayMS, resendDelayMS, TimeUnit.MILLISECONDS);
        this.metricUtil = new HandlerMetricContextUtil(this.metric, ((Object)((Object)this)).getClass().getName());
    }

    public ContentChannel handleRequest(Request rawRequest, ResponseHandler rawResponseHandler) {
        this.metricUtil.onHandle(rawRequest);
        ResponseHandler responseHandler = response -> {
            this.metricUtil.onHandled(rawRequest);
            return rawResponseHandler.handleResponse(response);
        };
        HttpRequest request = (HttpRequest)rawRequest;
        try {
            request.setTimeout(DocumentV1ApiHandler.doomMillis(request) - this.clock.millis(), TimeUnit.MILLISECONDS);
            Path requestPath = Path.withoutValidation((URI)request.getUri());
            for (String path : this.handlers.keySet()) {
                if (!requestPath.matches(path)) continue;
                Map<HttpRequest.Method, Handler> methods = this.handlers.get(path);
                if (methods.containsKey(request.getMethod())) {
                    return methods.get(request.getMethod()).handle(request, new DocumentPath(requestPath, request.getUri().getRawPath()), responseHandler);
                }
                if (request.getMethod() == HttpRequest.Method.OPTIONS) {
                    DocumentV1ApiHandler.options(methods.keySet(), responseHandler);
                }
                DocumentV1ApiHandler.methodNotAllowed(request, methods.keySet(), responseHandler);
            }
            DocumentV1ApiHandler.notFound(request, this.handlers.keySet(), responseHandler);
        }
        catch (IllegalArgumentException e) {
            DocumentV1ApiHandler.badRequest(request, e, responseHandler);
        }
        catch (RuntimeException e) {
            DocumentV1ApiHandler.serverError(request, e, responseHandler);
        }
        return ignoredContent;
    }

    public void handleTimeout(Request request, ResponseHandler responseHandler) {
        HttpRequest httpRequest = (HttpRequest)request;
        DocumentV1ApiHandler.timeout(httpRequest, "Timeout after " + String.valueOf(DocumentV1ApiHandler.getProperty(httpRequest, TIMEOUT, timeoutMillisParser).orElse(defaultTimeout.toMillis())) + "ms", responseHandler);
    }

    public void destroy() {
        Instant doom = this.clock.instant().plus(Duration.ofSeconds(30L));
        this.visits.values().forEach(VisitorControlSession::abort);
        this.visits.values().forEach(VisitorControlSession::destroy);
        this.dispatcher.shutdown();
        this.visitDispatcher.shutdown();
        while (!(this.operations.isEmpty() && this.visitOperations.isEmpty() || !this.clock.instant().isBefore(doom))) {
            this.dispatchEnqueued();
            this.dispatchVisitEnqueued();
        }
        if (!this.operations.isEmpty()) {
            log.log(Level.WARNING, "Failed to empty request queue before shutdown timeout \u2014 " + this.operations.size() + " requests left");
        }
        if (!this.visitOperations.isEmpty()) {
            log.log(Level.WARNING, "Failed to empty visitor operations queue before shutdown timeout \u2014 " + this.visitOperations.size() + " operations left");
        }
        try {
            while (this.outstanding.get() > 0L && this.clock.instant().isBefore(doom)) {
                Thread.sleep(Math.max(1L, Duration.between(this.clock.instant(), doom).toMillis()));
            }
            if (!this.dispatcher.awaitTermination(Duration.between(this.clock.instant(), doom).toMillis(), TimeUnit.MILLISECONDS)) {
                this.dispatcher.shutdownNow();
            }
            if (!this.visitDispatcher.awaitTermination(Duration.between(this.clock.instant(), doom).toMillis(), TimeUnit.MILLISECONDS)) {
                this.visitDispatcher.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Interrupted waiting for /document/v1 executor to shut down");
        }
        finally {
            this.asyncSession.destroy();
            if (this.outstanding.get() != 0L) {
                log.log(Level.WARNING, "Failed to receive a response to " + this.outstanding.get() + " outstanding document operations during shutdown");
            }
        }
    }

    private Map<String, Map<HttpRequest.Method, Handler>> defineApi() {
        LinkedHashMap<String, Map<HttpRequest.Method, Handler>> handlers = new LinkedHashMap<String, Map<HttpRequest.Method, Handler>>();
        handlers.put("/document/v1/", Map.of(HttpRequest.Method.GET, this::getDocuments, HttpRequest.Method.POST, this::postDocuments, HttpRequest.Method.DELETE, this::deleteDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/docid/", Map.of(HttpRequest.Method.GET, this::getDocuments, HttpRequest.Method.POST, this::postDocuments, HttpRequest.Method.PUT, this::putDocuments, HttpRequest.Method.DELETE, this::deleteDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/group/{group}/", Map.of(HttpRequest.Method.GET, this::getDocuments, HttpRequest.Method.POST, this::postDocuments, HttpRequest.Method.PUT, this::putDocuments, HttpRequest.Method.DELETE, this::deleteDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/number/{number}/", Map.of(HttpRequest.Method.GET, this::getDocuments, HttpRequest.Method.POST, this::postDocuments, HttpRequest.Method.PUT, this::putDocuments, HttpRequest.Method.DELETE, this::deleteDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/docid/{*}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        handlers.put("/document/v1/{namespace}/{documentType}/group/{group}/{*}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        handlers.put("/document/v1/{namespace}/{documentType}/number/{number}/{*}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        return Collections.unmodifiableMap(handlers);
    }

    private ContentChannel getDocuments(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        DocumentV1ApiHandler.disallow(request, DRY_RUN);
        this.enqueueAndDispatch(request, handler, () -> {
            boolean streamed = DocumentV1ApiHandler.getProperty(request, STREAM, booleanParser).orElse(false);
            VisitorParameters parameters = this.parseGetParameters(request, path, streamed);
            return () -> {
                this.visitAndWrite(request, parameters, handler, streamed);
                return true;
            };
        });
        return ignoredContent;
    }

    private ContentChannel postDocuments(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        DocumentV1ApiHandler.disallow(request, DRY_RUN);
        this.enqueueAndDispatch(request, handler, () -> {
            StorageCluster destination = DocumentV1ApiHandler.resolveCluster(Optional.of(DocumentV1ApiHandler.requireProperty(request, DESTINATION_CLUSTER)), this.clusters);
            VisitorParameters parameters = this.parseParameters(request, path);
            parameters.setRemoteDataHandler("[Content:cluster=" + destination.name() + "]");
            parameters.setFieldSet("[document]");
            return () -> {
                this.visitWithRemote(request, parameters, handler);
                return true;
            };
        });
        return ignoredContent;
    }

    private ContentChannel putDocuments(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        DocumentV1ApiHandler.disallow(request, DRY_RUN);
        return new ForwardingContentChannel(in -> this.enqueueAndDispatch(request, handler, () -> {
            StorageCluster cluster = DocumentV1ApiHandler.resolveCluster(Optional.of(DocumentV1ApiHandler.requireProperty(request, CLUSTER)), this.clusters);
            VisitorParameters parameters = this.parseParameters(request, path);
            parameters.setFieldSet("[id]");
            String type = path.documentType().orElseThrow(() -> new IllegalStateException("Document type must be specified for mass updates"));
            IdIdString dummyId = new IdIdString("dummy", type, "", "");
            ParsedDocumentOperation update = this.parser.parseUpdate((InputStream)in, dummyId.toString());
            update.operation().setCondition(new TestAndSetCondition(DocumentV1ApiHandler.requireProperty(request, SELECTION)));
            return () -> {
                this.visitAndUpdate(request, parameters, update.fullyApplied(), handler, (DocumentUpdate)update.operation(), cluster.name());
                return true;
            };
        }));
    }

    private ContentChannel deleteDocuments(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        DocumentV1ApiHandler.disallow(request, DRY_RUN);
        this.enqueueAndDispatch(request, handler, () -> {
            VisitorParameters parameters = this.parseParameters(request, path);
            parameters.setFieldSet("[id]");
            TestAndSetCondition condition = new TestAndSetCondition(DocumentV1ApiHandler.requireProperty(request, SELECTION));
            StorageCluster cluster = DocumentV1ApiHandler.resolveCluster(Optional.of(DocumentV1ApiHandler.requireProperty(request, CLUSTER)), this.clusters);
            return () -> {
                this.visitAndDelete(request, parameters, handler, condition, cluster.name());
                return true;
            };
        });
        return ignoredContent;
    }

    private ContentChannel getDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        MeasuringResponseHandler handler = new MeasuringResponseHandler(request, rawHandler, DocumentOperationType.GET, this.clock.instant());
        DocumentV1ApiHandler.disallow(request, DRY_RUN);
        this.enqueueAndDispatch(request, handler, () -> {
            DocumentOperationParameters rawParameters = this.parametersFromRequest(request, CLUSTER, FIELD_SET);
            if (rawParameters.fieldSet().isEmpty()) {
                rawParameters = rawParameters.withFieldSet(path.documentType().orElseThrow() + ":[document]");
            }
            DocumentOperationParameters parameters = rawParameters.withResponseHandler(response -> {
                this.outstanding.decrementAndGet();
                DocumentV1ApiHandler.handle(path, request, handler, response, (document, jsonResponse) -> {
                    if (document != null) {
                        jsonResponse.writeSingleDocument(document);
                        jsonResponse.commit(200);
                    } else {
                        jsonResponse.commit(404);
                    }
                });
            });
            return () -> this.dispatchOperation(() -> this.asyncSession.get(path.id(), parameters));
        });
        return ignoredContent;
    }

    private ContentChannel postDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        MeasuringResponseHandler handler = new MeasuringResponseHandler(request, rawHandler, DocumentOperationType.PUT, this.clock.instant());
        if (DocumentV1ApiHandler.getProperty(request, DRY_RUN, booleanParser).orElse(false).booleanValue()) {
            DocumentV1ApiHandler.handleFeedOperation(path, true, handler, new com.yahoo.documentapi.Response(-1L));
            return ignoredContent;
        }
        return new ForwardingContentChannel(in -> this.enqueueAndDispatch(request, handler, () -> {
            ParsedDocumentOperation parsed = this.parser.parsePut((InputStream)in, path.id().toString());
            DocumentPut put = (DocumentPut)parsed.operation();
            DocumentV1ApiHandler.getProperty(request, CONDITION).map(TestAndSetCondition::new).ifPresent(arg_0 -> ((DocumentPut)put).setCondition(arg_0));
            DocumentV1ApiHandler.getProperty(request, CREATE, booleanParser).ifPresent(arg_0 -> ((DocumentPut)put).setCreateIfNonExistent(arg_0));
            DocumentOperationParameters parameters = this.parametersFromRequest(request, ROUTE).withResponseHandler(response -> {
                this.outstanding.decrementAndGet();
                this.updatePutMetrics(response.outcome(), DocumentV1ApiHandler.latencyOf(request), put.getCreateIfNonExistent());
                DocumentV1ApiHandler.handleFeedOperation(path, parsed.fullyApplied(), handler, response);
            });
            return () -> this.dispatchOperation(() -> this.asyncSession.put(put, parameters));
        }));
    }

    private ContentChannel putDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        MeasuringResponseHandler handler = new MeasuringResponseHandler(request, rawHandler, DocumentOperationType.UPDATE, this.clock.instant());
        if (DocumentV1ApiHandler.getProperty(request, DRY_RUN, booleanParser).orElse(false).booleanValue()) {
            DocumentV1ApiHandler.handleFeedOperation(path, true, handler, new com.yahoo.documentapi.Response(-1L));
            return ignoredContent;
        }
        return new ForwardingContentChannel(in -> this.enqueueAndDispatch(request, handler, () -> {
            ParsedDocumentOperation parsed = this.parser.parseUpdate((InputStream)in, path.id().toString());
            DocumentUpdate update = (DocumentUpdate)parsed.operation();
            DocumentV1ApiHandler.getProperty(request, CONDITION).map(TestAndSetCondition::new).ifPresent(arg_0 -> ((DocumentUpdate)update).setCondition(arg_0));
            DocumentV1ApiHandler.getProperty(request, CREATE, booleanParser).ifPresent(arg_0 -> ((DocumentUpdate)update).setCreateIfNonExistent(arg_0));
            DocumentOperationParameters parameters = this.parametersFromRequest(request, ROUTE).withResponseHandler(response -> {
                this.outstanding.decrementAndGet();
                this.updateUpdateMetrics(response.outcome(), DocumentV1ApiHandler.latencyOf(request), update.getCreateIfNonExistent());
                DocumentV1ApiHandler.handleFeedOperation(path, parsed.fullyApplied(), handler, response);
            });
            return () -> this.dispatchOperation(() -> this.asyncSession.update(update, parameters));
        }));
    }

    private ContentChannel deleteDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        MeasuringResponseHandler handler = new MeasuringResponseHandler(request, rawHandler, DocumentOperationType.REMOVE, this.clock.instant());
        if (DocumentV1ApiHandler.getProperty(request, DRY_RUN, booleanParser).orElse(false).booleanValue()) {
            DocumentV1ApiHandler.handleFeedOperation(path, true, handler, new com.yahoo.documentapi.Response(-1L));
            return ignoredContent;
        }
        this.enqueueAndDispatch(request, handler, () -> {
            DocumentRemove remove = new DocumentRemove(path.id());
            DocumentV1ApiHandler.getProperty(request, CONDITION).map(TestAndSetCondition::new).ifPresent(arg_0 -> ((DocumentRemove)remove).setCondition(arg_0));
            DocumentOperationParameters parameters = this.parametersFromRequest(request, ROUTE).withResponseHandler(response -> {
                this.outstanding.decrementAndGet();
                this.updateRemoveMetrics(response.outcome(), DocumentV1ApiHandler.latencyOf(request));
                DocumentV1ApiHandler.handleFeedOperation(path, true, handler, response);
            });
            return () -> this.dispatchOperation(() -> this.asyncSession.remove(remove, parameters));
        });
        return ignoredContent;
    }

    private DocumentOperationParameters parametersFromRequest(HttpRequest request, String ... names) {
        DocumentOperationParameters parameters = DocumentV1ApiHandler.getProperty(request, TRACELEVEL, integerParser).map(arg_0 -> ((DocumentOperationParameters)DocumentOperationParameters.parameters()).withTraceLevel(arg_0)).orElse(DocumentOperationParameters.parameters());
        parameters = parameters.withDeadline(Instant.ofEpochMilli(DocumentV1ApiHandler.doomMillis(request)).minus(handlerTimeout));
        String[] stringArray = names;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String name;
            parameters = switch (name = stringArray[i]) {
                case CLUSTER -> DocumentV1ApiHandler.getProperty(request, CLUSTER).map(cluster -> DocumentV1ApiHandler.resolveCluster(Optional.of(cluster), this.clusters).name()).map(arg_0 -> ((DocumentOperationParameters)parameters).withRoute(arg_0)).orElse(parameters);
                case FIELD_SET -> DocumentV1ApiHandler.getProperty(request, FIELD_SET).map(arg_0 -> ((DocumentOperationParameters)parameters).withFieldSet(arg_0)).orElse(parameters);
                case ROUTE -> DocumentV1ApiHandler.getProperty(request, ROUTE).map(arg_0 -> ((DocumentOperationParameters)parameters).withRoute(arg_0)).orElse(parameters);
                default -> throw new IllegalArgumentException("Unrecognized document operation parameter name '" + name + "'");
            };
        }
        return parameters;
    }

    void dispatchEnqueued() {
        try {
            while (this.dispatchFirst()) {
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Uncaught exception in /document/v1 dispatch thread", e);
        }
    }

    private boolean dispatchFirst() {
        Operation operation = this.operations.poll();
        if (operation == null) {
            return false;
        }
        if (operation.dispatch()) {
            this.enqueued.decrementAndGet();
            return true;
        }
        this.operations.push(operation);
        return false;
    }

    private void dispatchVisitEnqueued() {
        try {
            while (this.dispatchFirstVisit()) {
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Uncaught exception in /document/v1 dispatch thread", e);
        }
    }

    private boolean dispatchFirstVisit() {
        BooleanSupplier operation = this.visitOperations.poll();
        if (operation == null) {
            return false;
        }
        if (operation.getAsBoolean()) {
            return true;
        }
        this.visitOperations.push(operation);
        return false;
    }

    private long qAgeNS(HttpRequest request) {
        Operation oldest = this.operations.peek();
        return oldest != null ? request.relativeCreatedAtNanoTime() - oldest.request.relativeCreatedAtNanoTime() : 0L;
    }

    private void enqueueAndDispatch(HttpRequest request, ResponseHandler handler, Supplier<BooleanSupplier> operationParser) {
        long ageNS;
        if (this.maxThrottled == 0L) {
            Operation operation = new Operation(request, handler, operationParser);
            if (!operation.dispatch()) {
                DocumentV1ApiHandler.overload(request, "Rejecting execution due to overload: " + (long)this.asyncSession.getCurrentWindowSize() + " requests already enqueued", handler);
            }
            return;
        }
        long numQueued = this.enqueued.incrementAndGet();
        if (numQueued > this.maxThrottled) {
            this.enqueued.decrementAndGet();
            DocumentV1ApiHandler.overload(request, "Rejecting execution due to overload: " + this.maxThrottled + " requests already enqueued", handler);
            return;
        }
        if (numQueued > 1L && (ageNS = this.qAgeNS(request)) > this.maxThrottledAgeNS) {
            this.enqueued.decrementAndGet();
            DocumentV1ApiHandler.overload(request, "Rejecting execution due to overload: " + (double)this.maxThrottledAgeNS / 1.0E9 + " seconds worth of work enqueued", handler);
            return;
        }
        this.operations.offer(new Operation(request, handler, operationParser));
        this.dispatchFirst();
    }

    private static void options(Collection<HttpRequest.Method> methods, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            Response response = new Response(204);
            response.headers().add("Allow", methods.stream().sorted().map(Enum::name).collect(Collectors.joining(",")));
            handler.handleResponse(response).close(logException);
        });
    }

    private static void badRequest(HttpRequest request, IllegalArgumentException e, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            String message = Exceptions.toMessageString((Throwable)e);
            log.log(Level.FINE, () -> "Bad request for " + String.valueOf(request.getMethod()) + " at " + request.getUri().getRawPath() + ": " + message);
            JsonResponse.create(request, message, handler).respond(400);
        });
    }

    private static void notFound(HttpRequest request, Collection<String> paths, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> JsonResponse.create(request, "Nothing at '" + request.getUri().getRawPath() + "'. Available paths are:\n" + String.join((CharSequence)"\n", paths), handler).respond(404));
    }

    private static void methodNotAllowed(HttpRequest request, Collection<HttpRequest.Method> methods, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> JsonResponse.create(request, "'" + String.valueOf(request.getMethod()) + "' not allowed at '" + request.getUri().getRawPath() + "'. Allowed methods are: " + methods.stream().sorted().map(Enum::name).collect(Collectors.joining(", ")), handler).respond(405));
    }

    private static void overload(HttpRequest request, String message, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            log.log(Level.FINE, () -> "Overload handling request " + String.valueOf(request.getMethod()) + " " + request.getUri().getRawPath() + ": " + message);
            JsonResponse.create(request, message, handler).respond(429);
        });
    }

    private static void serverError(HttpRequest request, Throwable t, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            log.log(Level.WARNING, "Uncaught exception handling request " + String.valueOf(request.getMethod()) + " " + request.getUri().getRawPath(), t);
            JsonResponse.create(request, Exceptions.toMessageString((Throwable)t), handler).respond(500);
        });
    }

    private static void timeout(HttpRequest request, String message, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            log.log(Level.FINE, () -> "Timeout handling request " + String.valueOf(request.getMethod()) + " " + request.getUri().getRawPath() + ": " + message);
            JsonResponse.create(request, message, handler).respond(504);
        });
    }

    private static void loggingException(Exceptions.RunnableThrowingIOException runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            log.log(Level.FINE, "Failed writing response", e);
        }
    }

    private boolean dispatchOperation(Supplier<Result> documentOperation) {
        Result result = documentOperation.get();
        if (result.type() == Result.ResultType.TRANSIENT_ERROR) {
            return false;
        }
        if (result.type() == Result.ResultType.FATAL_ERROR) {
            throw new DispatchException(new Throwable(result.error().toString()));
        }
        this.outstanding.incrementAndGet();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handle(DocumentPath path, HttpRequest request, ResponseHandler handler, com.yahoo.documentapi.Response response, SuccessCallback callback) {
        try (JsonResponse jsonResponse = JsonResponse.create(path, handler, request);){
            jsonResponse.writeTrace(response.getTrace());
            if (response.isSuccess()) {
                callback.onSuccess(response instanceof DocumentResponse ? ((DocumentResponse)response).getDocument() : null, jsonResponse);
                return;
            }
            jsonResponse.writeMessage(response.getTextMessage());
            switch (response.outcome()) {
                case NOT_FOUND: {
                    jsonResponse.commit(404);
                    return;
                }
                case CONDITION_FAILED: {
                    jsonResponse.commit(412);
                    return;
                }
                case INSUFFICIENT_STORAGE: {
                    jsonResponse.commit(507);
                    return;
                }
                case TIMEOUT: {
                    jsonResponse.commit(504);
                    return;
                }
                case ERROR: {
                    log.log(Level.FINE, () -> "Exception performing document operation: " + response.getTextMessage());
                    jsonResponse.commit(500);
                    return;
                }
                default: {
                    log.log(Level.WARNING, "Unexpected document API operation outcome '" + String.valueOf(response.outcome()) + "' " + response.getTextMessage());
                    jsonResponse.commit(500);
                    return;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, "Failed writing response", e);
        }
    }

    private static void handleFeedOperation(DocumentPath path, boolean fullyApplied, ResponseHandler handler, com.yahoo.documentapi.Response response) {
        DocumentV1ApiHandler.handle(path, null, handler, response, (document, jsonResponse) -> jsonResponse.commit(200, fullyApplied));
    }

    private static double latencyOf(HttpRequest r) {
        return (double)(System.nanoTime() - r.relativeCreatedAtNanoTime()) / 1.0E9;
    }

    private void updatePutMetrics(Response.Outcome outcome, double latency, boolean create) {
        if (create && outcome == Response.Outcome.NOT_FOUND) {
            outcome = Response.Outcome.SUCCESS;
        }
        this.incrementMetricNumOperations();
        this.incrementMetricNumPuts();
        this.sampleLatency(latency);
        switch (outcome) {
            case SUCCESS: {
                this.incrementMetricSucceeded();
                break;
            }
            case NOT_FOUND: {
                this.incrementMetricNotFound();
                break;
            }
            case CONDITION_FAILED: {
                this.incrementMetricConditionNotMet();
                break;
            }
            case TIMEOUT: {
                this.incrementMetricFailedTimeout();
                this.incrementMetricFailed();
                break;
            }
            case INSUFFICIENT_STORAGE: {
                this.incrementMetricFailedInsufficientStorage();
                this.incrementMetricFailed();
                break;
            }
            case ERROR: {
                this.incrementMetricFailedUnknown();
                this.incrementMetricFailed();
            }
        }
    }

    private void updateUpdateMetrics(Response.Outcome outcome, double latency, boolean create) {
        if (create && outcome == Response.Outcome.NOT_FOUND) {
            outcome = Response.Outcome.SUCCESS;
        }
        this.incrementMetricNumOperations();
        this.incrementMetricNumUpdates();
        this.sampleLatency(latency);
        switch (outcome) {
            case SUCCESS: {
                this.incrementMetricSucceeded();
                break;
            }
            case NOT_FOUND: {
                this.incrementMetricNotFound();
                break;
            }
            case CONDITION_FAILED: {
                this.incrementMetricConditionNotMet();
                break;
            }
            case TIMEOUT: {
                this.incrementMetricFailedTimeout();
                this.incrementMetricFailed();
                break;
            }
            case INSUFFICIENT_STORAGE: {
                this.incrementMetricFailedInsufficientStorage();
                this.incrementMetricFailed();
                break;
            }
            case ERROR: {
                this.incrementMetricFailedUnknown();
                this.incrementMetricFailed();
            }
        }
    }

    private void updateRemoveMetrics(Response.Outcome outcome, double latency) {
        this.incrementMetricNumOperations();
        this.incrementMetricNumRemoves();
        this.sampleLatency(latency);
        switch (outcome) {
            case NOT_FOUND: 
            case SUCCESS: {
                this.incrementMetricSucceeded();
                break;
            }
            case CONDITION_FAILED: {
                this.incrementMetricConditionNotMet();
                break;
            }
            case TIMEOUT: {
                this.incrementMetricFailedTimeout();
                this.incrementMetricFailed();
                break;
            }
            case INSUFFICIENT_STORAGE: {
                this.incrementMetricFailedInsufficientStorage();
                this.incrementMetricFailed();
                break;
            }
            case ERROR: {
                this.incrementMetricFailedUnknown();
                this.incrementMetricFailed();
            }
        }
    }

    private void sampleLatency(double latency) {
        this.setMetric(MetricNames.LATENCY, latency);
    }

    private void incrementMetricNumOperations() {
        this.incrementMetric(MetricNames.NUM_OPERATIONS);
    }

    private void incrementMetricNumPuts() {
        this.incrementMetric(MetricNames.NUM_PUTS);
    }

    private void incrementMetricNumRemoves() {
        this.incrementMetric(MetricNames.NUM_REMOVES);
    }

    private void incrementMetricNumUpdates() {
        this.incrementMetric(MetricNames.NUM_UPDATES);
    }

    private void incrementMetricFailed() {
        this.incrementMetric(MetricNames.FAILED);
    }

    private void incrementMetricConditionNotMet() {
        this.incrementMetric(MetricNames.CONDITION_NOT_MET);
    }

    private void incrementMetricSucceeded() {
        this.incrementMetric(MetricNames.SUCCEEDED);
    }

    private void incrementMetricNotFound() {
        this.incrementMetric(MetricNames.NOT_FOUND);
    }

    private void incrementMetricParseError() {
        this.incrementMetric(MetricNames.PARSE_ERROR);
    }

    private void incrementMetricFailedUnknown() {
        this.incrementMetric(MetricNames.FAILED_UNKNOWN);
    }

    private void incrementMetricFailedTimeout() {
        this.incrementMetric(MetricNames.FAILED_TIMEOUT);
    }

    private void incrementMetricFailedInsufficientStorage() {
        this.incrementMetric(MetricNames.FAILED_INSUFFICIENT_STORAGE);
    }

    private void incrementMetric(String n) {
        this.metric.add(n, (Number)1, null);
    }

    private void setMetric(String n, Number v) {
        this.metric.set(n, v, null);
    }

    private VisitorParameters parseGetParameters(HttpRequest request, DocumentPath path, boolean streamed) {
        int wantedDocumentCount = DocumentV1ApiHandler.getProperty(request, WANTED_DOCUMENT_COUNT, integerParser).orElse(streamed ? Integer.MAX_VALUE : 1);
        if (wantedDocumentCount <= 0) {
            throw new IllegalArgumentException("wantedDocumentCount must be positive");
        }
        Optional<Integer> concurrency = DocumentV1ApiHandler.getProperty(request, CONCURRENCY, integerParser);
        concurrency.ifPresent(value -> {
            if (value <= 0) {
                throw new IllegalArgumentException("concurrency must be positive");
            }
        });
        Optional<String> cluster = DocumentV1ApiHandler.getProperty(request, CLUSTER);
        if (cluster.isEmpty() && path.documentType().isEmpty()) {
            throw new IllegalArgumentException("Must set 'cluster' parameter to a valid content cluster id when visiting at a root /document/v1/ level");
        }
        VisitorParameters parameters = this.parseCommonParameters(request, path, cluster);
        parameters.setFieldSet(DocumentV1ApiHandler.getProperty(request, FIELD_SET).orElse(path.documentType().map(type -> type + ":[document]").orElse("[document]")));
        parameters.setMaxTotalHits((long)wantedDocumentCount);
        parameters.visitInconsistentBuckets(true);
        DocumentV1ApiHandler.getProperty(request, INCLUDE_REMOVES, booleanParser).ifPresent(arg_0 -> ((VisitorParameters)parameters).setVisitRemoves(arg_0));
        if (streamed) {
            DynamicThrottlePolicy throttlePolicy = new DynamicThrottlePolicy().setMinWindowSize(1.0).setWindowSizeIncrement(1.0);
            concurrency.ifPresent(arg_0 -> ((StaticThrottlePolicy)throttlePolicy).setMaxPendingCount(arg_0));
            parameters.setThrottlePolicy((ThrottlePolicy)throttlePolicy);
            parameters.setTimeoutMs(this.visitTimeout(request));
        } else {
            parameters.setThrottlePolicy((ThrottlePolicy)new StaticThrottlePolicy().setMaxPendingCount(Math.min(100, concurrency.orElse(1))));
            parameters.setSessionTimeoutMs(this.visitTimeout(request));
        }
        return parameters;
    }

    private VisitorParameters parseParameters(HttpRequest request, DocumentPath path) {
        DocumentV1ApiHandler.disallow(request, CONCURRENCY, FIELD_SET, ROUTE, WANTED_DOCUMENT_COUNT);
        DocumentV1ApiHandler.requireProperty(request, SELECTION);
        VisitorParameters parameters = this.parseCommonParameters(request, path, Optional.of(DocumentV1ApiHandler.requireProperty(request, CLUSTER)));
        parameters.setThrottlePolicy((ThrottlePolicy)new DynamicThrottlePolicy().setMinWindowSize(1.0).setWindowSizeIncrement(1.0));
        long timeChunk = DocumentV1ApiHandler.getProperty(request, TIME_CHUNK, timeoutMillisParser).orElse(60000L);
        parameters.setSessionTimeoutMs(Math.min(timeChunk, this.visitTimeout(request)));
        return parameters;
    }

    private long visitTimeout(HttpRequest request) {
        return Math.max(1L, Math.max(DocumentV1ApiHandler.doomMillis(request) - this.clock.millis() - this.visitTimeout.toMillis(), 9L * (DocumentV1ApiHandler.doomMillis(request) - this.clock.millis()) / 10L - handlerTimeout.toMillis()));
    }

    private VisitorParameters parseCommonParameters(HttpRequest request, DocumentPath path, Optional<String> cluster) {
        VisitorParameters parameters = new VisitorParameters(Stream.of(DocumentV1ApiHandler.getProperty(request, SELECTION), path.documentType(), path.namespace().map(value -> "id.namespace=='" + value + "'"), path.group().map(Group::selection)).flatMap(Optional::stream).reduce(new StringJoiner(") and (", "(", ")").setEmptyValue(""), StringJoiner::add, StringJoiner::merge).toString());
        DocumentV1ApiHandler.getProperty(request, TRACELEVEL, integerParser).ifPresent(arg_0 -> ((VisitorParameters)parameters).setTraceLevel(arg_0));
        DocumentV1ApiHandler.getProperty(request, CONTINUATION, ProgressToken::fromSerializedString).ifPresent(arg_0 -> ((VisitorParameters)parameters).setResumeToken(arg_0));
        parameters.setPriority(DocumentProtocol.Priority.NORMAL_4);
        DocumentV1ApiHandler.getProperty(request, FROM_TIMESTAMP, unsignedLongParser).ifPresent(arg_0 -> ((VisitorParameters)parameters).setFromTimestamp(arg_0));
        DocumentV1ApiHandler.getProperty(request, TO_TIMESTAMP, unsignedLongParser).ifPresent(ts -> {
            parameters.setToTimestamp(ts.longValue());
            if (Long.compareUnsigned(parameters.getFromTimestamp(), parameters.getToTimestamp()) > 0) {
                throw new IllegalArgumentException("toTimestamp must be greater than, or equal to, fromTimestamp");
            }
        });
        StorageCluster storageCluster = DocumentV1ApiHandler.resolveCluster(cluster, this.clusters);
        parameters.setRoute(storageCluster.name());
        parameters.setBucketSpace(DocumentV1ApiHandler.resolveBucket(storageCluster, path.documentType(), List.of(FixedBucketSpaces.defaultSpace(), FixedBucketSpaces.globalSpace()), DocumentV1ApiHandler.getProperty(request, BUCKET_SPACE)));
        Optional<Integer> slices = DocumentV1ApiHandler.getProperty(request, SLICES, integerParser);
        Optional<Integer> sliceId = DocumentV1ApiHandler.getProperty(request, SLICE_ID, integerParser);
        if (slices.isPresent() && sliceId.isPresent()) {
            parameters.slice(slices.get().intValue(), sliceId.get().intValue());
        } else if (slices.isPresent() != sliceId.isPresent()) {
            throw new IllegalArgumentException("None or both of 'slices' and 'sliceId' must be set");
        }
        return parameters;
    }

    private void visitAndDelete(HttpRequest request, VisitorParameters parameters, ResponseHandler handler, TestAndSetCondition condition, String route) {
        this.visitAndProcess(request, parameters, true, handler, route, (id, timestamp, operationParameters) -> {
            DocumentRemove remove = new DocumentRemove(id);
            if (timestamp != 0L) {
                remove.setCondition(TestAndSetCondition.ofRequiredTimestampWithSelectionFallback((long)timestamp, (String)condition.getSelection()));
            } else {
                remove.setCondition(condition);
            }
            return this.asyncSession.remove(remove, operationParameters);
        });
    }

    private void visitAndUpdate(HttpRequest request, VisitorParameters parameters, boolean fullyApplied, ResponseHandler handler, DocumentUpdate protoUpdate, String route) {
        this.visitAndProcess(request, parameters, fullyApplied, handler, route, (id, timestamp, operationParameters) -> {
            DocumentUpdate update = new DocumentUpdate(protoUpdate);
            if (timestamp != 0L) {
                update.setCondition(TestAndSetCondition.ofRequiredTimestampWithSelectionFallback((long)timestamp, (String)protoUpdate.getCondition().getSelection()));
            }
            update.setId(id);
            return this.asyncSession.update(update, operationParameters);
        });
    }

    private void visitAndProcess(HttpRequest request, VisitorParameters parameters, boolean fullyApplied, ResponseHandler handler, final String route, final VisitProcessingCallback operation) {
        this.visit(request, parameters, false, fullyApplied, handler, new VisitCallback(){

            @Override
            public void onDocument(JsonResponse response, Document document, DocumentId removeId, long persistedTimestamp, Runnable ack, Consumer<String> onError) {
                DocumentOperationParameters operationParameters = DocumentOperationParameters.parameters().withRoute(route).withResponseHandler(operationResponse -> {
                    DocumentV1ApiHandler.this.outstanding.decrementAndGet();
                    switch (operationResponse.outcome()) {
                        case NOT_FOUND: 
                        case CONDITION_FAILED: 
                        case SUCCESS: {
                            break;
                        }
                        case INSUFFICIENT_STORAGE: 
                        case TIMEOUT: 
                        case ERROR: {
                            onError.accept(operationResponse.getTextMessage());
                            break;
                        }
                        default: {
                            onError.accept("Unexpected response " + String.valueOf(operationResponse));
                        }
                    }
                });
                DocumentV1ApiHandler.this.visitOperations.offer(() -> {
                    Result result = operation.apply(document.getId(), persistedTimestamp, operationParameters);
                    if (result.type() == Result.ResultType.TRANSIENT_ERROR) {
                        return false;
                    }
                    if (result.type() == Result.ResultType.FATAL_ERROR) {
                        onError.accept(result.error().getMessage());
                    } else {
                        DocumentV1ApiHandler.this.outstanding.incrementAndGet();
                    }
                    ack.run();
                    return true;
                });
                DocumentV1ApiHandler.this.dispatchFirstVisit();
            }
        });
    }

    private void visitAndWrite(HttpRequest request, VisitorParameters parameters, ResponseHandler handler, final boolean streamed) {
        this.visit(request, parameters, streamed, true, handler, new VisitCallback(){

            @Override
            public void onStart(JsonResponse response, boolean fullyApplied) throws IOException {
                if (streamed) {
                    response.commit(200, fullyApplied);
                }
                response.writeDocumentsArrayStart();
            }

            @Override
            public void onDocument(JsonResponse response, Document document, DocumentId removeId, long persistedTimestamp, final Runnable ack, final Consumer<String> onError) {
                try {
                    if (streamed) {
                        CompletionHandler completion = new CompletionHandler(){

                            public void completed() {
                                ack.run();
                            }

                            public void failed(Throwable t) {
                                ack.run();
                                onError.accept(t.getMessage());
                            }
                        };
                        if (document != null) {
                            response.writeDocumentValue(document, completion);
                        } else {
                            response.writeDocumentRemoval(removeId, completion);
                        }
                    } else {
                        if (document != null) {
                            response.writeDocumentValue(document, null);
                        } else {
                            response.writeDocumentRemoval(removeId, null);
                        }
                        ack.run();
                    }
                }
                catch (Exception e) {
                    onError.accept(e.getMessage());
                }
            }

            @Override
            public void onEnd(JsonResponse response) throws IOException {
                response.writeArrayEnd();
            }
        });
    }

    private void visitWithRemote(HttpRequest request, VisitorParameters parameters, ResponseHandler handler) {
        this.visit(request, parameters, false, true, handler, new VisitCallback(){});
    }

    private void visit(final HttpRequest request, final VisitorParameters parameters, final boolean streaming, final boolean fullyApplied, ResponseHandler handler, final VisitCallback callback) {
        try {
            final JsonResponse response = JsonResponse.create(request, handler);
            final Phaser phaser = new Phaser(2);
            final AtomicReference error = new AtomicReference();
            callback.onStart(response, fullyApplied);
            final AtomicLong locallyReceivedDocCount = new AtomicLong(0L);
            final VisitorControlHandler controller = new VisitorControlHandler(){
                final ScheduledFuture<?> abort;
                final AtomicReference<VisitorSession> session;
                {
                    this.abort = streaming ? DocumentV1ApiHandler.this.visitDispatcher.schedule(() -> (this).abort(), DocumentV1ApiHandler.this.visitTimeout(request), TimeUnit.MILLISECONDS) : null;
                    this.session = new AtomicReference();
                }

                public void setSession(VisitorControlSession session) {
                    super.setSession(session);
                    if (session instanceof VisitorSession) {
                        VisitorSession visitorSession = (VisitorSession)session;
                        this.session.set(visitorSession);
                    }
                }

                public void onDone(VisitorControlHandler.CompletionCode code, String message) {
                    super.onDone(code, message);
                    DocumentV1ApiHandler.loggingException(() -> {
                        try (JsonResponse jsonResponse = response;){
                            callback.onEnd(response);
                            long statsDocCount = this.getVisitorStatistics() != null ? this.getVisitorStatistics().getDocumentsVisited() : 0L;
                            response.writeDocumentCount(parameters.getLocalDataHandler() != null ? locallyReceivedDocCount.get() : statsDocCount);
                            if (this.session.get() != null) {
                                response.writeTrace(this.session.get().getTrace());
                            }
                            int status = 500;
                            switch (code) {
                                case TIMEOUT: 
                                case ABORTED: {
                                    if (error.get() == null && !this.hasVisitedAnyBuckets() && parameters.getVisitInconsistentBuckets()) {
                                        response.writeMessage("No buckets visited within timeout of " + parameters.getSessionTimeoutMs() + "ms (request timeout -5s)");
                                        status = 504;
                                        break;
                                    }
                                }
                                case SUCCESS: {
                                    if (error.get() == null) {
                                        ProgressToken progress;
                                        ProgressToken progressToken = progress = this.getProgress() != null ? this.getProgress() : parameters.getResumeToken();
                                        if (progress != null && !progress.isFinished()) {
                                            response.writeContinuation(progress.serializeToString());
                                        }
                                        status = 200;
                                        break;
                                    }
                                }
                                default: {
                                    response.writeMessage(error.get() != null ? (String)error.get() : (message != null ? message : "Visiting failed"));
                                }
                            }
                            if (!streaming) {
                                response.commit(status, fullyApplied);
                            }
                        }
                    });
                    if (this.abort != null) {
                        this.abort.cancel(false);
                    }
                    DocumentV1ApiHandler.this.visitDispatcher.execute(() -> {
                        phaser.arriveAndAwaitAdvance();
                        DocumentV1ApiHandler.this.visits.remove((Object)this).destroy();
                    });
                }
            };
            if (parameters.getRemoteDataHandler() == null) {
                parameters.setLocalDataHandler(new VisitorDataHandler(){

                    public void onMessage(Message m, AckToken token) {
                        Document document = null;
                        DocumentId removeId = null;
                        long persistedTimestamp = 0L;
                        if (m instanceof PutDocumentMessage) {
                            PutDocumentMessage put = (PutDocumentMessage)m;
                            document = put.getDocumentPut().getDocument();
                            persistedTimestamp = put.getPersistedTimestamp();
                        } else if (parameters.visitRemoves() && m instanceof RemoveDocumentMessage) {
                            RemoveDocumentMessage remove = (RemoveDocumentMessage)m;
                            removeId = remove.getDocumentId();
                            persistedTimestamp = remove.getPersistedTimestamp();
                        } else {
                            throw new UnsupportedOperationException("Got unsupported message type: " + m.getClass().getName());
                        }
                        locallyReceivedDocCount.getAndAdd(1L);
                        callback.onDocument(response, document, removeId, persistedTimestamp, () -> this.ack(token), errorMessage -> {
                            error.set(errorMessage);
                            controller.abort();
                        });
                    }
                });
            }
            parameters.setControlHandler(controller);
            this.visits.put(controller, this.access.createVisitorSession(parameters));
            phaser.arriveAndDeregister();
        }
        catch (ParseException e) {
            DocumentV1ApiHandler.badRequest(request, new IllegalArgumentException(e), handler);
        }
        catch (IOException e) {
            log.log(Level.FINE, "Failed writing response", e);
        }
    }

    private static long doomMillis(HttpRequest request) {
        long createdAtMillis = request.creationTime(TimeUnit.MILLISECONDS);
        long requestTimeoutMillis = DocumentV1ApiHandler.getProperty(request, TIMEOUT, timeoutMillisParser).orElse(defaultTimeout.toMillis());
        return createdAtMillis + requestTimeoutMillis;
    }

    private static String requireProperty(HttpRequest request, String name) {
        return DocumentV1ApiHandler.getProperty(request, name).orElseThrow(() -> new IllegalArgumentException("Must specify '" + name + "' at '" + request.getUri().getRawPath() + "'"));
    }

    private static Optional<String> getProperty(HttpRequest request, String name) {
        String value;
        if (!request.parameters().containsKey(name)) {
            return Optional.empty();
        }
        List values = (List)request.parameters().get(name);
        if (values == null || values.isEmpty() || (value = (String)values.get(values.size() - 1)) == null || value.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty value for request property '" + name + "'");
        }
        return Optional.of(value);
    }

    private static <T> Optional<T> getProperty(HttpRequest request, String name, Parser<T> parser) {
        return DocumentV1ApiHandler.getProperty(request, name).map(parser::parse);
    }

    private static void disallow(HttpRequest request, String ... properties) {
        for (String property : properties) {
            if (!request.parameters().containsKey(property)) continue;
            throw new IllegalArgumentException("May not specify '" + property + "' at '" + request.getUri().getRawPath() + "'");
        }
    }

    private static Map<String, StorageCluster> parseClusters(ClusterListConfig clusters, AllClustersBucketSpacesConfig buckets) {
        return clusters.storage().stream().collect(Collectors.toUnmodifiableMap(ClusterListConfig.Storage::name, storage -> new StorageCluster(storage.name(), buckets.cluster(storage.name()).documentType().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AllClustersBucketSpacesConfig.Cluster.DocumentType)entry.getValue()).bucketSpace())))));
    }

    static StorageCluster resolveCluster(Optional<String> wanted, Map<String, StorageCluster> clusters) {
        if (clusters.isEmpty()) {
            throw new IllegalArgumentException("Your Vespa deployment has no content clusters, so the document API is not enabled");
        }
        return wanted.map(cluster -> {
            if (!clusters.containsKey(cluster)) {
                throw new IllegalArgumentException("Your Vespa deployment has no content cluster '" + cluster + "', only '" + String.join((CharSequence)"', '", clusters.keySet()) + "'");
            }
            return (StorageCluster)clusters.get(cluster);
        }).orElseGet(() -> {
            if (clusters.size() > 1) {
                throw new IllegalArgumentException("Please specify one of the content clusters in your Vespa deployment: '" + String.join((CharSequence)"', '", clusters.keySet()) + "'");
            }
            return (StorageCluster)clusters.values().iterator().next();
        });
    }

    static String resolveBucket(StorageCluster cluster, Optional<String> documentType, List<String> bucketSpaces, Optional<String> bucketSpace) {
        return documentType.map(type -> cluster.bucketOf((String)type).orElseThrow(() -> new IllegalArgumentException("There is no document type '" + type + "' in cluster '" + cluster.name() + "', only '" + String.join((CharSequence)"', '", cluster.documentBuckets.keySet()) + "'"))).or(() -> bucketSpace.map(space -> {
            if (!bucketSpaces.contains(space)) {
                throw new IllegalArgumentException("Bucket space '" + space + "' is not a known bucket space; expected one of " + String.join((CharSequence)", ", bucketSpaces));
            }
            return space;
        })).orElse(FixedBucketSpaces.defaultSpace());
    }

    class DocumentOperationParser {
        private final DocumentTypeManager manager;

        DocumentOperationParser(DocumentmanagerConfig config) {
            this.manager = new DocumentTypeManager(config);
        }

        ParsedDocumentOperation parsePut(InputStream inputStream, String docId) {
            return this.parse(inputStream, docId, com.yahoo.document.json.DocumentOperationType.PUT);
        }

        ParsedDocumentOperation parseUpdate(InputStream inputStream, String docId) {
            return this.parse(inputStream, docId, com.yahoo.document.json.DocumentOperationType.UPDATE);
        }

        private ParsedDocumentOperation parse(InputStream inputStream, String docId, com.yahoo.document.json.DocumentOperationType operation) {
            try {
                return new JsonReader(this.manager, inputStream, jsonFactory).readSingleDocumentStreaming(operation, docId);
            }
            catch (IllegalArgumentException e) {
                DocumentV1ApiHandler.this.incrementMetricParseError();
                throw e;
            }
        }
    }

    @FunctionalInterface
    static interface Handler {
        public ContentChannel handle(HttpRequest var1, DocumentPath var2, ResponseHandler var3);
    }

    private static class DocumentPath {
        private final Path path;
        private final String rawPath;
        private final Optional<Group> group;

        DocumentPath(Path path, String rawPath) {
            this.path = Objects.requireNonNull(path);
            this.rawPath = Objects.requireNonNull(rawPath);
            this.group = Optional.ofNullable(path.get("number")).map(unsignedLongParser::parse).map(Group::of).or(() -> Optional.ofNullable(path.get("group")).map(Group::of));
        }

        DocumentId id() {
            return new DocumentId("id:" + Objects.requireNonNull(this.path.get("namespace")) + ":" + Objects.requireNonNull(this.path.get("documentType")) + ":" + this.group.map(Group::docIdPart).orElse("") + ":" + String.join((CharSequence)"/", Objects.requireNonNull(this.path.getRest()).segments()));
        }

        String rawPath() {
            return this.rawPath;
        }

        Optional<String> documentType() {
            return Optional.ofNullable(this.path.get("documentType"));
        }

        Optional<String> namespace() {
            return Optional.ofNullable(this.path.get("namespace"));
        }

        Optional<Group> group() {
            return this.group;
        }
    }

    @FunctionalInterface
    static interface Parser<T>
    extends Function<String, T> {
        default public T parse(String value) {
            try {
                return (T)this.apply(value);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Failed parsing '" + value + "': " + Exceptions.toMessageString((Throwable)e));
            }
        }
    }

    static class ForwardingContentChannel
    implements ContentChannel {
        private final ReadableContentChannel delegate = new ReadableContentChannel();
        private final Consumer<InputStream> reader;
        private volatile boolean errorReported = false;

        public ForwardingContentChannel(Consumer<InputStream> reader) {
            this.reader = reader;
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            try {
                this.delegate.write(buf, logException);
                handler.completed();
            }
            catch (Exception e) {
                handler.failed((Throwable)e);
            }
        }

        public void close(CompletionHandler handler) {
            try {
                this.delegate.close(logException);
                if (!this.errorReported) {
                    this.reader.accept((InputStream)new UnsafeContentInputStream(this.delegate));
                }
                handler.completed();
            }
            catch (Exception e) {
                handler.failed((Throwable)e);
            }
        }

        public void onError(Throwable error) {
            log.log(Level.FINE, error, () -> "ContentChannel.onError(): " + error.getMessage());
            this.errorReported = true;
        }
    }

    private class MeasuringResponseHandler
    implements ResponseHandler {
        private final ResponseHandler delegate;
        private final DocumentOperationType type;
        private final Instant start;
        private final HttpRequest request;

        private MeasuringResponseHandler(HttpRequest request, ResponseHandler delegate, DocumentOperationType type, Instant start) {
            this.request = request;
            this.delegate = delegate;
            this.type = type;
            this.start = start;
        }

        public ContentChannel handleResponse(Response response) {
            switch (response.getStatus()) {
                case 200: {
                    this.report(DocumentOperationStatus.OK);
                    break;
                }
                case 400: {
                    this.report(DocumentOperationStatus.REQUEST_ERROR);
                    break;
                }
                case 404: {
                    this.report(DocumentOperationStatus.NOT_FOUND);
                    break;
                }
                case 412: {
                    this.report(DocumentOperationStatus.CONDITION_FAILED);
                    break;
                }
                case 429: {
                    this.report(DocumentOperationStatus.TOO_MANY_REQUESTS);
                    break;
                }
                case 500: 
                case 503: 
                case 504: 
                case 507: {
                    this.report(DocumentOperationStatus.SERVER_ERROR);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected status code '%s'".formatted(response.getStatus()));
                }
            }
            DocumentV1ApiHandler.this.metrics.reportHttpRequest(this.clientVersion());
            return this.delegate.handleResponse(response);
        }

        private void report(DocumentOperationStatus ... status) {
            DocumentV1ApiHandler.this.metrics.report(this.type, this.start, status);
        }

        private String clientVersion() {
            return Optional.ofNullable(this.request.headers().get((Object)"Vespa-Client-Version")).filter(l -> !l.isEmpty()).map(l -> (String)l.get(0)).orElse("unknown");
        }
    }

    private static class Operation {
        private final Lock lock = new ReentrantLock();
        private final HttpRequest request;
        private final ResponseHandler handler;
        private BooleanSupplier operation;
        private Supplier<BooleanSupplier> parser;

        Operation(HttpRequest request, ResponseHandler handler, Supplier<BooleanSupplier> parser) {
            this.request = request;
            this.handler = handler;
            this.parser = parser;
        }

        boolean dispatch() {
            if (this.request.isCancelled()) {
                return true;
            }
            if (!this.lock.tryLock()) {
                throw new IllegalStateException("Concurrent attempts at dispatch \u2014 this is a bug");
            }
            try {
                if (this.operation == null) {
                    this.operation = this.parser.get();
                    this.parser = null;
                }
                boolean bl = this.operation.getAsBoolean();
                return bl;
            }
            catch (IllegalArgumentException e) {
                DocumentV1ApiHandler.badRequest(this.request, e, this.handler);
            }
            catch (RuntimeException e) {
                DocumentV1ApiHandler.serverError(this.request, e, this.handler);
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
    }

    private static class DispatchException
    extends RuntimeException {
        private DispatchException(Throwable cause) {
            super(cause);
        }
    }

    private static class JsonResponse
    implements AutoCloseable {
        private static final ByteBuffer emptyBuffer = ByteBuffer.wrap(new byte[0]);
        private static final int FLUSH_SIZE = 128;
        private final BufferedContentChannel buffer = new BufferedContentChannel();
        private final OutputStream out = new ContentChannelOutputStream((ContentChannel)this.buffer);
        private final JsonGenerator json;
        private final ResponseHandler handler;
        private final HttpRequest request;
        private final Queue<CompletionHandler> acks = new ConcurrentLinkedQueue<CompletionHandler>();
        private final Queue<ByteArrayOutputStream> docs = new ConcurrentLinkedQueue<ByteArrayOutputStream>();
        private final AtomicLong documentsWritten = new AtomicLong();
        private final AtomicLong documentsFlushed = new AtomicLong();
        private final AtomicLong documentsAcked = new AtomicLong();
        private boolean documentsDone = false;
        private boolean first = true;
        private ContentChannel channel;

        private JsonResponse(ResponseHandler handler, HttpRequest request) throws IOException {
            this.handler = handler;
            this.request = request;
            this.json = jsonFactory.createGenerator(this.out);
            this.json.writeStartObject();
        }

        static JsonResponse create(DocumentPath path, ResponseHandler handler, HttpRequest request) throws IOException {
            JsonResponse response = new JsonResponse(handler, request);
            response.writePathId(path.rawPath());
            response.writeDocId(path.id());
            return response;
        }

        static JsonResponse create(HttpRequest request, ResponseHandler handler) throws IOException {
            JsonResponse response = new JsonResponse(handler, request);
            response.writePathId(request.getUri().getRawPath());
            return response;
        }

        static JsonResponse create(HttpRequest request, String message, ResponseHandler handler) throws IOException {
            JsonResponse response = JsonResponse.create(request, handler);
            response.writeMessage(message);
            return response;
        }

        synchronized void commit(int status) throws IOException {
            this.commit(status, true);
        }

        synchronized void commit(int status, boolean fullyApplied) throws IOException {
            Response response = new Response(status);
            response.headers().add("Content-Type", List.of("application/json; charset=UTF-8"));
            if (!fullyApplied) {
                response.headers().add("X-Vespa-Ignored-Fields", "true");
            }
            try {
                this.channel = this.handler.handleResponse(response);
                this.buffer.connectTo(this.channel);
            }
            catch (RuntimeException e) {
                throw new IOException(e);
            }
        }

        synchronized void respond(int status) throws IOException {
            try (JsonResponse jsonResponse = this;){
                this.commit(status);
            }
        }

        @Override
        public synchronized void close() throws IOException {
            this.documentsDone = true;
            try {
                if (this.channel == null) {
                    log.log(Level.WARNING, "Close called before response was committed, in " + this.getClass().getName());
                    this.commit(500);
                }
                this.json.close();
                this.out.close();
            }
            finally {
                if (this.channel != null) {
                    this.channel.close(logException);
                }
            }
        }

        synchronized void writePathId(String path) throws IOException {
            this.json.writeStringField("pathId", path);
        }

        synchronized void writeMessage(String message) throws IOException {
            this.json.writeStringField("message", message);
        }

        synchronized void writeDocumentCount(long count) throws IOException {
            this.json.writeNumberField("documentCount", count);
        }

        synchronized void writeDocId(DocumentId id) throws IOException {
            this.json.writeStringField("id", id.toString());
        }

        synchronized void writeTrace(Trace trace) throws IOException {
            if (trace != null && !trace.getRoot().isEmpty()) {
                this.writeTrace(trace.getRoot());
            }
        }

        private void writeTrace(TraceNode node) throws IOException {
            if (node.hasNote()) {
                this.json.writeStringField("message", node.getNote());
            }
            if (!node.isLeaf()) {
                this.json.writeArrayFieldStart(node.isStrict() ? "trace" : "fork");
                for (int i = 0; i < node.getNumChildren(); ++i) {
                    this.json.writeStartObject();
                    this.writeTrace(node.getChild(i));
                    this.json.writeEndObject();
                }
                this.json.writeEndArray();
            }
        }

        private JsonFormat.EncodeOptions tensorOptions() {
            List params;
            String format = "short";
            if (this.request != null && this.request.parameters().containsKey("format.tensors") && (params = (List)this.request.parameters().get("format.tensors")).size() == 1) {
                format = (String)params.get(0);
            }
            return switch (format) {
                case "hex" -> new JsonFormat.EncodeOptions(true, false, true);
                case "hex-value" -> new JsonFormat.EncodeOptions(true, true, true);
                default -> new JsonFormat.EncodeOptions(true, false, false);
                case "short-value" -> new JsonFormat.EncodeOptions(true, true, false);
                case "long" -> new JsonFormat.EncodeOptions(false, false, false);
                case "long-value" -> new JsonFormat.EncodeOptions(false, true, false);
            };
        }

        private boolean tensorShortForm() {
            return this.tensorOptions().shortForm();
        }

        private boolean tensorDirectValues() {
            return this.tensorOptions().directValues();
        }

        synchronized void writeSingleDocument(Document document) throws IOException {
            new JsonWriter(this.json, this.tensorOptions()).writeFields(document);
        }

        synchronized void writeDocumentsArrayStart() throws IOException {
            this.json.writeArrayFieldStart("documents");
        }

        void writeDocumentValue(Document document, CompletionHandler completionHandler) throws IOException {
            this.writeDocument(myOut -> {
                try (JsonGenerator myJson = jsonFactory.createGenerator((OutputStream)myOut);){
                    new JsonWriter(myJson, this.tensorShortForm(), this.tensorDirectValues()).write(document);
                }
            }, completionHandler);
        }

        void writeDocumentRemoval(DocumentId id, CompletionHandler completionHandler) throws IOException {
            this.writeDocument(myOut -> {
                try (JsonGenerator myJson = jsonFactory.createGenerator((OutputStream)myOut);){
                    myJson.writeStartObject();
                    myJson.writeStringField("remove", id.toString());
                    myJson.writeEndObject();
                }
            }, completionHandler);
        }

        void writeDocument(DocumentWriter documentWriter, CompletionHandler completionHandler) throws IOException {
            ByteArrayOutputStream myOut = new ByteArrayOutputStream(1);
            myOut.write(44);
            documentWriter.write(myOut);
            this.docs.add(myOut);
            if (completionHandler != null) {
                this.acks.add(completionHandler);
                this.ackDocuments();
            }
            if (this.documentsWritten.incrementAndGet() % 128L == 0L) {
                this.flushDocuments();
            }
        }

        void ackDocuments() {
            CompletionHandler ack;
            while (this.documentsAcked.incrementAndGet() <= this.documentsFlushed.get() + 128L && (ack = this.acks.poll()) != null) {
                ack.completed();
            }
            this.documentsAcked.decrementAndGet();
        }

        synchronized void flushDocuments() throws IOException {
            ByteArrayOutputStream doc;
            for (int i = 0; i < 128 && (doc = this.docs.poll()) != null; ++i) {
                if (this.documentsDone) continue;
                if (this.first) {
                    this.json.flush();
                    this.buffer.write(ByteBuffer.wrap(doc.toByteArray(), 1, doc.size() - 1), null);
                    this.first = false;
                    continue;
                }
                this.buffer.write(ByteBuffer.wrap(doc.toByteArray()), null);
            }
            this.buffer.write(emptyBuffer, new CompletionHandler(){

                public void completed() {
                    documentsFlushed.addAndGet(128L);
                    this.ackDocuments();
                }

                public void failed(Throwable t) {
                    log.log(Level.FINE, "Error writing documents", t);
                    this.completed();
                }
            });
        }

        synchronized void writeArrayEnd() throws IOException {
            this.flushDocuments();
            this.documentsDone = true;
            this.json.writeEndArray();
        }

        synchronized void writeContinuation(String token) throws IOException {
            this.json.writeStringField(DocumentV1ApiHandler.CONTINUATION, token);
        }

        private static interface DocumentWriter {
            public void write(ByteArrayOutputStream var1) throws IOException;
        }
    }

    static interface SuccessCallback {
        public void onSuccess(Document var1, JsonResponse var2) throws IOException;
    }

    static class StorageCluster {
        private final String name;
        private final Map<String, String> documentBuckets;

        StorageCluster(String name, Map<String, String> documentBuckets) {
            this.name = Objects.requireNonNull(name);
            this.documentBuckets = Map.copyOf(documentBuckets);
        }

        String name() {
            return this.name;
        }

        Optional<String> bucketOf(String documentType) {
            return Optional.ofNullable(this.documentBuckets.get(documentType));
        }
    }

    @FunctionalInterface
    private static interface VisitProcessingCallback {
        public Result apply(DocumentId var1, long var2, DocumentOperationParameters var4);
    }

    private static interface VisitCallback {
        default public void onStart(JsonResponse response, boolean fullyApplied) throws IOException {
        }

        default public void onDocument(JsonResponse response, Document document, DocumentId removeId, long persistedTimestamp, Runnable ack, Consumer<String> onError) {
        }

        default public void onEnd(JsonResponse response) throws IOException {
        }
    }

    static class Group {
        private final String docIdPart;
        private final String selection;

        private Group(String docIdPart, String selection) {
            this.docIdPart = docIdPart;
            this.selection = selection;
        }

        public static Group of(long value) {
            String stringValue = Long.toUnsignedString(value);
            return new Group("n=" + stringValue, "id.user==" + stringValue);
        }

        public static Group of(String value) {
            Text.validateTextString((String)value).ifPresent(codePoint -> {
                throw new IllegalArgumentException(String.format("Illegal code point U%04X in group", codePoint));
            });
            return new Group("g=" + value, "id.group=='" + value.replaceAll("'", "\\\\'") + "'");
        }

        public String docIdPart() {
            return this.docIdPart;
        }

        public String selection() {
            return this.selection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this.docIdPart.equals(group.docIdPart) && this.selection.equals(group.selection);
        }

        public int hashCode() {
            return Objects.hash(this.docIdPart, this.selection);
        }

        public String toString() {
            return "Group{docIdPart='" + this.docIdPart + "', selection='" + this.selection + "'}";
        }
    }
}

