/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

final class Encoder {
    Encoder() {
    }

    public static StringBuilder encode(String input, StringBuilder output) {
        int i = 0;
        while (i < input.length()) {
            int c = input.codePointAt(i);
            if (c <= 126) {
                if (c <= 32) {
                    Encoder.encode(c, output);
                } else {
                    switch (c) {
                        case 123: 
                        case 125: {
                            Encoder.encode(c, output);
                            break;
                        }
                        default: {
                            output.append((char)c);
                            break;
                        }
                    }
                }
            } else {
                Encoder.encode(c, output);
            }
            i = input.offsetByCodePoints(i, 1);
        }
        return output;
    }

    public static StringBuilder decode(String input, StringBuilder output) {
        int i = 0;
        while (i < input.length()) {
            int c = input.codePointAt(i);
            if (c > 126) {
                throw new IllegalArgumentException("Input contained character above printable ASCII at position " + i);
            }
            if (c == 123) {
                i = Encoder.decode(input, i, output);
            } else {
                output.append((char)c);
            }
            i = input.offsetByCodePoints(i, 1);
        }
        return output;
    }

    private static int decode(String input, int offset, StringBuilder output) {
        int codePoint;
        int c = 0;
        int end = offset;
        int start = offset + 1;
        while (125 != c) {
            if (++end >= input.length()) {
                throw new IllegalArgumentException("Unterminated quoted character or empty quoting.");
            }
            c = input.charAt(end);
        }
        try {
            codePoint = Integer.parseInt(input.substring(start, end), 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unexpected quoted data: [" + input.substring(start, end) + "]", e);
        }
        if (Character.charCount(codePoint) > 1) {
            try {
                output.append(Character.toChars(codePoint));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unexpected quoted data: [" + input.substring(start, end) + "]", e);
            }
        } else {
            output.append((char)codePoint);
        }
        return end;
    }

    private static void encode(int c, StringBuilder output) {
        output.append("{").append(Integer.toHexString(c)).append("}");
    }
}

