/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.json.JsonFeedReader;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.http.server.FeedParams;
import com.yahoo.vespaxmlparser.FeedReader;
import com.yahoo.vespaxmlparser.VespaXMLFeedReader;
import java.io.InputStream;

public class FeedReaderFactory {
    private static final int MARK_READLIMIT = 200;
    private final boolean debug;

    public FeedReaderFactory(boolean debug) {
        this.debug = debug;
    }

    public FeedReader createReader(InputStream inputStream, DocumentTypeManager docTypeManager, FeedParams.DataFormat dataFormat) {
        switch (dataFormat) {
            case XML_UTF8: {
                byte[] peek = null;
                int bytesPeeked = 0;
                try {
                    if (this.debug && inputStream.markSupported()) {
                        peek = new byte[200];
                        inputStream.mark(200);
                        bytesPeeked = inputStream.read(peek);
                        inputStream.reset();
                    }
                    return new VespaXMLFeedReader(inputStream, docTypeManager);
                }
                catch (Exception e) {
                    if (bytesPeeked > 0) {
                        throw new RuntimeException("Could not create VespaXMLFeedReader. First characters are: '" + Utf8.toString((byte[])peek, (int)0, (int)bytesPeeked) + "'", e);
                    }
                    throw new RuntimeException("Could not create VespaXMLFeedReader.", e);
                }
            }
            case JSON_UTF8: {
                return new JsonFeedReader(inputStream, docTypeManager);
            }
        }
        throw new IllegalStateException("Can not create feed reader for format: " + dataFormat);
    }
}

