/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server.util;

import java.io.IOException;
import java.io.InputStream;

public class ByteLimitedInputStream
extends InputStream {
    private final InputStream wrappedStream;
    private int remaining;
    private int remainingWhenMarked;

    public ByteLimitedInputStream(InputStream wrappedStream, int limit) {
        this.wrappedStream = wrappedStream;
        if (limit < 0) {
            throw new IllegalArgumentException("limit cannot be 0");
        }
        this.remaining = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining <= 0) {
            return -1;
        }
        int retval = this.wrappedStream.read();
        this.remaining = retval < 0 ? 0 : --this.remaining;
        return retval;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.remaining <= 0) {
            return -1;
        }
        int bytesToRead = Math.min(this.remaining, len);
        int retval = this.wrappedStream.read(b, off, bytesToRead);
        this.remaining = retval < 0 ? 0 : (this.remaining -= retval);
        return retval;
    }

    @Override
    public int available() throws IOException {
        return this.remaining;
    }

    @Override
    public void close() throws IOException {
        if (this.remaining <= 0) {
            return;
        }
        while (this.remaining > 0) {
            this.skip(this.remaining);
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.wrappedStream.mark(readlimit);
        this.remainingWhenMarked = this.remaining;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrappedStream.reset();
        this.remaining = this.remainingWhenMarked;
    }

    @Override
    public boolean markSupported() {
        return this.wrappedStream.markSupported();
    }
}

