/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.inject.Inject;
import com.yahoo.cloud.config.ClusterListConfig;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.container.core.HandlerMetricContextUtil;
import com.yahoo.container.core.documentapi.VespaDocumentAccess;
import com.yahoo.container.jdisc.ContentChannelOutputStream;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.idstring.IdIdString;
import com.yahoo.document.json.JsonReader;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.document.restapi.DocumentOperationExecutorConfig;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AckToken;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.AsyncSession;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.DocumentOperationParameters;
import com.yahoo.documentapi.DocumentResponse;
import com.yahoo.documentapi.ProgressToken;
import com.yahoo.documentapi.Result;
import com.yahoo.documentapi.VisitorControlHandler;
import com.yahoo.documentapi.VisitorControlSession;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.metrics.DocumentApiMetrics;
import com.yahoo.documentapi.metrics.DocumentOperationStatus;
import com.yahoo.documentapi.metrics.DocumentOperationType;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.BufferedContentChannel;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ReadableContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.handler.UnsafeContentInputStream;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.messagebus.DynamicThrottlePolicy;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.StaticThrottlePolicy;
import com.yahoo.messagebus.ThrottlePolicy;
import com.yahoo.messagebus.Trace;
import com.yahoo.messagebus.TraceNode;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.restapi.Path;
import com.yahoo.search.query.ParameterParser;
import com.yahoo.text.Text;
import com.yahoo.vespa.config.content.AllClustersBucketSpacesConfig;
import com.yahoo.yolean.Exceptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DocumentV1ApiHandler
extends AbstractRequestHandler {
    private static final Duration defaultTimeout = Duration.ofSeconds(180L);
    private static final Logger log = Logger.getLogger(DocumentV1ApiHandler.class.getName());
    private static final Parser<Integer> integerParser = Integer::parseInt;
    private static final Parser<Long> unsignedLongParser = Long::parseUnsignedLong;
    private static final Parser<Long> timeoutMillisParser = value -> ParameterParser.asMilliSeconds((Object)value, (Long)defaultTimeout.toMillis());
    private static final Parser<Boolean> booleanParser = Boolean::parseBoolean;
    private static final CompletionHandler logException = new CompletionHandler(){

        public void completed() {
        }

        public void failed(Throwable t) {
            log.log(Level.FINE, "Exception writing or closing response data", t);
        }
    };
    private static final ContentChannel ignoredContent = new ContentChannel(){

        public void write(ByteBuffer buf, CompletionHandler handler) {
            handler.completed();
        }

        public void close(CompletionHandler handler) {
            handler.completed();
        }
    };
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final String CREATE = "create";
    private static final String CONDITION = "condition";
    private static final String ROUTE = "route";
    private static final String FIELD_SET = "fieldSet";
    private static final String SELECTION = "selection";
    private static final String CLUSTER = "cluster";
    private static final String DESTINATION_CLUSTER = "destinationCluster";
    private static final String CONTINUATION = "continuation";
    private static final String WANTED_DOCUMENT_COUNT = "wantedDocumentCount";
    private static final String CONCURRENCY = "concurrency";
    private static final String BUCKET_SPACE = "bucketSpace";
    private static final String TIME_CHUNK = "timeChunk";
    private static final String TIMEOUT = "timeout";
    private static final String TRACELEVEL = "tracelevel";
    private static final String STREAM = "stream";
    private static final String SLICES = "slices";
    private static final String SLICE_ID = "sliceId";
    private final Clock clock;
    private final Duration handlerTimeout;
    private final Metric metric;
    private final DocumentApiMetrics metrics;
    private final DocumentOperationParser parser;
    private final long maxThrottled;
    private final DocumentAccess access;
    private final AsyncSession asyncSession;
    private final Map<String, StorageCluster> clusters;
    private final Deque<Operation> operations;
    private final Deque<BooleanSupplier> visitOperations = new ConcurrentLinkedDeque<BooleanSupplier>();
    private final AtomicLong enqueued = new AtomicLong();
    private final AtomicLong outstanding = new AtomicLong();
    private final Map<VisitorControlHandler, VisitorSession> visits = new ConcurrentHashMap<VisitorControlHandler, VisitorSession>();
    private final ScheduledExecutorService dispatcher = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("document-api-handler-"));
    private final ScheduledExecutorService visitDispatcher = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("document-api-handler-visit-"));
    private final Map<String, Map<HttpRequest.Method, Handler>> handlers = this.defineApi();

    @Inject
    public DocumentV1ApiHandler(Metric metric, MetricReceiver metricReceiver, VespaDocumentAccess documentAccess, DocumentmanagerConfig documentManagerConfig, ClusterListConfig clusterListConfig, AllClustersBucketSpacesConfig bucketSpacesConfig, DocumentOperationExecutorConfig executorConfig) {
        this(Clock.systemUTC(), Duration.ofSeconds(5L), metric, metricReceiver, (DocumentAccess)documentAccess, documentManagerConfig, executorConfig, clusterListConfig, bucketSpacesConfig);
    }

    DocumentV1ApiHandler(Clock clock, Duration handlerTimeout, Metric metric, MetricReceiver metricReceiver, DocumentAccess access, DocumentmanagerConfig documentmanagerConfig, DocumentOperationExecutorConfig executorConfig, ClusterListConfig clusterListConfig, AllClustersBucketSpacesConfig bucketSpacesConfig) {
        this.clock = clock;
        this.handlerTimeout = handlerTimeout;
        this.parser = new DocumentOperationParser(documentmanagerConfig);
        this.metric = metric;
        this.metrics = new DocumentApiMetrics(metricReceiver, "documentV1");
        this.maxThrottled = executorConfig.maxThrottled();
        this.access = access;
        this.asyncSession = access.createAsyncSession(new AsyncParameters());
        this.clusters = DocumentV1ApiHandler.parseClusters(clusterListConfig, bucketSpacesConfig);
        this.operations = new ConcurrentLinkedDeque<Operation>();
        this.dispatcher.scheduleWithFixedDelay(this::dispatchEnqueued, executorConfig.resendDelayMillis(), executorConfig.resendDelayMillis(), TimeUnit.MILLISECONDS);
        this.visitDispatcher.scheduleWithFixedDelay(this::dispatchVisitEnqueued, executorConfig.resendDelayMillis(), executorConfig.resendDelayMillis(), TimeUnit.MILLISECONDS);
    }

    public ContentChannel handleRequest(Request rawRequest, ResponseHandler rawResponseHandler) {
        HandlerMetricContextUtil.onHandle((Request)rawRequest, (Metric)this.metric, ((Object)((Object)this)).getClass());
        ResponseHandler responseHandler = response -> {
            HandlerMetricContextUtil.onHandled((Request)rawRequest, (Metric)this.metric, ((Object)((Object)this)).getClass());
            return rawResponseHandler.handleResponse(response);
        };
        HttpRequest request = (HttpRequest)rawRequest;
        try {
            request.setTimeout(DocumentV1ApiHandler.getProperty(request, TIMEOUT, timeoutMillisParser).orElse(defaultTimeout.toMillis()) + this.handlerTimeout.toMillis(), TimeUnit.MILLISECONDS);
            Path requestPath = new Path(request.getUri());
            for (String path : this.handlers.keySet()) {
                if (!requestPath.matches(path)) continue;
                Map<HttpRequest.Method, Handler> methods = this.handlers.get(path);
                if (methods.containsKey(request.getMethod())) {
                    return methods.get(request.getMethod()).handle(request, new DocumentPath(requestPath), responseHandler);
                }
                if (request.getMethod() == HttpRequest.Method.OPTIONS) {
                    DocumentV1ApiHandler.options(methods.keySet(), responseHandler);
                }
                DocumentV1ApiHandler.methodNotAllowed(request, methods.keySet(), responseHandler);
            }
            DocumentV1ApiHandler.notFound(request, this.handlers.keySet(), responseHandler);
        }
        catch (IllegalArgumentException e) {
            DocumentV1ApiHandler.badRequest(request, e, responseHandler);
        }
        catch (RuntimeException e) {
            DocumentV1ApiHandler.serverError(request, e, responseHandler);
        }
        return ignoredContent;
    }

    public void handleTimeout(Request request, ResponseHandler responseHandler) {
        DocumentV1ApiHandler.timeout((HttpRequest)request, "Timeout after " + (request.getTimeout(TimeUnit.MILLISECONDS) - this.handlerTimeout.toMillis()) + "ms", responseHandler);
    }

    public void destroy() {
        Instant doom = this.clock.instant().plus(Duration.ofSeconds(30L));
        this.visits.values().forEach(VisitorControlSession::abort);
        this.visits.values().forEach(VisitorControlSession::destroy);
        this.dispatcher.shutdown();
        this.visitDispatcher.shutdown();
        while (!(this.operations.isEmpty() && this.visitOperations.isEmpty() || !this.clock.instant().isBefore(doom))) {
            this.dispatchEnqueued();
            this.dispatchVisitEnqueued();
        }
        if (!this.operations.isEmpty()) {
            log.log(Level.WARNING, "Failed to empty request queue before shutdown timeout \u2014 " + this.operations.size() + " requests left");
        }
        if (!this.visitOperations.isEmpty()) {
            log.log(Level.WARNING, "Failed to empty visitor operations queue before shutdown timeout \u2014 " + this.operations.size() + " operations left");
        }
        try {
            while (this.outstanding.get() > 0L && this.clock.instant().isBefore(doom)) {
                Thread.sleep(Math.max(1L, Duration.between(this.clock.instant(), doom).toMillis()));
            }
            if (!this.dispatcher.awaitTermination(Duration.between(this.clock.instant(), doom).toMillis(), TimeUnit.MILLISECONDS)) {
                this.dispatcher.shutdownNow();
            }
            if (!this.visitDispatcher.awaitTermination(Duration.between(this.clock.instant(), doom).toMillis(), TimeUnit.MILLISECONDS)) {
                this.visitDispatcher.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Interrupted waiting for /document/v1 executor to shut down");
        }
        finally {
            this.asyncSession.destroy();
            if (this.outstanding.get() != 0L) {
                log.log(Level.WARNING, "Failed to receive a response to " + this.outstanding.get() + " outstanding document operations during shutdown");
            }
        }
    }

    private Map<String, Map<HttpRequest.Method, Handler>> defineApi() {
        LinkedHashMap<String, Map<HttpRequest.Method, Handler>> handlers = new LinkedHashMap<String, Map<HttpRequest.Method, Handler>>();
        handlers.put("/document/v1/", Map.of(HttpRequest.Method.GET, this::getDocuments, HttpRequest.Method.POST, this::postDocuments, HttpRequest.Method.DELETE, this::deleteDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/docid/", Map.of(HttpRequest.Method.GET, this::getDocuments, HttpRequest.Method.POST, this::postDocuments, HttpRequest.Method.PUT, this::putDocuments, HttpRequest.Method.DELETE, this::deleteDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/group/{group}/", Map.of(HttpRequest.Method.GET, this::getDocuments, HttpRequest.Method.POST, this::postDocuments, HttpRequest.Method.PUT, this::putDocuments, HttpRequest.Method.DELETE, this::deleteDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/number/{number}/", Map.of(HttpRequest.Method.GET, this::getDocuments, HttpRequest.Method.POST, this::postDocuments, HttpRequest.Method.PUT, this::putDocuments, HttpRequest.Method.DELETE, this::deleteDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/docid/{*}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        handlers.put("/document/v1/{namespace}/{documentType}/group/{group}/{*}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        handlers.put("/document/v1/{namespace}/{documentType}/number/{number}/{*}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        return Collections.unmodifiableMap(handlers);
    }

    private ContentChannel getDocuments(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        this.enqueueAndDispatch(request, handler, () -> {
            boolean streamed = DocumentV1ApiHandler.getProperty(request, STREAM, booleanParser).orElse(false);
            VisitorParameters parameters = this.parseGetParameters(request, path, streamed);
            return () -> {
                this.visitAndWrite(request, parameters, handler, streamed);
                return true;
            };
        });
        return ignoredContent;
    }

    private ContentChannel postDocuments(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        this.enqueueAndDispatch(request, handler, () -> {
            StorageCluster destination = DocumentV1ApiHandler.resolveCluster(Optional.of(DocumentV1ApiHandler.requireProperty(request, DESTINATION_CLUSTER)), this.clusters);
            VisitorParameters parameters = this.parseParameters(request, path);
            parameters.setRemoteDataHandler("[Content:cluster=" + destination.name() + "]");
            parameters.setFieldSet("[all]");
            return () -> {
                this.visitWithRemote(request, parameters, handler);
                return true;
            };
        });
        return ignoredContent;
    }

    private ContentChannel putDocuments(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        return new ForwardingContentChannel(in -> this.enqueueAndDispatch(request, handler, () -> {
            StorageCluster cluster = DocumentV1ApiHandler.resolveCluster(Optional.of(DocumentV1ApiHandler.requireProperty(request, CLUSTER)), this.clusters);
            VisitorParameters parameters = this.parseParameters(request, path);
            parameters.setFieldSet("[id]");
            String type = path.documentType().orElseThrow(() -> new IllegalStateException("Document type must be specified for mass updates"));
            IdIdString dummyId = new IdIdString("dummy", type, "", "");
            DocumentUpdate update = this.parser.parseUpdate((InputStream)in, dummyId.toString());
            update.setCondition(new TestAndSetCondition(DocumentV1ApiHandler.requireProperty(request, SELECTION)));
            return () -> {
                this.visitAndUpdate(request, parameters, handler, update, cluster.name());
                return true;
            };
        }));
    }

    private ContentChannel deleteDocuments(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        this.enqueueAndDispatch(request, handler, () -> {
            VisitorParameters parameters = this.parseParameters(request, path);
            parameters.setFieldSet("[id]");
            TestAndSetCondition condition = new TestAndSetCondition(DocumentV1ApiHandler.requireProperty(request, SELECTION));
            StorageCluster cluster = DocumentV1ApiHandler.resolveCluster(Optional.of(DocumentV1ApiHandler.requireProperty(request, CLUSTER)), this.clusters);
            return () -> {
                this.visitAndDelete(request, parameters, handler, condition, cluster.name());
                return true;
            };
        });
        return ignoredContent;
    }

    private ContentChannel getDocument(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        this.enqueueAndDispatch(request, handler, () -> {
            DocumentOperationParameters rawParameters = this.parametersFromRequest(request, CLUSTER, FIELD_SET);
            if (rawParameters.fieldSet().isEmpty()) {
                rawParameters = rawParameters.withFieldSet(path.documentType().orElseThrow() + ":[document]");
            }
            DocumentOperationParameters parameters = rawParameters.withResponseHandler(response -> {
                this.outstanding.decrementAndGet();
                DocumentV1ApiHandler.handle(path, handler, response, (document, jsonResponse) -> {
                    if (document != null) {
                        jsonResponse.writeSingleDocument(document);
                        jsonResponse.commit(200);
                    } else {
                        jsonResponse.commit(404);
                    }
                });
            });
            return () -> this.dispatchOperation(() -> this.asyncSession.get(path.id(), parameters));
        });
        return ignoredContent;
    }

    private ContentChannel postDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        MeasuringResponseHandler handler = new MeasuringResponseHandler(rawHandler, DocumentOperationType.PUT, this.clock.instant());
        return new ForwardingContentChannel(in -> this.enqueueAndDispatch(request, handler, () -> {
            DocumentPut put = this.parser.parsePut((InputStream)in, path.id().toString());
            DocumentV1ApiHandler.getProperty(request, CONDITION).map(TestAndSetCondition::new).ifPresent(arg_0 -> ((DocumentPut)put).setCondition(arg_0));
            DocumentOperationParameters parameters = this.parametersFromRequest(request, ROUTE).withResponseHandler(response -> {
                this.outstanding.decrementAndGet();
                DocumentV1ApiHandler.handle(path, handler, response);
            });
            return () -> this.dispatchOperation(() -> this.asyncSession.put(put, parameters));
        }));
    }

    private ContentChannel putDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        MeasuringResponseHandler handler = new MeasuringResponseHandler(rawHandler, DocumentOperationType.UPDATE, this.clock.instant());
        return new ForwardingContentChannel(in -> this.enqueueAndDispatch(request, handler, () -> {
            DocumentUpdate update = this.parser.parseUpdate((InputStream)in, path.id().toString());
            DocumentV1ApiHandler.getProperty(request, CONDITION).map(TestAndSetCondition::new).ifPresent(arg_0 -> ((DocumentUpdate)update).setCondition(arg_0));
            DocumentV1ApiHandler.getProperty(request, CREATE, booleanParser).ifPresent(arg_0 -> ((DocumentUpdate)update).setCreateIfNonExistent(arg_0));
            DocumentOperationParameters parameters = this.parametersFromRequest(request, ROUTE).withResponseHandler(response -> {
                this.outstanding.decrementAndGet();
                DocumentV1ApiHandler.handle(path, handler, response);
            });
            return () -> this.dispatchOperation(() -> this.asyncSession.update(update, parameters));
        }));
    }

    private ContentChannel deleteDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        MeasuringResponseHandler handler = new MeasuringResponseHandler(rawHandler, DocumentOperationType.REMOVE, this.clock.instant());
        this.enqueueAndDispatch(request, handler, () -> {
            DocumentRemove remove = new DocumentRemove(path.id());
            DocumentV1ApiHandler.getProperty(request, CONDITION).map(TestAndSetCondition::new).ifPresent(arg_0 -> ((DocumentRemove)remove).setCondition(arg_0));
            DocumentOperationParameters parameters = this.parametersFromRequest(request, ROUTE).withResponseHandler(response -> {
                this.outstanding.decrementAndGet();
                DocumentV1ApiHandler.handle(path, handler, response);
            });
            return () -> this.dispatchOperation(() -> this.asyncSession.remove(remove, parameters));
        });
        return ignoredContent;
    }

    private DocumentOperationParameters parametersFromRequest(HttpRequest request, String ... names) {
        DocumentOperationParameters parameters = DocumentV1ApiHandler.getProperty(request, TRACELEVEL, integerParser).map(arg_0 -> ((DocumentOperationParameters)DocumentOperationParameters.parameters()).withTraceLevel(arg_0)).orElse(DocumentOperationParameters.parameters());
        parameters = DocumentV1ApiHandler.getProperty(request, TIMEOUT, timeoutMillisParser).map(this.clock.instant()::plusMillis).map(arg_0 -> ((DocumentOperationParameters)parameters).withDeadline(arg_0)).orElse(parameters);
        String[] stringArray = names;
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String name;
            switch (name = stringArray[i]) {
                case "cluster": {
                    parameters = DocumentV1ApiHandler.getProperty(request, CLUSTER).map(cluster -> DocumentV1ApiHandler.resolveCluster(Optional.of(cluster), this.clusters).name()).map(arg_0 -> ((DocumentOperationParameters)parameters).withRoute(arg_0)).orElse(parameters);
                    continue block10;
                }
                case "fieldSet": {
                    parameters = DocumentV1ApiHandler.getProperty(request, FIELD_SET).map(arg_0 -> ((DocumentOperationParameters)parameters).withFieldSet(arg_0)).orElse(parameters);
                    continue block10;
                }
                case "route": {
                    parameters = DocumentV1ApiHandler.getProperty(request, ROUTE).map(arg_0 -> ((DocumentOperationParameters)parameters).withRoute(arg_0)).orElse(parameters);
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized document operation parameter name '" + name + "'");
                }
            }
        }
        return parameters;
    }

    void dispatchEnqueued() {
        try {
            while (this.dispatchFirst()) {
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Uncaught exception in /document/v1 dispatch thread", e);
        }
    }

    private boolean dispatchFirst() {
        Operation operation = this.operations.poll();
        if (operation == null) {
            return false;
        }
        if (operation.dispatch()) {
            this.enqueued.decrementAndGet();
            return true;
        }
        this.operations.push(operation);
        return false;
    }

    void dispatchVisitEnqueued() {
        try {
            while (this.dispatchFirstVisit()) {
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Uncaught exception in /document/v1 dispatch thread", e);
        }
    }

    private boolean dispatchFirstVisit() {
        BooleanSupplier operation = this.visitOperations.poll();
        if (operation == null) {
            return false;
        }
        if (operation.getAsBoolean()) {
            return true;
        }
        this.visitOperations.push(operation);
        return false;
    }

    private void enqueueAndDispatch(HttpRequest request, ResponseHandler handler, Supplier<BooleanSupplier> operationParser) {
        if (this.enqueued.incrementAndGet() > this.maxThrottled) {
            this.enqueued.decrementAndGet();
            DocumentV1ApiHandler.overload(request, "Rejecting execution due to overload: " + this.maxThrottled + " requests already enqueued", handler);
            return;
        }
        this.operations.offer(new Operation(request, handler, operationParser));
        this.dispatchFirst();
    }

    private static void options(Collection<HttpRequest.Method> methods, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            Response response = new Response(204);
            response.headers().add("Allow", methods.stream().sorted().map(Enum::name).collect(Collectors.joining(",")));
            handler.handleResponse(response).close(logException);
        });
    }

    private static void badRequest(HttpRequest request, IllegalArgumentException e, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            String message = Exceptions.toMessageString((Throwable)e);
            log.log(Level.FINE, () -> "Bad request for " + request.getMethod() + " at " + request.getUri().getRawPath() + ": " + message);
            JsonResponse.create(request, message, handler).respond(400);
        });
    }

    private static void notFound(HttpRequest request, Collection<String> paths, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> JsonResponse.create(request, "Nothing at '" + request.getUri().getRawPath() + "'. Available paths are:\n" + String.join((CharSequence)"\n", paths), handler).respond(404));
    }

    private static void methodNotAllowed(HttpRequest request, Collection<HttpRequest.Method> methods, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> JsonResponse.create(request, "'" + request.getMethod() + "' not allowed at '" + request.getUri().getRawPath() + "'. Allowed methods are: " + methods.stream().sorted().map(Enum::name).collect(Collectors.joining(", ")), handler).respond(405));
    }

    private static void overload(HttpRequest request, String message, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            log.log(Level.FINE, () -> "Overload handling request " + request.getMethod() + " " + request.getUri().getRawPath() + ": " + message);
            JsonResponse.create(request, message, handler).respond(429);
        });
    }

    private static void serverError(HttpRequest request, Throwable t, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            log.log(Level.WARNING, "Uncaught exception handling request " + request.getMethod() + " " + request.getUri().getRawPath(), t);
            JsonResponse.create(request, Exceptions.toMessageString((Throwable)t), handler).respond(500);
        });
    }

    private static void badGateway(HttpRequest request, Throwable t, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            log.log(Level.FINE, t, () -> "Document access error handling request " + request.getMethod() + " " + request.getUri().getRawPath());
            JsonResponse.create(request, Exceptions.toMessageString((Throwable)t), handler).respond(502);
        });
    }

    private static void timeout(HttpRequest request, String message, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            log.log(Level.FINE, () -> "Timeout handling request " + request.getMethod() + " " + request.getUri().getRawPath() + ": " + message);
            JsonResponse.create(request, message, handler).respond(504);
        });
    }

    private static void loggingException(Exceptions.RunnableThrowingIOException runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            log.log(Level.FINE, "Failed writing response", e);
        }
    }

    private boolean dispatchOperation(Supplier<Result> documentOperation) {
        Result result = documentOperation.get();
        if (result.type() == Result.ResultType.TRANSIENT_ERROR) {
            return false;
        }
        if (result.type() == Result.ResultType.FATAL_ERROR) {
            throw new DispatchException(result.getError());
        }
        this.outstanding.incrementAndGet();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handle(DocumentPath path, ResponseHandler handler, com.yahoo.documentapi.Response response, SuccessCallback callback) {
        try (JsonResponse jsonResponse = JsonResponse.create(path, handler);){
            jsonResponse.writeTrace(response.getTrace());
            if (response.isSuccess()) {
                callback.onSuccess(response instanceof DocumentResponse ? ((DocumentResponse)response).getDocument() : null, jsonResponse);
                return;
            }
            jsonResponse.writeMessage(response.getTextMessage());
            switch (response.outcome()) {
                case NOT_FOUND: {
                    jsonResponse.commit(404);
                    return;
                }
                case CONDITION_FAILED: {
                    jsonResponse.commit(412);
                    return;
                }
                case INSUFFICIENT_STORAGE: {
                    jsonResponse.commit(507);
                    return;
                }
                case TIMEOUT: {
                    jsonResponse.commit(504);
                    return;
                }
                default: {
                    log.log(Level.WARNING, "Unexpected document API operation outcome '" + response.outcome() + "'");
                }
                case ERROR: {
                    log.log(Level.FINE, () -> "Exception performing document operation: " + response.getTextMessage());
                    jsonResponse.commit(502);
                    return;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, "Failed writing response", e);
        }
    }

    private static void handle(DocumentPath path, ResponseHandler handler, com.yahoo.documentapi.Response response) {
        DocumentV1ApiHandler.handle(path, handler, response, (document, jsonResponse) -> jsonResponse.commit(200));
    }

    private VisitorParameters parseGetParameters(HttpRequest request, DocumentPath path, boolean streamed) {
        int wantedDocumentCount = Math.min(streamed ? Integer.MAX_VALUE : 1024, DocumentV1ApiHandler.getProperty(request, WANTED_DOCUMENT_COUNT, integerParser).orElse(streamed ? Integer.MAX_VALUE : 1));
        if (wantedDocumentCount <= 0) {
            throw new IllegalArgumentException("wantedDocumentCount must be positive");
        }
        Optional<Integer> concurrency = DocumentV1ApiHandler.getProperty(request, CONCURRENCY, integerParser);
        concurrency.ifPresent(value -> {
            if (value <= 0) {
                throw new IllegalArgumentException("concurrency must be positive");
            }
        });
        Optional<String> cluster = DocumentV1ApiHandler.getProperty(request, CLUSTER);
        if (cluster.isEmpty() && path.documentType().isEmpty()) {
            throw new IllegalArgumentException("Must set 'cluster' parameter to a valid content cluster id when visiting at a root /document/v1/ level");
        }
        VisitorParameters parameters = this.parseCommonParameters(request, path, cluster);
        parameters.setFieldSet(DocumentV1ApiHandler.getProperty(request, FIELD_SET).orElse(path.documentType().map(type -> type + ":[document]").orElse("[all]")));
        parameters.setMaxTotalHits((long)wantedDocumentCount);
        parameters.visitInconsistentBuckets(true);
        long timeoutMs = Math.max(1L, request.getTimeout(TimeUnit.MILLISECONDS) - this.handlerTimeout.toMillis());
        if (streamed) {
            DynamicThrottlePolicy throttlePolicy = new DynamicThrottlePolicy().setMinWindowSize(1.0).setWindowSizeIncrement(1.0);
            concurrency.ifPresent(arg_0 -> ((StaticThrottlePolicy)throttlePolicy).setMaxPendingCount(arg_0));
            parameters.setThrottlePolicy((ThrottlePolicy)throttlePolicy);
            parameters.setTimeoutMs(timeoutMs);
        } else {
            parameters.setThrottlePolicy((ThrottlePolicy)new StaticThrottlePolicy().setMaxPendingCount(Math.min(100, concurrency.orElse(1))));
            parameters.setSessionTimeoutMs(timeoutMs);
        }
        return parameters;
    }

    private VisitorParameters parseParameters(HttpRequest request, DocumentPath path) {
        DocumentV1ApiHandler.disallow(request, CONCURRENCY, FIELD_SET, ROUTE, WANTED_DOCUMENT_COUNT);
        DocumentV1ApiHandler.requireProperty(request, SELECTION);
        VisitorParameters parameters = this.parseCommonParameters(request, path, Optional.of(DocumentV1ApiHandler.requireProperty(request, CLUSTER)));
        parameters.setThrottlePolicy((ThrottlePolicy)new DynamicThrottlePolicy().setMinWindowSize(1.0).setWindowSizeIncrement(1.0));
        long timeChunk = DocumentV1ApiHandler.getProperty(request, TIME_CHUNK, timeoutMillisParser).orElse(60000L);
        parameters.setSessionTimeoutMs(Math.max(1L, Math.min(timeChunk, request.getTimeout(TimeUnit.MILLISECONDS) - this.handlerTimeout.toMillis())));
        return parameters;
    }

    private VisitorParameters parseCommonParameters(HttpRequest request, DocumentPath path, Optional<String> cluster) {
        VisitorParameters parameters = new VisitorParameters(Stream.of(DocumentV1ApiHandler.getProperty(request, SELECTION), path.documentType(), path.namespace().map(value -> "id.namespace=='" + value + "'"), path.group().map(Group::selection)).flatMap(Optional::stream).reduce(new StringJoiner(") and (", "(", ")").setEmptyValue(""), StringJoiner::add, StringJoiner::merge).toString());
        DocumentV1ApiHandler.getProperty(request, CONTINUATION).map(ProgressToken::fromSerializedString).ifPresent(arg_0 -> ((VisitorParameters)parameters).setResumeToken(arg_0));
        parameters.setPriority(DocumentProtocol.Priority.NORMAL_4);
        StorageCluster storageCluster = DocumentV1ApiHandler.resolveCluster(cluster, this.clusters);
        parameters.setRoute(storageCluster.name());
        parameters.setBucketSpace(DocumentV1ApiHandler.resolveBucket(storageCluster, path.documentType(), List.of(FixedBucketSpaces.defaultSpace(), FixedBucketSpaces.globalSpace()), DocumentV1ApiHandler.getProperty(request, BUCKET_SPACE)));
        Optional<Integer> slices = DocumentV1ApiHandler.getProperty(request, SLICES, integerParser);
        Optional<Integer> sliceId = DocumentV1ApiHandler.getProperty(request, SLICE_ID, integerParser);
        if (slices.isPresent() && sliceId.isPresent()) {
            parameters.slice(slices.get().intValue(), sliceId.get().intValue());
        } else if (slices.isPresent() != sliceId.isPresent()) {
            throw new IllegalArgumentException("None or both of 'slices' and 'sliceId' must be set");
        }
        return parameters;
    }

    private void visitAndDelete(HttpRequest request, VisitorParameters parameters, ResponseHandler handler, TestAndSetCondition condition, String route) {
        this.visitAndProcess(request, parameters, handler, route, (id, operationParameters) -> {
            DocumentRemove remove = new DocumentRemove(id);
            remove.setCondition(condition);
            return this.asyncSession.remove(remove, operationParameters);
        });
    }

    private void visitAndUpdate(HttpRequest request, VisitorParameters parameters, ResponseHandler handler, DocumentUpdate protoUpdate, String route) {
        this.visitAndProcess(request, parameters, handler, route, (id, operationParameters) -> {
            DocumentUpdate update = new DocumentUpdate(protoUpdate);
            update.setId(id);
            return this.asyncSession.update(update, operationParameters);
        });
    }

    private void visitAndProcess(HttpRequest request, VisitorParameters parameters, ResponseHandler handler, final String route, final BiFunction<DocumentId, DocumentOperationParameters, Result> operation) {
        this.visit(request, parameters, false, handler, new VisitCallback(){

            @Override
            public void onDocument(JsonResponse response, Document document, Runnable ack, Consumer<String> onError) {
                DocumentOperationParameters operationParameters = DocumentOperationParameters.parameters().withRoute(route).withResponseHandler(operationResponse -> {
                    DocumentV1ApiHandler.this.outstanding.decrementAndGet();
                    switch (operationResponse.outcome()) {
                        case NOT_FOUND: 
                        case CONDITION_FAILED: 
                        case SUCCESS: {
                            break;
                        }
                        case INSUFFICIENT_STORAGE: 
                        case TIMEOUT: 
                        case ERROR: {
                            onError.accept(operationResponse.getTextMessage());
                            break;
                        }
                        default: {
                            onError.accept("Unexpected response " + operationResponse);
                        }
                    }
                });
                DocumentV1ApiHandler.this.visitOperations.offer(() -> {
                    Result result = (Result)operation.apply(document.getId(), operationParameters);
                    if (result.type() == Result.ResultType.TRANSIENT_ERROR) {
                        return false;
                    }
                    if (result.type() == Result.ResultType.FATAL_ERROR) {
                        onError.accept(result.getError().getMessage());
                    } else {
                        DocumentV1ApiHandler.this.outstanding.incrementAndGet();
                    }
                    ack.run();
                    return true;
                });
                DocumentV1ApiHandler.this.dispatchFirstVisit();
            }
        });
    }

    private void visitAndWrite(HttpRequest request, VisitorParameters parameters, ResponseHandler handler, final boolean streamed) {
        this.visit(request, parameters, streamed, handler, new VisitCallback(){

            @Override
            public void onStart(JsonResponse response) throws IOException {
                if (streamed) {
                    response.commit(200);
                }
                response.writeDocumentsArrayStart();
            }

            @Override
            public void onDocument(JsonResponse response, Document document, final Runnable ack, final Consumer<String> onError) {
                try {
                    if (streamed) {
                        response.writeDocumentValue(document, new CompletionHandler(){

                            public void completed() {
                                ack.run();
                            }

                            public void failed(Throwable t) {
                                ack.run();
                                onError.accept(t.getMessage());
                            }
                        });
                    } else {
                        response.writeDocumentValue(document, null);
                        ack.run();
                    }
                }
                catch (Exception e) {
                    onError.accept(e.getMessage());
                }
            }

            @Override
            public void onEnd(JsonResponse response) throws IOException {
                response.writeArrayEnd();
            }
        });
    }

    private void visitWithRemote(HttpRequest request, VisitorParameters parameters, ResponseHandler handler) {
        this.visit(request, parameters, false, handler, new VisitCallback(){});
    }

    private void visit(final HttpRequest request, final VisitorParameters parameters, final boolean streaming, ResponseHandler handler, final VisitCallback callback) {
        try {
            final JsonResponse response = JsonResponse.create(request, handler);
            final Phaser phaser = new Phaser(2);
            final AtomicReference error = new AtomicReference();
            callback.onStart(response);
            final VisitorControlHandler controller = new VisitorControlHandler(){
                final ScheduledFuture<?> abort;
                {
                    this.abort = streaming ? DocumentV1ApiHandler.this.visitDispatcher.schedule(() -> (this).abort(), (long)request.getTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS) : null;
                }

                public void onDone(VisitorControlHandler.CompletionCode code, String message) {
                    super.onDone(code, message);
                    DocumentV1ApiHandler.loggingException(() -> {
                        try (JsonResponse jsonResponse = response;){
                            callback.onEnd(response);
                            if (this.getVisitorStatistics() != null) {
                                response.writeDocumentCount(this.getVisitorStatistics().getDocumentsVisited());
                            }
                            int status = 502;
                            switch (code) {
                                case TIMEOUT: {
                                    if (!this.hasVisitedAnyBuckets() && parameters.getVisitInconsistentBuckets()) {
                                        response.writeMessage("No buckets visited within timeout of " + parameters.getSessionTimeoutMs() + "ms (request timeout -5s)");
                                        status = 504;
                                        break;
                                    }
                                }
                                case SUCCESS: 
                                case ABORTED: {
                                    if (error.get() == null) {
                                        ProgressToken progress;
                                        ProgressToken progressToken = progress = this.getProgress() != null ? this.getProgress() : parameters.getResumeToken();
                                        if (progress != null && !progress.isFinished()) {
                                            response.writeContinuation(progress.serializeToString());
                                        }
                                        status = 200;
                                        break;
                                    }
                                }
                                default: {
                                    response.writeMessage(error.get() != null ? (String)error.get() : (message != null ? message : "Visiting failed"));
                                }
                            }
                            if (!streaming) {
                                response.commit(status);
                            }
                        }
                    });
                    if (this.abort != null) {
                        this.abort.cancel(false);
                    }
                    DocumentV1ApiHandler.this.visitDispatcher.execute(() -> {
                        phaser.arriveAndAwaitAdvance();
                        DocumentV1ApiHandler.this.visits.remove((Object)this).destroy();
                    });
                }
            };
            if (parameters.getRemoteDataHandler() == null) {
                parameters.setLocalDataHandler(new VisitorDataHandler(){

                    public void onMessage(Message m, AckToken token) {
                        if (!(m instanceof PutDocumentMessage)) {
                            throw new UnsupportedOperationException("Only PutDocumentMessage is supported, but got a " + m.getClass());
                        }
                        callback.onDocument(response, ((PutDocumentMessage)m).getDocumentPut().getDocument(), () -> this.ack(token), errorMessage -> {
                            error.set(errorMessage);
                            controller.abort();
                        });
                    }
                });
            }
            parameters.setControlHandler(controller);
            this.visits.put(controller, this.access.createVisitorSession(parameters));
            phaser.arriveAndDeregister();
        }
        catch (ParseException e) {
            DocumentV1ApiHandler.badRequest(request, new IllegalArgumentException(e), handler);
        }
        catch (IOException e) {
            log.log(Level.FINE, "Failed writing response", e);
        }
    }

    private static String requireProperty(HttpRequest request, String name) {
        return DocumentV1ApiHandler.getProperty(request, name).orElseThrow(() -> new IllegalArgumentException("Must specify '" + name + "' at '" + request.getUri().getRawPath() + "'"));
    }

    private static Optional<String> getProperty(HttpRequest request, String name) {
        String value;
        if (!request.parameters().containsKey(name)) {
            return Optional.empty();
        }
        List values = (List)request.parameters().get(name);
        if (values == null || values.isEmpty() || (value = (String)values.get(values.size() - 1)) == null || value.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty value for request property '" + name + "'");
        }
        return Optional.of(value);
    }

    private static <T> Optional<T> getProperty(HttpRequest request, String name, Parser<T> parser) {
        return DocumentV1ApiHandler.getProperty(request, name).map(parser::parse);
    }

    private static void disallow(HttpRequest request, String ... properties) {
        for (String property : properties) {
            if (!request.parameters().containsKey(property)) continue;
            throw new IllegalArgumentException("May not specify '" + property + "' at '" + request.getUri().getRawPath() + "'");
        }
    }

    private static Map<String, StorageCluster> parseClusters(ClusterListConfig clusters, AllClustersBucketSpacesConfig buckets) {
        return clusters.storage().stream().collect(Collectors.toUnmodifiableMap(storage -> storage.name(), storage -> new StorageCluster(storage.name(), buckets.cluster(storage.name()).documentType().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((AllClustersBucketSpacesConfig.Cluster.DocumentType)entry.getValue()).bucketSpace())))));
    }

    static StorageCluster resolveCluster(Optional<String> wanted, Map<String, StorageCluster> clusters) {
        if (clusters.isEmpty()) {
            throw new IllegalArgumentException("Your Vespa deployment has no content clusters, so the document API is not enabled");
        }
        return wanted.map(cluster -> {
            if (!clusters.containsKey(cluster)) {
                throw new IllegalArgumentException("Your Vespa deployment has no content cluster '" + cluster + "', only '" + String.join((CharSequence)"', '", clusters.keySet()) + "'");
            }
            return (StorageCluster)clusters.get(cluster);
        }).orElseGet(() -> {
            if (clusters.size() > 1) {
                throw new IllegalArgumentException("Please specify one of the content clusters in your Vespa deployment: '" + String.join((CharSequence)"', '", clusters.keySet()) + "'");
            }
            return (StorageCluster)clusters.values().iterator().next();
        });
    }

    static String resolveBucket(StorageCluster cluster, Optional<String> documentType, List<String> bucketSpaces, Optional<String> bucketSpace) {
        return documentType.map(type -> cluster.bucketOf((String)type).orElseThrow(() -> new IllegalArgumentException("Document type '" + type + "' in cluster '" + cluster.name() + "' is not mapped to a known bucket space"))).or(() -> bucketSpace.map(space -> {
            if (!bucketSpaces.contains(space)) {
                throw new IllegalArgumentException("Bucket space '" + space + "' is not a known bucket space; expected one of " + String.join((CharSequence)", ", bucketSpaces));
            }
            return space;
        })).orElse(FixedBucketSpaces.defaultSpace());
    }

    static class Group {
        private final String docIdPart;
        private final String selection;

        private Group(String docIdPart, String selection) {
            this.docIdPart = docIdPart;
            this.selection = selection;
        }

        public static Group of(long value) {
            String stringValue = Long.toUnsignedString(value);
            return new Group("n=" + stringValue, "id.user==" + stringValue);
        }

        public static Group of(String value) {
            Text.validateTextString((String)value).ifPresent(codePoint -> {
                throw new IllegalArgumentException(String.format("Illegal code point U%04X in group", codePoint));
            });
            return new Group("g=" + value, "id.group=='" + value.replaceAll("'", "\\\\'") + "'");
        }

        public String docIdPart() {
            return this.docIdPart;
        }

        public String selection() {
            return this.selection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this.docIdPart.equals(group.docIdPart) && this.selection.equals(group.selection);
        }

        public int hashCode() {
            return Objects.hash(this.docIdPart, this.selection);
        }

        public String toString() {
            return "Group{docIdPart='" + this.docIdPart + "', selection='" + this.selection + "'}";
        }
    }

    private static class DocumentPath {
        private final Path path;
        private final Optional<Group> group;

        DocumentPath(Path path) {
            this.path = Objects.requireNonNull(path);
            this.group = Optional.ofNullable(path.get("number")).map(unsignedLongParser::parse).map(Group::of).or(() -> Optional.ofNullable(path.get("group")).map(Group::of));
        }

        DocumentId id() {
            return new DocumentId("id:" + Objects.requireNonNull(this.path.get("namespace")) + ":" + Objects.requireNonNull(this.path.get("documentType")) + ":" + this.group.map(Group::docIdPart).orElse("") + ":" + Objects.requireNonNull(this.path.getRest()));
        }

        String rawPath() {
            return this.path.asString();
        }

        Optional<String> documentType() {
            return Optional.ofNullable(this.path.get("documentType"));
        }

        Optional<String> namespace() {
            return Optional.ofNullable(this.path.get("namespace"));
        }

        Optional<Group> group() {
            return this.group;
        }
    }

    static class StorageCluster {
        private final String name;
        private final Map<String, String> documentBuckets;

        StorageCluster(String name, Map<String, String> documentBuckets) {
            this.name = Objects.requireNonNull(name);
            this.documentBuckets = Map.copyOf(documentBuckets);
        }

        String name() {
            return this.name;
        }

        Optional<String> bucketOf(String documentType) {
            return Optional.ofNullable(this.documentBuckets.get(documentType));
        }
    }

    private class MeasuringResponseHandler
    implements ResponseHandler {
        private final ResponseHandler delegate;
        private final DocumentOperationType type;
        private final Instant start;

        private MeasuringResponseHandler(ResponseHandler delegate, DocumentOperationType type, Instant start) {
            this.delegate = delegate;
            this.type = type;
            this.start = start;
        }

        public ContentChannel handleResponse(Response response) {
            switch (response.getStatus() / 100) {
                case 2: {
                    DocumentV1ApiHandler.this.metrics.reportSuccessful(this.type, this.start);
                    break;
                }
                case 4: {
                    DocumentV1ApiHandler.this.metrics.reportFailure(this.type, DocumentOperationStatus.REQUEST_ERROR);
                    break;
                }
                case 5: {
                    DocumentV1ApiHandler.this.metrics.reportFailure(this.type, DocumentOperationStatus.SERVER_ERROR);
                }
            }
            return this.delegate.handleResponse(response);
        }
    }

    @FunctionalInterface
    static interface Parser<T>
    extends Function<String, T> {
        default public T parse(String value) {
            try {
                return (T)this.apply(value);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Failed parsing '" + value + "': " + Exceptions.toMessageString((Throwable)e));
            }
        }
    }

    private static interface VisitCallback {
        default public void onStart(JsonResponse response) throws IOException {
        }

        default public void onDocument(JsonResponse response, Document document, Runnable ack, Consumer<String> onError) {
        }

        default public void onEnd(JsonResponse response) throws IOException {
        }
    }

    static interface SuccessCallback {
        public void onSuccess(Document var1, JsonResponse var2) throws IOException;
    }

    static class DocumentOperationParser {
        private final DocumentTypeManager manager;

        DocumentOperationParser(DocumentmanagerConfig config) {
            this.manager = new DocumentTypeManager(config);
        }

        DocumentPut parsePut(InputStream inputStream, String docId) {
            return (DocumentPut)this.parse(inputStream, docId, com.yahoo.document.json.DocumentOperationType.PUT);
        }

        DocumentUpdate parseUpdate(InputStream inputStream, String docId) {
            return (DocumentUpdate)this.parse(inputStream, docId, com.yahoo.document.json.DocumentOperationType.UPDATE);
        }

        private DocumentOperation parse(InputStream inputStream, String docId, com.yahoo.document.json.DocumentOperationType operation) {
            return new JsonReader(this.manager, inputStream, jsonFactory).readSingleDocument(operation, docId);
        }
    }

    static class ForwardingContentChannel
    implements ContentChannel {
        private final ReadableContentChannel delegate = new ReadableContentChannel();
        private final Consumer<InputStream> reader;
        private volatile boolean errorReported = false;

        public ForwardingContentChannel(Consumer<InputStream> reader) {
            this.reader = reader;
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            try {
                this.delegate.write(buf, logException);
                handler.completed();
            }
            catch (Exception e) {
                handler.failed((Throwable)e);
            }
        }

        public void close(CompletionHandler handler) {
            try {
                this.delegate.close(logException);
                if (!this.errorReported) {
                    this.reader.accept((InputStream)new UnsafeContentInputStream(this.delegate));
                }
                handler.completed();
            }
            catch (Exception e) {
                handler.failed((Throwable)e);
            }
        }

        public void onError(Throwable error) {
            log.log(Level.FINE, error, () -> "ContentChannel.onError(): " + error.getMessage());
            this.errorReported = true;
        }
    }

    private static class DispatchException
    extends RuntimeException {
        private DispatchException(Throwable cause) {
            super(cause);
        }
    }

    private static class Operation {
        private final Lock lock = new ReentrantLock();
        private final HttpRequest request;
        private final ResponseHandler handler;
        private BooleanSupplier operation;
        private Supplier<BooleanSupplier> parser;

        Operation(HttpRequest request, ResponseHandler handler, Supplier<BooleanSupplier> parser) {
            this.request = request;
            this.handler = handler;
            this.parser = parser;
        }

        boolean dispatch() {
            if (this.request.isCancelled()) {
                return true;
            }
            if (!this.lock.tryLock()) {
                throw new IllegalStateException("Concurrent attempts at dispatch \u2014 this is a bug");
            }
            try {
                if (this.operation == null) {
                    this.operation = this.parser.get();
                    this.parser = null;
                }
                boolean bl = this.operation.getAsBoolean();
                return bl;
            }
            catch (IllegalArgumentException e) {
                DocumentV1ApiHandler.badRequest(this.request, e, this.handler);
            }
            catch (DispatchException e) {
                DocumentV1ApiHandler.badGateway(this.request, e, this.handler);
            }
            catch (RuntimeException e) {
                DocumentV1ApiHandler.serverError(this.request, e, this.handler);
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
    }

    private static class JsonResponse
    implements AutoCloseable {
        private static final ByteBuffer emptyBuffer = ByteBuffer.wrap(new byte[0]);
        private static final int FLUSH_SIZE = 128;
        private final BufferedContentChannel buffer = new BufferedContentChannel();
        private final OutputStream out = new ContentChannelOutputStream((ContentChannel)this.buffer);
        private final JsonGenerator json;
        private final ResponseHandler handler;
        private final Queue<CompletionHandler> acks = new ConcurrentLinkedQueue<CompletionHandler>();
        private final Queue<ByteArrayOutputStream> docs = new ConcurrentLinkedQueue<ByteArrayOutputStream>();
        private final AtomicLong documentsWritten = new AtomicLong();
        private final AtomicLong documentsFlushed = new AtomicLong();
        private final AtomicLong documentsAcked = new AtomicLong();
        private boolean documentsDone = false;
        private boolean first = true;
        private ContentChannel channel;

        private JsonResponse(ResponseHandler handler) throws IOException {
            this.handler = handler;
            this.json = jsonFactory.createGenerator(this.out);
            this.json.writeStartObject();
        }

        static JsonResponse create(DocumentPath path, ResponseHandler handler) throws IOException {
            JsonResponse response = new JsonResponse(handler);
            response.writePathId(path.rawPath());
            response.writeDocId(path.id());
            return response;
        }

        static JsonResponse create(HttpRequest request, ResponseHandler handler) throws IOException {
            JsonResponse response = new JsonResponse(handler);
            response.writePathId(request.getUri().getRawPath());
            return response;
        }

        static JsonResponse create(HttpRequest request, String message, ResponseHandler handler) throws IOException {
            JsonResponse response = JsonResponse.create(request, handler);
            response.writeMessage(message);
            return response;
        }

        synchronized void commit(int status) throws IOException {
            Response response = new Response(status);
            response.headers().addAll(Map.of("Content-Type", List.of("application/json; charset=UTF-8")));
            try {
                this.channel = this.handler.handleResponse(response);
                this.buffer.connectTo(this.channel);
            }
            catch (RuntimeException e) {
                throw new IOException(e);
            }
        }

        synchronized void respond(int status) throws IOException {
            try (JsonResponse jsonResponse = this;){
                this.commit(status);
            }
        }

        @Override
        public synchronized void close() throws IOException {
            this.documentsDone = true;
            try {
                if (this.channel == null) {
                    log.log(Level.WARNING, "Close called before response was committed, in " + this.getClass().getName());
                    this.commit(500);
                }
                this.json.close();
                this.out.close();
            }
            finally {
                if (this.channel != null) {
                    this.channel.close(logException);
                }
            }
        }

        synchronized void writePathId(String path) throws IOException {
            this.json.writeStringField("pathId", path);
        }

        synchronized void writeMessage(String message) throws IOException {
            this.json.writeStringField("message", message);
        }

        synchronized void writeDocumentCount(long count) throws IOException {
            this.json.writeNumberField("documentCount", count);
        }

        synchronized void writeDocId(DocumentId id) throws IOException {
            this.json.writeStringField("id", id.toString());
        }

        synchronized void writeTrace(Trace trace) throws IOException {
            if (trace != null && !trace.getRoot().isEmpty()) {
                this.writeTrace(trace.getRoot());
            }
        }

        private void writeTrace(TraceNode node) throws IOException {
            if (node.hasNote()) {
                this.json.writeStringField("message", node.getNote());
            }
            if (!node.isLeaf()) {
                this.json.writeArrayFieldStart(node.isStrict() ? "trace" : "fork");
                for (int i = 0; i < node.getNumChildren(); ++i) {
                    this.json.writeStartObject();
                    this.writeTrace(node.getChild(i));
                    this.json.writeEndObject();
                }
                this.json.writeEndArray();
            }
        }

        synchronized void writeSingleDocument(Document document) throws IOException {
            new JsonWriter(this.json).writeFields(document);
        }

        synchronized void writeDocumentsArrayStart() throws IOException {
            this.json.writeArrayFieldStart("documents");
        }

        void writeDocumentValue(Document document, CompletionHandler completionHandler) throws IOException {
            if (completionHandler != null) {
                this.acks.add(completionHandler);
                this.ackDocuments();
            }
            ByteArrayOutputStream myOut = new ByteArrayOutputStream(1);
            myOut.write(44);
            try (JsonGenerator myJson = jsonFactory.createGenerator((OutputStream)myOut);){
                new JsonWriter(myJson).write(document);
            }
            this.docs.add(myOut);
            if (this.documentsWritten.incrementAndGet() % 128L == 0L) {
                this.flushDocuments();
            }
        }

        void ackDocuments() {
            CompletionHandler ack;
            while (this.documentsAcked.incrementAndGet() <= this.documentsFlushed.get() + 128L && (ack = this.acks.poll()) != null) {
                ack.completed();
            }
            this.documentsAcked.decrementAndGet();
        }

        synchronized void flushDocuments() throws IOException {
            ByteArrayOutputStream doc;
            for (int i = 0; i < 128 && (doc = this.docs.poll()) != null; ++i) {
                if (this.documentsDone) continue;
                if (this.first) {
                    this.json.flush();
                    this.buffer.write(ByteBuffer.wrap(doc.toByteArray(), 1, doc.size() - 1), null);
                    this.first = false;
                    continue;
                }
                this.buffer.write(ByteBuffer.wrap(doc.toByteArray()), null);
            }
            this.buffer.write(emptyBuffer, new CompletionHandler(){

                public void completed() {
                    documentsFlushed.addAndGet(128L);
                    this.ackDocuments();
                }

                public void failed(Throwable t) {
                    log.log(Level.WARNING, "Error writing documents", t);
                    this.completed();
                }
            });
        }

        synchronized void writeArrayEnd() throws IOException {
            this.flushDocuments();
            this.documentsDone = true;
            this.json.writeEndArray();
        }

        synchronized void writeContinuation(String token) throws IOException {
            this.json.writeStringField(DocumentV1ApiHandler.CONTINUATION, token);
        }
    }

    @FunctionalInterface
    static interface Handler {
        public ContentChannel handle(HttpRequest var1, DocumentPath var2, ResponseHandler var3);
    }
}

