/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.metrics;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.yahoo.documentapi.metrics.DocumentOperationStatus;
import com.yahoo.documentapi.metrics.DocumentOperationType;
import com.yahoo.metrics.simple.Counter;
import com.yahoo.metrics.simple.Gauge;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.metrics.simple.Point;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class DocumentApiMetrics {
    private final Counter feeds;
    private final Gauge feedLatency;
    private final Counter feedRequests;
    private final Map<DocumentOperationStatus, Map<DocumentOperationType, Point>> points = new HashMap<DocumentOperationStatus, Map<DocumentOperationType, Point>>();
    private final Cache<String, Point> versionPointCache = CacheBuilder.newBuilder().maximumSize(256L).build();

    public DocumentApiMetrics(MetricReceiver metricReceiver, String apiName) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("api", apiName);
        for (DocumentOperationStatus status : DocumentOperationStatus.values()) {
            this.points.put(status, new HashMap());
            dimensions.put("status", status.name());
            for (DocumentOperationType operation : DocumentOperationType.values()) {
                dimensions.put("operation", operation.name());
                this.points.get((Object)status).put(operation, new Point(dimensions));
            }
        }
        this.feeds = metricReceiver.declareCounter("feed.operations");
        this.feedLatency = metricReceiver.declareGauge("feed.latency");
        this.feedRequests = metricReceiver.declareCounter("feed.http-requests");
    }

    public void reportSuccessful(DocumentOperationType documentOperationType, double latencyInSeconds) {
        Point point = this.points.get((Object)DocumentOperationStatus.OK).get((Object)documentOperationType);
        this.feedLatency.sample(latencyInSeconds, point);
        this.feeds.add(point);
    }

    public void reportSuccessful(DocumentOperationType documentOperationType, Instant startTime) {
        double latency = (double)Duration.between(startTime, Instant.now()).toMillis() / 1000.0;
        this.reportSuccessful(documentOperationType, latency);
    }

    public void reportFailure(DocumentOperationType documentOperationType, DocumentOperationStatus documentOperationStatus) {
        Point point = this.points.get((Object)documentOperationStatus).get((Object)documentOperationType);
        this.feeds.add(point);
    }

    public void reportHttpRequest(String clientVersion) {
        if (clientVersion != null) {
            try {
                Point point = (Point)this.versionPointCache.get((Object)clientVersion, () -> new Point(Map.of("client-version", clientVersion)));
                this.feedRequests.add(point);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.feedRequests.add();
        }
    }
}

