/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.inject.Inject;
import com.yahoo.cloud.config.ClusterListConfig;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.container.core.HandlerMetricContextUtil;
import com.yahoo.container.core.documentapi.VespaDocumentAccess;
import com.yahoo.container.jdisc.ContentChannelOutputStream;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.json.JsonReader;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.document.restapi.DocumentOperationExecutorConfig;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.AsyncSession;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.DocumentOperationParameters;
import com.yahoo.documentapi.DocumentResponse;
import com.yahoo.documentapi.DumpVisitorDataHandler;
import com.yahoo.documentapi.ProgressToken;
import com.yahoo.documentapi.Result;
import com.yahoo.documentapi.VisitorControlHandler;
import com.yahoo.documentapi.VisitorControlSession;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.metrics.DocumentApiMetrics;
import com.yahoo.documentapi.metrics.DocumentOperationStatus;
import com.yahoo.documentapi.metrics.DocumentOperationType;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.BufferedContentChannel;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ReadableContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.handler.UnsafeContentInputStream;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.messagebus.StaticThrottlePolicy;
import com.yahoo.messagebus.ThrottlePolicy;
import com.yahoo.messagebus.Trace;
import com.yahoo.messagebus.TraceNode;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.restapi.Path;
import com.yahoo.search.query.ParameterParser;
import com.yahoo.text.Text;
import com.yahoo.vespa.config.content.AllClustersBucketSpacesConfig;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DocumentV1ApiHandler
extends AbstractRequestHandler {
    private static final Duration defaultTimeout = Duration.ofSeconds(175L);
    private static final Logger log = Logger.getLogger(DocumentV1ApiHandler.class.getName());
    private static final Parser<Integer> integerParser = Integer::parseInt;
    private static final Parser<Long> timeoutMillisParser = value -> ParameterParser.asMilliSeconds((Object)value, (Long)defaultTimeout.toMillis());
    private static final Parser<Boolean> booleanParser = Boolean::parseBoolean;
    private static final CompletionHandler logException = new CompletionHandler(){

        public void completed() {
        }

        public void failed(Throwable t) {
            log.log(Level.FINE, "Exception writing or closing response data", t);
        }
    };
    private static final ContentChannel ignoredContent = new ContentChannel(){

        public void write(ByteBuffer buf, CompletionHandler handler) {
            handler.completed();
        }

        public void close(CompletionHandler handler) {
            handler.completed();
        }
    };
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final String CREATE = "create";
    private static final String CONDITION = "condition";
    private static final String ROUTE = "route";
    private static final String FIELD_SET = "fieldSet";
    private static final String SELECTION = "selection";
    private static final String CLUSTER = "cluster";
    private static final String CONTINUATION = "continuation";
    private static final String WANTED_DOCUMENT_COUNT = "wantedDocumentCount";
    private static final String CONCURRENCY = "concurrency";
    private static final String BUCKET_SPACE = "bucketSpace";
    private static final String TIMEOUT = "timeout";
    private static final String TRACELEVEL = "tracelevel";
    private final Clock clock;
    private final Metric metric;
    private final DocumentApiMetrics metrics;
    private final DocumentOperationParser parser;
    private final long maxThrottled;
    private final DocumentAccess access;
    private final AsyncSession asyncSession;
    private final Map<String, StorageCluster> clusters;
    private final Deque<Operation> operations;
    private final AtomicLong enqueued = new AtomicLong();
    private final Map<VisitorControlHandler, VisitorSession> visits = new ConcurrentHashMap<VisitorControlHandler, VisitorSession>();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("document-api-handler-"));
    private final Map<String, Map<HttpRequest.Method, Handler>> handlers = this.defineApi();

    @Inject
    public DocumentV1ApiHandler(Metric metric, MetricReceiver metricReceiver, VespaDocumentAccess documentAccess, DocumentmanagerConfig documentManagerConfig, ClusterListConfig clusterListConfig, AllClustersBucketSpacesConfig bucketSpacesConfig, DocumentOperationExecutorConfig executorConfig) {
        this(Clock.systemUTC(), metric, metricReceiver, (DocumentAccess)documentAccess, documentManagerConfig, executorConfig, clusterListConfig, bucketSpacesConfig);
    }

    DocumentV1ApiHandler(Clock clock, Metric metric, MetricReceiver metricReceiver, DocumentAccess access, DocumentmanagerConfig documentmanagerConfig, DocumentOperationExecutorConfig executorConfig, ClusterListConfig clusterListConfig, AllClustersBucketSpacesConfig bucketSpacesConfig) {
        this.clock = clock;
        this.parser = new DocumentOperationParser(documentmanagerConfig);
        this.metric = metric;
        this.metrics = new DocumentApiMetrics(metricReceiver, "documentV1");
        this.maxThrottled = executorConfig.maxThrottled();
        this.access = access;
        this.asyncSession = access.createAsyncSession(new AsyncParameters());
        this.clusters = DocumentV1ApiHandler.parseClusters(clusterListConfig, bucketSpacesConfig);
        this.operations = new ConcurrentLinkedDeque<Operation>();
        this.executor.scheduleWithFixedDelay(this::dispatchEnqueued, executorConfig.resendDelayMillis(), executorConfig.resendDelayMillis(), TimeUnit.MILLISECONDS);
    }

    public ContentChannel handleRequest(Request rawRequest, ResponseHandler rawResponseHandler) {
        HandlerMetricContextUtil.onHandle((Request)rawRequest, (Metric)this.metric, ((Object)((Object)this)).getClass());
        ResponseHandler responseHandler = response -> {
            HandlerMetricContextUtil.onHandled((Request)rawRequest, (Metric)this.metric, ((Object)((Object)this)).getClass());
            return rawResponseHandler.handleResponse(response);
        };
        HttpRequest request = (HttpRequest)rawRequest;
        try {
            request.setTimeout(DocumentV1ApiHandler.getProperty(request, TIMEOUT, timeoutMillisParser).orElse(defaultTimeout.toMillis()).longValue(), TimeUnit.MILLISECONDS);
            Path requestPath = new Path(request.getUri());
            for (String path : this.handlers.keySet()) {
                if (!requestPath.matches(path)) continue;
                Map<HttpRequest.Method, Handler> methods = this.handlers.get(path);
                if (methods.containsKey(request.getMethod())) {
                    return methods.get(request.getMethod()).handle(request, new DocumentPath(requestPath), responseHandler);
                }
                if (request.getMethod() == HttpRequest.Method.OPTIONS) {
                    DocumentV1ApiHandler.options(methods.keySet(), responseHandler);
                }
                DocumentV1ApiHandler.methodNotAllowed(request, methods.keySet(), responseHandler);
            }
            DocumentV1ApiHandler.notFound(request, this.handlers.keySet(), responseHandler);
        }
        catch (IllegalArgumentException e) {
            DocumentV1ApiHandler.badRequest(request, e, responseHandler);
        }
        catch (RuntimeException e) {
            DocumentV1ApiHandler.serverError(request, e, responseHandler);
        }
        return ignoredContent;
    }

    public void handleTimeout(Request request, ResponseHandler responseHandler) {
        DocumentV1ApiHandler.timeout((HttpRequest)request, "Request timeout after " + request.getTimeout(TimeUnit.MILLISECONDS) + "ms", responseHandler);
    }

    public void destroy() {
        this.executor.shutdown();
        Instant doom = this.clock.instant().plus(Duration.ofSeconds(20L));
        while (!this.operations.isEmpty() && this.clock.instant().isBefore(doom)) {
            this.dispatchEnqueued();
        }
        if (!this.operations.isEmpty()) {
            log.log(Level.WARNING, "Failed to empty request queue before shutdown timeout \u2014 " + this.operations.size() + " requests left");
        }
        this.asyncSession.destroy();
        this.visits.values().forEach(VisitorControlSession::destroy);
        try {
            if (!this.executor.awaitTermination(Duration.between(this.clock.instant(), doom).toMillis(), TimeUnit.MILLISECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Interrupted waiting for /document/v1 executor to shut down");
        }
    }

    private Map<String, Map<HttpRequest.Method, Handler>> defineApi() {
        LinkedHashMap<String, Map<HttpRequest.Method, Handler>> handlers = new LinkedHashMap<String, Map<HttpRequest.Method, Handler>>();
        handlers.put("/document/v1/", Map.of(HttpRequest.Method.GET, this::getDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/docid/", Map.of(HttpRequest.Method.GET, this::getDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/group/{group}/", Map.of(HttpRequest.Method.GET, this::getDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/number/{number}/", Map.of(HttpRequest.Method.GET, this::getDocuments));
        handlers.put("/document/v1/{namespace}/{documentType}/docid/{*}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        handlers.put("/document/v1/{namespace}/{documentType}/group/{group}/{*}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        handlers.put("/document/v1/{namespace}/{documentType}/number/{number}/{*}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        return Collections.unmodifiableMap(handlers);
    }

    private ContentChannel getDocuments(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        this.enqueueAndDispatch(request, handler, () -> {
            VisitorParameters parameters = this.parseParameters(request, path);
            return () -> {
                this.visit(request, parameters, handler);
                return true;
            };
        });
        return ignoredContent;
    }

    private ContentChannel getDocument(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        this.enqueueAndDispatch(request, handler, () -> {
            DocumentOperationParameters rawParameters = this.parametersFromRequest(request, CLUSTER, FIELD_SET);
            if (rawParameters.fieldSet().isEmpty()) {
                rawParameters = rawParameters.withFieldSet(path.documentType().orElseThrow() + ":[document]");
            }
            DocumentOperationParameters parameters = rawParameters.withResponseHandler(response -> DocumentV1ApiHandler.handle(path, handler, response, (document, jsonResponse) -> {
                if (document != null) {
                    jsonResponse.writeSingleDocument(document);
                    jsonResponse.commit(200);
                } else {
                    jsonResponse.commit(404);
                }
            }));
            return () -> DocumentV1ApiHandler.dispatchOperation(() -> this.asyncSession.get(path.id(), parameters));
        });
        return ignoredContent;
    }

    private ContentChannel postDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        MeasuringResponseHandler handler = new MeasuringResponseHandler(rawHandler, DocumentOperationType.PUT, this.clock.instant());
        return new ForwardingContentChannel(in -> this.enqueueAndDispatch(request, handler, () -> {
            DocumentPut put = this.parser.parsePut((InputStream)in, path.id().toString());
            DocumentV1ApiHandler.getProperty(request, CONDITION).map(TestAndSetCondition::new).ifPresent(arg_0 -> ((DocumentPut)put).setCondition(arg_0));
            DocumentOperationParameters parameters = this.parametersFromRequest(request, ROUTE).withResponseHandler(response -> DocumentV1ApiHandler.handle(path, handler, response));
            return () -> DocumentV1ApiHandler.dispatchOperation(() -> this.asyncSession.put(put, parameters));
        }));
    }

    private ContentChannel putDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        MeasuringResponseHandler handler = new MeasuringResponseHandler(rawHandler, DocumentOperationType.UPDATE, this.clock.instant());
        return new ForwardingContentChannel(in -> this.enqueueAndDispatch(request, handler, () -> {
            DocumentUpdate update = this.parser.parseUpdate((InputStream)in, path.id().toString());
            DocumentV1ApiHandler.getProperty(request, CONDITION).map(TestAndSetCondition::new).ifPresent(arg_0 -> ((DocumentUpdate)update).setCondition(arg_0));
            DocumentV1ApiHandler.getProperty(request, CREATE, booleanParser).ifPresent(arg_0 -> ((DocumentUpdate)update).setCreateIfNonExistent(arg_0));
            DocumentOperationParameters parameters = this.parametersFromRequest(request, ROUTE).withResponseHandler(response -> DocumentV1ApiHandler.handle(path, handler, response));
            return () -> DocumentV1ApiHandler.dispatchOperation(() -> this.asyncSession.update(update, parameters));
        }));
    }

    private ContentChannel deleteDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        MeasuringResponseHandler handler = new MeasuringResponseHandler(rawHandler, DocumentOperationType.REMOVE, this.clock.instant());
        this.enqueueAndDispatch(request, handler, () -> {
            DocumentRemove remove = new DocumentRemove(path.id());
            DocumentV1ApiHandler.getProperty(request, CONDITION).map(TestAndSetCondition::new).ifPresent(arg_0 -> ((DocumentRemove)remove).setCondition(arg_0));
            DocumentOperationParameters parameters = this.parametersFromRequest(request, ROUTE).withResponseHandler(response -> DocumentV1ApiHandler.handle(path, handler, response));
            return () -> DocumentV1ApiHandler.dispatchOperation(() -> this.asyncSession.remove(remove, parameters));
        });
        return ignoredContent;
    }

    private DocumentOperationParameters parametersFromRequest(HttpRequest request, String ... names) {
        DocumentOperationParameters parameters = DocumentV1ApiHandler.getProperty(request, TRACELEVEL, integerParser).map(arg_0 -> ((DocumentOperationParameters)DocumentOperationParameters.parameters()).withTraceLevel(arg_0)).orElse(DocumentOperationParameters.parameters());
        String[] stringArray = names;
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String name;
            switch (name = stringArray[i]) {
                case "cluster": {
                    parameters = DocumentV1ApiHandler.getProperty(request, CLUSTER).map(cluster -> DocumentV1ApiHandler.resolveCluster(Optional.of(cluster), this.clusters).route()).map(arg_0 -> ((DocumentOperationParameters)parameters).withRoute(arg_0)).orElse(parameters);
                    continue block10;
                }
                case "fieldSet": {
                    parameters = DocumentV1ApiHandler.getProperty(request, FIELD_SET).map(arg_0 -> ((DocumentOperationParameters)parameters).withFieldSet(arg_0)).orElse(parameters);
                    continue block10;
                }
                case "route": {
                    parameters = DocumentV1ApiHandler.getProperty(request, ROUTE).map(arg_0 -> ((DocumentOperationParameters)parameters).withRoute(arg_0)).orElse(parameters);
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized document operation parameter name '" + name + "'");
                }
            }
        }
        return parameters;
    }

    void dispatchEnqueued() {
        try {
            while (this.dispatchFirst()) {
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Uncaught exception in /document/v1 dispatch thread", e);
        }
    }

    private boolean dispatchFirst() {
        Operation operation = this.operations.poll();
        if (operation == null) {
            return false;
        }
        if (operation.dispatch()) {
            this.enqueued.decrementAndGet();
            return true;
        }
        this.operations.push(operation);
        return false;
    }

    private void enqueueAndDispatch(HttpRequest request, ResponseHandler handler, final Supplier<Supplier<Boolean>> operationParser) {
        if (this.enqueued.incrementAndGet() > this.maxThrottled) {
            this.enqueued.decrementAndGet();
            DocumentV1ApiHandler.overload(request, "Rejecting execution due to overload: " + this.maxThrottled + " requests already enqueued", handler);
            return;
        }
        this.operations.offer(new Operation(request, handler){

            @Override
            Supplier<Boolean> parse() {
                return (Supplier)operationParser.get();
            }
        });
        this.dispatchFirst();
    }

    private static void options(Collection<HttpRequest.Method> methods, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            Response response = new Response(204);
            response.headers().add("Allow", methods.stream().sorted().map(Enum::name).collect(Collectors.joining(",")));
            handler.handleResponse(response).close(logException);
        });
    }

    private static void badRequest(HttpRequest request, IllegalArgumentException e, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            String message = Exceptions.toMessageString((Throwable)e);
            log.log(Level.FINE, () -> "Bad request for " + request.getMethod() + " at " + request.getUri().getRawPath() + ": " + message);
            JsonResponse.create(request, message, handler).respond(400);
        });
    }

    private static void notFound(HttpRequest request, Collection<String> paths, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> JsonResponse.create(request, "Nothing at '" + request.getUri().getRawPath() + "'. Available paths are:\n" + String.join((CharSequence)"\n", paths), handler).respond(404));
    }

    private static void methodNotAllowed(HttpRequest request, Collection<HttpRequest.Method> methods, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> JsonResponse.create(request, "'" + request.getMethod() + "' not allowed at '" + request.getUri().getRawPath() + "'. Allowed methods are: " + methods.stream().sorted().map(Enum::name).collect(Collectors.joining(", ")), handler).respond(405));
    }

    private static void overload(HttpRequest request, String message, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            log.log(Level.FINE, () -> "Overload handling request " + request.getMethod() + " " + request.getUri().getRawPath() + ": " + message);
            JsonResponse.create(request, message, handler).respond(429);
        });
    }

    private static void serverError(HttpRequest request, Throwable t, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            log.log(Level.WARNING, "Uncaught exception handling request " + request.getMethod() + " " + request.getUri().getRawPath() + ":", t);
            JsonResponse.create(request, Exceptions.toMessageString((Throwable)t), handler).respond(500);
        });
    }

    private static void timeout(HttpRequest request, String message, ResponseHandler handler) {
        DocumentV1ApiHandler.loggingException(() -> {
            log.log(Level.FINE, () -> "Timeout handling request " + request.getMethod() + " " + request.getUri().getRawPath() + ": " + message);
            JsonResponse.create(request, message, handler).respond(504);
        });
    }

    private static void loggingException(Exceptions.RunnableThrowingIOException runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            log.log(Level.FINE, "Failed writing response", e);
        }
    }

    private static boolean dispatchOperation(Supplier<Result> documentOperation) {
        Result result = documentOperation.get();
        if (result.type() == Result.ResultType.TRANSIENT_ERROR) {
            return false;
        }
        if (result.type() == Result.ResultType.FATAL_ERROR) {
            throw new RuntimeException(result.getError());
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handle(DocumentPath path, ResponseHandler handler, com.yahoo.documentapi.Response response, SuccessCallback callback) {
        try (JsonResponse jsonResponse = JsonResponse.create(path, handler);){
            jsonResponse.writeTrace(response.getTrace());
            if (response.isSuccess()) {
                callback.onSuccess(response instanceof DocumentResponse ? ((DocumentResponse)response).getDocument() : null, jsonResponse);
                return;
            }
            jsonResponse.writeMessage(response.getTextMessage());
            switch (response.outcome()) {
                case NOT_FOUND: {
                    jsonResponse.commit(404);
                    return;
                }
                case CONDITION_FAILED: {
                    jsonResponse.commit(412);
                    return;
                }
                case INSUFFICIENT_STORAGE: {
                    jsonResponse.commit(507);
                    return;
                }
                default: {
                    log.log(Level.WARNING, "Unexpected document API operation outcome '" + response.outcome() + "'");
                }
                case ERROR: {
                    log.log(Level.FINE, () -> "Exception performing document operation: " + response.getTextMessage());
                    jsonResponse.commit(500);
                    return;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, "Failed writing response", e);
        }
    }

    private static void handle(DocumentPath path, ResponseHandler handler, com.yahoo.documentapi.Response response) {
        DocumentV1ApiHandler.handle(path, handler, response, (document, jsonResponse) -> jsonResponse.commit(200));
    }

    private VisitorParameters parseParameters(HttpRequest request, DocumentPath path) {
        int wantedDocumentCount = Math.min(1024, DocumentV1ApiHandler.getProperty(request, WANTED_DOCUMENT_COUNT, integerParser).orElse(1));
        if (wantedDocumentCount <= 0) {
            throw new IllegalArgumentException("wantedDocumentCount must be positive");
        }
        int concurrency = Math.min(100, DocumentV1ApiHandler.getProperty(request, CONCURRENCY, integerParser).orElse(1));
        if (concurrency <= 0) {
            throw new IllegalArgumentException("concurrency must be positive");
        }
        Optional<String> cluster = DocumentV1ApiHandler.getProperty(request, CLUSTER);
        if (cluster.isEmpty() && path.documentType().isEmpty()) {
            throw new IllegalArgumentException("Must set 'cluster' parameter to a valid content cluster id when visiting at a root /document/v1/ level");
        }
        VisitorParameters parameters = new VisitorParameters(Stream.of(DocumentV1ApiHandler.getProperty(request, SELECTION), path.documentType(), path.namespace().map(value -> "id.namespace=='" + value + "'"), path.group().map(Group::selection)).flatMap(Optional::stream).reduce(new StringJoiner(") and (", "(", ")").setEmptyValue(""), StringJoiner::add, StringJoiner::merge).toString());
        DocumentV1ApiHandler.getProperty(request, CONTINUATION).map(ProgressToken::fromSerializedString).ifPresent(arg_0 -> ((VisitorParameters)parameters).setResumeToken(arg_0));
        parameters.setFieldSet(DocumentV1ApiHandler.getProperty(request, FIELD_SET).orElse(path.documentType().map(type -> type + ":[document]").orElse("[all]")));
        parameters.setMaxTotalHits((long)wantedDocumentCount);
        parameters.setThrottlePolicy((ThrottlePolicy)new StaticThrottlePolicy().setMaxPendingCount(concurrency));
        parameters.setSessionTimeoutMs(Math.max(1L, request.getTimeout(TimeUnit.MILLISECONDS) - 5000L));
        parameters.visitInconsistentBuckets(true);
        parameters.setPriority(DocumentProtocol.Priority.NORMAL_4);
        StorageCluster storageCluster = DocumentV1ApiHandler.resolveCluster(cluster, this.clusters);
        parameters.setRoute(storageCluster.route());
        parameters.setBucketSpace(DocumentV1ApiHandler.resolveBucket(storageCluster, path.documentType(), List.of(FixedBucketSpaces.defaultSpace(), FixedBucketSpaces.globalSpace()), DocumentV1ApiHandler.getProperty(request, BUCKET_SPACE)));
        return parameters;
    }

    private void visit(HttpRequest request, final VisitorParameters parameters, ResponseHandler handler) {
        try {
            final JsonResponse response = JsonResponse.create(request, handler);
            response.writeDocumentsArrayStart();
            final CountDownLatch latch = new CountDownLatch(1);
            parameters.setLocalDataHandler((VisitorDataHandler)new DumpVisitorDataHandler(){

                public void onDocument(Document doc, long timeStamp) {
                    DocumentV1ApiHandler.loggingException(() -> response.writeDocumentValue(doc));
                }

                public void onRemove(DocumentId id) {
                }
            });
            parameters.setControlHandler(new VisitorControlHandler(){

                public void onDone(VisitorControlHandler.CompletionCode code, String message) {
                    super.onDone(code, message);
                    DocumentV1ApiHandler.loggingException(() -> {
                        response.writeArrayEnd();
                        switch (code) {
                            case TIMEOUT: {
                                if (!this.hasVisitedAnyBuckets()) {
                                    response.writeMessage("No buckets visited within timeout of " + parameters.getSessionTimeoutMs() + "ms (request timeout -5s)");
                                    response.respond(504);
                                    break;
                                }
                            }
                            case SUCCESS: 
                            case ABORTED: {
                                if (this.getProgress() != null && !this.getProgress().isFinished()) {
                                    response.writeContinuation(this.getProgress().serializeToString());
                                }
                                response.respond(200);
                                break;
                            }
                            default: {
                                response.writeMessage(message != null ? message : "Visiting failed");
                                response.respond(500);
                            }
                        }
                        DocumentV1ApiHandler.this.executor.execute(() -> {
                            try {
                                latch.await();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            DocumentV1ApiHandler.this.visits.remove((Object)this).destroy();
                        });
                    });
                }
            });
            this.visits.put(parameters.getControlHandler(), this.access.createVisitorSession(parameters));
            latch.countDown();
        }
        catch (ParseException e) {
            DocumentV1ApiHandler.badRequest(request, new IllegalArgumentException(e), handler);
        }
        catch (IOException e) {
            log.log(Level.FINE, "Failed writing response", e);
        }
    }

    private static Optional<String> getProperty(HttpRequest request, String name) {
        String value;
        if (!request.parameters().containsKey(name)) {
            return Optional.empty();
        }
        List values = (List)request.parameters().get(name);
        if (values == null || values.isEmpty() || (value = (String)values.get(values.size() - 1)) == null || value.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty value for request property '" + name + "'");
        }
        return Optional.of(value);
    }

    private static <T> Optional<T> getProperty(HttpRequest request, String name, Parser<T> parser) {
        return DocumentV1ApiHandler.getProperty(request, name).map(parser::parse);
    }

    private static Map<String, StorageCluster> parseClusters(ClusterListConfig clusters, AllClustersBucketSpacesConfig buckets) {
        return clusters.storage().stream().collect(Collectors.toUnmodifiableMap(storage -> storage.name(), storage -> new StorageCluster(storage.name(), buckets.cluster(storage.name()).documentType().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((AllClustersBucketSpacesConfig.Cluster.DocumentType)entry.getValue()).bucketSpace())))));
    }

    static StorageCluster resolveCluster(Optional<String> wanted, Map<String, StorageCluster> clusters) {
        if (clusters.isEmpty()) {
            throw new IllegalArgumentException("Your Vespa deployment has no content clusters, so the document API is not enabled");
        }
        return wanted.map(cluster -> {
            if (!clusters.containsKey(cluster)) {
                throw new IllegalArgumentException("Your Vespa deployment has no content cluster '" + cluster + "', only '" + String.join((CharSequence)"', '", clusters.keySet()) + "'");
            }
            return (StorageCluster)clusters.get(cluster);
        }).orElseGet(() -> {
            if (clusters.size() > 1) {
                throw new IllegalArgumentException("Please specify one of the content clusters in your Vespa deployment: '" + String.join((CharSequence)"', '", clusters.keySet()) + "'");
            }
            return (StorageCluster)clusters.values().iterator().next();
        });
    }

    static String resolveBucket(StorageCluster cluster, Optional<String> documentType, List<String> bucketSpaces, Optional<String> bucketSpace) {
        return documentType.map(type -> cluster.bucketOf((String)type).orElseThrow(() -> new IllegalArgumentException("Document type '" + type + "' in cluster '" + cluster.name() + "' is not mapped to a known bucket space"))).or(() -> bucketSpace.map(space -> {
            if (!bucketSpaces.contains(space)) {
                throw new IllegalArgumentException("Bucket space '" + space + "' is not a known bucket space; expected one of " + String.join((CharSequence)", ", bucketSpaces));
            }
            return space;
        })).orElse(FixedBucketSpaces.defaultSpace());
    }

    static class Group {
        private final String value;
        private final String docIdPart;
        private final String selection;

        private Group(String value, String docIdPart, String selection) {
            Text.validateTextString((String)value).ifPresent(codePoint -> {
                throw new IllegalArgumentException(String.format("Illegal code point U%04X in group", codePoint));
            });
            this.value = value;
            this.docIdPart = docIdPart;
            this.selection = selection;
        }

        public static Group of(long value) {
            return new Group(Long.toString(value), "n=" + value, "id.user==" + value);
        }

        public static Group of(String value) {
            return new Group(value, "g=" + value, "id.group=='" + value.replaceAll("'", "\\\\'") + "'");
        }

        public String value() {
            return this.value;
        }

        public String docIdPart() {
            return this.docIdPart;
        }

        public String selection() {
            return this.selection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this.value.equals(group.value) && this.docIdPart.equals(group.docIdPart) && this.selection.equals(group.selection);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.docIdPart, this.selection);
        }

        public String toString() {
            return "Group{value='" + this.value + "', docIdPart='" + this.docIdPart + "', selection='" + this.selection + "'}";
        }
    }

    private static class DocumentPath {
        private final Path path;
        private final Optional<Group> group;

        DocumentPath(Path path) {
            this.path = Objects.requireNonNull(path);
            this.group = Optional.ofNullable(path.get("number")).map(integerParser::parse).map(Group::of).or(() -> Optional.ofNullable(path.get("group")).map(Group::of));
        }

        DocumentId id() {
            return new DocumentId("id:" + Objects.requireNonNull(this.path.get("namespace")) + ":" + Objects.requireNonNull(this.path.get("documentType")) + ":" + this.group.map(Group::docIdPart).orElse("") + ":" + Objects.requireNonNull(this.path.getRest()));
        }

        String rawPath() {
            return this.path.asString();
        }

        Optional<String> documentType() {
            return Optional.ofNullable(this.path.get("documentType"));
        }

        Optional<String> namespace() {
            return Optional.ofNullable(this.path.get("namespace"));
        }

        Optional<Group> group() {
            return this.group;
        }
    }

    static class StorageCluster {
        private final String name;
        private final Map<String, String> documentBuckets;

        StorageCluster(String name, Map<String, String> documentBuckets) {
            this.name = Objects.requireNonNull(name);
            this.documentBuckets = Map.copyOf(documentBuckets);
        }

        String name() {
            return this.name;
        }

        String route() {
            return "[Content:cluster=" + this.name() + "]";
        }

        Optional<String> bucketOf(String documentType) {
            return Optional.ofNullable(this.documentBuckets.get(documentType));
        }
    }

    private class MeasuringResponseHandler
    implements ResponseHandler {
        private final ResponseHandler delegate;
        private final DocumentOperationType type;
        private final Instant start;

        private MeasuringResponseHandler(ResponseHandler delegate, DocumentOperationType type, Instant start) {
            this.delegate = delegate;
            this.type = type;
            this.start = start;
        }

        public ContentChannel handleResponse(Response response) {
            switch (response.getStatus() / 100) {
                case 2: {
                    DocumentV1ApiHandler.this.metrics.reportSuccessful(this.type, this.start);
                    break;
                }
                case 4: {
                    DocumentV1ApiHandler.this.metrics.reportFailure(this.type, DocumentOperationStatus.REQUEST_ERROR);
                    break;
                }
                case 5: {
                    DocumentV1ApiHandler.this.metrics.reportFailure(this.type, DocumentOperationStatus.SERVER_ERROR);
                }
            }
            return this.delegate.handleResponse(response);
        }
    }

    @FunctionalInterface
    static interface Parser<T>
    extends Function<String, T> {
        default public T parse(String value) {
            try {
                return (T)this.apply(value);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Failed parsing '" + value + "': " + Exceptions.toMessageString((Throwable)e));
            }
        }
    }

    static interface SuccessCallback {
        public void onSuccess(Document var1, JsonResponse var2) throws IOException;
    }

    static class DocumentOperationParser {
        private final DocumentTypeManager manager;

        DocumentOperationParser(DocumentmanagerConfig config) {
            this.manager = new DocumentTypeManager(config);
        }

        DocumentPut parsePut(InputStream inputStream, String docId) {
            return (DocumentPut)this.parse(inputStream, docId, com.yahoo.document.json.DocumentOperationType.PUT);
        }

        DocumentUpdate parseUpdate(InputStream inputStream, String docId) {
            return (DocumentUpdate)this.parse(inputStream, docId, com.yahoo.document.json.DocumentOperationType.UPDATE);
        }

        private DocumentOperation parse(InputStream inputStream, String docId, com.yahoo.document.json.DocumentOperationType operation) {
            return new JsonReader(this.manager, inputStream, jsonFactory).readSingleDocument(operation, docId);
        }
    }

    static class ForwardingContentChannel
    implements ContentChannel {
        private final ReadableContentChannel delegate = new ReadableContentChannel();
        private final Consumer<InputStream> reader;

        public ForwardingContentChannel(Consumer<InputStream> reader) {
            this.reader = reader;
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            try {
                this.delegate.write(buf, logException);
                handler.completed();
            }
            catch (Exception e) {
                handler.failed((Throwable)e);
            }
        }

        public void close(CompletionHandler handler) {
            try {
                this.delegate.close(logException);
                this.reader.accept((InputStream)new UnsafeContentInputStream(this.delegate));
                handler.completed();
            }
            catch (Exception e) {
                handler.failed((Throwable)e);
            }
        }
    }

    private static abstract class Operation {
        private final Lock lock = new ReentrantLock();
        private final HttpRequest request;
        private final ResponseHandler handler;
        private Supplier<Boolean> operation;

        Operation(HttpRequest request, ResponseHandler handler) {
            this.request = request;
            this.handler = handler;
        }

        boolean dispatch() {
            if (this.request.isCancelled()) {
                return true;
            }
            if (!this.lock.tryLock()) {
                throw new IllegalStateException("Concurrent attempts at dispatch \u2014 this is a bug");
            }
            try {
                if (this.operation == null) {
                    this.operation = this.parse();
                }
                boolean bl = this.operation.get();
                return bl;
            }
            catch (IllegalArgumentException e) {
                DocumentV1ApiHandler.badRequest(this.request, e, this.handler);
            }
            catch (RuntimeException e) {
                DocumentV1ApiHandler.serverError(this.request, e, this.handler);
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }

        abstract Supplier<Boolean> parse();
    }

    private static class JsonResponse
    implements AutoCloseable {
        private final BufferedContentChannel buffer = new BufferedContentChannel();
        private final OutputStream out = new ContentChannelOutputStream((ContentChannel)this.buffer);
        private final JsonGenerator json = jsonFactory.createGenerator(this.out);
        private final ResponseHandler handler;
        private ContentChannel channel;

        private JsonResponse(ResponseHandler handler) throws IOException {
            this.handler = handler;
            this.json.writeStartObject();
        }

        static JsonResponse create(DocumentPath path, ResponseHandler handler) throws IOException {
            JsonResponse response = new JsonResponse(handler);
            response.writePathId(path.rawPath());
            response.writeDocId(path.id());
            return response;
        }

        static JsonResponse create(HttpRequest request, ResponseHandler handler) throws IOException {
            JsonResponse response = new JsonResponse(handler);
            response.writePathId(request.getUri().getRawPath());
            return response;
        }

        static JsonResponse create(HttpRequest request, String message, ResponseHandler handler) throws IOException {
            JsonResponse response = new JsonResponse(handler);
            response.writePathId(request.getUri().getRawPath());
            response.writeMessage(message);
            return response;
        }

        synchronized void commit(int status) throws IOException {
            Response response = new Response(status);
            response.headers().addAll(Map.of("Content-Type", List.of("application/json; charset=UTF-8")));
            try {
                this.channel = this.handler.handleResponse(response);
                this.buffer.connectTo(this.channel);
            }
            catch (RuntimeException e) {
                throw new IOException(e);
            }
        }

        synchronized void respond(int status) throws IOException {
            try (JsonResponse jsonResponse = this;){
                this.commit(status);
            }
        }

        @Override
        public synchronized void close() throws IOException {
            try {
                if (this.channel == null) {
                    log.log(Level.WARNING, "Close called before response was committed, in " + this.getClass().getName());
                    this.commit(500);
                }
                this.json.close();
                this.out.close();
            }
            finally {
                if (this.channel != null) {
                    this.channel.close(logException);
                }
            }
        }

        synchronized void writePathId(String path) throws IOException {
            this.json.writeStringField("pathId", path);
        }

        synchronized void writeMessage(String message) throws IOException {
            this.json.writeStringField("message", message);
        }

        synchronized void writeDocId(DocumentId id) throws IOException {
            this.json.writeStringField("id", id.toString());
        }

        synchronized void writeTrace(Trace trace) throws IOException {
            if (trace != null && !trace.getRoot().isEmpty()) {
                this.writeTrace(trace.getRoot());
            }
        }

        private void writeTrace(TraceNode node) throws IOException {
            if (node.hasNote()) {
                this.json.writeStringField("message", node.getNote());
            }
            if (!node.isLeaf()) {
                this.json.writeArrayFieldStart(node.isStrict() ? "trace" : "fork");
                for (int i = 0; i < node.getNumChildren(); ++i) {
                    this.json.writeStartObject();
                    this.writeTrace(node.getChild(i));
                    this.json.writeEndObject();
                }
                this.json.writeEndArray();
            }
        }

        synchronized void writeSingleDocument(Document document) throws IOException {
            new JsonWriter(this.json).writeFields(document);
        }

        synchronized void writeDocumentsArrayStart() throws IOException {
            this.json.writeArrayFieldStart("documents");
        }

        synchronized void writeDocumentValue(Document document) throws IOException {
            new JsonWriter(this.json).write(document);
        }

        synchronized void writeArrayEnd() throws IOException {
            this.json.writeEndArray();
        }

        synchronized void writeContinuation(String token) throws IOException {
            this.json.writeStringField(DocumentV1ApiHandler.CONTINUATION, token);
        }
    }

    @FunctionalInterface
    static interface Handler {
        public ContentChannel handle(HttpRequest var1, DocumentPath var2, ResponseHandler var3);
    }
}

