/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.jdisc.Metric;
import com.yahoo.messagebus.Message;
import com.yahoo.vespaxmlparser.FeedOperation;

class DocumentOperationMessageV3 {
    private final String operationId;
    private final Message message;

    private DocumentOperationMessageV3(String operationId, Message message) {
        this.operationId = operationId;
        this.message = message;
    }

    Message getMessage() {
        return this.message;
    }

    String getOperationId() {
        return this.operationId;
    }

    private static DocumentOperationMessageV3 newUpdateMessage(FeedOperation op, String operationId) {
        DocumentUpdate update = op.getDocumentUpdate();
        update.setCondition(op.getCondition());
        UpdateDocumentMessage msg = new UpdateDocumentMessage(update);
        String id = operationId == null ? update.getId().toString() : operationId;
        return new DocumentOperationMessageV3(id, (Message)msg);
    }

    static DocumentOperationMessageV3 newRemoveMessage(FeedOperation op, String operationId) {
        DocumentRemove remove = new DocumentRemove(op.getRemove());
        remove.setCondition(op.getCondition());
        RemoveDocumentMessage msg = new RemoveDocumentMessage(remove);
        String id = operationId == null ? remove.getId().toString() : operationId;
        return new DocumentOperationMessageV3(id, (Message)msg);
    }

    private static DocumentOperationMessageV3 newPutMessage(FeedOperation op, String operationId) {
        DocumentPut put = new DocumentPut(op.getDocument());
        put.setCondition(op.getCondition());
        PutDocumentMessage msg = new PutDocumentMessage(put);
        String id = operationId == null ? put.getId().toString() : operationId;
        return new DocumentOperationMessageV3(id, (Message)msg);
    }

    static DocumentOperationMessageV3 create(FeedOperation operation, String operationId, Metric metric) {
        switch (operation.getType()) {
            case DOCUMENT: {
                metric.add("httpapi_num_puts", (Number)1, null);
                return DocumentOperationMessageV3.newPutMessage(operation, operationId);
            }
            case REMOVE: {
                metric.add("httpapi_num_removes", (Number)1, null);
                return DocumentOperationMessageV3.newRemoveMessage(operation, operationId);
            }
            case UPDATE: {
                metric.add("httpapi_num_updates", (Number)1, null);
                return DocumentOperationMessageV3.newUpdateMessage(operation, operationId);
            }
        }
        return null;
    }
}

