/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.google.inject.Inject;
import com.yahoo.cloud.config.ClusterListConfig;
import com.yahoo.container.core.HandlerMetricContextUtil;
import com.yahoo.container.core.documentapi.VespaDocumentAccess;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.json.JsonReader;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.document.json.document.DocumentParser;
import com.yahoo.document.restapi.DocumentOperationExecutor;
import com.yahoo.document.restapi.DocumentOperationExecutorConfig;
import com.yahoo.document.restapi.DocumentOperationExecutorImpl;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.DocumentOperationParameters;
import com.yahoo.documentapi.metrics.DocumentApiMetrics;
import com.yahoo.documentapi.metrics.DocumentOperationStatus;
import com.yahoo.documentapi.metrics.DocumentOperationType;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ReadableContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.handler.UnsafeContentInputStream;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.restapi.Path;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.content.AllClustersBucketSpacesConfig;
import com.yahoo.yolean.Exceptions;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DocumentV1ApiHandler
extends AbstractRequestHandler {
    private static final Logger log = Logger.getLogger(DocumentV1ApiHandler.class.getName());
    private static final Parser<Integer> numberParser = Integer::parseInt;
    private static final Parser<Boolean> booleanParser = Boolean::parseBoolean;
    private static final CompletionHandler logException = new CompletionHandler(){

        public void completed() {
        }

        public void failed(Throwable t) {
            log.log(Level.FINE, () -> "Exception writing or closing response data: " + Exceptions.toMessageString((Throwable)t));
        }
    };
    private static final ContentChannel ignoredContent = new ContentChannel(){

        public void write(ByteBuffer buf, CompletionHandler handler) {
            handler.completed();
        }

        public void close(CompletionHandler handler) {
            handler.completed();
        }
    };
    private static final String CREATE = "create";
    private static final String CONDITION = "condition";
    private static final String ROUTE = "route";
    private static final String FIELD_SET = "fieldSet";
    private static final String SELECTION = "selection";
    private static final String CLUSTER = "cluster";
    private static final String CONTINUATION = "continuation";
    private static final String WANTED_DOCUMENT_COUNT = "wantedDocumentCount";
    private static final String CONCURRENCY = "concurrency";
    private static final String BUCKET_SPACE = "bucketSpace";
    private final Clock clock;
    private final Metric metric;
    private final DocumentApiMetrics metrics;
    private final DocumentOperationExecutor executor;
    private final DocumentOperationParser parser;
    private final Map<String, Map<HttpRequest.Method, Handler>> handlers;

    @Inject
    public DocumentV1ApiHandler(Metric metric, MetricReceiver metricReceiver, VespaDocumentAccess documentAccess, DocumentmanagerConfig documentManagerConfig, ClusterListConfig clusterListConfig, AllClustersBucketSpacesConfig bucketSpacesConfig, DocumentOperationExecutorConfig executorConfig) {
        this(Clock.systemUTC(), new DocumentOperationExecutorImpl(clusterListConfig, bucketSpacesConfig, executorConfig, (DocumentAccess)documentAccess, Clock.systemUTC()), new DocumentOperationParser(documentManagerConfig), metric, metricReceiver);
    }

    DocumentV1ApiHandler(Clock clock, DocumentOperationExecutor executor, DocumentOperationParser parser, Metric metric, MetricReceiver metricReceiver) {
        this.clock = clock;
        this.executor = executor;
        this.parser = parser;
        this.metric = metric;
        this.metrics = new DocumentApiMetrics(metricReceiver, "documentV1");
        this.handlers = this.defineApi();
    }

    public ContentChannel handleRequest(Request rawRequest, ResponseHandler rawResponseHandler) {
        HandlerMetricContextUtil.onHandle((Request)rawRequest, (Metric)this.metric, ((Object)((Object)this)).getClass());
        ResponseHandler responseHandler = response -> {
            HandlerMetricContextUtil.onHandled((Request)rawRequest, (Metric)this.metric, ((Object)((Object)this)).getClass());
            return rawResponseHandler.handleResponse(response);
        };
        HttpRequest request = (HttpRequest)rawRequest;
        try {
            Path requestPath = new Path(request.getUri());
            for (String path : this.handlers.keySet()) {
                if (!requestPath.matches(path)) continue;
                Map<HttpRequest.Method, Handler> methods = this.handlers.get(path);
                if (methods.containsKey(request.getMethod())) {
                    return methods.get(request.getMethod()).handle(request, new DocumentPath(requestPath), responseHandler);
                }
                if (request.getMethod() == HttpRequest.Method.OPTIONS) {
                    return DocumentV1ApiHandler.options(methods.keySet(), responseHandler);
                }
                return DocumentV1ApiHandler.methodNotAllowed(request, methods.keySet(), responseHandler);
            }
            return DocumentV1ApiHandler.notFound(request, this.handlers.keySet(), responseHandler);
        }
        catch (IllegalArgumentException e) {
            return DocumentV1ApiHandler.badRequest(request, e, responseHandler);
        }
        catch (LinkageError | RuntimeException e) {
            return DocumentV1ApiHandler.serverError(request, e, responseHandler);
        }
    }

    public void destroy() {
        this.executor.shutdown();
    }

    private Map<String, Map<HttpRequest.Method, Handler>> defineApi() {
        LinkedHashMap<String, Map<HttpRequest.Method, Handler>> handlers = new LinkedHashMap<String, Map<HttpRequest.Method, Handler>>();
        handlers.put("/document/v1/", Map.of(HttpRequest.Method.GET, this::getRoot));
        handlers.put("/document/v1/{namespace}/{documentType}/docid/", Map.of(HttpRequest.Method.GET, this::getDocumentType));
        handlers.put("/document/v1/{namespace}/{documentType}/group/{group}/", Map.of(HttpRequest.Method.GET, this::getDocumentType));
        handlers.put("/document/v1/{namespace}/{documentType}/number/{number}/", Map.of(HttpRequest.Method.GET, this::getDocumentType));
        handlers.put("/document/v1/{namespace}/{documentType}/docid/{docid}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        handlers.put("/document/v1/{namespace}/{documentType}/group/{group}/{docid}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        handlers.put("/document/v1/{namespace}/{documentType}/number/{number}/{docid}", Map.of(HttpRequest.Method.GET, this::getDocument, HttpRequest.Method.POST, this::postDocument, HttpRequest.Method.PUT, this::putDocument, HttpRequest.Method.DELETE, this::deleteDocument));
        return Collections.unmodifiableMap(handlers);
    }

    private ContentChannel getRoot(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        Cursor root = DocumentV1ApiHandler.responseRoot(request);
        this.executor.visit(this.parseOptions(request, path).build(), DocumentV1ApiHandler.visitorContext(request, root, root.setArray("documents"), handler));
        return ignoredContent;
    }

    private ContentChannel getDocumentType(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        Cursor root = DocumentV1ApiHandler.responseRoot(request);
        DocumentOperationExecutor.VisitorOptions.Builder options = this.parseOptions(request, path);
        options = options.documentType(path.documentType());
        options = options.namespace(path.namespace());
        options = path.group().map(options::group).orElse(options);
        this.executor.visit(options.build(), DocumentV1ApiHandler.visitorContext(request, root, root.setArray("documents"), handler));
        return ignoredContent;
    }

    private static DocumentOperationExecutor.VisitOperationsContext visitorContext(HttpRequest request, Cursor root, Cursor documents, ResponseHandler handler) {
        Object monitor = new Object();
        return new DocumentOperationExecutor.VisitOperationsContext((type, message) -> {
            Object object = monitor;
            synchronized (object) {
                DocumentV1ApiHandler.handleError(request, type, message, root, handler);
            }
        }, token -> {
            token.ifPresent(value -> root.setString(CONTINUATION, value));
            Object object = monitor;
            synchronized (object) {
                DocumentV1ApiHandler.respond((Inspector)root, handler);
            }
        }, document -> {
            try {
                Object object = monitor;
                synchronized (object) {
                    SlimeUtils.copyObject((Inspector)SlimeUtils.jsonToSlime((byte[])JsonWriter.toByteArray((Document)document)).get(), (Cursor)documents.addObject());
                }
            }
            catch (LinkageError | RuntimeException e) {
                log.log(Level.WARNING, "Exception serializing document in document/v1 visit response", e);
            }
        });
    }

    private ContentChannel getDocument(HttpRequest request, DocumentPath path, ResponseHandler handler) {
        DocumentId id = path.id();
        DocumentOperationParameters parameters = DocumentOperationParameters.parameters();
        parameters = DocumentV1ApiHandler.getProperty(request, CLUSTER).map(this.executor::routeToCluster).map(arg_0 -> ((DocumentOperationParameters)parameters).withRoute(arg_0)).orElse(parameters);
        parameters = DocumentV1ApiHandler.getProperty(request, FIELD_SET).map(arg_0 -> ((DocumentOperationParameters)parameters).withFieldSet(arg_0)).orElse(parameters);
        this.executor.get(id, parameters, new DocumentOperationExecutor.OperationContext((type, message) -> DocumentV1ApiHandler.handleError(request, type, message, DocumentV1ApiHandler.responseRoot(request, id), handler), document -> {
            try {
                Cursor root = DocumentV1ApiHandler.responseRoot(request, id);
                document.map(JsonWriter::toByteArray).map(SlimeUtils::jsonToSlime).ifPresent(doc -> SlimeUtils.copyObject((Inspector)doc.get().field("fields"), (Cursor)root.setObject("fields")));
                DocumentV1ApiHandler.respond(document.isPresent() ? 200 : 404, (Inspector)root, handler);
            }
            catch (Exception e) {
                DocumentV1ApiHandler.serverError(request, new RuntimeException(e), handler);
            }
        }));
        return ignoredContent;
    }

    private ContentChannel postDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        DocumentId id = path.id();
        MeasuringResponseHandler handler = new MeasuringResponseHandler(rawHandler, DocumentOperationType.PUT, this.clock.instant());
        return new ForwardingContentChannel(in -> {
            try {
                DocumentPut put = this.parser.parsePut((InputStream)in, id.toString());
                DocumentV1ApiHandler.getProperty(request, CONDITION).map(TestAndSetCondition::new).ifPresent(arg_0 -> ((DocumentPut)put).setCondition(arg_0));
                this.executor.put(put, DocumentV1ApiHandler.getProperty(request, ROUTE).map(arg_0 -> ((DocumentOperationParameters)DocumentOperationParameters.parameters()).withRoute(arg_0)).orElse(DocumentOperationParameters.parameters()), new DocumentOperationExecutor.OperationContext((type, message) -> DocumentV1ApiHandler.handleError(request, type, message, DocumentV1ApiHandler.responseRoot(request, id), handler), __ -> DocumentV1ApiHandler.respond((Inspector)DocumentV1ApiHandler.responseRoot(request, id), handler)));
            }
            catch (IllegalArgumentException e) {
                DocumentV1ApiHandler.badRequest(request, e, handler);
            }
            catch (LinkageError | RuntimeException e) {
                DocumentV1ApiHandler.serverError(request, e, handler);
            }
        });
    }

    private ContentChannel putDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        DocumentId id = path.id();
        MeasuringResponseHandler handler = new MeasuringResponseHandler(rawHandler, DocumentOperationType.UPDATE, this.clock.instant());
        return new ForwardingContentChannel(in -> {
            try {
                DocumentUpdate update = this.parser.parseUpdate((InputStream)in, id.toString());
                DocumentV1ApiHandler.getProperty(request, CONDITION).map(TestAndSetCondition::new).ifPresent(arg_0 -> ((DocumentUpdate)update).setCondition(arg_0));
                DocumentV1ApiHandler.getProperty(request, CREATE).map(booleanParser::parse).ifPresent(arg_0 -> ((DocumentUpdate)update).setCreateIfNonExistent(arg_0));
                this.executor.update(update, DocumentV1ApiHandler.getProperty(request, ROUTE).map(arg_0 -> ((DocumentOperationParameters)DocumentOperationParameters.parameters()).withRoute(arg_0)).orElse(DocumentOperationParameters.parameters()), new DocumentOperationExecutor.OperationContext((type, message) -> DocumentV1ApiHandler.handleError(request, type, message, DocumentV1ApiHandler.responseRoot(request, id), handler), __ -> DocumentV1ApiHandler.respond((Inspector)DocumentV1ApiHandler.responseRoot(request, id), handler)));
            }
            catch (IllegalArgumentException e) {
                DocumentV1ApiHandler.badRequest(request, e, handler);
            }
            catch (LinkageError | RuntimeException e) {
                DocumentV1ApiHandler.serverError(request, e, handler);
            }
        });
    }

    private ContentChannel deleteDocument(HttpRequest request, DocumentPath path, ResponseHandler rawHandler) {
        DocumentId id = path.id();
        MeasuringResponseHandler handler = new MeasuringResponseHandler(rawHandler, DocumentOperationType.REMOVE, this.clock.instant());
        this.executor.remove(id, DocumentV1ApiHandler.getProperty(request, ROUTE).map(arg_0 -> ((DocumentOperationParameters)DocumentOperationParameters.parameters()).withRoute(arg_0)).orElse(DocumentOperationParameters.parameters()), new DocumentOperationExecutor.OperationContext((type, message) -> DocumentV1ApiHandler.handleError(request, type, message, DocumentV1ApiHandler.responseRoot(request, id), handler), __ -> DocumentV1ApiHandler.respond((Inspector)DocumentV1ApiHandler.responseRoot(request, id), handler)));
        return ignoredContent;
    }

    private static void handleError(HttpRequest request, DocumentOperationExecutor.ErrorType type, String message, Cursor root, ResponseHandler handler) {
        switch (type) {
            case BAD_REQUEST: {
                DocumentV1ApiHandler.badRequest(request, message, root, handler);
                break;
            }
            case NOT_FOUND: {
                DocumentV1ApiHandler.notFound(request, message, root, handler);
                break;
            }
            case PRECONDITION_FAILED: {
                DocumentV1ApiHandler.preconditionFailed(request, message, root, handler);
                break;
            }
            case OVERLOAD: {
                DocumentV1ApiHandler.overload(request, message, root, handler);
                break;
            }
            case TIMEOUT: {
                DocumentV1ApiHandler.timeout(request, message, root, handler);
                break;
            }
            default: {
                log.log(Level.WARNING, "Unexpected error type '" + type + "'");
            }
            case ERROR: {
                DocumentV1ApiHandler.serverError(request, message, root, handler);
            }
        }
    }

    private static Cursor responseRoot(HttpRequest request) {
        Cursor root = new Slime().setObject();
        root.setString("pathId", request.getUri().getRawPath());
        return root;
    }

    private static Cursor responseRoot(HttpRequest request, DocumentId id) {
        Cursor root = DocumentV1ApiHandler.responseRoot(request);
        root.setString("id", id.toString());
        return root;
    }

    private static ContentChannel options(Collection<HttpRequest.Method> methods, ResponseHandler handler) {
        Response response = new Response(204);
        response.headers().add("Allow", methods.stream().sorted().map(Enum::name).collect(Collectors.joining(",")));
        handler.handleResponse(response).close(logException);
        return ignoredContent;
    }

    private static ContentChannel badRequest(HttpRequest request, IllegalArgumentException e, ResponseHandler handler) {
        return DocumentV1ApiHandler.badRequest(request, Exceptions.toMessageString((Throwable)e), DocumentV1ApiHandler.responseRoot(request), handler);
    }

    private static ContentChannel badRequest(HttpRequest request, String message, Cursor root, ResponseHandler handler) {
        log.log(Level.FINE, () -> "Bad request for " + request.getMethod() + " at " + request.getUri().getRawPath() + ": " + message);
        root.setString("message", message);
        return DocumentV1ApiHandler.respond(400, (Inspector)root, handler);
    }

    private static ContentChannel notFound(HttpRequest request, Collection<String> paths, ResponseHandler handler) {
        return DocumentV1ApiHandler.notFound(request, "Nothing at '" + request.getUri().getRawPath() + "'. Available paths are:\n" + String.join((CharSequence)"\n", paths), DocumentV1ApiHandler.responseRoot(request), handler);
    }

    private static ContentChannel notFound(HttpRequest request, String message, Cursor root, ResponseHandler handler) {
        root.setString("message", message);
        return DocumentV1ApiHandler.respond(404, (Inspector)root, handler);
    }

    private static ContentChannel methodNotAllowed(HttpRequest request, Collection<HttpRequest.Method> methods, ResponseHandler handler) {
        Cursor root = DocumentV1ApiHandler.responseRoot(request);
        root.setString("message", "'" + request.getMethod() + "' not allowed at '" + request.getUri().getRawPath() + "'. Allowed methods are: " + methods.stream().sorted().map(Enum::name).collect(Collectors.joining(", ")));
        return DocumentV1ApiHandler.respond(405, (Inspector)root, handler);
    }

    private static ContentChannel preconditionFailed(HttpRequest request, String message, Cursor root, ResponseHandler handler) {
        root.setString("message", message);
        return DocumentV1ApiHandler.respond(412, (Inspector)root, handler);
    }

    private static ContentChannel overload(HttpRequest request, String message, Cursor root, ResponseHandler handler) {
        log.log(Level.FINE, () -> "Overload handling request " + request.getMethod() + " " + request.getUri().getRawPath() + ": " + message);
        root.setString("message", message);
        return DocumentV1ApiHandler.respond(429, (Inspector)root, handler);
    }

    private static ContentChannel serverError(HttpRequest request, Throwable t, ResponseHandler handler) {
        log.log(Level.WARNING, "Uncaught exception handling request " + request.getMethod() + " " + request.getUri().getRawPath() + ":", t);
        Cursor root = DocumentV1ApiHandler.responseRoot(request);
        root.setString("message", Exceptions.toMessageString((Throwable)t));
        return DocumentV1ApiHandler.respond(500, (Inspector)root, handler);
    }

    private static ContentChannel serverError(HttpRequest request, String message, Cursor root, ResponseHandler handler) {
        log.log(Level.WARNING, "Uncaught exception handling request " + request.getMethod() + " " + request.getUri().getRawPath() + ": " + message);
        root.setString("message", message);
        return DocumentV1ApiHandler.respond(500, (Inspector)root, handler);
    }

    private static ContentChannel timeout(HttpRequest request, String message, Cursor root, ResponseHandler handler) {
        log.log(Level.FINE, () -> "Timeout handling request " + request.getMethod() + " " + request.getUri().getRawPath() + ": " + message);
        root.setString("message", message);
        return DocumentV1ApiHandler.respond(504, (Inspector)root, handler);
    }

    private static ContentChannel respond(Inspector root, ResponseHandler handler) {
        return DocumentV1ApiHandler.respond(200, root, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContentChannel respond(int status, Inspector root, ResponseHandler handler) {
        Response response = new Response(status);
        response.headers().put("Content-Type", "application/json; charset=UTF-8");
        ContentChannel out = null;
        try {
            out = handler.handleResponse(response);
            out.write(ByteBuffer.wrap((byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Inspector)root))), logException);
        }
        catch (Exception e) {
            log.log(Level.FINE, () -> "Problems writing data to jDisc content channel: " + Exceptions.toMessageString((Throwable)e));
        }
        finally {
            if (out != null) {
                try {
                    out.close(logException);
                }
                catch (Exception e) {
                    log.log(Level.FINE, () -> "Problems closing jDisc content channel: " + Exceptions.toMessageString((Throwable)e));
                }
            }
        }
        return ignoredContent;
    }

    private DocumentOperationExecutor.VisitorOptions.Builder parseOptions(HttpRequest request, DocumentPath path) {
        DocumentOperationExecutor.VisitorOptions.Builder options = DocumentOperationExecutor.VisitorOptions.builder();
        DocumentV1ApiHandler.getProperty(request, SELECTION).ifPresent(options::selection);
        DocumentV1ApiHandler.getProperty(request, CONTINUATION).ifPresent(options::continuation);
        DocumentV1ApiHandler.getProperty(request, FIELD_SET).ifPresent(options::fieldSet);
        DocumentV1ApiHandler.getProperty(request, CLUSTER).ifPresent(options::cluster);
        DocumentV1ApiHandler.getProperty(request, BUCKET_SPACE).ifPresent(options::bucketSpace);
        DocumentV1ApiHandler.getProperty(request, WANTED_DOCUMENT_COUNT, numberParser).ifPresent(count -> options.wantedDocumentCount(Math.min(1024, count)));
        DocumentV1ApiHandler.getProperty(request, CONCURRENCY, numberParser).ifPresent(concurrency -> options.concurrency(Math.min(100, concurrency)));
        return options;
    }

    private static Optional<String> getProperty(HttpRequest request, String name) {
        List values = (List)request.parameters().get(name);
        if (values != null && values.size() != 0) {
            return Optional.ofNullable((String)values.get(values.size() - 1));
        }
        return Optional.empty();
    }

    private static <T> Optional<T> getProperty(HttpRequest request, String name, Parser<T> parser) {
        return DocumentV1ApiHandler.getProperty(request, name).map(parser::parse);
    }

    private class MeasuringResponseHandler
    implements ResponseHandler {
        private final ResponseHandler delegate;
        private final DocumentOperationType type;
        private final Instant start;

        private MeasuringResponseHandler(ResponseHandler delegate, DocumentOperationType type, Instant start) {
            this.delegate = delegate;
            this.type = type;
            this.start = start;
        }

        public ContentChannel handleResponse(Response response) {
            switch (response.getStatus() / 100) {
                case 2: {
                    DocumentV1ApiHandler.this.metrics.reportSuccessful(this.type, this.start);
                    break;
                }
                case 4: {
                    DocumentV1ApiHandler.this.metrics.reportFailure(this.type, DocumentOperationStatus.REQUEST_ERROR);
                    break;
                }
                case 5: {
                    DocumentV1ApiHandler.this.metrics.reportFailure(this.type, DocumentOperationStatus.SERVER_ERROR);
                }
            }
            return this.delegate.handleResponse(response);
        }
    }

    static class DocumentOperationParser {
        private static final JsonFactory jsonFactory = new JsonFactory();
        private final DocumentTypeManager manager;

        DocumentOperationParser(DocumentmanagerConfig config) {
            this.manager = new DocumentTypeManager(config);
        }

        DocumentPut parsePut(InputStream inputStream, String docId) {
            return (DocumentPut)this.parse(inputStream, docId, DocumentParser.SupportedOperation.PUT);
        }

        DocumentUpdate parseUpdate(InputStream inputStream, String docId) {
            return (DocumentUpdate)this.parse(inputStream, docId, DocumentParser.SupportedOperation.UPDATE);
        }

        private DocumentOperation parse(InputStream inputStream, String docId, DocumentParser.SupportedOperation operation) {
            return new JsonReader(this.manager, inputStream, jsonFactory).readSingleDocument(operation, docId);
        }
    }

    static class ForwardingContentChannel
    implements ContentChannel {
        private final ReadableContentChannel delegate = new ReadableContentChannel();
        private final Consumer<InputStream> reader;

        public ForwardingContentChannel(Consumer<InputStream> reader) {
            this.reader = reader;
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            try {
                this.delegate.write(buf, logException);
                handler.completed();
            }
            catch (Exception e) {
                handler.failed((Throwable)e);
            }
        }

        public void close(CompletionHandler handler) {
            try {
                this.delegate.close(logException);
                try (UnsafeContentInputStream in = new UnsafeContentInputStream(this.delegate);){
                    this.reader.accept((InputStream)in);
                }
                handler.completed();
            }
            catch (Exception e) {
                handler.failed((Throwable)e);
            }
        }
    }

    @FunctionalInterface
    static interface Handler {
        public ContentChannel handle(HttpRequest var1, DocumentPath var2, ResponseHandler var3);
    }

    @FunctionalInterface
    static interface Parser<T>
    extends Function<String, T> {
        default public T parse(String value) {
            try {
                return (T)this.apply(value);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Failed parsing '" + value + "': " + Exceptions.toMessageString((Throwable)e));
            }
        }
    }

    static class DocumentPath {
        private final Path path;
        private final Optional<DocumentOperationExecutor.Group> group;

        DocumentPath(Path path) {
            this.path = Objects.requireNonNull(path);
            this.group = Optional.ofNullable(path.get("number")).map(numberParser::parse).map(DocumentOperationExecutor.Group::of).or(() -> Optional.ofNullable(path.get("group")).map(DocumentOperationExecutor.Group::of));
        }

        DocumentId id() {
            return new DocumentId("id:" + Objects.requireNonNull(this.path.get("namespace")) + ":" + Objects.requireNonNull(this.path.get("documentType")) + ":" + this.group.map(DocumentOperationExecutor.Group::docIdPart).orElse("") + ":" + Objects.requireNonNull(this.path.get("docid")));
        }

        String documentType() {
            return Objects.requireNonNull(this.path.get("documentType"));
        }

        String namespace() {
            return Objects.requireNonNull(this.path.get("namespace"));
        }

        Optional<DocumentOperationExecutor.Group> group() {
            return this.group;
        }
    }
}

