/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.documentapi.DocumentOperationParameters;
import com.yahoo.text.Text;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface DocumentOperationExecutor {
    default public void shutdown() {
    }

    public void get(DocumentId var1, DocumentOperationParameters var2, OperationContext var3);

    public void put(DocumentPut var1, DocumentOperationParameters var2, OperationContext var3);

    public void update(DocumentUpdate var1, DocumentOperationParameters var2, OperationContext var3);

    public void remove(DocumentId var1, DocumentOperationParameters var2, OperationContext var3);

    public void visit(VisitorOptions var1, VisitOperationsContext var2);

    public String routeToCluster(String var1);

    public static class Group {
        private final String value;
        private final String docIdPart;
        private final String selection;

        private Group(String value, String docIdPart, String selection) {
            Text.validateTextString((String)value).ifPresent(codePoint -> {
                throw new IllegalArgumentException(String.format("Illegal code point U%04X in group", codePoint));
            });
            this.value = value;
            this.docIdPart = docIdPart;
            this.selection = selection;
        }

        public static Group of(long value) {
            return new Group(Long.toString(value), "n=" + value, "id.user==" + value);
        }

        public static Group of(String value) {
            return new Group(value, "g=" + value, "id.group=='" + value.replaceAll("'", "\\'") + "'");
        }

        public String value() {
            return this.value;
        }

        public String docIdPart() {
            return this.docIdPart;
        }

        public String selection() {
            return this.selection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this.value.equals(group.value) && this.docIdPart.equals(group.docIdPart) && this.selection.equals(group.selection);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.docIdPart, this.selection);
        }

        public String toString() {
            return "Group{value='" + this.value + "', docIdPart='" + this.docIdPart + "', selection='" + this.selection + "'}";
        }
    }

    public static class VisitorOptions {
        final Optional<String> cluster;
        final Optional<String> namespace;
        final Optional<String> documentType;
        final Optional<Group> group;
        final Optional<String> selection;
        final Optional<String> fieldSet;
        final Optional<String> continuation;
        final Optional<String> bucketSpace;
        final Optional<Integer> wantedDocumentCount;
        final Optional<Integer> concurrency;

        private VisitorOptions(Optional<String> cluster, Optional<String> documentType, Optional<String> namespace, Optional<Group> group, Optional<String> selection, Optional<String> fieldSet, Optional<String> continuation, Optional<String> bucketSpace, Optional<Integer> wantedDocumentCount, Optional<Integer> concurrency) {
            this.cluster = cluster;
            this.namespace = namespace;
            this.documentType = documentType;
            this.group = group;
            this.selection = selection;
            this.fieldSet = fieldSet;
            this.continuation = continuation;
            this.bucketSpace = bucketSpace;
            this.wantedDocumentCount = wantedDocumentCount;
            this.concurrency = concurrency;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VisitorOptions that = (VisitorOptions)o;
            return this.cluster.equals(that.cluster) && this.namespace.equals(that.namespace) && this.documentType.equals(that.documentType) && this.group.equals(that.group) && this.selection.equals(that.selection) && this.fieldSet.equals(that.fieldSet) && this.continuation.equals(that.continuation) && this.bucketSpace.equals(that.bucketSpace) && this.wantedDocumentCount.equals(that.wantedDocumentCount) && this.concurrency.equals(that.concurrency);
        }

        public int hashCode() {
            return Objects.hash(this.cluster, this.namespace, this.documentType, this.group, this.selection, this.fieldSet, this.continuation, this.bucketSpace, this.wantedDocumentCount, this.concurrency);
        }

        public String toString() {
            return "VisitorOptions{cluster=" + this.cluster + ", namespace=" + this.namespace + ", documentType=" + this.documentType + ", group=" + this.group + ", selection=" + this.selection + ", fieldSet=" + this.fieldSet + ", continuation=" + this.continuation + ", bucketSpace=" + this.bucketSpace + ", wantedDocumentCount=" + this.wantedDocumentCount + ", concurrency=" + this.concurrency + "}";
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String cluster;
            private String documentType;
            private String namespace;
            private Group group;
            private String selection;
            private String fieldSet;
            private String continuation;
            private String bucketSpace;
            private Integer wantedDocumentCount;
            private Integer concurrency;

            public Builder cluster(String cluster) {
                this.cluster = cluster;
                return this;
            }

            public Builder documentType(String documentType) {
                this.documentType = documentType;
                return this;
            }

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder group(Group group) {
                this.group = group;
                return this;
            }

            public Builder selection(String selection) {
                this.selection = selection;
                return this;
            }

            public Builder fieldSet(String fieldSet) {
                this.fieldSet = fieldSet;
                return this;
            }

            public Builder continuation(String continuation) {
                this.continuation = continuation;
                return this;
            }

            public Builder bucketSpace(String bucketSpace) {
                this.bucketSpace = bucketSpace;
                return this;
            }

            public Builder wantedDocumentCount(Integer wantedDocumentCount) {
                this.wantedDocumentCount = wantedDocumentCount;
                return this;
            }

            public Builder concurrency(Integer concurrency) {
                this.concurrency = concurrency;
                return this;
            }

            public VisitorOptions build() {
                return new VisitorOptions(Optional.ofNullable(this.cluster), Optional.ofNullable(this.documentType), Optional.ofNullable(this.namespace), Optional.ofNullable(this.group), Optional.ofNullable(this.selection), Optional.ofNullable(this.fieldSet), Optional.ofNullable(this.continuation), Optional.ofNullable(this.bucketSpace), Optional.ofNullable(this.wantedDocumentCount), Optional.ofNullable(this.concurrency));
            }
        }
    }

    public static class OperationContext
    extends Context<Optional<Document>> {
        public OperationContext(BiConsumer<ErrorType, String> onError, Consumer<Optional<Document>> onSuccess) {
            super(onError, onSuccess);
        }
    }

    public static class VisitOperationsContext
    extends Context<Optional<String>> {
        private final Consumer<Document> onDocument;

        public VisitOperationsContext(BiConsumer<ErrorType, String> onError, Consumer<Optional<String>> onSuccess, Consumer<Document> onDocument) {
            super(onError, onSuccess);
            this.onDocument = onDocument;
        }

        public void document(Document document) {
            if (!this.handled()) {
                this.onDocument.accept(document);
            }
        }
    }

    public static class Context<T> {
        private final AtomicBoolean handled = new AtomicBoolean();
        private final BiConsumer<ErrorType, String> onError;
        private final Consumer<T> onSuccess;

        Context(BiConsumer<ErrorType, String> onError, Consumer<T> onSuccess) {
            this.onError = onError;
            this.onSuccess = onSuccess;
        }

        public void error(ErrorType type, String message) {
            if (!this.handled.getAndSet(true)) {
                this.onError.accept(type, message);
            }
        }

        public void success(T result) {
            if (!this.handled.getAndSet(true)) {
                this.onSuccess.accept(result);
            }
        }

        public boolean handled() {
            return this.handled.get();
        }
    }

    public static enum ErrorType {
        OVERLOAD,
        NOT_FOUND,
        PRECONDITION_FAILED,
        BAD_REQUEST,
        TIMEOUT,
        ERROR;

    }
}

