/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.documentapi.metrics.DocumentApiMetrics;
import com.yahoo.documentapi.metrics.DocumentOperationStatus;
import com.yahoo.documentapi.metrics.DocumentOperationType;
import com.yahoo.jdisc.Metric;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Trace;
import com.yahoo.vespa.http.client.core.ErrorCode;
import com.yahoo.vespa.http.client.core.OperationStatus;
import com.yahoo.vespa.http.server.ReplyContext;
import java.util.Set;
import java.util.logging.Logger;

public class FeedReplyReader
implements ReplyHandler {
    private static final Logger log = Logger.getLogger(FeedReplyReader.class.getName());
    private final Metric metric;
    private final DocumentApiMetrics metricsHelper;

    public FeedReplyReader(Metric metric, DocumentApiMetrics metricsHelper) {
        this.metric = metric;
        this.metricsHelper = metricsHelper;
    }

    public void handleReply(Reply reply) {
        Object o = reply.getContext();
        if (!(o instanceof ReplyContext)) {
            return;
        }
        ReplyContext context = (ReplyContext)o;
        double latencyInSeconds = (double)(System.currentTimeMillis() - context.creationTime) / 1000.0;
        this.metric.set("httpapi_latency", (Number)latencyInSeconds, null);
        if (reply.hasErrors()) {
            Set errorCodes = reply.getErrorCodes();
            this.metricsHelper.reportFailure(DocumentOperationType.fromMessage(reply.getMessage()), DocumentOperationStatus.fromMessageBusErrorCodes(errorCodes));
            this.metric.add("httpapi_failed", (Number)1, null);
            this.enqueue(context, reply.getError(0).getMessage(), ErrorCode.ERROR, reply.getError(0).getCode() == 251013, reply.getTrace());
        } else {
            this.metricsHelper.reportSuccessful(DocumentOperationType.fromMessage(reply.getMessage()), latencyInSeconds);
            this.metric.add("httpapi_succeeded", (Number)1, null);
            this.enqueue(context, "Document processed.", ErrorCode.OK, false, reply.getTrace());
        }
    }

    private void enqueue(ReplyContext context, String message, ErrorCode status, boolean isConditionNotMet, Trace trace) {
        try {
            String traceMessage = trace != null && trace.getLevel() > 0 ? trace.toString() : "";
            context.feedReplies.put(new OperationStatus(message, context.docId, status, isConditionNotMet, traceMessage));
        }
        catch (InterruptedException e) {
            log.log(LogLevel.WARNING, "Interrupted while enqueueing result from putting document with id: " + context.docId);
            Thread.currentThread().interrupt();
        }
    }
}

