/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.json.JsonFeedReader;
import com.yahoo.vespa.http.client.config.FeedParams;
import com.yahoo.vespaxmlparser.FeedReader;
import com.yahoo.vespaxmlparser.VespaXMLFeedReader;
import java.io.InputStream;

public class FeedReaderFactory {
    public FeedReader createReader(InputStream inputStream, DocumentTypeManager docTypeManager, FeedParams.DataFormat dataFormat) {
        switch (dataFormat) {
            case XML_UTF8: {
                try {
                    return new VespaXMLFeedReader(inputStream, docTypeManager);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create VespaXMLFeedReader", e);
                }
            }
            case JSON_UTF8: {
                return new JsonFeedReader(inputStream, docTypeManager);
            }
        }
        throw new IllegalStateException("Can not create feed reader for format: " + dataFormat);
    }
}

