/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.container.jdisc.messagebus.SessionCache;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.documentapi.metrics.DocumentApiMetrics;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.ReferencedResource;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.shared.SharedSourceSession;
import com.yahoo.vespa.http.server.ClientFeederV3;
import com.yahoo.vespa.http.server.ErrorHttpResponse;
import com.yahoo.vespa.http.server.FeedReaderFactory;
import com.yahoo.vespa.http.server.FeedReplyReader;
import com.yahoo.vespa.http.server.UnknownClientException;
import com.yahoo.yolean.Exceptions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class FeedHandlerV3
extends LoggingRequestHandler {
    private DocumentTypeManager docTypeManager;
    private final Map<String, ClientFeederV3> clientFeederByClientId = new HashMap<String, ClientFeederV3>();
    private final ScheduledThreadPoolExecutor cron;
    private final SessionCache sessionCache;
    protected final ReplyHandler feedReplyHandler;
    private final Metric metric;
    private final Object monitor = new Object();
    private final AtomicInteger threadsAvailableForFeeding;
    private static final Logger log = Logger.getLogger(FeedHandlerV3.class.getName());

    public FeedHandlerV3(LoggingRequestHandler.Context parentCtx, DocumentmanagerConfig documentManagerConfig, SessionCache sessionCache, ThreadpoolConfig threadpoolConfig, DocumentApiMetrics metricsHelper) {
        super(parentCtx);
        this.docTypeManager = new DocumentTypeManager(documentManagerConfig);
        this.sessionCache = sessionCache;
        this.feedReplyHandler = new FeedReplyReader(parentCtx.getMetric(), metricsHelper);
        this.cron = new ScheduledThreadPoolExecutor(1, ThreadFactoryFactory.getThreadFactory((String)"feedhandlerv3.cron"));
        this.cron.scheduleWithFixedDelay(this::removeOldClients, 16L, 11L, TimeUnit.MINUTES);
        this.metric = parentCtx.getMetric();
        if (threadpoolConfig != null) {
            this.threadsAvailableForFeeding = new AtomicInteger(Math.max((int)(0.4 * (double)threadpoolConfig.maxthreads()), 1));
        } else {
            log.warning("No config for threadpool, using 200 for max blocking threads for feeding.");
            this.threadsAvailableForFeeding = new AtomicInteger(200);
        }
    }

    public void injectDocumentManangerForTests(DocumentTypeManager docTypeManager) {
        this.docTypeManager = docTypeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse handle(HttpRequest request) {
        Object msg;
        ClientFeederV3 clientFeederV3;
        String clientId = this.clientId(request);
        Object object = this.monitor;
        synchronized (object) {
            if (!this.clientFeederByClientId.containsKey(clientId)) {
                SourceSessionParams sourceSessionParams = this.sourceSessionParams(request);
                this.clientFeederByClientId.put(clientId, new ClientFeederV3(this.retainSource(this.sessionCache, sourceSessionParams), new FeedReaderFactory(), this.docTypeManager, clientId, this.metric, this.feedReplyHandler, this.threadsAvailableForFeeding));
            }
            clientFeederV3 = this.clientFeederByClientId.get(clientId);
        }
        try {
            return clientFeederV3.handleRequest(request);
        }
        catch (UnknownClientException uce) {
            msg = Exceptions.toMessageString((Throwable)uce);
            log.log(LogLevel.WARNING, (String)msg);
            return new ErrorHttpResponse(400, (String)msg);
        }
        catch (Exception e) {
            msg = "Could not initialize document parsing: " + Exceptions.toMessageString((Throwable)e);
            log.log(LogLevel.WARNING, (String)msg);
            return new ErrorHttpResponse(500, (String)msg);
        }
    }

    protected ReferencedResource<SharedSourceSession> retainSource(SessionCache sessionCache, SourceSessionParams params) {
        return sessionCache.retainSource(params);
    }

    protected void destroy() {
        Thread destroyer = new Thread(() -> {
            super.destroy();
            this.cron.shutdown();
            Object object = this.monitor;
            synchronized (object) {
                for (ClientFeederV3 client : this.clientFeederByClientId.values()) {
                    client.kill();
                }
                this.clientFeederByClientId.clear();
            }
        });
        destroyer.setDaemon(true);
        destroyer.start();
    }

    private String clientId(HttpRequest request) {
        String clientDictatedId = request.getHeader("X-Yahoo-Client-Id");
        if (clientDictatedId == null || clientDictatedId.isEmpty()) {
            throw new IllegalArgumentException("Did not get any CLIENT_ID header (X-Yahoo-Client-Id)");
        }
        return clientDictatedId;
    }

    private SourceSessionParams sourceSessionParams(HttpRequest request) {
        SourceSessionParams params = new SourceSessionParams();
        String timeout = request.getHeader("X-Yahoo-Feed-Timeout");
        if (timeout != null) {
            try {
                params.setTimeout(Double.parseDouble(timeout));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldClients() {
        Object object = this.monitor;
        synchronized (object) {
            Iterator<Map.Entry<String, ClientFeederV3>> iterator = this.clientFeederByClientId.entrySet().iterator();
            while (iterator.hasNext()) {
                ClientFeederV3 client = iterator.next().getValue();
                if (!client.timedOut()) continue;
                client.kill();
                iterator.remove();
            }
        }
    }
}

