/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedhandler;

import com.google.inject.Inject;
import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.cloud.config.ClusterListConfig;
import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.protect.Error;
import com.yahoo.document.DocumentId;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.feedapi.FeedContext;
import com.yahoo.feedapi.MessageProcessor;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SharedSender;
import com.yahoo.feedapi.SingleSender;
import com.yahoo.feedhandler.FeedResponse;
import com.yahoo.feedhandler.MetricResponse;
import com.yahoo.feedhandler.VespaFeedHandlerBase;
import com.yahoo.jdisc.Metric;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespaclient.config.FeederConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.concurrent.Executor;

@Deprecated
public class VespaFeedHandlerRemove
extends VespaFeedHandlerBase {
    @Inject
    public VespaFeedHandlerRemove(FeederConfig feederConfig, LoadTypeConfig loadTypeConfig, DocumentmanagerConfig documentmanagerConfig, SlobroksConfig slobroksConfig, ClusterListConfig clusterListConfig, Executor executor, Metric metric) throws Exception {
        super(feederConfig, loadTypeConfig, documentmanagerConfig, slobroksConfig, clusterListConfig, executor, metric);
    }

    VespaFeedHandlerRemove(FeedContext context, Executor executor) throws Exception {
        super(context, executor);
    }

    public HttpResponse handle(HttpRequest request) {
        if (request.getProperty("status") != null) {
            return new MetricResponse(this.context.getMetrics().getMetricSet());
        }
        MessagePropertyProcessor.PropertySetter properties = this.getPropertyProcessor().buildPropertySetter(request);
        String route = properties.getRoute().toString();
        FeedResponse response = new FeedResponse(new RouteMetricSet(route, null));
        SingleSender sender = new SingleSender((SharedSender.ResultCallback)response, this.getSharedSender(route));
        sender.addMessageProcessor((MessageProcessor)properties);
        response.setAbortOnFeedError(properties.getAbortOnFeedError());
        if (request.hasProperty("id")) {
            sender.remove(new DocumentId(request.getProperty("id")));
        } else if (request.hasProperty("id[0]")) {
            int index = 0;
            while (request.hasProperty("id[" + index + "]")) {
                sender.remove(new DocumentId(request.getProperty("id[" + index + "]")));
                ++index;
            }
        }
        if (request.getData() != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getRequestInputStream(request), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sender.remove(new DocumentId(line));
                }
            }
            catch (Exception e) {
                response.addError(e.getClass() + ": " + e.getCause());
            }
        }
        sender.done();
        long millis = this.getTimeoutMillis(request);
        boolean completed = sender.waitForPending(millis);
        if (!completed) {
            response.addError(Error.TIMEOUT, "Timed out after " + millis + " ms waiting for responses");
        }
        return response;
    }
}

