/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi;

import com.yahoo.document.restapi.RestApiException;
import com.yahoo.document.restapi.RestUri;
import com.yahoo.vespaxmlparser.VespaXMLFeedReader;
import java.util.Optional;

public interface OperationHandler {
    public VisitResult visit(RestUri var1, String var2, VisitOptions var3) throws RestApiException;

    public void put(RestUri var1, VespaXMLFeedReader.Operation var2, Optional<String> var3) throws RestApiException;

    public void update(RestUri var1, VespaXMLFeedReader.Operation var2, Optional<String> var3) throws RestApiException;

    public void delete(RestUri var1, String var2, Optional<String> var3) throws RestApiException;

    public Optional<String> get(RestUri var1) throws RestApiException;

    default public Optional<String> get(RestUri restUri, Optional<String> fieldSet) throws RestApiException {
        return this.get(restUri);
    }

    default public void shutdown() {
    }

    public static class VisitOptions {
        public final Optional<String> cluster;
        public final Optional<String> continuation;
        public final Optional<Integer> wantedDocumentCount;
        public final Optional<String> fieldSet;
        public final Optional<Integer> concurrency;
        public final Optional<String> bucketSpace;

        @Deprecated
        public VisitOptions(Optional<String> cluster, Optional<String> continuation, Optional<Integer> wantedDocumentCount) {
            this.cluster = cluster;
            this.continuation = continuation;
            this.wantedDocumentCount = wantedDocumentCount;
            this.fieldSet = Optional.empty();
            this.concurrency = Optional.empty();
            this.bucketSpace = Optional.empty();
        }

        private VisitOptions(Builder builder) {
            this.cluster = Optional.ofNullable(builder.cluster);
            this.continuation = Optional.ofNullable(builder.continuation);
            this.wantedDocumentCount = Optional.ofNullable(builder.wantedDocumentCount);
            this.fieldSet = Optional.ofNullable(builder.fieldSet);
            this.concurrency = Optional.ofNullable(builder.concurrency);
            this.bucketSpace = Optional.ofNullable(builder.bucketSpace);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            String cluster;
            String continuation;
            Integer wantedDocumentCount;
            String fieldSet;
            Integer concurrency;
            String bucketSpace;

            public Builder cluster(String cluster) {
                this.cluster = cluster;
                return this;
            }

            public Builder continuation(String continuation) {
                this.continuation = continuation;
                return this;
            }

            public Builder wantedDocumentCount(Integer count) {
                this.wantedDocumentCount = count;
                return this;
            }

            public Builder fieldSet(String fieldSet) {
                this.fieldSet = fieldSet;
                return this;
            }

            public Builder concurrency(Integer concurrency) {
                this.concurrency = concurrency;
                return this;
            }

            public Builder bucketSpace(String bucketSpace) {
                this.bucketSpace = bucketSpace;
                return this;
            }

            public VisitOptions build() {
                return new VisitOptions(this);
            }
        }
    }

    public static class VisitResult {
        public final Optional<String> token;
        public final String documentsAsJsonList;

        public VisitResult(Optional<String> token, String documentsAsJsonList) {
            this.token = token;
            this.documentsAsJsonList = documentsAsJsonList;
        }
    }
}

