/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.storage.searcher;

import com.yahoo.cloud.config.ClusterListConfig;
import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.documentapi.DumpVisitorDataHandler;
import com.yahoo.documentapi.ProgressToken;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.feedapi.FeedContext;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.jdisc.Metric;
import com.yahoo.messagebus.StaticThrottlePolicy;
import com.yahoo.messagebus.ThrottlePolicy;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.storage.searcher.ContinuationHit;
import com.yahoo.storage.searcher.DocumentHit;
import com.yahoo.storage.searcher.DocumentRemoveHit;
import com.yahoo.storage.searcher.GetSearcher;
import com.yahoo.vdslib.VisitorOrdering;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespaclient.ClusterDef;
import com.yahoo.vespaclient.config.FeederConfig;

public class VisitSearcher
extends Searcher {
    public static final String VISITOR_CONTINUATION_TOKEN_FIELDNAME = "visitorContinuationToken";
    FeedContext context;

    public VisitSearcher(FeederConfig feederConfig, LoadTypeConfig loadTypeConfig, DocumentmanagerConfig documentmanagerConfig, SlobroksConfig slobroksConfig, ClusterListConfig clusterListConfig, Metric metric) throws Exception {
        this(FeedContext.getInstance((FeederConfig)feederConfig, (LoadTypeConfig)loadTypeConfig, (DocumentmanagerConfig)documentmanagerConfig, (SlobroksConfig)slobroksConfig, (ClusterListConfig)clusterListConfig, (Metric)metric));
    }

    VisitSearcher(FeedContext context) throws Exception {
        this.context = context;
    }

    public VisitorParameters getVisitorParameters(Query query, Result result) throws Exception {
        String continuation;
        String ordering;
        String documentSelection = query.properties().getString("visit.selection");
        if (documentSelection == null) {
            documentSelection = "";
        }
        VisitorParameters params = new VisitorParameters(documentSelection);
        params.setMaxBucketsPerVisitor(query.properties().getInteger("visit.maxBucketsPerVisitor", Integer.valueOf(1)).intValue());
        params.setMaxPending(query.properties().getInteger("visit.maxPendingMessagesPerVisitor", Integer.valueOf(32)).intValue());
        params.setMaxFirstPassHits((long)query.properties().getInteger("visit.approxMaxDocs", Integer.valueOf(1)).intValue());
        params.setMaxTotalHits((long)query.properties().getInteger("visit.approxMaxDocs", Integer.valueOf(1)).intValue());
        params.setThrottlePolicy((ThrottlePolicy)new StaticThrottlePolicy().setMaxPendingCount(query.properties().getInteger("visit.maxPendingVisitors", Integer.valueOf(1)).intValue()));
        params.setToTimestamp(query.properties().getLong("visit.toTimestamp", Long.valueOf(0L)).longValue());
        params.setFromTimestamp(query.properties().getLong("visit.fromTimestamp", Long.valueOf(0L)).longValue());
        String pri = query.properties().getString("visit.priority");
        if (pri != null) {
            params.setPriority(DocumentProtocol.Priority.valueOf((String)pri));
        }
        if (query.properties().getBoolean("visit.visitInconsistentBuckets")) {
            params.visitInconsistentBuckets(true);
        }
        if (!"ascending".equalsIgnoreCase(ordering = query.properties().getString("visit.order"))) {
            params.setVisitorOrdering(VisitorOrdering.ASCENDING);
        } else {
            params.setVisitorOrdering(VisitorOrdering.DESCENDING);
        }
        String remoteCluster = query.properties().getString("visit.dataHandler");
        if (remoteCluster != null) {
            params.setRemoteDataHandler(remoteCluster);
        } else {
            params.setLocalDataHandler((VisitorDataHandler)new HitDataHandler(result, query.properties().getBoolean("populatehitfields", false)));
        }
        String fieldSet = query.properties().getString("visit.fieldSet");
        if (fieldSet != null) {
            params.fieldSet(fieldSet);
        }
        if ((continuation = query.properties().getString("visit.continuation")) != null) {
            params.setResumeToken(ContinuationHit.getToken(continuation));
        }
        params.setVisitRemoves(query.properties().getBoolean("visit.visitRemoves"));
        MessagePropertyProcessor.PropertySetter propertySetter = this.context.getPropertyProcessor().buildPropertySetter(query.getHttpRequest());
        propertySetter.process(params);
        if (this.context.getClusterList().getStorageClusters().size() == 0) {
            throw new IllegalArgumentException("No content clusters have been defined");
        }
        String route = query.properties().getString("visit.cluster");
        ClusterDef found = null;
        if (route != null) {
            String names = "";
            for (ClusterDef c : this.context.getClusterList().getStorageClusters()) {
                if (c.getName().equals(route)) {
                    found = c;
                }
                if (!names.isEmpty()) {
                    names = names + ", ";
                }
                names = names + c.getName();
            }
            if (found == null) {
                throw new IllegalArgumentException("Your vespa cluster contains the storage clusters " + names + ", not " + route + ". Please select a valid vespa cluster.");
            }
        } else if (this.context.getClusterList().getStorageClusters().size() == 1) {
            found = (ClusterDef)this.context.getClusterList().getStorageClusters().get(0);
        } else {
            throw new IllegalArgumentException("Multiple content clusters are defined, select one using the \"visit.cluster\" option");
        }
        params.setRoute("[Storage:cluster=" + found.getName() + ";clusterconfigid=" + found.getConfigId() + "]");
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result search(Query query, Execution execution) {
        VisitorParameters parameters;
        Result result = execution.search(query);
        try {
            parameters = this.getVisitorParameters(query, result);
        }
        catch (Exception e) {
            return new Result(query, ErrorMessage.createBadRequest((String)("Illegal parameters: " + e.toString())));
        }
        if (parameters != null) {
            VisitorSession session = this.context.getSessionFactory().createVisitorSession(parameters);
            try {
                if (!session.waitUntilDone(query.getTimeout())) {
                    Result result2 = new Result(query, ErrorMessage.createTimeout((String)"Visitor timed out"));
                    return result2;
                }
                ProgressToken token = session.getProgress();
                if (!token.isFinished()) {
                    ContinuationHit continuation = new ContinuationHit(token);
                    result.hits().setField(VISITOR_CONTINUATION_TOKEN_FIELDNAME, (Object)continuation.getValue());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                session.destroy();
            }
        }
        GetSearcher.setOutputFormat(query, result);
        query.setHits(result.hits().size());
        return result;
    }

    class HitDataHandler
    extends DumpVisitorDataHandler {
        private final Result result;
        private final boolean populateHits;
        private final Object monitor = new Object();

        HitDataHandler(Result result, boolean populateHits) {
            this.result = result;
            this.populateHits = populateHits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDocument(Document document, long l) {
            DocumentHit hit = new DocumentHit(document, 0);
            if (this.populateHits) {
                hit.populateHitFields();
            }
            Object object = this.monitor;
            synchronized (object) {
                this.result.hits().add((Hit)hit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRemove(DocumentId documentId) {
            DocumentRemoveHit hit = new DocumentRemoveHit(documentId);
            Object object = this.monitor;
            synchronized (object) {
                this.result.hits().add((Hit)hit);
            }
        }
    }
}

