/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.collections.Tuple2;
import com.yahoo.container.jdisc.messagebus.SessionCache;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.documentapi.metrics.DocumentOperationType;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.ReferencedResource;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Result;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.routing.ErrorDirective;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.HopDirective;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.shared.SharedSourceSession;
import com.yahoo.text.Utf8String;
import com.yahoo.vespa.http.client.core.Encoder;
import com.yahoo.vespa.http.client.core.ErrorCode;
import com.yahoo.vespa.http.client.core.OperationStatus;
import com.yahoo.vespa.http.server.ClientState;
import com.yahoo.vespa.http.server.FeedHandler;
import com.yahoo.vespa.http.server.FeedReaderFactory;
import com.yahoo.vespa.http.server.FeederSettings;
import com.yahoo.vespa.http.server.ReplyContext;
import com.yahoo.vespa.http.server.UnknownClientException;
import com.yahoo.vespa.http.server.util.ByteLimitedInputStream;
import com.yahoo.vespaxmlparser.FeedReader;
import com.yahoo.vespaxmlparser.VespaXMLFeedReader;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Feeder
implements Runnable {
    protected static final Logger log = Logger.getLogger(Feeder.class.getName());
    final InputStream requestInputStream;
    final DocumentTypeManager docTypeManager;
    final BlockingQueue<OperationStatus> operations;
    final BlockingQueue<OperationStatus> feedReplies;
    int numPending;
    final FeederSettings settings;
    final String clientId;
    final ReferencedResource<SharedSourceSession> sourceSession;
    final FeedHandler handler;
    final Metric metric;
    final Metric.Context metricContext;
    private long prevOpsPerSecTime;
    private double operationsForOpsPerSec;
    private final ReplyHandler feedReplyHandler;
    protected static final String EOF = "End of stream";
    protected final boolean sessionIdWasGeneratedJustNow;
    private final CountDownLatch requestReceived = new CountDownLatch(1);
    private final FeedReaderFactory feedReaderFactory;

    public Feeder(InputStream requestInputStream, FeedReaderFactory feedReaderFactory, DocumentTypeManager docTypeManager, BlockingQueue<OperationStatus> operations, ClientState storedState, FeederSettings settings, String clientId, boolean sessionIdWasGeneratedJustNow, SourceSessionParams sessionParams, SessionCache sessionCache, FeedHandler handler, Metric metric, ReplyHandler feedReplyHandler, String localHostname) throws Exception {
        this.feedReaderFactory = feedReaderFactory;
        if (storedState == null) {
            if (!sessionIdWasGeneratedJustNow) {
                this.examineClientId(clientId, localHostname);
            }
            this.numPending = 0;
            this.feedReplies = new LinkedBlockingQueue<OperationStatus>();
            this.sourceSession = this.retainSession(sessionParams, sessionCache);
            this.metricContext = Feeder.createClientMetricContext(metric, clientId);
            this.prevOpsPerSecTime = System.currentTimeMillis();
            this.operationsForOpsPerSec = 0.0;
        } else {
            this.numPending = storedState.pending;
            this.feedReplies = storedState.feedReplies;
            this.sourceSession = storedState.sourceSession;
            this.metricContext = storedState.metricContext;
            this.prevOpsPerSecTime = storedState.prevOpsPerSecTime;
            this.operationsForOpsPerSec = storedState.operationsForOpsPerSec;
        }
        this.clientId = clientId;
        this.sessionIdWasGeneratedJustNow = sessionIdWasGeneratedJustNow;
        this.requestInputStream = requestInputStream;
        this.docTypeManager = docTypeManager;
        this.operations = operations;
        this.settings = settings;
        this.handler = handler;
        this.metric = metric;
        this.feedReplyHandler = feedReplyHandler;
    }

    protected void examineClientId(String clientId, String localHostname) {
        if (!clientId.contains("#")) {
            throw new UnknownClientException("Got request from client with id '" + clientId + "', but found no session for this client. This is expected during upgrades of gateways and infrastructure nodes.");
        }
        int hashPos = clientId.indexOf("#");
        String supposedHostname = clientId.substring(hashPos + 1, clientId.length());
        if (supposedHostname.isEmpty()) {
            throw new UnknownClientException("Got request from client with id '" + clientId + "', but found no session for this client. Possible session timeout due to inactivity, server restart or reconfig, or bad VIP usage. This is expected during upgrades of gateways and infrastructure nodes.");
        }
        if (!supposedHostname.equals(localHostname)) {
            throw new UnknownClientException("Got request from client with id '" + clientId + "', but found no session for this client. Session was originally established towards host " + supposedHostname + ", but our hostname is " + localHostname + ". If using VIP rotation, this could be due to a session was rotated from one server to another. Configure VIP with persistence=enabled. This is expected during upgrades of gateways and infrastructure nodes.");
        }
        log.log((Level)LogLevel.DEBUG, "Client '" + clientId + "' reconnected after session inactivity, or server restart or reconfig. Re-establishing session.");
    }

    private static Metric.Context createClientMetricContext(Metric metric, String clientId) {
        return null;
    }

    protected ReferencedResource<SharedSourceSession> retainSession(SourceSessionParams sessionParams, SessionCache sessionCache) {
        return sessionCache.retainSource(sessionParams);
    }

    @Override
    public void run() {
        try {
            if (this.handshake()) {
                return;
            }
            this.flushResponseQueue();
            this.feed();
            this.requestReceived.countDown();
            this.drain();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, "Unhandled exception while feeding: " + Exceptions.toMessageString((Throwable)e), e);
        }
        catch (Throwable e) {
            log.log(LogLevel.WARNING, "Unhandled error while feeding: " + Exceptions.toMessageString((Throwable)e), e);
            throw e;
        }
        finally {
            this.requestReceived.countDown();
            this.putClient();
            try {
                this.enqueue("-", "-", ErrorCode.END_OF_FEED, false, null);
            }
            catch (InterruptedException e) {}
        }
    }

    protected boolean handshake() throws IOException {
        if (this.sessionIdWasGeneratedJustNow) {
            if (log.isLoggable((Level)LogLevel.DEBUG)) {
                log.log((Level)LogLevel.DEBUG, "Handshake completed for client " + this.clientId + ".");
            }
            this.requestInputStream.close();
            return true;
        }
        return false;
    }

    void feed() throws InterruptedException {
        block11: {
            Result result;
            Tuple2<String, Message> msg;
            while (true) {
                String operationId;
                try {
                    operationId = this.getNextOperationId();
                }
                catch (IOException ioe) {
                    if (!log.isLoggable((Level)LogLevel.DEBUG)) break block11;
                    log.log((Level)LogLevel.DEBUG, Exceptions.toMessageString((Throwable)ioe), ioe);
                    break block11;
                }
                if (operationId == EOF) break block11;
                try {
                    msg = this.getNextMessage(operationId);
                    this.setRoute(msg);
                }
                catch (Exception e) {
                    if (log.isLoggable((Level)LogLevel.DEBUG)) {
                        log.log((Level)LogLevel.DEBUG, Exceptions.toMessageString((Throwable)e), e);
                    }
                    if (operationId == null) break block11;
                    msg = this.newErrorMessage(operationId, e);
                }
                if (msg == null) break block11;
                this.setMessageParameters(msg);
                while (true) {
                    try {
                        ((Message)msg.second).pushHandler(this.feedReplyHandler);
                        result = this.settings.denyIfBusy ? ((SharedSourceSession)this.sourceSession.getResource()).sendMessage((Message)msg.second) : ((SharedSourceSession)this.sourceSession.getResource()).sendMessageBlocking((Message)msg.second);
                    }
                    catch (RuntimeException e) {
                        this.enqueue((String)msg.first, Exceptions.toMessageString((Throwable)e), ErrorCode.ERROR, false, (Message)msg.second);
                        return;
                    }
                    if (result.isAccepted() || result.getError().getCode() != 100001 || this.settings.denyIfBusy) break;
                    Thread.sleep(100L);
                }
                if (!result.isAccepted()) break;
                ++this.numPending;
                this.updateMetrics((Message)msg.second);
                this.updateOpsPerSec();
                this.log(LogLevel.DEBUG, "Sent message successfully, document id: ", msg.first);
            }
            if (!result.getError().isFatal()) {
                this.enqueue((String)msg.first, result.getError().getMessage(), ErrorCode.TRANSIENT_ERROR, false, (Message)msg.second);
            } else {
                boolean isConditionNotMet = result.getError().getCode() == 251013;
                this.enqueue((String)msg.first, result.getError().getMessage(), ErrorCode.ERROR, isConditionNotMet, (Message)msg.second);
            }
        }
    }

    private Tuple2<String, Message> newErrorMessage(String operationId, Exception e) {
        FeedErrorMessage m = new FeedErrorMessage(operationId);
        Tuple2 msg = new Tuple2((Object)operationId, (Object)m);
        Hop hop = new Hop();
        hop.addDirective((HopDirective)new ErrorDirective(Exceptions.toMessageString((Throwable)e)));
        Route route = new Route();
        route.addHop(hop);
        m.setRoute(route);
        return msg;
    }

    private void updateMetrics(Message m) {
        this.metric.set("httpapi_pending", (Number)((SharedSourceSession)this.sourceSession.getResource()).session().getPendingCount(), null);
        this.metric.add("httpapi_num_operations", (Number)1, this.metricContext);
        if (m instanceof PutDocumentMessage) {
            this.metric.add("httpapi_num_puts", (Number)1, this.metricContext);
        } else if (m instanceof RemoveDocumentMessage) {
            this.metric.add("httpapi_num_removes", (Number)1, this.metricContext);
        } else if (m instanceof UpdateDocumentMessage) {
            this.metric.add("httpapi_num_updates", (Number)1, this.metricContext);
        }
    }

    private void updateOpsPerSec() {
        long now = System.currentTimeMillis();
        if (now - this.prevOpsPerSecTime >= 1000L) {
            double ms = now - this.prevOpsPerSecTime;
            double opsPerSec = this.operationsForOpsPerSec / (ms / 1000.0);
            this.metric.set("httpapi_ops_per_sec", (Number)opsPerSec, this.metricContext);
            this.operationsForOpsPerSec = 1.0;
            this.prevOpsPerSecTime = now;
        } else {
            this.operationsForOpsPerSec += 1.0;
        }
    }

    private Tuple2<String, Message> getNextMessage(String operationId) throws Exception {
        Tuple2<String, Message> msg;
        VespaXMLFeedReader.Operation op = new VespaXMLFeedReader.Operation();
        this.getNextOperation(op);
        switch (op.getType()) {
            case DOCUMENT: {
                msg = this.newPutMessage(op, operationId);
                break;
            }
            case REMOVE: {
                msg = this.newRemoveMessage(op, operationId);
                break;
            }
            case UPDATE: {
                msg = this.newUpdateMessage(op, operationId);
                break;
            }
            default: {
                return null;
            }
        }
        this.log(LogLevel.DEBUG, "Successfully deserialized document id: ", msg.first);
        return msg;
    }

    private void setMessageParameters(Tuple2<String, Message> msg) {
        ((Message)msg.second).setContext((Object)new ReplyContext((String)msg.first, this.feedReplies, DocumentOperationType.fromMessage((Message)msg.second)));
        if (this.settings.traceLevel != null) {
            ((Message)msg.second).getTrace().setLevel(this.settings.traceLevel.intValue());
        }
        if (this.settings.priority != null) {
            try {
                DocumentProtocol.Priority priority = DocumentProtocol.Priority.valueOf((String)this.settings.priority);
                if (msg.second instanceof DocumentMessage) {
                    ((DocumentMessage)msg.second).setPriority(priority);
                }
            }
            catch (IllegalArgumentException i) {
                log.severe(i.getMessage());
            }
        }
    }

    private void setRoute(Tuple2<String, Message> msg) {
        if (this.settings.route != null) {
            ((Message)msg.second).setRoute(this.settings.route);
        }
    }

    protected void getNextOperation(VespaXMLFeedReader.Operation op) throws Exception {
        int length = this.readByteLength();
        try (ByteLimitedInputStream limitedInputStream = new ByteLimitedInputStream(this.requestInputStream, length);){
            FeedReader reader = this.feedReaderFactory.createReader(limitedInputStream, this.docTypeManager, this.settings.dataFormat);
            reader.read(op);
        }
    }

    protected String getNextOperationId() throws IOException {
        return this.readOperationId();
    }

    private String readOperationId() throws IOException {
        int c;
        StringBuilder idBuf = new StringBuilder(100);
        while ((c = this.requestInputStream.read()) != -1 && c != 32) {
            idBuf.append((char)c);
        }
        if (idBuf.length() == 0) {
            return EOF;
        }
        return Encoder.decode((String)idBuf.toString(), (StringBuilder)new StringBuilder(idBuf.length())).toString();
    }

    private int readByteLength() throws IOException {
        int c;
        StringBuilder lenBuf = new StringBuilder(8);
        while ((c = this.requestInputStream.read()) != -1 && c != 10) {
            lenBuf.append((char)c);
        }
        if (lenBuf.length() == 0) {
            throw new IllegalStateException("Operation length missing.");
        }
        return Integer.valueOf(lenBuf.toString(), 16);
    }

    protected final void log(LogLevel level, Object ... msgParts) {
        if (!log.isLoggable((Level)level)) {
            return;
        }
        StringBuilder s = new StringBuilder();
        for (Object part : msgParts) {
            s.append(part.toString());
        }
        log.log((Level)level, s.toString());
    }

    private Tuple2<String, Message> newUpdateMessage(VespaXMLFeedReader.Operation op, String operationId) {
        DocumentUpdate update = op.getDocumentUpdate();
        update.setCondition(op.getCondition());
        UpdateDocumentMessage msg = new UpdateDocumentMessage(update);
        String id = operationId == null ? update.getId().toString() : operationId;
        return new Tuple2((Object)id, (Object)msg);
    }

    private Tuple2<String, Message> newRemoveMessage(VespaXMLFeedReader.Operation op, String operationId) {
        DocumentRemove remove = new DocumentRemove(op.getRemove());
        remove.setCondition(op.getCondition());
        RemoveDocumentMessage msg = new RemoveDocumentMessage(remove);
        String id = operationId == null ? remove.getId().toString() : operationId;
        return new Tuple2((Object)id, (Object)msg);
    }

    private Tuple2<String, Message> newPutMessage(VespaXMLFeedReader.Operation op, String operationId) {
        DocumentPut put = new DocumentPut(op.getDocument());
        put.setCondition(op.getCondition());
        PutDocumentMessage msg = new PutDocumentMessage(put);
        String id = operationId == null ? put.getId().toString() : operationId;
        return new Tuple2((Object)id, (Object)msg);
    }

    void flushResponseQueue() throws InterruptedException {
        OperationStatus status = (OperationStatus)this.feedReplies.poll();
        while (status != null) {
            this.decreasePending(status);
            status = (OperationStatus)this.feedReplies.poll();
        }
    }

    void putClient() {
        this.handler.putClient(this.clientId, new ClientState(this.numPending, this.feedReplies, this.sourceSession, this.metricContext, this.prevOpsPerSecTime, this.operationsForOpsPerSec));
    }

    void drain() throws InterruptedException {
        if (this.settings.drain) {
            while (this.numPending > 0) {
                OperationStatus o = this.feedReplies.take();
                this.decreasePending(o);
            }
        }
    }

    private void decreasePending(OperationStatus o) throws InterruptedException {
        this.operations.put(o);
        --this.numPending;
    }

    private void enqueue(String id, String message, ErrorCode code, boolean isConditionalNotMet, Message msg) throws InterruptedException {
        String traceMessage = msg != null && msg.getTrace() != null && msg.getTrace().getLevel() > 0 ? msg.getTrace().toString() : "";
        this.operations.put(new OperationStatus(message, id, code, isConditionalNotMet, traceMessage));
    }

    public void waitForRequestReceived() throws InterruptedException {
        this.requestReceived.await(1L, TimeUnit.HOURS);
    }

    public class FeedErrorMessage
    extends Message {
        private long sequenceId;

        private FeedErrorMessage(String operationId) {
            try {
                DocumentId id = new DocumentId(operationId);
                this.sequenceId = Arrays.hashCode(id.getGlobalId());
            }
            catch (Exception e) {
                this.sequenceId = 0L;
            }
        }

        public Utf8String getProtocol() {
            return new Utf8String("vespa-feed-handler-internal-bogus-protocol");
        }

        public int getType() {
            return 1234;
        }

        public boolean hasSequenceId() {
            return true;
        }

        public long getSequenceId() {
            return this.sequenceId;
        }
    }
}

