/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.Inject;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.json.SingleDocumentParser;
import com.yahoo.document.restapi.OperationHandler;
import com.yahoo.document.restapi.OperationHandlerImpl;
import com.yahoo.document.restapi.Response;
import com.yahoo.document.restapi.RestApiException;
import com.yahoo.document.restapi.RestUri;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespaxmlparser.VespaXMLFeedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public class RestApi
extends LoggingRequestHandler {
    private static final String CREATE_PARAMETER_NAME = "create";
    private static final String CONDITION_PARAMETER_NAME = "condition";
    private static final String ROUTE_PARAMETER_NAME = "route";
    private static final String DOCUMENTS = "documents";
    private static final String FIELDS = "fields";
    private static final String DOC_ID_NAME = "id";
    private static final String PATH_NAME = "pathId";
    private static final String SELECTION = "selection";
    private static final String CLUSTER = "cluster";
    private static final String CONTINUATION = "continuation";
    private static final String WANTED_DOCUMENT_COUNT = "wantedDocumentCount";
    private static final String APPLICATION_JSON = "application/json";
    private final OperationHandler operationHandler;
    private SingleDocumentParser singleDocumentParser;
    private final ObjectMapper mapper = new ObjectMapper();
    private final AtomicInteger threadsAvailableForApi;

    @Inject
    public RestApi(Executor executor, AccessLog accessLog, DocumentmanagerConfig documentManagerConfig, LoadTypeConfig loadTypeConfig, ThreadpoolConfig threadpoolConfig, MetricReceiver metricReceiver) {
        super(executor, accessLog);
        MessageBusParams params = new MessageBusParams(new LoadTypeSet(loadTypeConfig));
        params.setDocumentmanagerConfig(documentManagerConfig);
        this.operationHandler = new OperationHandlerImpl((DocumentAccess)new MessageBusDocumentAccess(params), metricReceiver);
        this.singleDocumentParser = new SingleDocumentParser(new DocumentTypeManager(documentManagerConfig));
        if (threadpoolConfig != null) {
            this.threadsAvailableForApi = new AtomicInteger(Math.max((int)(0.4 * (double)threadpoolConfig.maxthreads()), 1));
        } else {
            this.log.warning("No config for threadpool, using 200 for max blocking threads for document rest API.");
            this.threadsAvailableForApi = new AtomicInteger(200);
        }
    }

    public RestApi(Executor executor, AccessLog accessLog, OperationHandler operationHandler, int threadsAvailable) {
        super(executor, accessLog);
        this.operationHandler = operationHandler;
        this.threadsAvailableForApi = new AtomicInteger(threadsAvailable);
    }

    public void destroy() {
        this.operationHandler.shutdown();
    }

    protected void setDocTypeManagerForTests(DocumentTypeManager docTypeManager) {
        this.singleDocumentParser = new SingleDocumentParser(docTypeManager);
    }

    private static Optional<String> requestProperty(String parameter, HttpRequest request) {
        String property = request.getProperty(parameter);
        if (property != null && !property.isEmpty()) {
            return Optional.of(property);
        }
        return Optional.empty();
    }

    private static boolean parseBooleanStrict(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Value not convertible to bool: '%s'", value));
    }

    private static Optional<Boolean> parseBoolean(String parameter, HttpRequest request) {
        Optional<String> property = RestApi.requestProperty(parameter, request);
        return property.map(RestApi::parseBooleanStrict);
    }

    private static Optional<Integer> parseInteger(String parameter, HttpRequest request) throws NumberFormatException {
        Optional<String> property = RestApi.requestProperty(parameter, request);
        return property.map(Integer::parseInt);
    }

    public HttpResponse handle(HttpRequest request) {
        try {
            if (this.threadsAvailableForApi.decrementAndGet() < 1) {
                Response response = Response.createErrorResponse(429, "Too many parallel requests, consider using http-vespa-java-client. Please try again later.", RestUri.apiErrorCodes.TOO_MANY_PARALLEL_REQUESTS);
                return response;
            }
            HttpResponse httpResponse = this.handleInternal(request);
            return httpResponse;
        }
        finally {
            this.threadsAvailableForApi.incrementAndGet();
        }
    }

    protected HttpResponse handleInternal(HttpRequest request) {
        Optional<Boolean> create;
        RestUri restUri;
        try {
            restUri = new RestUri(request.getUri());
        }
        catch (RestApiException e) {
            return e.getResponse();
        }
        catch (Exception e2) {
            return Response.createErrorResponse(500, "Exception while parsing URI: " + e2.getMessage(), RestUri.apiErrorCodes.URL_PARSING);
        }
        try {
            create = RestApi.parseBoolean(CREATE_PARAMETER_NAME, request);
        }
        catch (IllegalArgumentException e) {
            return Response.createErrorResponse(403, "Non valid value for 'create' parameter, must be empty, true, or false: " + request.getProperty(CREATE_PARAMETER_NAME), RestUri.apiErrorCodes.INVALID_CREATE_VALUE);
        }
        String condition = request.getProperty(CONDITION_PARAMETER_NAME);
        Optional<String> route = Optional.ofNullable(request.getProperty(ROUTE_PARAMETER_NAME));
        Optional<ObjectNode> resultJson = Optional.empty();
        try {
            switch (request.getMethod()) {
                case GET: {
                    return restUri.getDocId().isEmpty() ? this.handleVisit(restUri, request) : this.handleGet(restUri);
                }
                case POST: {
                    this.operationHandler.put(restUri, this.createPutOperation(request, restUri.generateFullId(), condition), route);
                    break;
                }
                case PUT: {
                    this.operationHandler.update(restUri, this.createUpdateOperation(request, restUri.generateFullId(), condition, create), route);
                    break;
                }
                case DELETE: {
                    this.operationHandler.delete(restUri, condition, route);
                    break;
                }
                default: {
                    return new Response(405, Optional.empty(), Optional.of(restUri));
                }
            }
        }
        catch (RestApiException e) {
            return e.getResponse();
        }
        catch (Exception e2) {
            return Response.createErrorResponse(400, e2.getMessage(), restUri, RestUri.apiErrorCodes.PARSER_ERROR);
        }
        return new Response(200, resultJson, Optional.of(restUri));
    }

    private VespaXMLFeedReader.Operation createPutOperation(HttpRequest request, String id, String condition) {
        VespaXMLFeedReader.Operation operationPut = this.singleDocumentParser.parsePut(request.getData(), id);
        if (condition != null && !condition.isEmpty()) {
            operationPut.setCondition(new TestAndSetCondition(condition));
        }
        return operationPut;
    }

    private VespaXMLFeedReader.Operation createUpdateOperation(HttpRequest request, String id, String condition, Optional<Boolean> create) {
        VespaXMLFeedReader.Operation operationUpdate = this.singleDocumentParser.parseUpdate(request.getData(), id);
        if (condition != null && !condition.isEmpty()) {
            operationUpdate.getDocumentUpdate().setCondition(new TestAndSetCondition(condition));
        }
        create.ifPresent(c -> operationUpdate.getDocumentUpdate().setCreateIfNonExistent(c.booleanValue()));
        return operationUpdate;
    }

    private HttpResponse handleGet(RestUri restUri) throws RestApiException {
        Optional<String> getDocument = this.operationHandler.get(restUri);
        final ObjectNode resultNode = this.mapper.createObjectNode();
        if (getDocument.isPresent()) {
            JsonNode parseNode;
            try {
                parseNode = this.mapper.readTree(getDocument.get());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed while parsing my own results", e);
            }
            resultNode.putPOJO(FIELDS, (Object)parseNode.get(FIELDS));
        }
        resultNode.put(DOC_ID_NAME, restUri.generateFullId());
        resultNode.put(PATH_NAME, restUri.getRawPath());
        return new HttpResponse(getDocument.isPresent() ? 200 : 404){

            public String getContentType() {
                return RestApi.APPLICATION_JSON;
            }

            public void render(OutputStream outputStream) throws IOException {
                outputStream.write(resultNode.toString().getBytes(StandardCharsets.UTF_8.name()));
            }
        };
    }

    private static HttpResponse createInvalidParameterResponse(String parameter, String explanation) {
        return Response.createErrorResponse(403, String.format("Invalid '%s' value. %s", parameter, explanation), RestUri.apiErrorCodes.UNSPECIFIED);
    }

    private HttpResponse handleVisit(RestUri restUri, HttpRequest request) throws RestApiException {
        Optional<Integer> wantedDocumentCount;
        String documentSelection = Optional.ofNullable(request.getProperty(SELECTION)).orElse("");
        if (restUri.getGroup().isPresent() && !restUri.getGroup().get().value.isEmpty()) {
            if (!documentSelection.isEmpty()) {
                return Response.createErrorResponse(400, "Visiting does not support setting value for group/value in combination with expression, try using only expression parameter instead.", restUri, RestUri.apiErrorCodes.GROUP_AND_EXPRESSION_ERROR);
            }
            RestUri.Group group = restUri.getGroup().get();
            documentSelection = group.name == 'n' ? "id.user=" + group.value : "id.group='" + group.value + "'";
        }
        Optional<String> cluster = Optional.ofNullable(request.getProperty(CLUSTER));
        Optional<String> continuation = Optional.ofNullable(request.getProperty(CONTINUATION));
        try {
            wantedDocumentCount = RestApi.parseInteger(WANTED_DOCUMENT_COUNT, request);
        }
        catch (IllegalArgumentException e) {
            return RestApi.createInvalidParameterResponse(WANTED_DOCUMENT_COUNT, "Expected integer");
        }
        OperationHandler.VisitOptions options = new OperationHandler.VisitOptions(cluster, continuation, wantedDocumentCount);
        OperationHandler.VisitResult visit = this.operationHandler.visit(restUri, documentSelection, options);
        final ObjectNode resultNode = this.mapper.createObjectNode();
        visit.token.ifPresent(t -> resultNode.put(CONTINUATION, t));
        resultNode.putArray(DOCUMENTS).addPOJO((Object)visit.documentsAsJsonList);
        resultNode.put(PATH_NAME, restUri.getRawPath());
        HttpResponse httpResponse = new HttpResponse(200){

            public String getContentType() {
                return RestApi.APPLICATION_JSON;
            }

            public void render(OutputStream outputStream) throws IOException {
                try {
                    outputStream.write(resultNode.toString().getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return httpResponse;
    }
}

