/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.FeedException;
import ai.vespa.feed.client.JsonFeeder;
import ai.vespa.feed.client.OperationStats;
import ai.vespa.feed.client.Result;
import ai.vespa.feed.client.ResultException;
import ai.vespa.feed.client.impl.CliArguments;
import ai.vespa.feed.client.impl.GracePeriodCircuitBreaker;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.SequenceInputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.time.Instant;
import java.util.Enumeration;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

public class CliClient {
    private static final JsonFactory factory = new JsonFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    private final PrintStream systemOut;
    private final PrintStream systemError;
    private final InputStream systemIn;
    private final Object printMonitor = new Object();

    private CliClient(PrintStream systemOut, PrintStream systemError, InputStream systemIn) {
        this.systemOut = systemOut;
        this.systemError = systemError;
        this.systemIn = systemIn;
    }

    public static void main(String[] args) {
        CliClient client = new CliClient(System.out, System.err, System.in);
        int exitCode = client.run(args);
        System.exit(exitCode);
    }

    private int run(String[] rawArgs) {
        boolean verbose = false;
        try {
            final CliArguments cliArgs = CliArguments.fromRawArgs(rawArgs);
            verbose = cliArgs.verboseSpecified();
            if (cliArgs.helpSpecified()) {
                cliArgs.printHelp(this.systemOut);
                return 0;
            }
            if (cliArgs.versionSpecified()) {
                this.systemOut.println("8.324.16");
                return 0;
            }
            try (InputStream in = this.createFeedInputStream(cliArgs);
                 FeedClient feedClient = CliClient.createFeedClient(cliArgs);
                 JsonFeeder feeder = CliClient.createJsonFeeder(feedClient, cliArgs);){
                final CountDownLatch latch = new CountDownLatch(1);
                final AtomicReference fatal = new AtomicReference();
                final AtomicLong successes = new AtomicLong();
                final AtomicLong failures = new AtomicLong();
                long startNanos = System.nanoTime();
                if (cliArgs.showProgress()) {
                    Thread progressPrinter = new Thread(() -> {
                        try {
                            while (!latch.await(10L, TimeUnit.SECONDS)) {
                                Object object = this.printMonitor;
                                synchronized (object) {
                                    CliClient.printBenchmarkResult(System.nanoTime() - startNanos, successes.get(), failures.get(), feedClient.stats(), this.systemError);
                                }
                            }
                            return;
                        }
                        catch (IOException | InterruptedException exception) {
                            // empty catch block
                        }
                    }, "progress-printer");
                    progressPrinter.setDaemon(true);
                    progressPrinter.start();
                }
                feeder.feedMany(in, new JsonFeeder.ResultCallback(){

                    public void onNextResult(Result result, FeedException error) {
                        CliClient.this.handleResult(result, error, successes, failures, cliArgs);
                    }

                    public void onError(FeedException error) {
                        fatal.set(error);
                        latch.countDown();
                    }

                    public void onComplete() {
                        latch.countDown();
                    }
                });
                latch.await();
                CliClient.printBenchmarkResult(System.nanoTime() - startNanos, successes.get(), failures.get(), feedClient.stats(), cliArgs.benchmarkModeEnabled() ? this.systemOut : this.systemError);
                if (fatal.get() != null) {
                    throw (FeedException)((Object)fatal.get());
                }
            }
            return 0;
        }
        catch (FeedException | CliArguments.CliArgumentsException | IOException e) {
            return this.handleException(verbose, (Exception)e);
        }
        catch (Exception e) {
            return this.handleException(verbose, "Unknown failure: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResult(Result result, FeedException error, AtomicLong successes, AtomicLong failures, CliArguments args) {
        if (error != null) {
            failures.incrementAndGet();
            if (args.showErrors()) {
                Object object = this.printMonitor;
                synchronized (object) {
                    this.systemError.println(error.getMessage());
                    if (error instanceof ResultException) {
                        ((ResultException)error).getTrace().ifPresent(this.systemError::println);
                    }
                    if (args.verboseSpecified()) {
                        error.printStackTrace(this.systemError);
                    }
                }
            }
        } else {
            successes.incrementAndGet();
            if (args.showSuccesses()) {
                Object object = this.printMonitor;
                synchronized (object) {
                    this.systemError.println(result.documentId() + ": " + result.type());
                    result.traceMessage().ifPresent(this.systemError::println);
                    result.resultMessage().ifPresent(this.systemError::println);
                }
            }
        }
    }

    private static FeedClient createFeedClient(CliArguments cliArgs) throws CliArguments.CliArgumentsException {
        FeedClientBuilder builder = FeedClientBuilder.create((URI)cliArgs.endpoint());
        cliArgs.connections().ifPresent(arg_0 -> ((FeedClientBuilder)builder).setConnectionsPerEndpoint(arg_0));
        cliArgs.maxStreamsPerConnection().ifPresent(arg_0 -> ((FeedClientBuilder)builder).setMaxStreamPerConnection(arg_0));
        if (cliArgs.sslHostnameVerificationDisabled()) {
            builder.setHostnameVerifier((HostnameVerifier)AcceptAllHostnameVerifier.INSTANCE);
        }
        cliArgs.certificateAndKey().ifPresent(c -> builder.setCertificate(c.certificateFile, c.privateKeyFile));
        cliArgs.caCertificates().ifPresent(arg_0 -> ((FeedClientBuilder)builder).setCaCertificatesFile(arg_0));
        cliArgs.headers().forEach((arg_0, arg_1) -> ((FeedClientBuilder)builder).addRequestHeader(arg_0, arg_1));
        builder.setDryrun(cliArgs.dryrunEnabled());
        builder.setSpeedTest(cliArgs.speedTest());
        builder.setCompression(cliArgs.compression());
        cliArgs.doomSeconds().ifPresent(doom -> builder.setCircuitBreaker((FeedClient.CircuitBreaker)new GracePeriodCircuitBreaker(Duration.ofSeconds(10L), Duration.ofSeconds(doom))));
        cliArgs.proxy().ifPresent(arg_0 -> ((FeedClientBuilder)builder).setProxy(arg_0));
        return builder.build();
    }

    private static JsonFeeder createJsonFeeder(FeedClient feedClient, CliArguments cliArgs) throws CliArguments.CliArgumentsException, IOException {
        JsonFeeder.Builder builder = JsonFeeder.builder((FeedClient)feedClient);
        cliArgs.timeout().ifPresent(arg_0 -> ((JsonFeeder.Builder)builder).withTimeout(arg_0));
        cliArgs.route().ifPresent(arg_0 -> ((JsonFeeder.Builder)builder).withRoute(arg_0));
        cliArgs.traceLevel().ifPresent(arg_0 -> ((JsonFeeder.Builder)builder).withTracelevel(arg_0));
        return builder.build();
    }

    private InputStream createFeedInputStream(CliArguments cliArgs) throws CliArguments.CliArgumentsException, IOException {
        return cliArgs.readFeedFromStandardInput() ? this.systemIn : (cliArgs.inputFile().isPresent() ? Files.newInputStream(cliArgs.inputFile().get(), new OpenOption[0]) : CliClient.createDummyInputStream(cliArgs.testPayloadSize().orElse(1024)));
    }

    private int handleException(boolean verbose, Exception e) {
        return this.handleException(verbose, e.getMessage(), e);
    }

    private int handleException(boolean verbose, String message, Exception exception) {
        this.systemError.println(message);
        if (verbose) {
            exception.printStackTrace(this.systemError);
        }
        return 1;
    }

    static void printBenchmarkResult(long durationNanos, long successes, long failures, OperationStats stats, OutputStream systemOut) throws IOException {
        try (JsonGenerator generator = factory.createGenerator(systemOut).useDefaultPrettyPrinter();){
            generator.writeStartObject();
            CliClient.writeFloatField(generator, "feeder.seconds", (double)durationNanos * 1.0E-9, 3);
            generator.writeNumberField("feeder.ok.count", successes);
            CliClient.writeFloatField(generator, "feeder.ok.rate", (double)successes * 1.0E9 / (double)Math.max(1L, durationNanos), 3);
            generator.writeNumberField("feeder.error.count", failures);
            generator.writeNumberField("feeder.inflight.count", stats.inflight());
            generator.writeNumberField("http.request.count", stats.requests());
            generator.writeNumberField("http.request.bytes", stats.bytesSent());
            CliClient.writeFloatField(generator, "http.request.MBps", (double)stats.bytesSent() * 1000.0 / (double)durationNanos, 3);
            generator.writeNumberField("http.exception.count", stats.exceptions());
            generator.writeNumberField("http.response.count", stats.responses());
            generator.writeNumberField("http.response.bytes", stats.bytesReceived());
            CliClient.writeFloatField(generator, "http.response.MBps", (double)stats.bytesReceived() * 1000.0 / (double)durationNanos, 3);
            generator.writeNumberField("http.response.error.count", stats.responses() - stats.successes());
            CliClient.writeFloatField(generator, "http.response.latency.millis.min", stats.minLatencyMillis(), 3);
            CliClient.writeFloatField(generator, "http.response.latency.millis.avg", stats.averageLatencyMillis(), 3);
            CliClient.writeFloatField(generator, "http.response.latency.millis.max", stats.maxLatencyMillis(), 3);
            generator.writeObjectFieldStart("http.response.code.counts");
            for (Map.Entry entry : stats.responsesByCode().entrySet()) {
                generator.writeNumberField(Integer.toString((Integer)entry.getKey()), ((Long)entry.getValue()).longValue());
            }
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    private static void writeFloatField(JsonGenerator generator, String name, double value, int precision) throws IOException {
        generator.writeFieldName(name);
        generator.writeNumber(String.format("%." + precision + "f", value));
    }

    static InputStream createDummyInputStream(int payloadSize) {
        Instant end = Instant.now().plusSeconds(60L);
        return CliClient.createDummyInputStream(payloadSize, ThreadLocalRandom.current(), () -> Instant.now().isBefore(end));
    }

    static InputStream createDummyInputStream(final int payloadSize, final Random random, final BooleanSupplier hasNext) {
        final int idSize = 8;
        String template = String.format("{ \"put\": \"id:test:test::%s\", \"fields\": { \"test\": \"%s\" } }\n", IntStream.range(0, idSize).mapToObj(__ -> "*").collect(Collectors.joining()), IntStream.range(0, payloadSize).mapToObj(__ -> "#").collect(Collectors.joining()));
        final byte[] buffer = template.getBytes(StandardCharsets.UTF_8);
        final int idIndex = template.indexOf(42);
        final int dataIndex = template.indexOf(35);
        return new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return hasNext.getAsBoolean();
            }

            @Override
            public InputStream nextElement() {
                int i;
                for (i = 0; i < idSize; ++i) {
                    buffer[idIndex + i] = (byte)(97 + random.nextInt(26));
                }
                for (i = 0; i < payloadSize; ++i) {
                    buffer[dataIndex + i] = (byte)(97 + random.nextInt(26));
                }
                return new ByteArrayInputStream(buffer);
            }
        });
    }

    private static class AcceptAllHostnameVerifier
    implements HostnameVerifier {
        static final AcceptAllHostnameVerifier INSTANCE = new AcceptAllHostnameVerifier();

        private AcceptAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

