/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.CliArguments;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.JsonFeeder;
import ai.vespa.feed.client.OperationStats;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

public class CliClient {
    private final PrintStream systemOut;
    private final PrintStream systemError;
    private final InputStream systemIn;
    private final Properties systemProperties;
    private final Map<String, String> environmentVariables;

    private CliClient(PrintStream systemOut, PrintStream systemError, InputStream systemIn, Properties systemProperties, Map<String, String> environmentVariables) {
        this.systemOut = systemOut;
        this.systemError = systemError;
        this.systemIn = systemIn;
        this.systemProperties = systemProperties;
        this.environmentVariables = environmentVariables;
    }

    public static void main(String[] args) {
        CliClient client = new CliClient(System.out, System.err, System.in, System.getProperties(), System.getenv());
        int exitCode = client.run(args);
        System.exit(exitCode);
    }

    private int run(String[] rawArgs) {
        CliArguments cliArgs = null;
        try {
            cliArgs = CliArguments.fromRawArgs(rawArgs);
            if (cliArgs.helpSpecified()) {
                cliArgs.printHelp(this.systemOut);
                return 0;
            }
            if (cliArgs.versionSpecified()) {
                this.systemOut.println("7.423.37");
                return 0;
            }
            try (InputStream in = this.createFeedInputStream(cliArgs);
                 FeedClient feedClient = CliClient.createFeedClient(cliArgs);
                 JsonFeeder feeder = CliClient.createJsonFeeder(feedClient, cliArgs);){
                long startNanos = System.nanoTime();
                feeder.feedMany(in).join();
                if (cliArgs.benchmarkModeEnabled()) {
                    CliClient.printBenchmarkResult(System.nanoTime() - startNanos, feedClient.stats(), this.systemOut);
                }
            }
            return 0;
        }
        catch (CliArguments.CliArgumentsException | IOException e) {
            boolean verbose = cliArgs != null && cliArgs.verboseSpecified();
            return this.handleException(verbose, e);
        }
        catch (Exception e) {
            boolean verbose = cliArgs != null && cliArgs.verboseSpecified();
            return this.handleException(verbose, "Unknown failure: " + e.getMessage(), e);
        }
    }

    private static FeedClient createFeedClient(CliArguments cliArgs) throws CliArguments.CliArgumentsException {
        FeedClientBuilder builder = FeedClientBuilder.create((URI)cliArgs.endpoint());
        cliArgs.connections().ifPresent(arg_0 -> ((FeedClientBuilder)builder).setConnectionsPerEndpoint(arg_0));
        cliArgs.maxStreamsPerConnection().ifPresent(arg_0 -> ((FeedClientBuilder)builder).setMaxStreamPerConnection(arg_0));
        if (cliArgs.sslHostnameVerificationDisabled()) {
            builder.setHostnameVerifier((HostnameVerifier)AcceptAllHostnameVerifier.INSTANCE);
        }
        cliArgs.certificateAndKey().ifPresent(c -> builder.setCertificate(c.certificateFile, c.privateKeyFile));
        cliArgs.caCertificates().ifPresent(arg_0 -> ((FeedClientBuilder)builder).setCaCertificatesFile(arg_0));
        cliArgs.headers().forEach((arg_0, arg_1) -> ((FeedClientBuilder)builder).addRequestHeader(arg_0, arg_1));
        return builder.build();
    }

    private static JsonFeeder createJsonFeeder(FeedClient feedClient, CliArguments cliArgs) throws CliArguments.CliArgumentsException, IOException {
        JsonFeeder.Builder builder = JsonFeeder.builder((FeedClient)feedClient);
        cliArgs.timeout().ifPresent(arg_0 -> ((JsonFeeder.Builder)builder).withTimeout(arg_0));
        cliArgs.route().ifPresent(arg_0 -> ((JsonFeeder.Builder)builder).withRoute(arg_0));
        cliArgs.traceLevel().ifPresent(arg_0 -> ((JsonFeeder.Builder)builder).withTracelevel(arg_0));
        return builder.build();
    }

    private InputStream createFeedInputStream(CliArguments cliArgs) throws CliArguments.CliArgumentsException, IOException {
        return cliArgs.readFeedFromStandardInput() ? this.systemIn : Files.newInputStream(cliArgs.inputFile().get(), new OpenOption[0]);
    }

    private int handleException(boolean verbose, Exception e) {
        return this.handleException(verbose, e.getMessage(), e);
    }

    private int handleException(boolean verbose, String message, Exception exception) {
        this.systemError.println(message);
        if (this.debugMode() || verbose) {
            exception.printStackTrace(this.systemError);
        }
        return 1;
    }

    private boolean debugMode() {
        boolean enabledWithSystemProperty = Boolean.parseBoolean(this.systemProperties.getProperty("VESPA_DEBUG", Boolean.FALSE.toString()));
        boolean enabledWithEnvironmentVariable = Optional.ofNullable(this.environmentVariables.get("VESPA_DEBUG")).map(Boolean::parseBoolean).orElse(false);
        return enabledWithSystemProperty || enabledWithEnvironmentVariable;
    }

    static void printBenchmarkResult(long durationNanos, OperationStats stats, OutputStream systemOut) throws IOException {
        JsonFactory factory = new JsonFactory();
        long okCount = stats.successes();
        long errorCount = stats.requests() - okCount;
        double throughput = (double)okCount * 1.0E9 / (double)Math.max(1L, durationNanos);
        try (JsonGenerator generator = factory.createGenerator(systemOut).useDefaultPrettyPrinter();){
            generator.writeStartObject();
            generator.writeNumberField("feeder.runtime", durationNanos / 1000000L);
            generator.writeNumberField("feeder.okcount", okCount);
            generator.writeNumberField("feeder.errorcount", errorCount);
            generator.writeNumberField("feeder.throughput", throughput);
            generator.writeNumberField("feeder.minlatency", stats.minLatencyMillis());
            generator.writeNumberField("feeder.avglatency", stats.averageLatencyMillis());
            generator.writeNumberField("feeder.maxlatency", stats.maxLatencyMillis());
            generator.writeNumberField("feeder.bytessent", stats.bytesSent());
            generator.writeNumberField("feeder.bytesreceived", stats.bytesReceived());
            generator.writeObjectFieldStart("feeder.responsecodes");
            for (Map.Entry entry : stats.responsesByCode().entrySet()) {
                generator.writeNumberField(Integer.toString((Integer)entry.getKey()), ((Long)entry.getValue()).longValue());
            }
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    private static class AcceptAllHostnameVerifier
    implements HostnameVerifier {
        static final AcceptAllHostnameVerifier INSTANCE = new AcceptAllHostnameVerifier();

        private AcceptAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

