/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.CliArguments;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.JsonFeeder;
import ai.vespa.feed.client.Result;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

public class CliClient {
    private final PrintStream systemOut;
    private final PrintStream systemError;
    private final InputStream systemIn;
    private final Properties systemProperties;
    private final Map<String, String> environmentVariables;

    private CliClient(PrintStream systemOut, PrintStream systemError, InputStream systemIn, Properties systemProperties, Map<String, String> environmentVariables) {
        this.systemOut = systemOut;
        this.systemError = systemError;
        this.systemIn = systemIn;
        this.systemProperties = systemProperties;
        this.environmentVariables = environmentVariables;
    }

    public static void main(String[] args) {
        CliClient client = new CliClient(System.out, System.err, System.in, System.getProperties(), System.getenv());
        int exitCode = client.run(args);
        System.exit(exitCode);
    }

    private int run(String[] rawArgs) {
        CliArguments cliArgs = null;
        try {
            cliArgs = CliArguments.fromRawArgs(rawArgs);
            if (cliArgs.helpSpecified()) {
                cliArgs.printHelp(this.systemOut);
                return 0;
            }
            if (cliArgs.versionSpecified()) {
                this.systemOut.println("7.418.23");
                return 0;
            }
            try (InputStream in = this.createFeedInputStream(cliArgs);
                 JsonFeeder feeder = CliClient.createJsonFeeder(cliArgs);){
                if (cliArgs.benchmarkModeEnabled()) {
                    BenchmarkResultAggregator aggregator = new BenchmarkResultAggregator();
                    feeder.feedMany(in, aggregator).join();
                    aggregator.printBenchmarkResult();
                } else {
                    JsonFeeder.ResultCallback emptyCallback = new JsonFeeder.ResultCallback(){

                        @Override
                        public void onNextResult(Result result, Throwable error) {
                        }

                        @Override
                        public void onError(Throwable error) {
                        }

                        @Override
                        public void onComplete() {
                        }
                    };
                    feeder.feedMany(in, emptyCallback).join();
                }
            }
            return 0;
        }
        catch (CliArguments.CliArgumentsException | IOException e) {
            boolean verbose = cliArgs != null && cliArgs.verboseSpecified();
            return this.handleException(verbose, e);
        }
        catch (Exception e) {
            boolean verbose = cliArgs != null && cliArgs.verboseSpecified();
            return this.handleException(verbose, "Unknown failure: " + e.getMessage(), e);
        }
    }

    private static FeedClient createFeedClient(CliArguments cliArgs) throws CliArguments.CliArgumentsException {
        FeedClientBuilder builder = FeedClientBuilder.create(cliArgs.endpoint());
        cliArgs.connections().ifPresent(builder::setConnectionsPerEndpoint);
        cliArgs.maxStreamsPerConnection().ifPresent(builder::setMaxStreamPerConnection);
        if (cliArgs.sslHostnameVerificationDisabled()) {
            builder.setHostnameVerifier(AcceptAllHostnameVerifier.INSTANCE);
        }
        cliArgs.certificateAndKey().ifPresent(c -> builder.setCertificate(c.certificateFile, c.privateKeyFile));
        cliArgs.caCertificates().ifPresent(builder::setCaCertificates);
        cliArgs.headers().forEach(builder::addRequestHeader);
        return builder.build();
    }

    private static JsonFeeder createJsonFeeder(CliArguments cliArgs) throws CliArguments.CliArgumentsException, IOException {
        FeedClient feedClient = CliClient.createFeedClient(cliArgs);
        JsonFeeder.Builder builder = JsonFeeder.builder(feedClient);
        cliArgs.timeout().ifPresent(builder::withTimeout);
        cliArgs.route().ifPresent(builder::withRoute);
        cliArgs.traceLevel().ifPresent(builder::withTracelevel);
        return builder.build();
    }

    private InputStream createFeedInputStream(CliArguments cliArgs) throws CliArguments.CliArgumentsException, IOException {
        return cliArgs.readFeedFromStandardInput() ? this.systemIn : Files.newInputStream(cliArgs.inputFile().get(), new OpenOption[0]);
    }

    private int handleException(boolean verbose, Exception e) {
        return this.handleException(verbose, e.getMessage(), e);
    }

    private int handleException(boolean verbose, String message, Exception exception) {
        this.systemError.println(message);
        if (this.debugMode() || verbose) {
            exception.printStackTrace(this.systemError);
        }
        return 1;
    }

    private boolean debugMode() {
        boolean enabledWithSystemProperty = Boolean.parseBoolean(this.systemProperties.getProperty("VESPA_DEBUG", Boolean.FALSE.toString()));
        boolean enabledWithEnvironmentVariable = Optional.ofNullable(this.environmentVariables.get("VESPA_DEBUG")).map(Boolean::parseBoolean).orElse(false);
        return enabledWithSystemProperty || enabledWithEnvironmentVariable;
    }

    private class BenchmarkResultAggregator
    implements JsonFeeder.ResultCallback {
        private final AtomicInteger okCount = new AtomicInteger();
        private final AtomicInteger errorCount = new AtomicInteger();
        private volatile long endNanoTime;
        private volatile long startNanoTime;

        private BenchmarkResultAggregator() {
        }

        void start() {
            this.startNanoTime = System.nanoTime();
        }

        void printBenchmarkResult() throws IOException {
            JsonFactory factory = new JsonFactory();
            Duration duration = Duration.ofNanos(this.endNanoTime - this.startNanoTime);
            int okCount = this.okCount.get();
            int errorCount = this.errorCount.get();
            double throughput = (double)okCount / (double)duration.toMillis() * 1000.0;
            try (JsonGenerator generator = factory.createGenerator(CliClient.this.systemOut).useDefaultPrettyPrinter();){
                generator.writeStartObject();
                generator.writeNumberField("feeder.runtime", duration.toMillis());
                generator.writeNumberField("feeder.okcount", okCount);
                generator.writeNumberField("feeder.errorcount", errorCount);
                generator.writeNumberField("feeder.throughput", throughput);
                generator.writeEndObject();
            }
        }

        @Override
        public void onNextResult(Result result, Throwable error) {
            if (error != null) {
                this.errorCount.incrementAndGet();
            } else {
                this.okCount.incrementAndGet();
            }
        }

        @Override
        public void onError(Throwable error) {
        }

        @Override
        public void onComplete() {
            this.endNanoTime = System.nanoTime();
        }
    }

    private static class AcceptAllHostnameVerifier
    implements HostnameVerifier {
        static final AcceptAllHostnameVerifier INSTANCE = new AcceptAllHostnameVerifier();

        private AcceptAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

