/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.FeedClient;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GracePeriodCircuitBreaker
implements FeedClient.CircuitBreaker {
    private static final Logger log = Logger.getLogger(GracePeriodCircuitBreaker.class.getName());
    private final AtomicLong lastSuccessMillis = new AtomicLong(0L);
    private final AtomicBoolean halfOpen = new AtomicBoolean(false);
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final Clock clock;
    private final long graceMillis;
    private final long doomMillis;

    GracePeriodCircuitBreaker(Clock clock, Duration grace, Duration doom) {
        if (grace.isNegative()) {
            throw new IllegalArgumentException("Grace delay must be non-negative");
        }
        if (doom.isNegative()) {
            throw new IllegalArgumentException("Doom delay must be non-negative");
        }
        this.clock = Objects.requireNonNull(clock);
        this.graceMillis = grace.toMillis();
        this.doomMillis = doom.toMillis();
    }

    @Override
    public void success() {
        this.lastSuccessMillis.set(this.clock.millis());
        if (this.halfOpen.compareAndSet(true, false)) {
            log.log(Level.INFO, "Circuit breaker is now closed");
        }
    }

    @Override
    public void failure() {
        long nowMillis = this.clock.millis();
        if (this.lastSuccessMillis.get() < nowMillis - this.doomMillis && this.open.compareAndSet(false, true)) {
            log.log(Level.WARNING, "Circuit breaker is now open");
        }
        if (this.lastSuccessMillis.get() < nowMillis - this.graceMillis && this.halfOpen.compareAndSet(false, true)) {
            log.log(Level.INFO, "Circuit breaker is now half-open");
        }
    }

    @Override
    public FeedClient.CircuitBreaker.State state() {
        return this.open.get() ? FeedClient.CircuitBreaker.State.OPEN : (this.halfOpen.get() ? FeedClient.CircuitBreaker.State.HALF_OPEN : FeedClient.CircuitBreaker.State.CLOSED);
    }
}

