/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.RequestStrategy;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;

class HttpRequestStrategy
implements RequestStrategy,
AutoCloseable {
    private static final Logger log = Logger.getLogger(HttpRequestStrategy.class.getName());
    private final Map<DocumentId, CompletableFuture<Void>> inflightById = new HashMap<DocumentId, CompletableFuture<Void>>();
    private final Object monitor = new Object();
    private final Clock clock;
    private final FeedClient.RetryStrategy wrapped;
    private final Thread delayer = new Thread(this::drainDelayed, "feed-client-retry-delayer");
    private final BlockingQueue<CompletableFuture<Void>> delayed = new LinkedBlockingQueue<CompletableFuture<Void>>();
    private final long maxInflight;
    private final long minInflight;
    private double targetInflight;
    private long inflight = 0L;
    private long consecutiveSuccesses = 0L;
    private Instant lastSuccess;
    private boolean failed = false;
    private boolean closed = false;

    HttpRequestStrategy(FeedClientBuilder builder, Clock clock) {
        this.wrapped = builder.retryStrategy;
        this.maxInflight = (long)builder.maxConnections * (long)builder.maxStreamsPerConnection;
        this.minInflight = (long)builder.maxConnections * (long)Math.min(16, builder.maxStreamsPerConnection);
        this.targetInflight = Math.sqrt(this.maxInflight) * Math.sqrt(this.minInflight);
        this.clock = clock;
        this.lastSuccess = clock.instant();
        this.delayer.start();
    }

    private void drainDelayed() {
        try {
            while (true) {
                this.delayed.take().complete(null);
                if (!this.hasFailed()) continue;
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            this.delayed.forEach(action -> action.cancel(true));
            return;
        }
    }

    private boolean retry(SimpleHttpRequest request, int attempt) {
        if (attempt >= this.wrapped.retries()) {
            return false;
        }
        switch (request.getMethod().toUpperCase()) {
            case "POST": {
                return this.wrapped.retry(FeedClient.OperationType.put);
            }
            case "PUT": {
                return this.wrapped.retry(FeedClient.OperationType.update);
            }
            case "DELETE": {
                return this.wrapped.retry(FeedClient.OperationType.remove);
            }
        }
        throw new IllegalStateException("Unexpected HTTP method: " + request.getMethod());
    }

    private boolean retry(SimpleHttpRequest request, Throwable thrown, int attempt) {
        this.failure();
        log.log(Level.INFO, thrown, () -> "Failed attempt " + attempt + " at " + request + ", " + this.consecutiveSuccesses + " successes since last error");
        if (!(thrown instanceof IOException)) {
            return false;
        }
        return this.retry(request, attempt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void success() {
        Instant now = this.clock.instant();
        Object object = this.monitor;
        synchronized (object) {
            ++this.consecutiveSuccesses;
            this.lastSuccess = now;
            this.targetInflight = Math.min(this.targetInflight + 0.1, (double)this.maxInflight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failure() {
        Instant threshold = this.clock.instant().minusSeconds(300L);
        Object object = this.monitor;
        synchronized (object) {
            this.consecutiveSuccesses = 0L;
            if (this.lastSuccess.isBefore(threshold)) {
                this.failed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retry(SimpleHttpRequest request, SimpleHttpResponse response, int attempt) {
        if (response.getCode() / 100 == 2) {
            this.success();
            return false;
        }
        if (response.getCode() == 429 || response.getCode() == 503) {
            Object object = this.monitor;
            synchronized (object) {
                this.targetInflight = Math.max((double)this.inflight * 0.9, (double)this.minInflight);
            }
            log.log(Level.FINE, () -> "Status code " + response.getCode() + " (" + response.getBodyText() + ") on attempt " + attempt + " at " + request + ", " + this.consecutiveSuccesses + " successes since last error");
            return true;
        }
        log.log(Level.INFO, () -> "Status code " + response.getCode() + " (" + response.getBodyText() + ") on attempt " + attempt + " at " + request + ", " + this.consecutiveSuccesses + " successes since last error");
        this.failure();
        if (response.getCode() != 500 && response.getCode() != 502) {
            return false;
        }
        return this.retry(request, attempt);
    }

    private void acquireSlot() {
        try {
            while ((double)this.inflight >= this.targetInflight) {
                this.monitor.wait();
            }
            ++this.inflight;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void releaseSlot() {
        long i = --this.inflight;
        while ((double)i < this.targetInflight) {
            this.monitor.notify();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFailed() {
        Object object = this.monitor;
        synchronized (object) {
            return this.failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<SimpleHttpResponse> enqueue(DocumentId documentId, SimpleHttpRequest request, BiConsumer<SimpleHttpRequest, CompletableFuture<SimpleHttpResponse>> dispatch) {
        CompletableFuture previous;
        CompletableFuture<SimpleHttpResponse> result = new CompletableFuture<SimpleHttpResponse>();
        CompletableFuture<SimpleHttpResponse> vessel = new CompletableFuture<SimpleHttpResponse>();
        CompletableFuture blocker = new CompletableFuture();
        Object object = this.monitor;
        synchronized (object) {
            previous = this.inflightById.put(documentId, blocker);
            if (previous == null) {
                this.acquireSlot();
            }
        }
        if (previous == null) {
            dispatch.accept(request, vessel);
        } else {
            previous.thenRun(() -> dispatch.accept(request, vessel));
        }
        this.handleAttempt(vessel, dispatch, request, result, 1);
        result.thenRun(() -> {
            CompletableFuture<Void> current;
            Object object = this.monitor;
            synchronized (object) {
                current = this.inflightById.get(documentId);
                if (current == blocker) {
                    this.releaseSlot();
                    this.inflightById.put(documentId, null);
                }
            }
            if (current != blocker) {
                blocker.complete(null);
            }
        });
        return result;
    }

    private void handleAttempt(CompletableFuture<SimpleHttpResponse> vessel, BiConsumer<SimpleHttpRequest, CompletableFuture<SimpleHttpResponse>> dispatch, SimpleHttpRequest request, CompletableFuture<SimpleHttpResponse> result, int attempt) {
        vessel.whenComplete((response, thrown) -> {
            if (thrown != null ? this.retry(request, (Throwable)thrown, attempt) : this.retry(request, (SimpleHttpResponse)response, attempt)) {
                CompletableFuture<SimpleHttpResponse> retry = new CompletableFuture<SimpleHttpResponse>();
                boolean hasFailed = this.hasFailed();
                if (hasFailed) {
                    this.delayed.add((CompletableFuture<Void>)new CompletableFuture().thenRun(() -> dispatch.accept(request, retry)));
                } else {
                    dispatch.accept(request, retry);
                }
                this.handleAttempt(retry, dispatch, request, result, attempt + (hasFailed ? 0 : 1));
                return;
            }
            if (thrown == null) {
                result.complete((SimpleHttpResponse)response);
            } else {
                result.completeExceptionally((Throwable)thrown);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.delayer.interrupt();
        try {
            this.delayer.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

