/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.HttpFeedClient;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class FeedClientBuilder {
    FeedClient.RetryStrategy defaultRetryStrategy = new FeedClient.RetryStrategy(){};
    final URI endpoint;
    final Map<String, Supplier<String>> requestHeaders = new HashMap<String, Supplier<String>>();
    SSLContext sslContext;
    HostnameVerifier hostnameVerifier;
    int maxConnections = 4;
    int maxStreamsPerConnection = 1024;
    FeedClient.RetryStrategy retryStrategy = this.defaultRetryStrategy;
    Path certificate;
    Path privateKey;
    Path caCertificates;
    Clock clock;

    public static FeedClientBuilder create(URI endpoint) {
        return new FeedClientBuilder(endpoint);
    }

    private FeedClientBuilder(URI endpoint) {
        Objects.requireNonNull(endpoint.getHost());
        this.endpoint = endpoint;
    }

    public FeedClientBuilder setMaxConnections(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Max connections must be at least 1, but was " + max);
        }
        this.maxConnections = max;
        return this;
    }

    public FeedClientBuilder setMaxStreamPerConnection(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Max streams per connection must be at least 1, but was " + max);
        }
        this.maxStreamsPerConnection = max;
        return this;
    }

    public FeedClientBuilder setSslContext(SSLContext context) {
        if (this.certificate != null || this.caCertificates != null || this.privateKey != null) {
            throw new IllegalArgumentException("Cannot set both SSLContext and certificate / CA certificates");
        }
        this.sslContext = Objects.requireNonNull(context);
        return this;
    }

    public FeedClientBuilder setHostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = Objects.requireNonNull(verifier);
        return this;
    }

    public FeedClientBuilder addRequestHeader(String name, String value) {
        return this.addRequestHeader(name, () -> Objects.requireNonNull(value));
    }

    public FeedClientBuilder addRequestHeader(String name, Supplier<String> valueSupplier) {
        this.requestHeaders.put(Objects.requireNonNull(name), Objects.requireNonNull(valueSupplier));
        return this;
    }

    public FeedClientBuilder setRetryStrategy(FeedClient.RetryStrategy strategy) {
        this.retryStrategy = Objects.requireNonNull(strategy);
        return this;
    }

    public FeedClientBuilder setCertificate(Path certificatePemFile, Path privateKeyPemFile) {
        if (this.sslContext != null) {
            throw new IllegalArgumentException("Cannot set both SSLContext and certificate");
        }
        this.certificate = certificatePemFile;
        this.privateKey = privateKeyPemFile;
        return this;
    }

    public FeedClientBuilder setCaCertificates(Path caCertificatesFile) {
        if (this.sslContext != null) {
            throw new IllegalArgumentException("Cannot set both SSLContext and CA certificate");
        }
        this.caCertificates = caCertificatesFile;
        return this;
    }

    public FeedClient build() {
        try {
            return new HttpFeedClient(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

