/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.HttpRequestStrategy;
import ai.vespa.feed.client.OperationParameters;
import ai.vespa.feed.client.RequestStrategy;
import ai.vespa.feed.client.Result;
import ai.vespa.feed.client.SslContextBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.ssl.TlsCiphers;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

class HttpFeedClient
implements FeedClient {
    private final URI endpoint;
    private final Map<String, Supplier<String>> requestHeaders;
    private final RequestStrategy requestStrategy;
    private final List<CloseableHttpAsyncClient> httpClients = new ArrayList<CloseableHttpAsyncClient>();
    private final List<AtomicInteger> inflight = new ArrayList<AtomicInteger>();
    private final AtomicBoolean closed = new AtomicBoolean();

    HttpFeedClient(FeedClientBuilder builder) throws IOException {
        this.endpoint = builder.endpoint;
        this.requestHeaders = new HashMap<String, Supplier<String>>(builder.requestHeaders);
        this.requestStrategy = new HttpRequestStrategy(builder);
        for (int i = 0; i < builder.maxConnections; ++i) {
            CloseableHttpAsyncClient client = HttpFeedClient.createHttpClient(builder);
            client.start();
            this.httpClients.add(client);
            this.inflight.add(new AtomicInteger());
        }
    }

    private static CloseableHttpAsyncClient createHttpClient(FeedClientBuilder builder) throws IOException {
        H2AsyncClientBuilder httpClientBuilder = H2AsyncClientBuilder.create().setUserAgent(String.format("vespa-feed-client/%s", "7.413.25")).setDefaultHeaders(Collections.singletonList(new BasicHeader("Vespa-Client-Version", "7.413.25"))).disableCookieManagement().disableRedirectHandling().disableAutomaticRetries().setIOReactorConfig(IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds(10L)).build()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds(10L)).setConnectionRequestTimeout(Timeout.DISABLED).setResponseTimeout(Timeout.ofMinutes(5L)).build()).setH2Config(H2Config.initial().setMaxConcurrentStreams(builder.maxStreamsPerConnection).setCompressionEnabled(true).setPushEnabled(false).build());
        SSLContext sslContext = HttpFeedClient.constructSslContext(builder);
        String[] allowedCiphers = TlsCiphers.excludeH2Blacklisted(TlsCiphers.excludeWeak(sslContext.getSupportedSSLParameters().getCipherSuites()));
        if (allowedCiphers.length == 0) {
            throw new IllegalStateException("No adequate SSL cipher suites supported by the JVM");
        }
        ClientTlsStrategyBuilder tlsStrategyBuilder = ClientTlsStrategyBuilder.create().setCiphers(allowedCiphers).setSslContext(sslContext);
        if (builder.hostnameVerifier != null) {
            tlsStrategyBuilder.setHostnameVerifier(builder.hostnameVerifier);
        }
        return httpClientBuilder.setTlsStrategy(tlsStrategyBuilder.build()).build();
    }

    private static SSLContext constructSslContext(FeedClientBuilder builder) throws IOException {
        if (builder.sslContext != null) {
            return builder.sslContext;
        }
        SslContextBuilder sslContextBuilder = new SslContextBuilder();
        if (builder.certificate != null && builder.privateKey != null) {
            sslContextBuilder.withCertificateAndKey(builder.certificate, builder.privateKey);
        }
        if (builder.caCertificates != null) {
            sslContextBuilder.withCaCertificates(builder.caCertificates);
        }
        return sslContextBuilder.build();
    }

    @Override
    public CompletableFuture<Result> put(DocumentId documentId, String documentJson, OperationParameters params) {
        return this.send("POST", documentId, Objects.requireNonNull(documentJson), params);
    }

    @Override
    public CompletableFuture<Result> update(DocumentId documentId, String updateJson, OperationParameters params) {
        return this.send("PUT", documentId, Objects.requireNonNull(updateJson), params);
    }

    @Override
    public CompletableFuture<Result> remove(DocumentId documentId, OperationParameters params) {
        return this.send("DELETE", documentId, null, params);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            for (CloseableHttpAsyncClient hc : this.httpClients) {
                hc.close();
            }
        }
    }

    private CompletableFuture<Result> send(String method, DocumentId documentId, String operationJson, OperationParameters params) {
        SimpleHttpRequest request = new SimpleHttpRequest(method, HttpFeedClient.operationUrl(this.endpoint, documentId, params));
        this.requestHeaders.forEach((name, value) -> request.setHeader((String)name, value.get()));
        if (operationJson != null) {
            request.setBody(operationJson, ContentType.APPLICATION_JSON);
        }
        return this.requestStrategy.enqueue(documentId, request, this::send).handle((response, thrown) -> {
            if (thrown != null) {
                if (this.requestStrategy.hasFailed()) {
                    try {
                        this.close();
                    }
                    catch (IOException exception) {
                        thrown.addSuppressed(exception);
                    }
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                thrown.printStackTrace(new PrintStream(buffer));
                return new Result(Result.Type.failure, documentId, buffer.toString(), null);
            }
            return HttpFeedClient.toResult(response, documentId);
        });
    }

    private void send(SimpleHttpRequest request, final CompletableFuture<SimpleHttpResponse> vessel) {
        int index = 0;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.httpClients.size(); ++i) {
            if (this.inflight.get(i).get() >= min) continue;
            min = this.inflight.get(i).get();
            index = i;
        }
        this.inflight.get(index).incrementAndGet();
        try {
            this.httpClients.get(index).execute(request, new FutureCallback<SimpleHttpResponse>(){

                @Override
                public void completed(SimpleHttpResponse response) {
                    vessel.complete(response);
                }

                @Override
                public void failed(Exception ex) {
                    vessel.completeExceptionally(ex);
                }

                @Override
                public void cancelled() {
                    vessel.cancel(false);
                }
            });
        }
        catch (Throwable thrown) {
            vessel.completeExceptionally(thrown);
        }
        vessel.thenRun(this.inflight.get(index)::decrementAndGet);
    }

    static Result toResult(SimpleHttpResponse response, DocumentId documentId) {
        Result.Type type;
        switch (response.getCode()) {
            case 200: {
                type = Result.Type.success;
                break;
            }
            case 412: {
                type = Result.Type.conditionNotMet;
                break;
            }
            default: {
                type = Result.Type.failure;
            }
        }
        Object responseJson = null;
        return new Result(type, documentId, response.getBodyText(), "trace");
    }

    static List<String> toPath(DocumentId documentId) {
        ArrayList<String> path = new ArrayList<String>();
        path.add("document");
        path.add("v1");
        path.add(documentId.namespace());
        path.add(documentId.documentType());
        if (documentId.number().isPresent()) {
            path.add("number");
            path.add(Long.toUnsignedString(documentId.number().getAsLong()));
        } else if (documentId.group().isPresent()) {
            path.add("group");
            path.add(documentId.group().get());
        } else {
            path.add("docid");
        }
        path.add(documentId.userSpecific());
        return path;
    }

    static URI operationUrl(URI endpoint, DocumentId documentId, OperationParameters params) {
        URIBuilder url = new URIBuilder(endpoint);
        url.setPathSegments(HttpFeedClient.toPath(documentId));
        if (params.createIfNonExistent()) {
            url.addParameter("create", "true");
        }
        params.testAndSetCondition().ifPresent(condition -> url.addParameter("condition", (String)condition));
        params.timeout().ifPresent(timeout -> url.addParameter("timeout", timeout.toMillis() + "ms"));
        params.route().ifPresent(route -> url.addParameter("route", (String)route));
        params.tracelevel().ifPresent(tracelevel -> url.addParameter("tracelevel", Integer.toString(tracelevel)));
        try {
            return url.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

