/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.RequestStrategy;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;

class HttpRequestStrategy
implements RequestStrategy<SimpleHttpResponse>,
HttpRequestRetryStrategy {
    private final Map<DocumentId, CompletableFuture<SimpleHttpResponse>> byId = new ConcurrentHashMap<DocumentId, CompletableFuture<SimpleHttpResponse>>();
    private final FeedClient.RetryStrategy wrapped;
    private final long maxInflight;
    private double targetInflight;
    private long inflight;
    private final AtomicReference<Double> errorRate;
    private final double errorThreshold;
    private final Lock lock;
    private final Condition available;

    HttpRequestStrategy(FeedClientBuilder builder) {
        this.wrapped = builder.retryStrategy;
        this.maxInflight = (long)builder.maxConnections * (long)builder.maxStreamsPerConnection;
        this.targetInflight = this.maxInflight;
        this.inflight = 0L;
        this.errorRate = new AtomicReference<Double>(0.0);
        this.errorThreshold = 0.1;
        this.lock = new ReentrantLock(true);
        this.available = this.lock.newCondition();
    }

    private double cycle() {
        return this.targetInflight;
    }

    @Override
    public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
        if (this.errorRate.updateAndGet(rate -> rate + (1.0 - rate) / this.cycle()) > this.errorThreshold) {
            return false;
        }
        if (execCount > this.wrapped.retries()) {
            return false;
        }
        switch (request.getMethod().toUpperCase()) {
            case "POST": {
                return this.wrapped.retry(FeedClient.OperationType.put);
            }
            case "PUT": {
                return this.wrapped.retry(FeedClient.OperationType.update);
            }
            case "DELETE": {
                return this.wrapped.retry(FeedClient.OperationType.remove);
            }
        }
        throw new IllegalStateException("Unexpected HTTP method: " + request.getMethod());
    }

    void success() {
        this.errorRate.updateAndGet(rate -> rate - rate / this.cycle());
        this.lock.lock();
        this.targetInflight = Math.min(this.targetInflight + 0.1, (double)this.maxInflight);
        this.lock.unlock();
    }

    @Override
    public boolean retryRequest(HttpResponse response, int execCount, HttpContext context) {
        if (response.getCode() == 429 || response.getCode() == 503) {
            this.lock.lock();
            this.targetInflight = Math.max(100L, 99L * this.inflight / 100L);
            this.lock.unlock();
            return true;
        }
        return false;
    }

    @Override
    public TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
        return TimeValue.ofMilliseconds(100L);
    }

    void acquireSlot() {
        this.lock.lock();
        try {
            while ((double)this.inflight >= this.targetInflight) {
                this.available.awaitUninterruptibly();
            }
            ++this.inflight;
        }
        finally {
            this.lock.unlock();
        }
    }

    void releaseSlot() {
        this.lock.lock();
        try {
            --this.inflight;
            if ((double)this.inflight < this.targetInflight) {
                this.available.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasFailed() {
        return this.errorRate.get() > this.errorThreshold;
    }

    @Override
    public CompletableFuture<SimpleHttpResponse> enqueue(DocumentId documentId, Consumer<CompletableFuture<SimpleHttpResponse>> dispatch) {
        this.acquireSlot();
        Consumer<CompletableFuture> safeDispatch = vessel -> {
            try {
                dispatch.accept((CompletableFuture<SimpleHttpResponse>)vessel);
            }
            catch (Throwable t) {
                vessel.completeExceptionally(t);
            }
        };
        CompletableFuture vessel2 = new CompletableFuture();
        this.byId.compute(documentId, (id, previous) -> {
            if (previous == null) {
                safeDispatch.accept(vessel2);
            } else {
                previous.whenComplete((__, ___) -> safeDispatch.accept(vessel2));
            }
            return vessel2;
        });
        return vessel2.whenComplete((__, thrown) -> {
            this.releaseSlot();
            if (thrown == null) {
                this.success();
            }
            this.byId.compute(documentId, (id, current) -> current == vessel2 ? null : current);
        });
    }
}

