/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class OperationParameters {
    static final OperationParameters empty = new OperationParameters(false, null, null, null, 0);
    private final boolean create;
    private final String condition;
    private final Duration timeout;
    private final String route;
    private final int tracelevel;

    private OperationParameters(boolean create, String condition, Duration timeout, String route, int tracelevel) {
        this.create = create;
        this.condition = condition;
        this.timeout = timeout;
        this.route = route;
        this.tracelevel = tracelevel;
    }

    public static OperationParameters empty() {
        return empty;
    }

    public OperationParameters createIfNonExistent(boolean create) {
        return new OperationParameters(create, this.condition, this.timeout, this.route, this.tracelevel);
    }

    public OperationParameters testAndSetCondition(String condition) {
        if (condition.isEmpty()) {
            throw new IllegalArgumentException("TestAndSetCondition must be non-empty");
        }
        return new OperationParameters(this.create, condition, this.timeout, this.route, this.tracelevel);
    }

    public OperationParameters timeout(Duration timeout) {
        if (timeout.isNegative() || timeout.isZero()) {
            throw new IllegalArgumentException("Timeout must be positive, but was " + timeout);
        }
        return new OperationParameters(this.create, this.condition, timeout, this.route, this.tracelevel);
    }

    public OperationParameters route(String route) {
        if (route.isEmpty()) {
            throw new IllegalArgumentException("Route must be non-empty");
        }
        return new OperationParameters(this.create, this.condition, this.timeout, route, this.tracelevel);
    }

    public OperationParameters tracelevel(int tracelevel) {
        if (tracelevel < 1 || tracelevel > 9) {
            throw new IllegalArgumentException("Tracelevel must be in [1, 9]");
        }
        return new OperationParameters(this.create, this.condition, this.timeout, this.route, tracelevel);
    }

    public boolean createIfNonExistent() {
        return this.create;
    }

    public Optional<String> testAndSetCondition() {
        return Optional.ofNullable(this.condition);
    }

    public Optional<Duration> timeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Optional<String> route() {
        return Optional.ofNullable(this.route);
    }

    public OptionalInt tracelevel() {
        return this.tracelevel == 0 ? OptionalInt.empty() : OptionalInt.of(this.tracelevel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationParameters that = (OperationParameters)o;
        return this.create == that.create && this.tracelevel == that.tracelevel && Objects.equals(this.condition, that.condition) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.route, that.route);
    }

    public int hashCode() {
        return Objects.hash(this.create, this.condition, this.timeout, this.route, this.tracelevel);
    }

    public String toString() {
        return "OperationParameters{create=" + this.create + ", condition='" + this.condition + "', timeout=" + this.timeout + ", route='" + this.route + "', tracelevel=" + this.tracelevel + "}";
    }
}

