/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.FeedException;
import ai.vespa.feed.client.MultiFeedException;
import ai.vespa.feed.client.Result;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class Helper {
    private static final AtomicReference<Supplier<FeedClientBuilder>> feedClientBuilderSupplier = new AtomicReference<Supplier<FeedClientBuilder>>(Helper::getFeedClientBuilder);

    static final void setFeedClientBuilderSupplier(Supplier<FeedClientBuilder> supplier) {
        feedClientBuilderSupplier.set(supplier);
    }

    static Supplier<FeedClientBuilder> getFeedClientBuilderSupplier() {
        return feedClientBuilderSupplier.get();
    }

    static FeedClientBuilder getFeedClientBuilder() {
        String defaultImplementation = "ai.vespa.feed.client.impl.FeedClientBuilderImpl";
        String preferredImplementation = System.getProperty("vespa.feed.client.builder.implementation", defaultImplementation);
        Iterator<FeedClientBuilder> iterator = ServiceLoader.load(FeedClientBuilder.class).iterator();
        if (iterator.hasNext()) {
            ArrayList builders = new ArrayList();
            iterator.forEachRemaining(builders::add);
            return builders.stream().filter(builder -> preferredImplementation.equals(builder.getClass().getName())).findFirst().orElse((FeedClientBuilder)builders.get(0));
        }
        try {
            Class<?> aClass = Class.forName(preferredImplementation);
            for (Constructor<?> constructor : aClass.getConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                return (FeedClientBuilder)constructor.newInstance(new Object[0]);
            }
            throw new RuntimeException("Could not find Feed client builder implementation");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Helper() {
    }

    @SafeVarargs
    static List<Result> await(CompletableFuture<Result> ... promises) throws MultiFeedException {
        ArrayList<CompletableFuture<Result>> list = new ArrayList<CompletableFuture<Result>>();
        for (CompletableFuture<Result> p : promises) {
            list.add(p);
        }
        return Helper.await(list);
    }

    static List<Result> await(List<CompletableFuture<Result>> promises) throws MultiFeedException {
        try {
            CompletableFuture.allOf(promises.toArray(new CompletableFuture[0])).join();
            return promises.stream().map(p -> Objects.requireNonNull(p.getNow(null))).collect(Collectors.toList());
        }
        catch (CompletionException e) {
            ArrayList<FeedException> exceptions = new ArrayList<FeedException>();
            for (CompletableFuture<Result> promise : promises) {
                if (!promise.isCompletedExceptionally()) continue;
                promise.whenComplete((__, error) -> exceptions.add((FeedException)error));
            }
            throw new MultiFeedException(exceptions);
        }
    }
}

