/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.Helper;
import java.net.URI;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public interface FeedClientBuilder {
    public static final String PREFERRED_IMPLEMENTATION_PROPERTY = "vespa.feed.client.builder.implementation";

    public static FeedClientBuilder create(URI endpoint) {
        return FeedClientBuilder.create(Collections.singletonList(endpoint));
    }

    public static FeedClientBuilder create(List<URI> endpoints) {
        return Helper.getFeedClientBuilderSupplier().get().setEndpointUris(endpoints);
    }

    public static void setFeedClientBuilderSupplier(Supplier<FeedClientBuilder> supplier) {
        Helper.setFeedClientBuilderSupplier(supplier);
    }

    public FeedClientBuilder setConnectionsPerEndpoint(int var1);

    public FeedClientBuilder setMaxStreamPerConnection(int var1);

    public FeedClientBuilder setSslContext(SSLContext var1);

    public FeedClientBuilder setHostnameVerifier(HostnameVerifier var1);

    public FeedClientBuilder noBenchmarking();

    public FeedClientBuilder addRequestHeader(String var1, String var2);

    public FeedClientBuilder addRequestHeader(String var1, Supplier<String> var2);

    public FeedClientBuilder setRetryStrategy(FeedClient.RetryStrategy var1);

    public FeedClientBuilder setCircuitBreaker(FeedClient.CircuitBreaker var1);

    public FeedClientBuilder setCertificate(Path var1, Path var2);

    public FeedClientBuilder setCertificate(Collection<X509Certificate> var1, PrivateKey var2);

    public FeedClientBuilder setCertificate(X509Certificate var1, PrivateKey var2);

    public FeedClientBuilder setDryrun(boolean var1);

    public FeedClientBuilder setCaCertificatesFile(Path var1);

    public FeedClientBuilder setCaCertificates(Collection<X509Certificate> var1);

    public FeedClientBuilder setEndpointUris(List<URI> var1);

    public FeedClient build();
}

