/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.FeedClient;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public interface FeedClientBuilder {
    public static FeedClientBuilder create(URI endpoint) {
        return FeedClientBuilder.create(Collections.singletonList(endpoint));
    }

    public static FeedClientBuilder create(List<URI> endpoints) {
        Iterator<FeedClientBuilder> iterator = ServiceLoader.load(FeedClientBuilder.class).iterator();
        if (iterator.hasNext()) {
            return iterator.next().setEndpointUris(endpoints);
        }
        try {
            Class<?> aClass = Class.forName("ai.vespa.feed.client.impl.FeedClientBuilderImpl");
            for (Constructor<?> constructor : aClass.getConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                return ((FeedClientBuilder)constructor.newInstance(new Object[0])).setEndpointUris(endpoints);
            }
            throw new RuntimeException("Could not find Feed client builder implementation");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public FeedClientBuilder setConnectionsPerEndpoint(int var1);

    public FeedClientBuilder setMaxStreamPerConnection(int var1);

    public FeedClientBuilder setSslContext(SSLContext var1);

    public FeedClientBuilder setHostnameVerifier(HostnameVerifier var1);

    public FeedClientBuilder noBenchmarking();

    public FeedClientBuilder addRequestHeader(String var1, String var2);

    public FeedClientBuilder addRequestHeader(String var1, Supplier<String> var2);

    public FeedClientBuilder setRetryStrategy(FeedClient.RetryStrategy var1);

    public FeedClientBuilder setCircuitBreaker(FeedClient.CircuitBreaker var1);

    public FeedClientBuilder setCertificate(Path var1, Path var2);

    public FeedClientBuilder setCertificate(Collection<X509Certificate> var1, PrivateKey var2);

    public FeedClientBuilder setCertificate(X509Certificate var1, PrivateKey var2);

    public FeedClientBuilder setDryrun(boolean var1);

    public FeedClientBuilder setCaCertificatesFile(Path var1);

    public FeedClientBuilder setCaCertificates(Collection<X509Certificate> var1);

    public FeedClientBuilder setEndpointUris(List<URI> var1);

    public FeedClient build();
}

