/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa;

import com.yahoo.collections.Pair;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.documentmodel.OwnedStructDataType;
import com.yahoo.documentmodel.VespaDocumentType;
import com.yahoo.schema.ApplicationBuilder;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.FieldSet;
import com.yahoo.schema.parser.ParseException;
import com.yahoo.vespa.Annotation;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="document-gen", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class DocumentGenMojo
extends AbstractMojo {
    private long newestModifiedTime = 0L;
    private static final int STD_INDENT = 4;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue=".", required=true)
    private File schemasDirectory;
    @Parameter(defaultValue="com.yahoo.vespa.document", required=true)
    private String packageName;
    @Parameter
    private List<Annotation> provided = new ArrayList<Annotation>();
    @Parameter
    private List<Annotation> abztract = new ArrayList<Annotation>();
    @Parameter(property="plugin.configuration.outputDirectory", defaultValue="${project.build.directory}/generated-sources/vespa-documentgen-plugin/", required=true)
    private File outputDirectory;
    private Map<String, Schema> searches;
    private Map<String, String> docTypes;
    private Map<String, String> structTypes;
    private Map<String, String> annotationTypes;

    void execute(File schemasDir, File outputDir, String packageName) {
        if ("".equals(packageName)) {
            throw new IllegalArgumentException("You may not use empty package for generated types.");
        }
        this.searches = new HashMap<String, Schema>();
        this.docTypes = new HashMap<String, String>();
        this.structTypes = new HashMap<String, String>();
        this.annotationTypes = new HashMap<String, String>();
        outputDir.mkdirs();
        ApplicationBuilder builder = this.buildSearches(schemasDir);
        boolean annotationsExported = false;
        for (NewDocumentType docType : builder.getModel().getDocumentManager().getTypes()) {
            if (docType == VespaDocumentType.INSTANCE) continue;
            this.exportDocumentSources(outputDir, docType, packageName);
            for (AnnotationType annotationType : docType.getAllAnnotations()) {
                if (this.provided(annotationType.getName()) != null) continue;
                annotationsExported = true;
                this.exportAnnotationSources(outputDir, annotationType, docType, packageName);
            }
        }
        this.exportPackageInfo(outputDir, packageName);
        if (annotationsExported) {
            this.exportPackageInfo(outputDir, packageName + ".annotation");
        }
        this.exportDocFactory(outputDir, packageName);
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.outputDirectory.toString());
        }
    }

    private ApplicationBuilder buildSearches(File sdDir) {
        File[] sdFiles = sdDir.listFiles((dir, name) -> name.endsWith(".sd"));
        ApplicationBuilder builder = new ApplicationBuilder(true);
        for (File f : sdFiles) {
            try {
                long modTime = f.lastModified();
                if (modTime > this.newestModifiedTime) {
                    this.newestModifiedTime = modTime;
                }
                builder.addSchemaFile(f.getAbsolutePath());
            }
            catch (ParseException | IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        builder.build(true);
        for (Schema schema : builder.getSchemaList()) {
            this.searches.put(schema.getName(), schema);
        }
        return builder;
    }

    private void exportPackageInfo(File outputDir, String packageName) {
        File dirForSources = new File(outputDir, packageName.replaceAll("\\.", "/"));
        dirForSources.mkdirs();
        File target = new File(dirForSources, "package-info.java");
        if (target.lastModified() > this.newestModifiedTime) {
            this.getLog().debug((CharSequence)("No changes, not updating " + String.valueOf(target)));
            return;
        }
        try (FileWriter out = new FileWriter(target);){
            out.write("@ExportPackage\npackage " + packageName + ";\n\nimport com.yahoo.osgi.annotation.ExportPackage;\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String provided(String annotationType) {
        if (this.provided == null) {
            return null;
        }
        for (Annotation a : this.provided) {
            if (!a.type.equals(annotationType)) continue;
            return a.clazz;
        }
        return null;
    }

    private boolean isAbstract(String annotationType) {
        if (this.abztract == null) {
            return false;
        }
        for (Annotation a : this.abztract) {
            if (!a.type.equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    private void exportDocFactory(File outputDir, String packageName) {
        File dirForSources = new File(outputDir, packageName.replaceAll("\\.", "/"));
        dirForSources.mkdirs();
        File target = new File(dirForSources, "ConcreteDocumentFactory.java");
        if (target.lastModified() > this.newestModifiedTime) {
            this.getLog().debug((CharSequence)("No changes, not updating " + String.valueOf(target)));
            return;
        }
        try (FileWriter out = new FileWriter(target);){
            String fullClassName;
            String docTypeName;
            out.write("package " + packageName + ";\n\n/**\n *  Registry of generated concrete document, struct and annotation types.\n *\n *  Generated by vespa-documentgen-plugin, do not edit.\n *  Date: " + String.valueOf(new Date()) + "\n */\n");
            out.write("@com.yahoo.document.Generated\n");
            out.write("@SuppressWarnings({\"deprecation\", \"removal\"})\n");
            out.write("public class ConcreteDocumentFactory extends com.yahoo.docproc.AbstractConcreteDocumentFactory {\n");
            out.write(DocumentGenMojo.ind() + "private static java.util.Map<java.lang.String, java.lang.Class<? extends com.yahoo.document.Document>> dTypes = new java.util.HashMap<java.lang.String, java.lang.Class<? extends com.yahoo.document.Document>>();\n");
            out.write(DocumentGenMojo.ind() + "private static java.util.Map<java.lang.String, com.yahoo.document.DocumentType> docTypes = new java.util.HashMap<>();\n");
            out.write(DocumentGenMojo.ind() + "private static java.util.Map<java.lang.String, java.lang.Class<? extends com.yahoo.document.datatypes.Struct>> sTypes = new java.util.HashMap<java.lang.String, java.lang.Class<? extends com.yahoo.document.datatypes.Struct>>();\n");
            out.write(DocumentGenMojo.ind() + "private static java.util.Map<java.lang.String, java.lang.Class<? extends com.yahoo.document.annotation.Annotation>> aTypes = new java.util.HashMap<java.lang.String, java.lang.Class<? extends com.yahoo.document.annotation.Annotation>>();\n");
            out.write(DocumentGenMojo.ind() + "static {\n");
            for (Map.Entry<String, String> entry : this.docTypes.entrySet()) {
                docTypeName = entry.getKey();
                fullClassName = entry.getValue();
                out.write(DocumentGenMojo.ind(2) + "dTypes.put(\"" + docTypeName + "\"," + fullClassName + ".class);\n");
            }
            for (Map.Entry<String, String> entry : this.docTypes.entrySet()) {
                docTypeName = entry.getKey();
                fullClassName = entry.getValue();
                out.write(DocumentGenMojo.ind(2) + "docTypes.put(\"" + docTypeName + "\"," + fullClassName + ".type);\n");
            }
            for (Map.Entry<String, String> entry : this.structTypes.entrySet()) {
                String structTypeName = entry.getKey();
                fullClassName = entry.getValue();
                out.write(DocumentGenMojo.ind(2) + "sTypes.put(\"" + structTypeName + "\"," + fullClassName + ".class);\n");
            }
            for (Map.Entry<String, String> entry : this.annotationTypes.entrySet()) {
                String annotationTypeName = entry.getKey();
                fullClassName = entry.getValue();
                out.write(DocumentGenMojo.ind(2) + "aTypes.put(\"" + annotationTypeName + "\"," + fullClassName + ".class);\n");
            }
            for (Annotation annotation : this.provided) {
                out.write(DocumentGenMojo.ind(2) + "aTypes.put(\"" + annotation.type + "\"," + annotation.clazz + ".class);\n");
            }
            out.write(DocumentGenMojo.ind() + "}\n\n");
            out.write(DocumentGenMojo.ind() + "public static final java.util.Map<java.lang.String, java.lang.Class<? extends com.yahoo.document.Document>> documentTypes = java.util.Collections.unmodifiableMap(dTypes);\n" + DocumentGenMojo.ind() + "public static final java.util.Map<java.lang.String, com.yahoo.document.DocumentType> documentTypeObjects = java.util.Collections.unmodifiableMap(docTypes);\n" + DocumentGenMojo.ind() + "public static final java.util.Map<java.lang.String, java.lang.Class<? extends com.yahoo.document.datatypes.Struct>> structTypes = java.util.Collections.unmodifiableMap(sTypes);\n" + DocumentGenMojo.ind() + "public static final java.util.Map<java.lang.String, java.lang.Class<? extends com.yahoo.document.annotation.Annotation>> annotationTypes = java.util.Collections.unmodifiableMap(aTypes);\n\n");
            out.write(DocumentGenMojo.ind() + "@Override public java.util.Map<java.lang.String, java.lang.Class<? extends com.yahoo.document.Document>> documentTypes() { return ConcreteDocumentFactory.documentTypes; }\n" + DocumentGenMojo.ind() + "@Override public java.util.Map<java.lang.String, java.lang.Class<? extends com.yahoo.document.datatypes.Struct>> structTypes() { return ConcreteDocumentFactory.structTypes; }\n" + DocumentGenMojo.ind() + "@Override public java.util.Map<java.lang.String, java.lang.Class<? extends com.yahoo.document.annotation.Annotation>> annotationTypes() { return ConcreteDocumentFactory.annotationTypes; }\n\n");
            out.write(DocumentGenMojo.ind() + "/**\n" + DocumentGenMojo.ind() + " * Returns a new Document which will be of the correct concrete type and a copy of the given StructFieldValue.\n" + DocumentGenMojo.ind() + " */\n" + DocumentGenMojo.ind() + "@Override public com.yahoo.document.Document getDocumentCopy(java.lang.String type, com.yahoo.document.datatypes.StructuredFieldValue src, com.yahoo.document.DocumentId id) {\n");
            for (Map.Entry entry : this.docTypes.entrySet()) {
                out.write(DocumentGenMojo.ind(2) + "if (\"" + (String)entry.getKey() + "\".equals(type)) return new " + (String)entry.getValue() + "(src, id);\n");
            }
            out.write(DocumentGenMojo.ind(2) + "throw new java.lang.IllegalArgumentException(\"No such concrete document type: \"+type);\n");
            out.write(DocumentGenMojo.ind() + "}\n\n");
            out.write(DocumentGenMojo.ind() + "/**\n" + DocumentGenMojo.ind() + " * Returns a new Document which will be of the correct concrete type.\n" + DocumentGenMojo.ind() + " */\n" + DocumentGenMojo.ind() + "public static com.yahoo.document.Document getDocument(java.lang.String type, com.yahoo.document.DocumentId id) {\n" + DocumentGenMojo.ind(2) + "if (!ConcreteDocumentFactory.documentTypes.containsKey(type)) throw new java.lang.IllegalArgumentException(\"No such concrete document type: \"+type);\n" + DocumentGenMojo.ind(2) + "try {\n" + DocumentGenMojo.ind(3) + "return ConcreteDocumentFactory.documentTypes.get(type).getConstructor(com.yahoo.document.DocumentId.class).newInstance(id);\n" + DocumentGenMojo.ind(2) + "} catch (java.lang.Exception ex) { throw new java.lang.RuntimeException(ex); }\n" + DocumentGenMojo.ind() + "}\n\n");
            out.write(DocumentGenMojo.ind() + "/**\n" + DocumentGenMojo.ind() + " * Returns a new Struct which will be of the correct concrete type.\n" + DocumentGenMojo.ind() + " */\n" + DocumentGenMojo.ind() + "public static com.yahoo.document.datatypes.Struct getStruct(java.lang.String type) {\n" + DocumentGenMojo.ind(2) + "if (!ConcreteDocumentFactory.structTypes.containsKey(type)) throw new java.lang.IllegalArgumentException(\"No such concrete struct type: \"+type);\n" + DocumentGenMojo.ind(2) + "try {\n" + DocumentGenMojo.ind(3) + "return ConcreteDocumentFactory.structTypes.get(type).getConstructor().newInstance();\n" + DocumentGenMojo.ind(2) + "} catch (java.lang.Exception ex) { throw new java.lang.RuntimeException(ex); }\n" + DocumentGenMojo.ind() + "}\n\n");
            out.write(DocumentGenMojo.ind() + "/**\n" + DocumentGenMojo.ind() + " * Returns a new Annotation which will be of the correct concrete type.\n" + DocumentGenMojo.ind() + " */\n" + DocumentGenMojo.ind() + "public static com.yahoo.document.annotation.Annotation getAnnotation(java.lang.String type) {\n" + DocumentGenMojo.ind(2) + "if (!ConcreteDocumentFactory.annotationTypes.containsKey(type)) throw new java.lang.IllegalArgumentException(\"No such concrete annotation type: \"+type);\n" + DocumentGenMojo.ind(2) + "try {\n" + DocumentGenMojo.ind(3) + "return ConcreteDocumentFactory.annotationTypes.get(type).getConstructor().newInstance();\n" + DocumentGenMojo.ind(2) + "} catch (java.lang.Exception ex) { throw new java.lang.RuntimeException(ex); }\n" + DocumentGenMojo.ind() + "}\n\n");
            out.write("}\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void exportAnnotationSources(File outputDir, AnnotationType annType, NewDocumentType docType, String packageName) {
        File dirForSources = new File(outputDir, packageName.replaceAll("\\.", "/") + "/annotation/");
        dirForSources.mkdirs();
        String className = DocumentGenMojo.className(annType.getName());
        File target = new File(dirForSources, className + ".java");
        if (target.lastModified() > this.newestModifiedTime) {
            this.getLog().debug((CharSequence)("No changes, not updating " + String.valueOf(target)));
            return;
        }
        try (FileWriter out = new FileWriter(target);){
            out.write("package " + packageName + ".annotation;\n\nimport " + packageName + ".ConcreteDocumentFactory;\n" + DocumentGenMojo.exportInnerImportsFromDocAndSuperTypes(docType, packageName) + this.exportImportProvidedAnnotationRefs(annType) + "/**\n *  Generated by vespa-documentgen-plugin, do not edit.\n *  Input annotation type: " + annType.getName() + "\n *  Date: " + String.valueOf(new Date()) + "\n */\n@com.yahoo.document.Generated\n@SuppressWarnings({\"unchecked\",\"deprecation\",\"removal\"})\npublic " + this.annTypeModifier(annType) + "class " + className + " extends " + this.getParentAnnotationType(annType) + " {\n\n");
            if (annType.getDataType() instanceof StructDataType) {
                out.write(DocumentGenMojo.ind() + "public " + className + "() {\n" + DocumentGenMojo.ind(2) + "setType(new com.yahoo.document.annotation.AnnotationType(\"" + annType.getName() + "\", Fields.type));\n" + DocumentGenMojo.ind() + "}\n\n");
                StructDataType annStruct = (StructDataType)annType.getDataType();
                StructDataType annStructTmp = new StructDataType("fields");
                annStructTmp.assign(annStruct);
                ArrayList<DataType> tmpList = new ArrayList<DataType>();
                tmpList.add((DataType)annStructTmp);
                DocumentGenMojo.exportStructTypes(tmpList, out, 1, null);
                DocumentGenMojo.exportFieldsAndAccessors(className, annStruct.getFieldsThisTypeOnly(), out, 1, false);
                out.write(DocumentGenMojo.ind() + "@Override public boolean hasFieldValue() { return true; }\n\n");
                out.write(DocumentGenMojo.ind() + "@Override public com.yahoo.document.datatypes.FieldValue getFieldValue() {\n");
                out.write(DocumentGenMojo.ind(2) + "com.yahoo.document.datatypes.Struct ret = new Fields();\n");
                for (Field f : annStruct.getFields()) {
                    out.write(DocumentGenMojo.ind(2) + "if (" + DocumentGenMojo.getter(f.getName()) + "()!=null) {\n" + DocumentGenMojo.ind(3) + "com.yahoo.document.Field f = ret.getField(\"" + f.getName() + "\");\n" + DocumentGenMojo.ind(3) + "com.yahoo.document.datatypes.FieldValue fv = f.getDataType().createFieldValue(" + DocumentGenMojo.getter(f.getName()) + "());\n" + DocumentGenMojo.ind(3) + "ret.setFieldValue(f, fv);\n" + DocumentGenMojo.ind(2) + "}\n");
                }
                out.write(DocumentGenMojo.ind(2) + "return ret;\n");
                out.write(DocumentGenMojo.ind() + "}\n\n");
            } else {
                out.write(DocumentGenMojo.ind() + "public " + className + "() { setType(new com.yahoo.document.annotation.AnnotationType(\"" + annType.getName() + "\")); } \n\n");
                out.write(DocumentGenMojo.ind() + "@Override public boolean hasFieldValue() { return false; }\n\n");
                out.write(DocumentGenMojo.ind() + "@Override public com.yahoo.document.datatypes.FieldValue getFieldValue() { return null; }\n\n");
            }
            out.write("}\n");
            this.annotationTypes.put(annType.getName(), packageName + ".annotation." + className);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not export sources for annotation type '" + annType.getName() + "'", e);
        }
    }

    private String exportImportProvidedAnnotationRefs(AnnotationType annType) {
        if (annType.getDataType() == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        for (Field f : ((StructDataType)annType.getDataType()).getFields()) {
            AnnotationReferenceDataType refType;
            AnnotationType referenced;
            String providedClass;
            if (!(f.getDataType() instanceof AnnotationReferenceDataType) || (providedClass = this.provided((referenced = (refType = (AnnotationReferenceDataType)f.getDataType()).getAnnotationType()).getName())) == null) continue;
            ret.append("import ").append(providedClass).append(";\n");
        }
        return ret.toString();
    }

    private String annTypeModifier(AnnotationType annType) {
        if (this.isAbstract(annType.getName())) {
            return "abstract ";
        }
        return "";
    }

    private static String exportInnerImportsFromDocAndSuperTypes(NewDocumentType docType, String packageName) {
        Object ret = "";
        ret = (String)ret + "import " + packageName + "." + DocumentGenMojo.className(docType.getName()) + ".*;\n";
        ret = (String)ret + DocumentGenMojo.exportInnerImportsFromSuperTypes(docType, packageName);
        return ret;
    }

    private static String exportInnerImportsFromSuperTypes(NewDocumentType docType, String packageName) {
        StringBuilder ret = new StringBuilder();
        for (NewDocumentType inherited : docType.getInherited()) {
            if (inherited.getName().equals("document")) continue;
            ret.append("import ").append(packageName).append(".").append(DocumentGenMojo.className(inherited.getName())).append(".*;\n");
        }
        return ret.toString();
    }

    private String getParentAnnotationType(AnnotationType annType) {
        if (annType.getInheritedTypes().isEmpty()) {
            return "com.yahoo.document.annotation.Annotation";
        }
        String superType = ((AnnotationType)annType.getInheritedTypes().iterator().next()).getName();
        String providedSuperType = this.provided(superType);
        if (providedSuperType != null) {
            return providedSuperType;
        }
        return DocumentGenMojo.className(((AnnotationType)annType.getInheritedTypes().iterator().next()).getName());
    }

    private void exportDocumentSources(File outputDir, NewDocumentType docType, String packageName) {
        File dirForSources = new File(outputDir, packageName.replaceAll("\\.", "/"));
        dirForSources.mkdirs();
        File target = new File(dirForSources, DocumentGenMojo.className(docType.getName()) + ".java");
        if (target.lastModified() > this.newestModifiedTime) {
            this.getLog().debug((CharSequence)("No changes, not updating " + String.valueOf(target)));
            return;
        }
        try (FileWriter doc = new FileWriter(target);){
            this.exportDocumentClass(docType, doc, packageName);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not export sources for document type '" + docType.getName() + "'", e);
        }
    }

    private void exportDocumentClass(NewDocumentType docType, Writer out, String packageName) throws IOException {
        String className = DocumentGenMojo.className(docType.getName());
        Pair<String, Boolean> extendInfo = DocumentGenMojo.javaSuperType(docType);
        String superType = (String)extendInfo.getFirst();
        boolean multiExtends = (Boolean)extendInfo.getSecond();
        out.write("package " + packageName + ";\n\n" + DocumentGenMojo.exportInnerImportsFromSuperTypes(docType, packageName) + "/**\n *  Generated by vespa-documentgen-plugin, do not edit.\n *  Input document type: " + docType.getName() + "\n *  Date: " + String.valueOf(new Date()) + "\n */\n@com.yahoo.document.Generated\n@SuppressWarnings({\"unchecked\",\"deprecation\",\"removal\"})\npublic class " + className + " extends " + superType + " {\n\n" + DocumentGenMojo.ind(1) + "/** The doc type of this.*/\n" + DocumentGenMojo.ind(1) + "public static final com.yahoo.document.DocumentType type = getDocumentType();\n\n");
        out.write(DocumentGenMojo.ind(1) + "public " + className + "(com.yahoo.document.DocumentId docId) {\n" + DocumentGenMojo.ind(2) + "super(" + className + ".type, docId);\n" + DocumentGenMojo.ind(1) + "}\n\n");
        out.write(DocumentGenMojo.ind(1) + "protected " + className + "(com.yahoo.document.DocumentType type, com.yahoo.document.DocumentId docId) {\n" + DocumentGenMojo.ind(2) + "super(type, docId);\n" + DocumentGenMojo.ind(1) + "}\n\n");
        out.write(DocumentGenMojo.ind(1) + "@Override protected boolean isGenerated() { return true; }\n\n");
        Collection allUniqueFields = this.getAllUniqueFields(multiExtends, docType.getAllFields());
        DocumentGenMojo.exportExtendedStructTypeGetter(className, docType.getName(), docType.getInherited(), allUniqueFields, docType.getFieldSets(), docType.getImportedFieldNames(), out, 1, "getDocumentType", "com.yahoo.document.DocumentType");
        DocumentGenMojo.exportCopyConstructor(className, out, 1, true);
        DocumentGenMojo.exportFieldsAndAccessors(className, "com.yahoo.document.Document".equals(superType) ? allUniqueFields : docType.getFields(), out, 1, true);
        DocumentGenMojo.exportDocumentMethods(allUniqueFields, out, 1);
        DocumentGenMojo.exportHashCode(allUniqueFields, out, 1, "(getDataType() != null ? getDataType().hashCode() : 0) + getId().hashCode()");
        DocumentGenMojo.exportEquals(className, allUniqueFields, out, 1);
        Set<DataType> exportedStructs = DocumentGenMojo.exportStructTypes(docType.getTypes(), out, 1, null);
        if (DocumentGenMojo.hasAnyPositionField(allUniqueFields)) {
            exportedStructs = DocumentGenMojo.exportStructTypes(List.of(PositionDataType.INSTANCE), out, 1, exportedStructs);
        }
        this.docTypes.put(docType.getName(), packageName + "." + className);
        for (DataType exportedStruct : exportedStructs) {
            String fullName = packageName + "." + className + "." + DocumentGenMojo.className(exportedStruct.getName());
            this.structTypes.put(exportedStruct.getName(), fullName);
            if (!(exportedStruct instanceof OwnedStructDataType)) continue;
            OwnedStructDataType owned = (OwnedStructDataType)exportedStruct;
            this.structTypes.put(owned.getUniqueName(), fullName);
        }
        out.write("}\n");
    }

    private static boolean hasAnyPositionDataType(DataType dt) {
        if (PositionDataType.INSTANCE.equals((Object)dt)) {
            return true;
        }
        if (dt instanceof CollectionDataType) {
            return DocumentGenMojo.hasAnyPositionDataType(((CollectionDataType)dt).getNestedType());
        }
        if (dt instanceof StructuredDataType) {
            return DocumentGenMojo.hasAnyPositionField(((StructuredDataType)dt).getFields());
        }
        return false;
    }

    private static boolean hasAnyPositionField(Collection<Field> fields) {
        for (Field f : fields) {
            if (!DocumentGenMojo.hasAnyPositionDataType(f.getDataType())) continue;
            return true;
        }
        return false;
    }

    private Collection<Field> getAllUniqueFields(boolean multipleInheritance, Collection<Field> allFields) {
        HashMap<String, Field> seen = new HashMap<String, Field>();
        for (Field f : allFields) {
            if (seen.containsKey(f.getName()) && multipleInheritance && !f.equals(seen.get(f.getName()))) {
                throw new IllegalArgumentException("Field '" + f.getName() + "' has conflicting definitions in multiple inheritance.First defined as '" + String.valueOf(seen.get(f.getName())) + "', then as '" + String.valueOf(f) + "'.");
            }
            seen.put(f.getName(), f);
        }
        return seen.values();
    }

    private static Pair<String, Boolean> javaSuperType(NewDocumentType docType) {
        String ret = "com.yahoo.document.Document";
        Collection<NewDocumentType> specInheriteds = DocumentGenMojo.specificInheriteds(docType);
        boolean singleExtends = DocumentGenMojo.singleInheritance(specInheriteds);
        if (!specInheriteds.isEmpty() && singleExtends) {
            ret = DocumentGenMojo.className(specInheriteds.iterator().next().getName());
        }
        return new Pair((Object)ret, (Object)(!singleExtends ? 1 : 0));
    }

    private static boolean singleInheritance(Collection<NewDocumentType> specInheriteds) {
        if (specInheriteds.isEmpty()) {
            return true;
        }
        if (specInheriteds.size() > 1) {
            return false;
        }
        return DocumentGenMojo.singleInheritance(DocumentGenMojo.specificInheriteds(specInheriteds.iterator().next()));
    }

    private static Collection<NewDocumentType> specificInheriteds(NewDocumentType type) {
        ArrayList<NewDocumentType> ret = new ArrayList<NewDocumentType>();
        for (NewDocumentType t : type.getInherited()) {
            if ("document".equals(t.getName())) continue;
            ret.add(t);
        }
        return ret;
    }

    private static void exportCopyConstructor(String className, Writer out, int ind, boolean docId) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "/**\n" + DocumentGenMojo.ind(ind) + " * Constructs a " + className + " by taking a deep copy of the provided StructuredFieldValue.\n" + DocumentGenMojo.ind(ind) + " */\n");
        if (docId) {
            out.write(DocumentGenMojo.ind(ind) + "public " + className + "(com.yahoo.document.datatypes.StructuredFieldValue src, com.yahoo.document.DocumentId docId) {\n" + DocumentGenMojo.ind(ind + 1) + "super(" + className + ".type,docId);\n");
        } else {
            out.write(DocumentGenMojo.ind(ind) + "public " + className + "(com.yahoo.document.datatypes.StructuredFieldValue src) {\n" + DocumentGenMojo.ind(ind + 1) + "super(" + className + ".type);\n");
        }
        out.write(DocumentGenMojo.ind(ind + 1) + "ConcreteDocumentFactory factory = new ConcreteDocumentFactory();\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "for (java.util.Iterator<java.util.Map.Entry<com.yahoo.document.Field, com.yahoo.document.datatypes.FieldValue>>i=src.iterator() ; i.hasNext() ; ) {\n" + DocumentGenMojo.ind(ind + 2) + "java.util.Map.Entry<com.yahoo.document.Field, com.yahoo.document.datatypes.FieldValue> e = i.next();\n" + DocumentGenMojo.ind(ind + 2) + "com.yahoo.document.Field f = e.getKey();\n" + DocumentGenMojo.ind(ind + 2) + "com.yahoo.document.datatypes.FieldValue fv = e.getValue();\n" + DocumentGenMojo.ind(ind + 2) + "setFieldValue(f, factory.optionallyUpgrade(f, fv));\n" + DocumentGenMojo.ind(ind + 1) + "}\n" + DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static void addExtendedField(String className, Field f, Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "ret.addField(new com.yahoo.document.ExtendedField(\"" + f.getName() + "\", " + DocumentGenMojo.toJavaReference(f.getDataType()) + ",\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "new com.yahoo.document.ExtendedField.Extract() {\n");
        out.write(DocumentGenMojo.ind(ind + 2) + "public Object get(com.yahoo.document.datatypes.StructuredFieldValue doc) {return ((" + className + ")doc)." + DocumentGenMojo.getter(f.getName()) + "(); }\n");
        out.write(DocumentGenMojo.ind(ind + 2) + "public void set(com.yahoo.document.datatypes.StructuredFieldValue doc, Object value) { ((" + className + ")doc)." + DocumentGenMojo.setter(f.getName()) + "((" + DocumentGenMojo.toJavaType(f.getDataType()) + ")value); }\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "}\n");
        out.write(DocumentGenMojo.ind(ind) + "));\n");
    }

    private static void addExtendedStringField(String className, Field f, Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "ret.addField(new com.yahoo.document.ExtendedStringField(\"" + f.getName() + "\", " + DocumentGenMojo.toJavaReference(f.getDataType()) + ",\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "new com.yahoo.document.ExtendedField.Extract() {\n");
        out.write(DocumentGenMojo.ind(ind + 2) + "public Object get(com.yahoo.document.datatypes.StructuredFieldValue doc) {return ((" + className + ")doc)." + DocumentGenMojo.getter(f.getName()) + "(); }\n");
        out.write(DocumentGenMojo.ind(ind + 2) + "public void set(com.yahoo.document.datatypes.StructuredFieldValue doc, Object value) { ((" + className + ")doc)." + DocumentGenMojo.setter(f.getName()) + "((" + DocumentGenMojo.toJavaType(f.getDataType()) + ")value); }\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "},\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "new com.yahoo.document.ExtendedStringField.ExtractSpanTrees() {\n");
        out.write(DocumentGenMojo.ind(ind + 2) + "@SuppressWarnings({\"deprecation\", \"removal\"})\n");
        out.write(DocumentGenMojo.ind(ind + 2) + "public java.util.Map<java.lang.String,com.yahoo.document.annotation.SpanTree> get(com.yahoo.document.datatypes.StructuredFieldValue doc) {return ((" + className + ")doc)." + DocumentGenMojo.spanTreeGetter(f.getName()) + "(); }\n");
        out.write(DocumentGenMojo.ind(ind + 2) + "@SuppressWarnings({\"deprecation\", \"removal\"})\n");
        out.write(DocumentGenMojo.ind(ind + 2) + "public void set(com.yahoo.document.datatypes.StructuredFieldValue doc, java.util.Map<java.lang.String,com.yahoo.document.annotation.SpanTree> value) { ((" + className + ")doc)." + DocumentGenMojo.spanTreeSetter(f.getName()) + "(value); }\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "}\n");
        out.write(DocumentGenMojo.ind(ind) + "));\n");
    }

    private static void exportFieldSetDefinition(Set<FieldSet> fieldSets, Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "java.util.Map<java.lang.String, java.util.Collection<java.lang.String>> fieldSets = new java.util.HashMap<>();\n");
        for (FieldSet fieldSet : fieldSets) {
            out.write(DocumentGenMojo.ind(ind) + "fieldSets.put(\"" + fieldSet.getName() + "\", java.util.List.of(");
            int count = 0;
            for (String field : fieldSet.getFieldNames()) {
                out.write("\"" + field + "\"");
                if (++count == fieldSet.getFieldNames().size()) continue;
                out.write(",");
            }
            out.write("));\n");
        }
        out.write(DocumentGenMojo.ind(ind) + "ret.addFieldSets(fieldSets);\n");
    }

    private static void exportImportedFields(Set<String> importedFieldNames, Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "java.util.Set<java.lang.String> importedFieldNames = new java.util.HashSet<>();\n");
        for (String importedField : importedFieldNames) {
            out.write(DocumentGenMojo.ind(ind) + "importedFieldNames.add(\"" + importedField + "\");\n");
        }
    }

    private static void exportExtendedStructTypeGetter(String className, String name, Collection<NewDocumentType> parentTypes, Collection<Field> fields, Set<FieldSet> fieldSets, Set<String> importedFieldNames, Writer out, int ind, String methodName, String retType) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "private static " + retType + " " + methodName + "() {\n");
        String bodyIndent = DocumentGenMojo.ind(ind + 1);
        if (importedFieldNames != null) {
            DocumentGenMojo.exportImportedFields(importedFieldNames, out, ind + 1);
            out.write(bodyIndent + retType + " ret = new " + retType + "(\"" + name + "\", importedFieldNames);\n");
        } else {
            out.write(bodyIndent + retType + " ret = new " + retType + "(\"" + name + "\");\n");
        }
        for (Field f : fields) {
            if (f.getDataType().equals((Object)DataType.STRING)) {
                DocumentGenMojo.addExtendedStringField(className, f, out, ind + 1);
                continue;
            }
            DocumentGenMojo.addExtendedField(className, f, out, ind + 1);
        }
        if (fieldSets != null) {
            DocumentGenMojo.exportFieldSetDefinition(fieldSets, out, ind + 1);
        }
        for (NewDocumentType parentType : parentTypes) {
            if (parentType.getName().equals("document")) continue;
            out.write("%sret.inherit(%s.type);\n".formatted(bodyIndent, DocumentGenMojo.className(parentType.getName())));
        }
        out.write(bodyIndent + "return ret;\n");
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static void exportDocumentMethods(Collection<Field> fieldSet, Writer out, int ind) throws IOException {
        DocumentGenMojo.exportGetFieldCount(fieldSet, out, ind);
        DocumentGenMojo.exportGetField(out, ind);
        DocumentGenMojo.exportGetFieldValue(fieldSet, out, ind);
        DocumentGenMojo.exportSetFieldValue(out, ind);
        DocumentGenMojo.exportRemoveFieldValue(out, ind);
        DocumentGenMojo.exportIterator(fieldSet, out, ind);
        DocumentGenMojo.exportClear(fieldSet, out, ind);
    }

    private static void exportEquals(String className, Collection<Field> fieldSet, Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "@Override public boolean equals(Object o) {\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "if (!(o instanceof " + className + ")) return false;\n");
        out.write(DocumentGenMojo.ind(ind + 1) + className + " other = (" + className + ")o;\n");
        for (Field field : fieldSet) {
            out.write(DocumentGenMojo.ind(ind + 1) + "if (" + DocumentGenMojo.getter(field.getName()) + "()==null) { if (other." + DocumentGenMojo.getter(field.getName()) + "()!=null) return false; }\n");
            out.write(DocumentGenMojo.ind(ind + 2) + "else if (!(" + DocumentGenMojo.getter(field.getName()) + "().equals(other." + DocumentGenMojo.getter(field.getName()) + "()))) return false;\n");
        }
        out.write(DocumentGenMojo.ind(ind + 1) + "return true;\n");
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static void exportHashCode(Collection<Field> fieldSet, Writer out, int ind, String hcBase) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "@Override public int hashCode() {\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "int hc = " + hcBase + ";\n");
        for (Field field : fieldSet) {
            out.write(DocumentGenMojo.ind(ind + 1) + "hc += " + DocumentGenMojo.getter(field.getName()) + "()!=null ? " + DocumentGenMojo.getter(field.getName()) + "().hashCode() : 0;\n");
        }
        out.write(DocumentGenMojo.ind(ind + 1) + "return hc;\n");
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static void exportClear(Collection<Field> fieldSet, Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "@Override public void clear() {\n");
        for (Field field : fieldSet) {
            out.write(DocumentGenMojo.ind(ind + 1) + DocumentGenMojo.setter(field.getName()) + "(null);\n");
        }
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static void exportIterator(Collection<Field> fieldSet, Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "@Override public java.util.Iterator<java.util.Map.Entry<com.yahoo.document.Field, com.yahoo.document.datatypes.FieldValue>> iterator() {\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "java.util.Map<com.yahoo.document.Field, com.yahoo.document.datatypes.FieldValue> ret = new java.util.HashMap<>();\n");
        for (Field field : fieldSet) {
            String name = field.getName();
            out.write(DocumentGenMojo.ind(ind + 1) + "if (" + DocumentGenMojo.getter(name) + "()!=null) {\n");
            out.write(DocumentGenMojo.ind(ind + 2) + "com.yahoo.document.Field f = getField(\"" + name + "\");\n");
            out.write(DocumentGenMojo.ind(ind + 2) + "ret.put(f, ((com.yahoo.document.ExtendedField)f).getFieldValue(this));\n" + DocumentGenMojo.ind(ind + 1) + "}\n");
        }
        out.write(DocumentGenMojo.ind(ind + 1) + "return ret.entrySet().iterator();\n" + DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static void exportRemoveFieldValue(Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "@Override public com.yahoo.document.datatypes.FieldValue removeFieldValue(com.yahoo.document.Field field) {\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "if (field==null) return null;\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "com.yahoo.document.ExtendedField ef = ensureExtended(field);\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "return (ef != null) ? ef.setFieldValue(this, null) : super.removeFieldValue(field);\n");
        out.write(DocumentGenMojo.ind(ind) + "}\n");
    }

    private static void exportSetFieldValue(Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "@Override public com.yahoo.document.datatypes.FieldValue setFieldValue(com.yahoo.document.Field field, com.yahoo.document.datatypes.FieldValue value) {\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "com.yahoo.document.ExtendedField ef = ensureExtended(field);\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "return (ef != null) ? ef.setFieldValue(this, value) : super.setFieldValue(field, value);\n");
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static void exportGetFieldValue(Collection<Field> fieldSet, Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "@Override public com.yahoo.document.datatypes.FieldValue getFieldValue(com.yahoo.document.Field field) {\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "if (field==null) return null;\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "if (field.getDataType() instanceof com.yahoo.document.StructDataType) {\n");
        for (Field field : fieldSet) {
            String name = field.getName();
            if (!(field.getDataType() instanceof StructDataType)) continue;
            out.write(DocumentGenMojo.ind(ind + 2) + "if (\"" + name + "\".equals(field.getName())) return " + name + ";\n");
        }
        out.write(DocumentGenMojo.ind(ind + 1) + "}\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "com.yahoo.document.ExtendedField ef = ensureExtended(field);\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "return (ef != null) ? ef.getFieldValue(this) : super.getFieldValue(field);\n");
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static void exportGetField(Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "private com.yahoo.document.ExtendedStringField ensureExtendedString(com.yahoo.document.Field f) {\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "return (com.yahoo.document.ExtendedStringField)((f instanceof com.yahoo.document.ExtendedStringField) ? f : getField(f.getName()));\n");
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
        out.write(DocumentGenMojo.ind(ind) + "private com.yahoo.document.ExtendedField ensureExtended(com.yahoo.document.Field f) {\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "return (com.yahoo.document.ExtendedField)((f instanceof com.yahoo.document.ExtendedField) ? f : getField(f.getName()));\n");
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
        out.write(DocumentGenMojo.ind(ind) + "@Override public com.yahoo.document.Field getField(String fieldName) {\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "if (fieldName==null) return null;\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "return type.getField(fieldName);\n");
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static Set<DataType> exportStructTypes(Collection<DataType> fields, Writer out, int ind, Set<DataType> exportedStructs) throws IOException {
        if (exportedStructs == null) {
            exportedStructs = new HashSet<DataType>();
        }
        for (DataType f : fields) {
            if (!(f instanceof StructDataType) || f.getName().contains(".") || exportedStructs.contains(f)) continue;
            exportedStructs.add(f);
            StructDataType structType = (StructDataType)f;
            String structClassName = DocumentGenMojo.className(structType.getName());
            out.write(DocumentGenMojo.ind(ind) + "/**\n" + DocumentGenMojo.ind(ind) + " *  Generated by vespa-documentgen-plugin, do not edit.\n" + DocumentGenMojo.ind(ind) + " *  Input struct type: " + structType.getName() + "\n" + DocumentGenMojo.ind(ind) + " *  Date: " + String.valueOf(new Date()) + "\n" + DocumentGenMojo.ind(ind) + " */\n" + DocumentGenMojo.ind(ind) + "@com.yahoo.document.Generated\n" + DocumentGenMojo.ind(ind) + "@SuppressWarnings({\"unchecked\",\"deprecation\",\"removal\"})\n" + DocumentGenMojo.ind(ind) + "public static class " + structClassName + " extends com.yahoo.document.datatypes.Struct {\n\n" + DocumentGenMojo.ind(ind + 1) + "/** The type of this.*/\n" + DocumentGenMojo.ind(ind + 1) + "public static final com.yahoo.document.StructDataType type = getStructType();\n\n");
            out.write(DocumentGenMojo.ind(ind + 1) + "public " + structClassName + "() {\n" + DocumentGenMojo.ind(ind + 2) + "super(" + structClassName + ".type);\n" + DocumentGenMojo.ind(ind + 1) + "}\n\n");
            DocumentGenMojo.exportCopyConstructor(structClassName, out, ind + 1, false);
            DocumentGenMojo.exportExtendedStructTypeGetter(structClassName, structType.getName(), List.of(), structType.getFields(), null, null, out, ind + 1, "getStructType", "com.yahoo.document.StructDataType");
            DocumentGenMojo.exportAssign(structType, structClassName, out, ind + 1);
            DocumentGenMojo.exportFieldsAndAccessors(structClassName, structType.getFields(), out, ind + 1, true);
            DocumentGenMojo.exportGetFields(structType.getFields(), out, ind + 1);
            DocumentGenMojo.exportDocumentMethods(structType.getFields(), out, ind + 1);
            DocumentGenMojo.exportHashCode(structType.getFields(), out, ind + 1, "(getDataType() != null ? getDataType().hashCode() : 0)");
            DocumentGenMojo.exportEquals(structClassName, structType.getFields(), out, ind + 1);
            out.write(DocumentGenMojo.ind(ind) + "}\n\n");
        }
        return exportedStructs;
    }

    private static void exportGetFieldCount(Collection<Field> fields, Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "@Override public int getFieldCount() {\n");
        out.write(DocumentGenMojo.ind(ind + 1) + "int ret=0;\n");
        for (Field f : fields) {
            out.write(DocumentGenMojo.ind(ind + 1) + "if (" + DocumentGenMojo.getter(f.getName()) + "()!=null) ret++;\n");
        }
        out.write(DocumentGenMojo.ind(ind + 1) + "return ret;\n");
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static void exportGetFields(Collection<Field> fields, Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "@Override public java.util.Set<java.util.Map.Entry<com.yahoo.document.Field, com.yahoo.document.datatypes.FieldValue>> getFields() {\n" + DocumentGenMojo.ind(ind + 1) + "java.util.Map<com.yahoo.document.Field, com.yahoo.document.datatypes.FieldValue> ret = new java.util.LinkedHashMap<com.yahoo.document.Field, com.yahoo.document.datatypes.FieldValue>();\n");
        for (Field f : fields) {
            out.write(DocumentGenMojo.ind(ind + 1) + "if (" + DocumentGenMojo.getter(f.getName()) + "()!=null) {\n");
            out.write(DocumentGenMojo.ind(ind + 2) + "com.yahoo.document.Field f = getField(\"" + f.getName() + "\");\n");
            out.write(DocumentGenMojo.ind(ind + 2) + "ret.put(f, ((com.yahoo.document.ExtendedField)f).getFieldValue(this));\n");
            out.write(DocumentGenMojo.ind(ind + 1) + "}\n");
        }
        out.write(DocumentGenMojo.ind(ind + 1) + "return ret.entrySet();\n");
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static void exportAssign(StructDataType structType, String structClassName, Writer out, int ind) throws IOException {
        out.write(DocumentGenMojo.ind(ind) + "@Override public void assign(Object o) {\n" + DocumentGenMojo.ind(ind + 1) + "if (!(o instanceof " + structClassName + ")) { super.assign(o); return; }\n" + DocumentGenMojo.ind(ind + 1) + structClassName + " other = (" + structClassName + ")o;\n");
        for (Field f : structType.getFields()) {
            out.write(DocumentGenMojo.ind(ind + 1) + DocumentGenMojo.setter(f.getName()) + "(other." + DocumentGenMojo.getter(f.getName()) + "());\n");
        }
        out.write(DocumentGenMojo.ind(ind) + "}\n\n");
    }

    private static void exportFieldsAndAccessors(String className, Collection<Field> fields, Writer out, int ind, boolean spanTrees) throws IOException {
        DataType dt;
        for (Field field : fields) {
            dt = field.getDataType();
            out.write(DocumentGenMojo.ind(ind) + DocumentGenMojo.toJavaType(dt) + " " + field.getName() + ";\n");
            if (!spanTrees || !dt.equals((Object)DataType.STRING)) continue;
            out.write(DocumentGenMojo.ind(ind) + "java.util.Map<java.lang.String,com.yahoo.document.annotation.SpanTree> " + DocumentGenMojo.spanTreeGetter(field.getName()) + ";\n");
        }
        out.write(DocumentGenMojo.ind(ind) + "\n");
        for (Field field : fields) {
            dt = field.getDataType();
            out.write(DocumentGenMojo.ind(ind) + "public " + DocumentGenMojo.toJavaType(dt) + " " + DocumentGenMojo.getter(field.getName()) + "() { return " + field.getName() + "; }\n" + DocumentGenMojo.ind(ind) + "public " + className + " " + DocumentGenMojo.setter(field.getName()) + "(" + DocumentGenMojo.toJavaType(dt) + " " + field.getName() + ") {\n" + DocumentGenMojo.validateArgument(field.getDataType(), field.getName(), ind + 1) + DocumentGenMojo.ind(ind + 1) + "this." + field.getName() + "=" + field.getName() + ";\n" + DocumentGenMojo.ind(ind + 1) + "return this;\n" + DocumentGenMojo.ind(ind) + "}\n");
            if (!spanTrees || !dt.equals((Object)DataType.STRING)) continue;
            out.write(DocumentGenMojo.ind(ind) + "@Deprecated(forRemoval = true)\n" + DocumentGenMojo.ind(ind) + "public java.util.Map<java.lang.String,com.yahoo.document.annotation.SpanTree> " + DocumentGenMojo.spanTreeGetter(field.getName()) + "() { return " + field.getName() + "SpanTrees; }\n" + DocumentGenMojo.ind(ind) + "@Deprecated(forRemoval = true)\n" + DocumentGenMojo.ind(ind) + "public void " + DocumentGenMojo.spanTreeSetter(field.getName()) + "(java.util.Map<java.lang.String,com.yahoo.document.annotation.SpanTree> spanTrees) { this." + field.getName() + "SpanTrees=spanTrees; }\n");
        }
        out.write("\n");
    }

    private static String validateArgument(DataType type, String variable, int ind) {
        if (type instanceof MapDataType) {
            MapDataType mdt = (MapDataType)type;
            return DocumentGenMojo.validateWrapped(mdt.getKeyType(), variable, variable + ".keySet()", ind) + DocumentGenMojo.validateWrapped(mdt.getValueType(), variable, variable + ".values()", ind);
        }
        if (type instanceof CollectionDataType) {
            CollectionDataType cdt = (CollectionDataType)type;
            Object elements = cdt instanceof WeightedSetDataType ? variable + ".keySet()" : variable;
            return DocumentGenMojo.validateWrapped(cdt.getNestedType(), variable, (String)elements, ind);
        }
        if (DataType.STRING.equals((Object)type) || DataType.URI.equals((Object)type) || type instanceof AnnotationReferenceDataType || type instanceof NewDocumentReferenceDataType) {
            return DocumentGenMojo.ind(ind) + "if (" + variable + " != null) {\n" + DocumentGenMojo.ind(ind + 1) + DocumentGenMojo.toJavaReference(type) + ".createFieldValue(" + variable + ");\n" + DocumentGenMojo.ind(ind) + "}\n";
        }
        return "";
    }

    private static String validateWrapped(DataType type, String variable, String elements, int ind) {
        String wrappedValidation = DocumentGenMojo.validateArgument(type, variable + "$", ind + 2);
        if (wrappedValidation.isBlank()) {
            return "";
        }
        return DocumentGenMojo.ind(ind) + "if (" + variable + " != null) {\n" + DocumentGenMojo.ind(ind + 1) + "for (" + DocumentGenMojo.toJavaType(type) + " " + variable + "$ : " + elements + ") {\n" + wrappedValidation + DocumentGenMojo.ind(ind + 1) + "}\n" + DocumentGenMojo.ind(ind) + "}\n";
    }

    private static String spanTreeSetter(String field) {
        return DocumentGenMojo.setter(field) + "SpanTrees";
    }

    private static String spanTreeGetter(String field) {
        return field + "SpanTrees";
    }

    private static String ind(int levels) {
        int indent = levels * 4;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static String ind() {
        return DocumentGenMojo.ind(1);
    }

    private static String getter(String field) {
        return "get" + DocumentGenMojo.upperCaseFirstChar(field);
    }

    private static String setter(String field) {
        return "set" + DocumentGenMojo.upperCaseFirstChar(field);
    }

    private static String className(String field) {
        return DocumentGenMojo.upperCaseFirstChar(field);
    }

    private static String toJavaType(DataType dt) {
        if (DataType.NONE.equals((Object)dt)) {
            return "void";
        }
        if (DataType.INT.equals((Object)dt)) {
            return "java.lang.Integer";
        }
        if (DataType.FLOAT.equals((Object)dt)) {
            return "java.lang.Float";
        }
        if (DataType.STRING.equals((Object)dt)) {
            return "java.lang.String";
        }
        if (DataType.RAW.equals((Object)dt)) {
            return "java.nio.ByteBuffer";
        }
        if (DataType.LONG.equals((Object)dt)) {
            return "java.lang.Long";
        }
        if (DataType.DOUBLE.equals((Object)dt)) {
            return "java.lang.Double";
        }
        if (DataType.DOCUMENT.equals((Object)dt)) {
            return "com.yahoo.document.Document";
        }
        if (DataType.URI.equals((Object)dt)) {
            return "java.net.URI";
        }
        if (DataType.BYTE.equals((Object)dt)) {
            return "java.lang.Byte";
        }
        if (DataType.BOOL.equals((Object)dt)) {
            return "java.lang.Boolean";
        }
        if (DataType.TAG.equals((Object)dt)) {
            return "java.lang.String";
        }
        if (dt instanceof StructDataType) {
            return DocumentGenMojo.className(dt.getName());
        }
        if (dt instanceof WeightedSetDataType) {
            WeightedSetDataType wdt = (WeightedSetDataType)dt;
            return "java.util.Map<" + DocumentGenMojo.toJavaType(wdt.getNestedType()) + ",java.lang.Integer>";
        }
        if (dt instanceof ArrayDataType) {
            ArrayDataType adt = (ArrayDataType)dt;
            return "java.util.List<" + DocumentGenMojo.toJavaType(adt.getNestedType()) + ">";
        }
        if (dt instanceof MapDataType) {
            MapDataType mdt = (MapDataType)dt;
            return "java.util.Map<" + DocumentGenMojo.toJavaType(mdt.getKeyType()) + "," + DocumentGenMojo.toJavaType(mdt.getValueType()) + ">";
        }
        if (dt instanceof AnnotationReferenceDataType) {
            AnnotationReferenceDataType ardt = (AnnotationReferenceDataType)dt;
            return DocumentGenMojo.className(ardt.getAnnotationType().getName());
        }
        if (dt instanceof NewDocumentReferenceDataType) {
            return "com.yahoo.document.DocumentId";
        }
        if (dt instanceof TensorDataType) {
            return "com.yahoo.tensor.Tensor";
        }
        return "byte[]";
    }

    private static String toJavaReference(DataType dt) {
        if (DataType.NONE.equals((Object)dt)) {
            return "com.yahoo.document.DataType.NONE";
        }
        if (DataType.INT.equals((Object)dt)) {
            return "com.yahoo.document.DataType.INT";
        }
        if (DataType.FLOAT.equals((Object)dt)) {
            return "com.yahoo.document.DataType.FLOAT";
        }
        if (DataType.STRING.equals((Object)dt)) {
            return "com.yahoo.document.DataType.STRING";
        }
        if (DataType.RAW.equals((Object)dt)) {
            return "com.yahoo.document.DataType.RAW";
        }
        if (DataType.LONG.equals((Object)dt)) {
            return "com.yahoo.document.DataType.LONG";
        }
        if (DataType.DOUBLE.equals((Object)dt)) {
            return "com.yahoo.document.DataType.DOUBLE";
        }
        if (DataType.DOCUMENT.equals((Object)dt)) {
            return "com.yahoo.document.DataType.DOCUMENT";
        }
        if (DataType.URI.equals((Object)dt)) {
            return "com.yahoo.document.DataType.URI";
        }
        if (DataType.BYTE.equals((Object)dt)) {
            return "com.yahoo.document.DataType.BYTE";
        }
        if (DataType.BOOL.equals((Object)dt)) {
            return "com.yahoo.document.DataType.BOOL";
        }
        if (DataType.TAG.equals((Object)dt)) {
            return "com.yahoo.document.DataType.TAG";
        }
        if (dt instanceof StructDataType) {
            return DocumentGenMojo.className(dt.getName()) + ".type";
        }
        if (dt instanceof WeightedSetDataType) {
            WeightedSetDataType wdt = (WeightedSetDataType)dt;
            return "new com.yahoo.document.WeightedSetDataType(" + DocumentGenMojo.toJavaReference(wdt.getNestedType()) + ", " + wdt.createIfNonExistent() + ", " + wdt.removeIfZero() + "," + dt.getId() + ")";
        }
        if (dt instanceof ArrayDataType) {
            ArrayDataType adt = (ArrayDataType)dt;
            return "new com.yahoo.document.ArrayDataType(" + DocumentGenMojo.toJavaReference(adt.getNestedType()) + ")";
        }
        if (dt instanceof MapDataType) {
            MapDataType mdt = (MapDataType)dt;
            return "new com.yahoo.document.MapDataType(" + DocumentGenMojo.toJavaReference(mdt.getKeyType()) + ", " + DocumentGenMojo.toJavaReference(mdt.getValueType()) + ", " + dt.getId() + ")";
        }
        if (dt instanceof AnnotationReferenceDataType) {
            AnnotationReferenceDataType adt = (AnnotationReferenceDataType)dt;
            return "new com.yahoo.document.annotation.AnnotationReferenceDataType(new com.yahoo.document.annotation.AnnotationType(\"" + adt.getAnnotationType().getName() + "\"))";
        }
        if (dt instanceof NewDocumentReferenceDataType) {
            NewDocumentReferenceDataType nrdt = (NewDocumentReferenceDataType)dt;
            return String.format("new com.yahoo.document.ReferenceDataType(%s.type, %d)", DocumentGenMojo.className(nrdt.getTargetType().getName()), dt.getId());
        }
        if (dt instanceof TensorDataType) {
            TensorDataType tdt = (TensorDataType)dt;
            return String.format("new com.yahoo.document.TensorDataType(com.yahoo.tensor.TensorType.fromSpec(\"%s\"))", tdt.getTensorType().toString());
        }
        return "com.yahoo.document.DataType.RAW";
    }

    public void execute() {
        this.execute(this.schemasDirectory, this.outputDirectory, this.packageName);
    }

    Map<String, Schema> getSearches() {
        return this.searches;
    }

    private static boolean reservedFieldName(String name) {
        return name.equals("id") || name.equals("version");
    }

    private static String upperCaseFirstChar(String s) {
        if (DocumentGenMojo.reservedFieldName(s)) {
            System.err.println("WARNING - field '" + s + "' has a reserved name; using 'My_" + s + "' instead");
            return "My_" + s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }
}

