/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.state;

import com.yahoo.vdslib.state.NodeType;
import java.util.ArrayList;

public final class State
extends Enum<State> {
    public static final /* enum */ State UNKNOWN = new State("-", false, true, true, false, false, false, false, false);
    public static final /* enum */ State MAINTENANCE = new State("m", false, false, false, true, true, false, true, true);
    public static final /* enum */ State DOWN = new State("d", true, true, true, true, true, true, true, true);
    public static final /* enum */ State STOPPING = new State("s", false, true, true, false, false, true, true, true);
    public static final /* enum */ State INITIALIZING = new State("i", false, true, true, false, false, true, true, true);
    public static final /* enum */ State RETIRED = new State("r", false, false, false, false, true, false, true, true);
    public static final /* enum */ State UP = new State("u", true, true, true, true, true, true, true, true);
    private final boolean validDiskState;
    private final boolean validClusterState;
    private final ArrayList<Boolean> validReportedNodeState = new ArrayList();
    private final ArrayList<Boolean> validWantedNodeState = new ArrayList();
    private final ArrayList<Boolean> validCurrentNodeState = new ArrayList();
    private final String serializedAs;
    private static final /* synthetic */ State[] $VALUES;

    public static State[] values() {
        return (State[])$VALUES.clone();
    }

    public static State valueOf(String name) {
        return Enum.valueOf(State.class, name);
    }

    private State(String serialized, boolean validDisk, boolean validDistReported, boolean validStorReported, boolean validDistWanted, boolean validStorWanted, boolean validCluster, boolean validDistCurrent, boolean validStorCurrent) {
        this.validDiskState = validDisk;
        this.validClusterState = validCluster;
        assert (NodeType.STORAGE.ordinal() == 0);
        assert (NodeType.DISTRIBUTOR.ordinal() == 1);
        this.validReportedNodeState.add(validStorReported);
        this.validReportedNodeState.add(validDistReported);
        this.validWantedNodeState.add(validStorWanted);
        this.validWantedNodeState.add(validDistWanted);
        this.validCurrentNodeState.add(validStorCurrent);
        this.validCurrentNodeState.add(validDistCurrent);
        this.serializedAs = serialized;
    }

    public static State get(String serialized) {
        for (State s : State.values()) {
            if (!s.serializedAs.equals(serialized)) continue;
            return s;
        }
        throw new IllegalArgumentException("Invalid state '" + serialized + "'.");
    }

    public String serialize() {
        return this.serializedAs;
    }

    public boolean validDiskState() {
        return this.validDiskState;
    }

    public boolean validClusterState() {
        return this.validClusterState;
    }

    public boolean validReportedNodeState(NodeType type) {
        return this.validReportedNodeState.get(type.ordinal());
    }

    public boolean validWantedNodeState(NodeType type) {
        return this.validWantedNodeState.get(type.ordinal());
    }

    public boolean validCurrentNodeState(NodeType type) {
        return this.validCurrentNodeState.get(type.ordinal());
    }

    public boolean maySetWantedStateForThisNodeState(State s) {
        return s.ordinal() <= this.ordinal();
    }

    public boolean oneOf(String states) {
        for (char c : states.toCharArray()) {
            String s = "" + c;
            if (!s.equals(this.serializedAs)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String id = this.name();
        String lower = id.substring(1).toLowerCase();
        return id.charAt(0) + lower;
    }

    static {
        $VALUES = new State[]{UNKNOWN, MAINTENANCE, DOWN, STOPPING, INITIALIZING, RETIRED, UP};
    }
}

