/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.state;

import java.util.LinkedList;
import java.util.List;

public class Diff {
    private List<Entry> diff = new LinkedList<Entry>();

    public void add(Entry e) {
        this.diff.add(e);
    }

    public boolean differs() {
        return !this.diff.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        PrintProperties pp = new PrintProperties();
        this.print(sb, "", pp, false);
        return sb.toString();
    }

    public String toHtml() {
        StringBuilder sb = new StringBuilder();
        PrintProperties pp = new PrintProperties();
        pp.lineBreak = "<br>\n";
        pp.indent = "&nbsp;";
        pp.keyValueSeparator = " =&gt; ";
        pp.insertLineBreaks = true;
        pp.boldStart = "<b>";
        pp.boldStop = "</b>";
        this.print(sb, "", pp, false);
        return sb.toString();
    }

    public void print(StringBuilder sb, String indent, PrintProperties pp, boolean splitLines) {
        boolean first = true;
        for (Entry e : this.diff) {
            if (first) {
                first = false;
            } else {
                sb.append(pp.entrySeparator);
                if (splitLines && pp.insertLineBreaks) {
                    sb.append(pp.lineBreak).append(indent);
                }
            }
            sb.append(e.id);
            if (e.subDiff != null) {
                sb.append(pp.idValueSeparator);
                if (e.subDiff.diff.size() > 1 || !pp.ommitGroupForSingleEntries) {
                    sb.append(pp.groupStart);
                } else {
                    sb.append(pp.singleGroupSeparator);
                }
                if (e.splitLine && pp.insertLineBreaks) {
                    sb.append(pp.lineBreak).append(indent + pp.indent);
                }
                e.subDiff.print(sb, indent + pp.indent, pp, e.splitLine);
                if (e.splitLine && pp.insertLineBreaks) {
                    sb.append(pp.lineBreak).append(indent);
                }
                if (e.subDiff.diff.size() <= 1 && pp.ommitGroupForSingleEntries) continue;
                sb.append(pp.groupStop);
                continue;
            }
            if (!e.id.isEmpty()) {
                sb.append(pp.idValueSeparator);
            }
            if (e.bold) {
                sb.append(pp.boldStart).append(e.preContent).append(pp.boldStop).append(pp.keyValueSeparator).append(pp.boldStart).append(e.postContent).append(pp.boldStop);
                continue;
            }
            sb.append(e.preContent).append(pp.keyValueSeparator).append(e.postContent);
        }
    }

    class PrintProperties {
        boolean insertLineBreaks = false;
        boolean ommitGroupForSingleEntries = true;
        String lineBreak = "\n";
        String entrySeparator = ", ";
        String idValueSeparator = ": ";
        String keyValueSeparator = " => ";
        String singleGroupSeparator = "";
        String groupStart = "[";
        String groupStop = "]";
        String indent = "  ";
        String boldStart = "";
        String boldStop = "";

        PrintProperties() {
        }
    }

    public static class Entry {
        String id;
        String preContent;
        String postContent;
        boolean bold = false;
        Diff subDiff;
        boolean splitLine = false;

        public Entry(Object id, Object pre, Object post) {
            this.id = id.toString();
            this.preContent = pre.toString();
            this.postContent = post.toString();
        }

        public Entry(Object id, Diff subDiff) {
            this.id = id.toString();
            this.subDiff = subDiff;
        }

        public Entry bold() {
            this.bold = true;
            return this;
        }

        public Entry splitLine() {
            this.splitLine = true;
            return this;
        }
    }
}

