/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib;

import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Deserializer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.TreeMap;

public class SearchResult {
    private int totalHits;
    private Hit[] hits;
    private TreeMap<Integer, byte[]> aggregatorList;
    private TreeMap<Integer, byte[]> groupingList;

    public SearchResult(Deserializer buf) {
        int i;
        int i2;
        BufferSerializer bser = (BufferSerializer)buf;
        bser.order(ByteOrder.BIG_ENDIAN);
        this.totalHits = buf.getInt(null);
        int numHits = buf.getInt(null);
        this.hits = new Hit[numHits];
        if (numHits != 0) {
            int docIdBufferLength = buf.getInt(null);
            byte[] cArr = bser.getBuf().array();
            int start = bser.getBuf().arrayOffset() + bser.position();
            for (i2 = 0; i2 < numHits; ++i2) {
                int end = start;
                while (cArr[end++] != 0) {
                }
                try {
                    this.hits[i2] = new Hit(new String(cArr, start, end - start - 1, "utf-8"), 0.0);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("UTF-8 apparently not supported");
                }
                start = end;
            }
            bser.position(start - bser.getBuf().arrayOffset());
            for (i2 = 0; i2 < numHits; ++i2) {
                this.hits[i2].setRank(buf.getDouble(null));
            }
        }
        int numSortBlobs = buf.getInt(null);
        int[] size = new int[numSortBlobs];
        for (i = 0; i < numSortBlobs; ++i) {
            size[i] = buf.getInt(null);
        }
        for (i = 0; i < numSortBlobs; ++i) {
            this.hits[i] = new HitWithSortBlob(this.hits[i], buf.getBytes(null, size[i]));
        }
        int numAggregators = buf.getInt(null);
        this.aggregatorList = new TreeMap();
        for (i2 = 0; i2 < numAggregators; ++i2) {
            int aggrId = buf.getInt(null);
            int aggrLength = buf.getInt(null);
            this.aggregatorList.put(aggrId, buf.getBytes(null, aggrLength));
        }
        int numGroupings = buf.getInt(null);
        this.groupingList = new TreeMap();
        for (int i3 = 0; i3 < numGroupings; ++i3) {
            int aggrId = buf.getInt(null);
            int aggrLength = buf.getInt(null);
            this.groupingList.put(aggrId, buf.getBytes(null, aggrLength));
        }
    }

    public SearchResult(byte[] buffer) {
        this((Deserializer)BufferSerializer.wrap((byte[])buffer));
    }

    public final int getHitCount() {
        return this.hits.length;
    }

    public final int getTotalHitCount() {
        return this.totalHits != 0 ? this.totalHits : this.getHitCount();
    }

    public final Hit getHit(int hitNo) {
        return this.hits[hitNo];
    }

    public final Map<Integer, byte[]> getAggregatorList() {
        return this.aggregatorList;
    }

    public final Map<Integer, byte[]> getGroupingList() {
        return this.groupingList;
    }

    public static class HitWithSortBlob
    extends Hit {
        private byte[] sortBlob;

        public HitWithSortBlob(Hit h, byte[] sb) {
            super(h);
            this.sortBlob = sb;
        }

        public final byte[] getSortBlob() {
            return this.sortBlob;
        }

        @Override
        public int compareTo(Hit h) {
            HitWithSortBlob b = (HitWithSortBlob)h;
            int m = Math.min(this.sortBlob.length, b.sortBlob.length);
            for (int i = 0; i < m; ++i) {
                if (this.sortBlob[i] == b.sortBlob[i]) continue;
                return (this.sortBlob[i] & 0xFF) < (b.sortBlob[i] & 0xFF) ? -1 : 1;
            }
            return this.sortBlob.length - b.sortBlob.length;
        }
    }

    public static class Hit
    implements Comparable<Hit> {
        private String docId;
        private double rank;

        public Hit(Hit h) {
            this.docId = h.docId;
            this.rank = h.rank;
        }

        public Hit(String docId, double rank) {
            this.rank = rank;
            this.docId = docId;
        }

        public final String getDocId() {
            return this.docId;
        }

        public final double getRank() {
            return this.rank;
        }

        public final void setRank(double rank) {
            this.rank = rank;
        }

        @Override
        public int compareTo(Hit h) {
            return h.rank < this.rank ? -1 : (h.rank > this.rank ? 1 : 0);
        }
    }
}

