/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.state;

import com.yahoo.text.StringUtilities;
import com.yahoo.vdslib.state.Diff;
import com.yahoo.vdslib.state.DiskState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class NodeState
implements Cloneable {
    private final NodeType type;
    private State state = State.UP;
    private String description = "";
    private double capacity = 1.0;
    private int reliability = 1;
    private double initProgress = 1.0;
    private int minUsedBits = 16;
    private List<DiskState> diskStates = new ArrayList<DiskState>();
    private boolean anyDiskDown = false;
    private long startTimestamp = 0L;

    public static double getListingBucketsInitProgressLimit() {
        return 0.01;
    }

    public NodeState(NodeType type, State state) {
        this.type = type;
        this.state = state;
        this.updateAnyDiskDownFlag();
    }

    private void updateAnyDiskDownFlag() {
        boolean anyDown = false;
        for (DiskState ds : this.diskStates) {
            if (ds.getState().equals((Object)State.UP)) continue;
            anyDown = true;
            break;
        }
        this.anyDiskDown = anyDown;
    }

    public NodeState clone() {
        try {
            NodeState ns = (NodeState)super.clone();
            ns.diskStates = new ArrayList<DiskState>();
            for (DiskState s : this.diskStates) {
                ns.diskStates.add(s.clone());
            }
            return ns;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Does not happen");
        }
    }

    public boolean above(NodeState other) {
        return this.state.ordinal() > other.state.ordinal();
    }

    public boolean equals(Object o) {
        block7: {
            if (!(o instanceof NodeState)) {
                return false;
            }
            NodeState ns = (NodeState)o;
            if (this.state != ns.state || Math.abs(this.capacity - ns.capacity) > 1.0E-10 || (double)Math.abs(this.reliability - ns.reliability) > 1.0E-10 || Math.abs(this.initProgress - ns.initProgress) > 1.0E-10 || this.startTimestamp != ns.startTimestamp || this.minUsedBits != ns.minUsedBits) {
                return false;
            }
            if (this.diskStates.size() == 0 && ns.diskStates.size() == 0) break block7;
            if (this.diskStates.size() == 0 || ns.diskStates.size() == 0) {
                NodeState nonEmptyState = this.diskStates.size() == 0 ? ns : this;
                for (int i = 0; i < nonEmptyState.diskStates.size(); ++i) {
                    if (nonEmptyState.diskStates.get(i).equals(new DiskState(State.UP))) continue;
                    return false;
                }
            } else {
                if (this.diskStates.size() != ns.diskStates.size()) {
                    return false;
                }
                for (int i = 0; i < this.diskStates.size(); ++i) {
                    if (this.diskStates.get(i).equals(ns.diskStates.get(i))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public int hashCode() {
        return this.state.hashCode() ^ this.diskStates.hashCode() ^ Double.valueOf(this.capacity).hashCode() ^ Double.valueOf(this.reliability).hashCode();
    }

    public boolean similarTo(Object o) {
        if (!(o instanceof NodeState)) {
            return false;
        }
        return this.similarToImpl((NodeState)o, true);
    }

    public boolean similarToIgnoringInitProgress(NodeState other) {
        return this.similarToImpl(other, false);
    }

    private boolean similarToImpl(NodeState other, boolean considerInitProgress) {
        block10: {
            if (this.state != other.state) {
                return false;
            }
            if (Math.abs(this.capacity - other.capacity) > 1.0E-10) {
                return false;
            }
            if ((double)Math.abs(this.reliability - other.reliability) > 1.0E-10) {
                return false;
            }
            if (this.startTimestamp != other.startTimestamp) {
                return false;
            }
            if (considerInitProgress && this.type.equals((Object)NodeType.STORAGE) && this.initProgress < NodeState.getListingBucketsInitProgressLimit() ^ other.initProgress < NodeState.getListingBucketsInitProgressLimit()) {
                return false;
            }
            if (this.diskStates.size() == 0 && other.diskStates.size() == 0) break block10;
            if (this.diskStates.size() == 0 || other.diskStates.size() == 0) {
                NodeState nonEmptyState = this.diskStates.size() == 0 ? other : this;
                for (int i = 0; i < nonEmptyState.diskStates.size(); ++i) {
                    if (nonEmptyState.diskStates.get(i).equals(new DiskState(State.UP))) continue;
                    return false;
                }
            } else {
                if (this.diskStates.size() != other.diskStates.size()) {
                    return false;
                }
                for (int i = 0; i < this.diskStates.size(); ++i) {
                    if (this.diskStates.get(i).equals(other.diskStates.get(i))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Diff getDiff(NodeState other) {
        Diff diff = new Diff();
        if (!this.state.equals((Object)other.state)) {
            diff.add(new Diff.Entry("", (Object)this.state, (Object)other.state).bold());
        }
        if (Math.abs(this.capacity - other.capacity) > 1.0E-9) {
            diff.add(new Diff.Entry("capacity", this.capacity, other.capacity));
        }
        if ((double)Math.abs(this.reliability - other.reliability) > 1.0E-9) {
            diff.add(new Diff.Entry("reliability", this.reliability, other.reliability));
        }
        if (this.minUsedBits != other.minUsedBits) {
            diff.add(new Diff.Entry("minUsedBits", this.minUsedBits, other.minUsedBits));
        }
        if (Math.abs(this.initProgress - other.initProgress) > 1.0E-9 && this.state.equals((Object)State.INITIALIZING) && other.state.equals((Object)State.INITIALIZING)) {
            diff.add(new Diff.Entry("initProgress", this.initProgress, other.initProgress));
        }
        if (this.startTimestamp != other.startTimestamp) {
            diff.add(new Diff.Entry("startTimestamp", this.startTimestamp, other.startTimestamp));
        }
        if (this.diskStates.size() != other.diskStates.size()) {
            diff.add(new Diff.Entry("disks", this.diskStates.size(), other.diskStates.size()));
        } else {
            Diff diskDiff = new Diff();
            for (int i = 0; i < this.diskStates.size(); ++i) {
                if (this.diskStates.get(i).equals(other.diskStates.get(i))) continue;
                diskDiff.add(new Diff.Entry(i, this.diskStates.get(i), other.diskStates.get(i)));
            }
            if (diskDiff.differs()) {
                diff.add(new Diff.Entry("disks", diskDiff));
            }
        }
        if (!this.description.equals(other.description)) {
            diff.add(new Diff.Entry("description", this.description, other.description));
        }
        return diff;
    }

    public String getTextualDifference(NodeState other) {
        return this.getDiff(other).toString();
    }

    public NodeState setCapacity(double c) {
        this.capacity = c;
        return this;
    }

    public NodeState setReliability(int r) {
        this.reliability = r;
        return this;
    }

    public NodeState setInitProgress(double p) {
        this.initProgress = p;
        return this;
    }

    public NodeState setDescription(String desc) {
        this.description = desc;
        return this;
    }

    public NodeState setMinUsedBits(int u) {
        this.minUsedBits = u;
        return this;
    }

    public NodeState setState(State state) {
        this.state = state;
        return this;
    }

    public NodeState setStartTimestamp(long ts) {
        this.startTimestamp = ts;
        return this;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public int getReliability() {
        return this.reliability;
    }

    public double getInitProgress() {
        return this.initProgress;
    }

    public boolean hasDescription() {
        return this.description.length() > 0;
    }

    public String getDescription() {
        return this.description;
    }

    public State getState() {
        return this.state;
    }

    public int getMinUsedBits() {
        return this.minUsedBits;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public boolean isAnyDiskDown() {
        return this.anyDiskDown;
    }

    public int getDiskCount() {
        return this.diskStates.size();
    }

    public List<DiskState> getDiskStates() {
        return Collections.unmodifiableList(this.diskStates);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean compact) {
        StringBuilder sb = new StringBuilder();
        if (compact) {
            sb.append(this.state.serialize().toUpperCase());
        } else {
            sb.append((Object)this.state);
        }
        if (Math.abs(this.capacity - 1.0) > 1.0E-9) {
            sb.append(compact ? ", c " : ", capacity ").append(compact ? String.format(Locale.ENGLISH, "%.3g", this.capacity) : Double.valueOf(this.capacity));
        }
        if (Math.abs((double)this.reliability - 1.0) > 1.0E-9) {
            sb.append(compact ? ", r " : ", reliability ").append(this.reliability);
        }
        if (this.state.equals((Object)State.INITIALIZING)) {
            sb.append(compact ? ", i " : ", init progress ").append(compact ? String.format(Locale.ENGLISH, "%.3g", this.initProgress) : Double.valueOf(this.initProgress));
            if (this.type.equals((Object)NodeType.STORAGE)) {
                if (this.initProgress < NodeState.getListingBucketsInitProgressLimit()) {
                    sb.append(compact ? " (ls)" : " (listing files)");
                } else {
                    sb.append(compact ? " (read)" : " (reading file headers)");
                }
            }
        }
        if (this.startTimestamp > 0L) {
            sb.append(compact ? ", t " : ", start timestamp ").append(this.startTimestamp);
        }
        if (this.minUsedBits != 16) {
            sb.append(compact ? ", b " : ", minimum used bits ").append(this.minUsedBits);
        }
        if (this.diskStates.size() > 0) {
            if (compact) {
                boolean anyNonDefault = false;
                for (DiskState diskState : this.diskStates) {
                    anyNonDefault |= !diskState.equals(new DiskState(State.UP));
                }
                if (anyNonDefault) {
                    sb.append(",");
                    DiskState defaultDiskState = new DiskState(State.UP);
                    for (int i = 0; i < this.diskStates.size(); ++i) {
                        if (this.diskStates.get(i).equals(defaultDiskState)) continue;
                        sb.append(" d").append(i).append("(").append(this.diskStates.get(i).serialize("", false)).append(")");
                    }
                }
            } else {
                sb.append(", disk states:");
                for (int i = 0; i < this.diskStates.size(); ++i) {
                    sb.append(" disk ").append(i).append(": ").append(this.diskStates.get(i).toString());
                }
            }
        }
        if (this.description.length() > 0) {
            sb.append(": ").append(this.description);
        }
        return sb.toString();
    }

    public NodeState setDiskCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive. Was " + count + ".");
        }
        this.diskStates.clear();
        for (int i = 0; i < count; ++i) {
            this.diskStates.add(new DiskState(State.UP, "", 1.0));
        }
        return this;
    }

    public NodeState setDiskState(int disk, DiskState state) throws IndexOutOfBoundsException {
        this.diskStates.set(disk, state);
        this.updateAnyDiskDownFlag();
        return this;
    }

    public DiskState getDiskState(int disk) throws IndexOutOfBoundsException {
        if (this.diskStates.isEmpty()) {
            return new DiskState();
        }
        return this.diskStates.get(disk);
    }

    public String serialize() {
        return this.serialize(-1, false);
    }

    public String serialize(boolean verbose) {
        return this.serialize(-1, verbose);
    }

    public String serialize(int nodeIdx, boolean verbose) {
        Object prefix;
        boolean empty = true;
        StringBuilder sb = new StringBuilder();
        Object object = prefix = nodeIdx == -1 ? "" : "." + nodeIdx + ".";
        if (this.state != State.UP) {
            empty = false;
            sb.append((String)prefix).append("s:").append(this.state.serialize());
        }
        if (Math.abs(this.capacity - 1.0) > 1.0E-9) {
            if (empty) {
                empty = false;
            } else {
                sb.append(' ');
            }
            sb.append((String)prefix).append("c:").append(this.capacity);
        }
        if (Math.abs((double)this.reliability - 1.0) > 1.0E-9) {
            if (empty) {
                empty = false;
            } else {
                sb.append(' ');
            }
            sb.append((String)prefix).append("r:").append(this.reliability);
        }
        if (this.state == State.INITIALIZING) {
            sb.append(' ');
            sb.append((String)prefix).append("i:").append(this.initProgress);
        }
        if (this.startTimestamp != 0L) {
            if (empty) {
                empty = false;
            } else {
                sb.append(' ');
            }
            sb.append((String)prefix).append("t:").append(this.startTimestamp);
        }
        if (nodeIdx == -1 && this.minUsedBits != 16) {
            if (empty) {
                empty = false;
            } else {
                sb.append(' ');
            }
            sb.append((String)prefix).append("b:").append(this.minUsedBits);
        }
        if (this.diskStates.size() > 0) {
            StringBuilder diskInfo = new StringBuilder();
            for (int i = 0; i < this.diskStates.size(); ++i) {
                String diskPrefix = (String)prefix + "d." + i + ".";
                String disk = this.diskStates.get(i).serialize(diskPrefix, verbose);
                if (disk.length() <= 0) continue;
                diskInfo.append(' ').append(disk);
            }
            String diskInfoStr = diskInfo.toString();
            if (verbose || diskInfoStr.length() > 0) {
                if (empty) {
                    empty = false;
                } else {
                    sb.append(' ');
                }
                sb.append((String)prefix).append("d:").append(this.diskStates.size());
                sb.append(diskInfoStr);
            } else if (nodeIdx == -1) {
                if (empty) {
                    empty = false;
                } else {
                    sb.append(' ');
                }
                sb.append((String)prefix).append("d:").append(this.diskStates.size());
            }
        }
        if ((verbose || nodeIdx == -1) && this.description.length() > 0) {
            if (!empty) {
                sb.append(' ');
            }
            sb.append((String)prefix).append("m:").append(StringUtilities.escape((String)this.description, (char)' '));
        }
        return sb.toString();
    }

    public static NodeState deserialize(NodeType type, String serialized) throws ParseException {
        NodeState newState = new NodeState(type, State.UP);
        StringTokenizer st = new StringTokenizer(serialized, " \t\r\f\n", false);
        DiskData diskData = new DiskData();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf(58);
            if (index < 0) {
                throw new ParseException("Token " + token + " does not contain ':': " + serialized, 0);
            }
            String key = token.substring(0, index);
            String value = token.substring(index + 1);
            if (key.length() > 0) {
                switch (key.charAt(0)) {
                    case 's': {
                        if (key.length() > 1) break;
                        newState.setState(State.get(value));
                        break;
                    }
                    case 'b': {
                        if (key.length() > 1) break;
                        newState.setMinUsedBits(Integer.parseInt(value));
                        break;
                    }
                    case 'c': {
                        if (key.length() > 1 || type != null && !type.equals((Object)NodeType.STORAGE)) break;
                        try {
                            newState.setCapacity(Double.valueOf(value));
                            break;
                        }
                        catch (Exception e) {
                            throw new ParseException("Illegal capacity '" + value + "'. Capacity must be a positive floating point number", 0);
                        }
                    }
                    case 'r': {
                        if (key.length() > 1 || type != null && !type.equals((Object)NodeType.STORAGE)) break;
                        try {
                            newState.setReliability(Integer.valueOf(value));
                            break;
                        }
                        catch (Exception e) {
                            throw new ParseException("Illegal reliability '" + value + "'. Reliability must be a positive integer number", 0);
                        }
                    }
                    case 'i': {
                        if (key.length() > 1) break;
                        try {
                            newState.setInitProgress(Double.valueOf(value));
                            break;
                        }
                        catch (Exception e) {
                            throw new ParseException("Illegal init progress '" + value + "'. Init progress must be a floating point number from 0.0 to 1.0", 0);
                        }
                    }
                    case 't': {
                        if (key.length() > 1) break;
                        try {
                            newState.setStartTimestamp(Long.valueOf(value));
                            if (newState.getStartTimestamp() < 0L) {
                                throw new Exception();
                            }
                            break;
                        }
                        catch (Exception e) {
                            throw new ParseException("Illegal start timestamp " + value + ". Start timestamp must be 0 or a positive long.", 0);
                        }
                    }
                    case 'm': {
                        if (key.length() > 1) break;
                        newState.setDescription(StringUtilities.unescape((String)value));
                        break;
                    }
                    case 'd': {
                        int diskIndex;
                        if (type != null && !type.equals((Object)NodeType.STORAGE)) break;
                        if (key.length() == 1) {
                            int size;
                            try {
                                size = Integer.valueOf(value);
                            }
                            catch (Exception e) {
                                throw new ParseException("Invalid disk count '" + value + "'. Need a positive integer value", 0);
                            }
                            while (newState.diskStates.size() < size) {
                                newState.diskStates.add(new DiskState());
                            }
                            break;
                        }
                        if (key.charAt(1) != '.') break;
                        int endp = key.indexOf(46, 2);
                        String indexStr = endp < 0 ? key.substring(2) : key.substring(2, endp);
                        try {
                            diskIndex = Integer.valueOf(indexStr);
                        }
                        catch (Exception e) {
                            throw new ParseException("Invalid disk index '" + indexStr + "'. need a positive integer value", 0);
                        }
                        if (diskIndex >= newState.diskStates.size()) {
                            throw new ParseException("Cannot index disk " + diskIndex + " of " + newState.diskStates.size(), 0);
                        }
                        if (diskData.diskIndex != diskIndex) {
                            diskData.addDisk(newState);
                        }
                        if (endp < 0) {
                            diskData.sb.append(" s:").append(value);
                        } else {
                            diskData.sb.append(" ").append(key.substring(endp + 1)).append(':').append(value);
                        }
                        diskData.diskIndex = diskIndex;
                        diskData.empty = false;
                        break;
                    }
                }
            }
        }
        diskData.addDisk(newState);
        newState.updateAnyDiskDownFlag();
        return newState;
    }

    public void verifyValidInSystemState(NodeType type) {
        if (!this.state.validCurrentNodeState(type)) {
            throw new IllegalArgumentException("State " + this.state + " cannot fit in system state for node of type: " + type);
        }
        if (type.equals((Object)NodeType.DISTRIBUTOR) && Math.abs(this.capacity - 1.0) > 1.0E-9) {
            throw new IllegalArgumentException("Capacity should not be set for a distributor node");
        }
        if (type.equals((Object)NodeType.DISTRIBUTOR) && Math.abs((double)this.reliability - 1.0) > 1.0E-9) {
            throw new IllegalArgumentException("Reliability should not be set for a distributor node");
        }
        if (type.equals((Object)NodeType.DISTRIBUTOR) && !this.diskStates.isEmpty()) {
            throw new IllegalArgumentException("Disk states should not be set for a distributor node");
        }
    }

    private static class DiskData {
        boolean empty = true;
        int diskIndex = 0;
        StringBuilder sb = new StringBuilder();

        private DiskData() {
        }

        public void addDisk(NodeState ns) throws ParseException {
            if (!this.empty) {
                while (this.diskIndex >= ns.diskStates.size()) {
                    ns.diskStates.add(new DiskState());
                }
                ns.diskStates.set(this.diskIndex, new DiskState(this.sb.toString()));
                this.empty = true;
                this.sb = new StringBuilder();
            }
        }
    }
}

