/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.state;

import com.yahoo.vdslib.state.NodeType;

public class Node
implements Comparable<Node> {
    private final NodeType type;
    private final int index;

    public Node(NodeType type, int index) {
        this.type = type;
        this.index = index;
    }

    public Node(String serialized) {
        int dot = serialized.lastIndexOf(46);
        if (dot < 0) {
            throw new IllegalArgumentException("Not a legal node string '" + serialized + "'.");
        }
        this.type = NodeType.get(serialized.substring(0, dot));
        this.index = Integer.valueOf(serialized.substring(dot + 1));
    }

    public static Node ofStorage(int index) {
        return new Node(NodeType.STORAGE, index);
    }

    public static Node ofDistributor(int index) {
        return new Node(NodeType.DISTRIBUTOR, index);
    }

    public String toString() {
        return this.type.toString() + "." + this.index;
    }

    public NodeType getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    private int getOrdering() {
        return (this.type.equals((Object)NodeType.STORAGE) ? 65536 : 0) + this.index;
    }

    @Override
    public int compareTo(Node n) {
        return this.getOrdering() - n.getOrdering();
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.index;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        Node n = (Node)o;
        return this.type.equals((Object)n.type) && this.index == n.index;
    }
}

